/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.jdo.FetchGroup;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.SentryOwnerInfo;
import org.apache.sentry.api.common.ApiConstants;
import org.apache.sentry.api.service.thrift.TSentryActiveRoleSet;
import org.apache.sentry.api.service.thrift.TSentryAuthorizable;
import org.apache.sentry.api.service.thrift.TSentryGrantOption;
import org.apache.sentry.api.service.thrift.TSentryGroup;
import org.apache.sentry.api.service.thrift.TSentryMappingData;
import org.apache.sentry.api.service.thrift.TSentryPrivilege;
import org.apache.sentry.api.service.thrift.TSentryPrivilegeMap;
import org.apache.sentry.api.service.thrift.TSentryRole;
import org.apache.sentry.core.common.exception.SentryAccessDeniedException;
import org.apache.sentry.core.common.exception.SentryAlreadyExistsException;
import org.apache.sentry.core.common.exception.SentryInvalidInputException;
import org.apache.sentry.core.common.exception.SentryNoSuchObjectException;
import org.apache.sentry.core.common.exception.SentrySiteConfigurationException;
import org.apache.sentry.core.common.utils.PathUtils;
import org.apache.sentry.core.common.utils.SentryConstants;
import org.apache.sentry.core.common.utils.SentryUtils;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.hdfs.PathsUpdate;
import org.apache.sentry.hdfs.UniquePathsUpdate;
import org.apache.sentry.hdfs.Updateable;
import org.apache.sentry.hdfs.UpdateableAuthzPaths;
import org.apache.sentry.hdfs.service.thrift.TPrivilegePrincipal;
import org.apache.sentry.hdfs.service.thrift.TPrivilegePrincipalType;
import org.apache.sentry.provider.db.service.model.MAuthzPathsMapping;
import org.apache.sentry.provider.db.service.model.MAuthzPathsSnapshotId;
import org.apache.sentry.provider.db.service.model.MPath;
import org.apache.sentry.provider.db.service.model.MSentryChange;
import org.apache.sentry.provider.db.service.model.MSentryGMPrivilege;
import org.apache.sentry.provider.db.service.model.MSentryGroup;
import org.apache.sentry.provider.db.service.model.MSentryHmsNotification;
import org.apache.sentry.provider.db.service.model.MSentryPathChange;
import org.apache.sentry.provider.db.service.model.MSentryPermChange;
import org.apache.sentry.provider.db.service.model.MSentryPrivilege;
import org.apache.sentry.provider.db.service.model.MSentryRole;
import org.apache.sentry.provider.db.service.model.MSentryUser;
import org.apache.sentry.provider.db.service.model.MSentryUtil;
import org.apache.sentry.provider.db.service.model.MSentryVersion;
import org.apache.sentry.provider.db.service.persistent.CounterWait;
import org.apache.sentry.provider.db.service.persistent.DeltaTransactionBlock;
import org.apache.sentry.provider.db.service.persistent.PathsImage;
import org.apache.sentry.provider.db.service.persistent.PermissionsImage;
import org.apache.sentry.provider.db.service.persistent.PrivilegePrincipal;
import org.apache.sentry.provider.db.service.persistent.QueryParamBuilder;
import org.apache.sentry.provider.db.service.persistent.SentryStoreInterface;
import org.apache.sentry.provider.db.service.persistent.SentryStoreSchemaInfo;
import org.apache.sentry.provider.db.service.persistent.TransactionBlock;
import org.apache.sentry.provider.db.service.persistent.TransactionManager;
import org.apache.sentry.service.common.SentryOwnerPrivilegeType;
import org.apache.sentry.service.common.ServiceConstants;
import org.datanucleus.store.rdbms.exceptions.MissingTableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sentry.com.codahale.metrics.Gauge;

public class SentryStore
implements SentryStoreInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryStore.class);
    private static final long COUNT_VALUE_UNKNOWN = -1L;
    private static final long NOTIFICATION_UNKNOWN = -1L;
    private static final String EMPTY_GRANTOR_PRINCIPAL = "--";
    private static final Set<String> ALL_ACTIONS = Sets.newHashSet((Object[])new String[]{"*", "ALL", "select", "insert", "alter", "create", "drop", "index", "lock", "OWNER"});
    private static final Set<String> PARTIAL_REVOKE_ACTIONS = Sets.newHashSet((Object[])new String[]{"*", "ALL".toLowerCase(), "select", "insert"});
    private static final String LOAD_RESULTS_AT_COMMIT = "datanucleus.query.loadResultsAtCommit";
    private final PersistenceManagerFactory pmf;
    private Configuration conf;
    private final TransactionManager tm;
    private boolean persistUpdateDeltas;
    private final CounterWait counterWait;
    private final long printSnapshotPersistTimeInterval = 300000L;
    private final boolean ownerPrivilegeWithGrant;

    public static Properties getDataNucleusProperties(Configuration conf) throws SentrySiteConfigurationException, IOException {
        String[] parts;
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)ServiceConstants.ServerConfig.SENTRY_STORE_DEFAULTS);
        String jdbcUrl = conf.get("sentry.store.jdbc.url", "").trim();
        Preconditions.checkArgument((!jdbcUrl.isEmpty() ? 1 : 0) != 0, (Object)"Required parameter sentry.store.jdbc.url is missed");
        String user = conf.get("sentry.store.jdbc.user", "Sentry").trim();
        char[] passTmp = conf.getPassword("sentry.store.jdbc.password");
        if (passTmp == null) {
            throw new SentrySiteConfigurationException("Error reading sentry.store.jdbc.password");
        }
        String pass = new String(passTmp);
        String driverName = conf.get("sentry.store.jdbc.driver", "org.apache.derby.jdbc.EmbeddedDriver");
        prop.setProperty("javax.jdo.option.ConnectionURL", jdbcUrl);
        prop.setProperty("javax.jdo.option.ConnectionUserName", user);
        prop.setProperty("javax.jdo.option.ConnectionPassword", pass);
        prop.setProperty("javax.jdo.option.ConnectionDriverName", driverName);
        String oracleDb = "oracle";
        if (prop.getProperty("datanucleus.transactionIsolation", "").equals("repeatable-read") && jdbcUrl.contains("oracle") && (parts = jdbcUrl.split(":")).length > 1 && parts[1].equals("oracle")) {
            prop.setProperty("datanucleus.transactionIsolation", "read-committed");
        }
        for (Map.Entry entry : conf) {
            String key = (String)entry.getKey();
            if (!key.startsWith("sentry.javax.jdo") && !key.startsWith("sentry.datanucleus")) continue;
            key = StringUtils.removeStart((String)key, (String)"sentry.");
            prop.setProperty(key, (String)entry.getValue());
        }
        prop.setProperty("datanucleus.NontransactionalRead", "false");
        prop.setProperty("datanucleus.NontransactionalWrite", "false");
        int batchSize = conf.getInt("sentry.statement.batch.limit", 100);
        prop.setProperty("datanucleus.rdbms.statementBatchLimit", Integer.toString(batchSize));
        int allocationSize = conf.getInt("sentry.db.valuegeneration.allocation.size", 100);
        prop.setProperty("datanucleus.valuegeneration.increment.allocationSize", Integer.toString(allocationSize));
        return prop;
    }

    public SentryStore(Configuration conf) throws Exception {
        this.conf = conf;
        Properties prop = SentryStore.getDataNucleusProperties(conf);
        boolean checkSchemaVersion = conf.get("sentry.verify.schema.version", "true").equalsIgnoreCase("true");
        if (!checkSchemaVersion) {
            prop.setProperty("datanucleus.schema.autoCreateAll", "true");
        }
        this.pmf = JDOHelper.getPersistenceManagerFactory((Map)prop);
        this.tm = new TransactionManager(this.pmf, conf);
        this.verifySentryStoreSchema(checkSchemaVersion);
        long notificationTimeout = conf.getInt("sentry.notification.sync.timeout.ms", 200000);
        this.counterWait = new CounterWait(notificationTimeout, TimeUnit.MILLISECONDS);
        this.ownerPrivilegeWithGrant = SentryOwnerPrivilegeType.ALL_WITH_GRANT.isConfSet(conf);
    }

    @Override
    public void setPersistUpdateDeltas(boolean persistUpdateDeltas) {
        this.persistUpdateDeltas = persistUpdateDeltas;
    }

    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    @Override
    public CounterWait getCounterWait() {
        return this.counterWait;
    }

    void verifySentryStoreSchema(boolean checkVersion) throws Exception {
        if (!checkVersion) {
            this.setSentryVersion(SentryStoreSchemaInfo.getSentryVersion(), "Schema version set implicitly");
        } else {
            String currentVersion = this.getSentryVersion();
            if (!SentryStoreSchemaInfo.getSentryVersion().equals(currentVersion)) {
                throw new SentryAccessDeniedException("The Sentry store schema version " + currentVersion + " is different from distribution version " + SentryStoreSchemaInfo.getSentryVersion());
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (this.pmf != null) {
            this.pmf.close();
        }
    }

    public MSentryRole getRole(PersistenceManager pm, String roleName) {
        Query query = pm.newQuery(MSentryRole.class);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        query.setFilter("this.roleName == :roleName");
        query.setUnique(true);
        FetchGroup grp = pm.getFetchGroup(MSentryRole.class, "fetchPrivileges");
        grp.addMember("privileges");
        pm.getFetchPlan().addGroup("fetchPrivileges");
        return (MSentryRole)query.execute((Object)roleName);
    }

    public List<MSentryRole> getAllRoles(PersistenceManager pm) {
        Query query = pm.newQuery(MSentryRole.class);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        FetchGroup grp = pm.getFetchGroup(MSentryRole.class, "fetchGroups");
        grp.addMember("groups");
        pm.getFetchPlan().addGroup("fetchGroups");
        return (List)query.execute();
    }

    public MSentryUser getUser(PersistenceManager pm, String userName) {
        Query query = pm.newQuery(MSentryUser.class);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        query.setFilter("this.userName == :userName");
        query.setUnique(true);
        FetchGroup grp = pm.getFetchGroup(MSentryUser.class, "fetchPrivileges");
        grp.addMember("privileges");
        pm.getFetchPlan().addGroup("fetchPrivileges");
        return (MSentryUser)query.execute((Object)userName);
    }

    public void createSentryUser(String userName) throws Exception {
        this.tm.executeTransactionWithRetry(pm -> {
            pm.setDetachAllOnCommit(false);
            String trimmedUserName = userName.trim();
            if (this.getUser(pm, trimmedUserName) != null) {
                throw new SentryAlreadyExistsException("User: " + trimmedUserName);
            }
            pm.makePersistent((Object)new MSentryUser(trimmedUserName, System.currentTimeMillis(), Sets.newHashSet()));
            return null;
        });
    }

    private String trimAndLower(String input) {
        return input.trim().toLowerCase();
    }

    @Override
    public void createSentryRole(String roleName) throws Exception {
        this.tm.executeTransactionWithRetry(pm -> {
            pm.setDetachAllOnCommit(false);
            String trimmedRoleName = this.trimAndLower(roleName);
            if (this.getRole(pm, trimmedRoleName) != null) {
                throw new SentryAlreadyExistsException("Role: " + trimmedRoleName);
            }
            pm.makePersistent((Object)new MSentryRole(trimmedRoleName));
            return null;
        });
    }

    @VisibleForTesting
    <T> Long getCount(Class<T> tClass) {
        try {
            return this.tm.executeTransaction(pm -> {
                pm.setDetachAllOnCommit(false);
                Query query = pm.newQuery();
                query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
                query.setClass(tClass);
                query.setResult("count(this)");
                Long result = (Long)query.execute();
                return result;
            });
        }
        catch (Exception e) {
            return -1L;
        }
    }

    @Override
    public Gauge<Long> getRoleCountGauge() {
        return () -> this.getCount(MSentryRole.class);
    }

    @Override
    public Gauge<Long> getPrivilegeCountGauge() {
        return () -> this.getCount(MSentryPrivilege.class);
    }

    @Override
    public Gauge<Long> getGenericModelPrivilegeCountGauge() {
        return () -> this.getCount(MSentryGMPrivilege.class);
    }

    @Override
    public Gauge<Long> getGroupCountGauge() {
        return () -> this.getCount(MSentryGroup.class);
    }

    Gauge<Long> getUserCountGauge() {
        return () -> this.getCount(MSentryUser.class);
    }

    @Override
    public Gauge<Long> getAuthzObjectsCountGauge() {
        return () -> {
            try {
                return this.getCount(MAuthzPathsMapping.class);
            }
            catch (Exception e) {
                LOGGER.error("Cannot read AUTHZ_PATHS_MAPPING table", (Throwable)e);
                return -1L;
            }
        };
    }

    @Override
    public Gauge<Long> getAuthzPathsCountGauge() {
        return () -> {
            try {
                return this.getCount(MPath.class);
            }
            catch (Exception e) {
                LOGGER.error("Cannot read AUTHZ_PATH table", (Throwable)e);
                return -1L;
            }
        };
    }

    @Override
    public Gauge<Integer> getHMSWaitersCountGauge() {
        return () -> this.counterWait.waitersCount();
    }

    @Override
    public Gauge<Long> getLastNotificationIdGauge() {
        return () -> {
            try {
                return this.getLastProcessedNotificationID();
            }
            catch (Exception e) {
                LOGGER.error("Can not read current notificationId", (Throwable)e);
                return -1L;
            }
        };
    }

    @Override
    public Gauge<Long> getLastPathsSnapshotIdGauge() {
        return () -> {
            try {
                return this.getCurrentAuthzPathsSnapshotID();
            }
            catch (Exception e) {
                LOGGER.error("Can not read current paths snapshot ID", (Throwable)e);
                return -1L;
            }
        };
    }

    @Override
    public Gauge<Long> getPermChangeIdGauge() {
        return new Gauge<Long>(){

            @Override
            public Long getValue() {
                try {
                    return SentryStore.this.tm.executeTransaction(pm -> SentryStore.getLastProcessedChangeIDCore(pm, MSentryPermChange.class));
                }
                catch (Exception e) {
                    LOGGER.error("Can not read current permissions change ID", (Throwable)e);
                    return -1L;
                }
            }
        };
    }

    @Override
    public Gauge<Long> getPathChangeIdGauge() {
        return () -> {
            try {
                return this.tm.executeTransaction(pm -> SentryStore.getLastProcessedChangeIDCore(pm, MSentryPathChange.class));
            }
            catch (Exception e) {
                LOGGER.error("Can not read current path change ID", (Throwable)e);
                return -1L;
            }
        };
    }

    @VisibleForTesting
    long countMSentryPrivileges() {
        return this.getCount(MSentryPrivilege.class);
    }

    @VisibleForTesting
    void clearAllTables() {
        try {
            this.tm.executeTransaction(pm -> {
                pm.newQuery(MSentryRole.class).deletePersistentAll();
                pm.newQuery(MSentryGroup.class).deletePersistentAll();
                pm.newQuery(MSentryUser.class).deletePersistentAll();
                pm.newQuery(MSentryPrivilege.class).deletePersistentAll();
                pm.newQuery(MSentryPermChange.class).deletePersistentAll();
                pm.newQuery(MSentryPathChange.class).deletePersistentAll();
                pm.newQuery(MAuthzPathsMapping.class).deletePersistentAll();
                pm.newQuery(MPath.class).deletePersistentAll();
                pm.newQuery(MSentryHmsNotification.class).deletePersistentAll();
                pm.newQuery(MAuthzPathsSnapshotId.class).deletePersistentAll();
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void clearHmsPathInformation() throws Exception {
        LOGGER.info("Clearing all the Path information");
        this.tm.executeTransactionWithRetry(pm -> {
            pm.newQuery(MSentryPathChange.class).deletePersistentAll();
            pm.newQuery(MAuthzPathsMapping.class).deletePersistentAll();
            pm.newQuery(MPath.class).deletePersistentAll();
            return null;
        });
    }

    @VisibleForTesting
    <T extends MSentryChange> void purgeDeltaChangeTableCore(Class<T> cls, PersistenceManager pm, long changesToKeep) {
        Preconditions.checkArgument((changesToKeep >= 0L ? 1 : 0) != 0, (Object)"changes to keep must be a non-negative number");
        long lastChangedID = SentryStore.getLastProcessedChangeIDCore(pm, cls);
        long maxIDDeleted = lastChangedID - changesToKeep;
        Query query = pm.newQuery(cls);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        query.setFilter("changeID <= maxChangedIdDeleted");
        query.declareParameters("long maxChangedIdDeleted");
        long numDeleted = query.deletePersistentAll(new Object[]{maxIDDeleted});
        if (numDeleted > 0L) {
            LOGGER.info(String.format("Purged %d of %s to changeID=%d", numDeleted, cls.getSimpleName(), maxIDDeleted));
        }
    }

    @VisibleForTesting
    protected void purgeNotificationIdTableCore(PersistenceManager pm, long changesToKeep) {
        Preconditions.checkArgument((changesToKeep > 0L ? 1 : 0) != 0, (Object)"You need to keep at least one entry in SENTRY_HMS_NOTIFICATION_ID table");
        long lastNotificationID = SentryStore.getLastProcessedNotificationIDCore(pm);
        Query query = pm.newQuery(MSentryHmsNotification.class);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        query.setFilter("notificationId <= maxNotificationIdDeleted");
        query.declareParameters("long maxNotificationIdDeleted");
        long numDeleted = query.deletePersistentAll(new Object[]{lastNotificationID - changesToKeep});
        if (numDeleted > 0L) {
            LOGGER.info("Purged {} of {}", (Object)numDeleted, (Object)MSentryHmsNotification.class.getSimpleName());
        }
    }

    @Override
    public void purgeDeltaChangeTables() {
        int changesToKeep = this.conf.getInt("sentry.server.delta.keep.count", 200);
        LOGGER.info("Purging MSentryPathUpdate and MSentyPermUpdate tables, leaving {} entries", (Object)changesToKeep);
        try {
            this.tm.executeTransaction(pm -> {
                pm.setDetachAllOnCommit(false);
                this.purgeDeltaChangeTableCore(MSentryPermChange.class, pm, changesToKeep);
                LOGGER.info("MSentryPermChange table has been purged.");
                this.purgeDeltaChangeTableCore(MSentryPathChange.class, pm, changesToKeep);
                LOGGER.info("MSentryPathUpdate table has been purged.");
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.error("Delta change cleaning process encountered an error", (Throwable)e);
        }
    }

    @Override
    public void purgeNotificationIdTable() {
        int changesToKeep = this.conf.getInt("sentry.server.delta.keep.count", 100);
        LOGGER.debug("Purging MSentryHmsNotification table, leaving {} entries", (Object)changesToKeep);
        try {
            this.tm.executeTransaction(pm -> {
                pm.setDetachAllOnCommit(false);
                this.purgeNotificationIdTableCore(pm, changesToKeep);
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.error("MSentryHmsNotification cleaning process encountered an error", (Throwable)e);
        }
    }

    @Override
    public void alterSentryRoleGrantPrivileges(String roleName, Set<TSentryPrivilege> privileges) throws Exception {
        this.alterSentryGrantPrivileges(ServiceConstants.SentryPrincipalType.ROLE, roleName, privileges, null);
    }

    synchronized void alterSentryGrantPrivileges(ServiceConstants.SentryPrincipalType type, String name, Set<TSentryPrivilege> privileges, List<Updateable.Update> updatesToPersist) throws Exception {
        this.execute(updatesToPersist, (PersistenceManager pm) -> {
            pm.setDetachAllOnCommit(false);
            String trimmedEntityName = this.trimAndLower(name);
            for (TSentryPrivilege privilege : privileges) {
                MSentryPrivilege mPrivilege = this.alterSentryGrantPrivilegeCore(pm, type, trimmedEntityName, privilege);
                if (mPrivilege == null) continue;
                this.convertToTSentryPrivilege(mPrivilege, privilege);
            }
            return null;
        });
    }

    @Override
    public void alterSentryRoleGrantPrivileges(String roleName, Set<TSentryPrivilege> privileges, Map<TSentryPrivilege, Updateable.Update> privilegesUpdateMap) throws Exception {
        Preconditions.checkNotNull(privilegesUpdateMap);
        this.alterSentryGrantPrivileges(ServiceConstants.SentryPrincipalType.ROLE, roleName, privileges, new ArrayList<Updateable.Update>(privilegesUpdateMap.values()));
    }

    private MSentryPrivilege findMatchPrivilege(Set<MSentryPrivilege> entityPrivileges, MSentryPrivilege inputPrivilege) {
        for (MSentryPrivilege entityPrivilege : entityPrivileges) {
            if (!entityPrivilege.equals(inputPrivilege)) continue;
            return entityPrivilege;
        }
        return null;
    }

    private MSentryPrivilege alterSentryGrantPrivilegeCore(PersistenceManager pm, ServiceConstants.SentryPrincipalType type, String entityName, TSentryPrivilege privilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        PrivilegePrincipal mEntity;
        MSentryPrivilege mPrivilege = null;
        entityName = entityName.trim();
        if (type.equals((Object)ServiceConstants.SentryPrincipalType.ROLE)) {
            entityName = entityName.toLowerCase();
        }
        if ((mEntity = this.getEntity(pm, entityName, type)) == null) {
            if (type == ServiceConstants.SentryPrincipalType.ROLE) {
                throw SentryStore.noSuchRole(entityName);
            }
            if (type == ServiceConstants.SentryPrincipalType.USER) {
                mEntity = new MSentryUser(entityName, System.currentTimeMillis(), Sets.newHashSet());
            }
        }
        if (privilege.getPrivilegeScope().equalsIgnoreCase(ApiConstants.PrivilegeScope.URI.name()) && StringUtils.isBlank((String)privilege.getURI())) {
            throw new SentryInvalidInputException("cannot grant URI privileges to Null or EMPTY location");
        }
        if (!(SentryUtils.isNULL((String)privilege.getColumnName()) && SentryUtils.isNULL((String)privilege.getTableName()) && SentryUtils.isNULL((String)privilege.getDbName()) || "OWNER".equalsIgnoreCase(privilege.getAction()))) {
            if ("*".equalsIgnoreCase(privilege.getAction()) || "ALL".equalsIgnoreCase(privilege.getAction())) {
                this.dropPrivilegesForGrantAll(pm, mEntity, privilege);
            } else {
                TSentryPrivilege tAll = new TSentryPrivilege(privilege);
                tAll.setAction("*");
                MSentryPrivilege mAll1 = this.findMatchPrivilege(mEntity.getPrivileges(), this.convertToMSentryPrivilege(tAll));
                tAll.setAction("ALL");
                MSentryPrivilege mAll2 = this.findMatchPrivilege(mEntity.getPrivileges(), this.convertToMSentryPrivilege(tAll));
                if (mAll1 != null) {
                    return null;
                }
                if (mAll2 != null) {
                    return null;
                }
            }
        }
        if ((mPrivilege = this.getMSentryPrivilege(privilege, pm)) == null) {
            mPrivilege = this.convertToMSentryPrivilege(privilege);
            mPrivilege.appendPrincipal(mEntity);
            pm.makePersistent((Object)mPrivilege);
        } else {
            mEntity.appendPrivilege(mPrivilege);
            pm.makePersistent((Object)mEntity);
        }
        return mPrivilege;
    }

    private void dropPrivilegesForGrantAll(PersistenceManager pm, PrivilegePrincipal principal, TSentryPrivilege privilege) throws SentryInvalidInputException {
        TSentryPrivilege tNotAll = new TSentryPrivilege(privilege);
        for (String action : ALL_ACTIONS) {
            if (action.equalsIgnoreCase("OWNER")) continue;
            tNotAll.setAction(action);
            MSentryPrivilege mAction = this.findMatchPrivilege(principal.getPrivileges(), this.convertToMSentryPrivilege(tNotAll));
            if (mAction == null) continue;
            mAction.removePrincipal(principal);
            this.persistPrivilege(pm, mAction);
        }
    }

    public void alterSentryUserGrantPrivileges(String userName, Set<TSentryPrivilege> privileges) throws Exception {
        try {
            MSentryUser userEntry = this.getMSentryUserByName(userName, false);
            if (userEntry == null) {
                this.createSentryUser(userName);
            }
        }
        catch (SentryAlreadyExistsException sentryAlreadyExistsException) {
            // empty catch block
        }
        this.alterSentryGrantPrivileges(ServiceConstants.SentryPrincipalType.USER, userName, privileges, null);
    }

    @Override
    public void alterSentryGrantOwnerPrivilege(String principalName, ServiceConstants.SentryPrincipalType entityType, TSentryPrivilege privilege, Updateable.Update update) throws Exception {
        this.execute(update, (PersistenceManager pm) -> {
            pm.setDetachAllOnCommit(false);
            MSentryPrivilege mPrivilege = this.alterSentryGrantPrivilegeCore(pm, entityType, principalName, privilege);
            if (mPrivilege != null) {
                this.convertToTSentryPrivilege(mPrivilege, privilege);
            }
            return null;
        });
    }

    @VisibleForTesting
    public MSentryUser getMSentryUserByName(String userName) throws Exception {
        return this.getMSentryUserByName(userName, true);
    }

    MSentryUser getMSentryUserByName(final String userName, final boolean throwExceptionIfNotExist) throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<MSentryUser>(){

            @Override
            public MSentryUser execute(PersistenceManager pm) throws Exception {
                String trimmedUserName = userName.trim();
                MSentryUser sentryUser = SentryStore.this.getUser(pm, trimmedUserName);
                if (sentryUser == null) {
                    if (throwExceptionIfNotExist) {
                        throw SentryStore.noSuchUser(trimmedUserName);
                    }
                    return null;
                }
                return sentryUser;
            }
        });
    }

    public void alterSentryUserRevokePrivileges(String userName, Set<TSentryPrivilege> tPrivileges) throws Exception {
        this.alterSentryRevokePrivileges(ServiceConstants.SentryPrincipalType.USER, userName, tPrivileges, null);
    }

    @Override
    public void alterSentryRoleRevokePrivileges(String roleName, Set<TSentryPrivilege> tPrivileges) throws Exception {
        this.alterSentryRevokePrivileges(ServiceConstants.SentryPrincipalType.ROLE, roleName, tPrivileges, null);
    }

    synchronized void alterSentryRevokePrivileges(ServiceConstants.SentryPrincipalType type, String principalName, Set<TSentryPrivilege> privileges, List<Updateable.Update> updatesToDelete) throws Exception {
        this.execute(updatesToDelete, (PersistenceManager pm) -> {
            pm.setDetachAllOnCommit(false);
            String trimmedEntityName = SentryStore.safeTrimLower(principalName);
            for (TSentryPrivilege tPrivilege : privileges) {
                this.alterSentryRevokePrivilegeCore(pm, type, trimmedEntityName, tPrivilege);
            }
            return null;
        });
    }

    @Override
    public void alterSentryRoleRevokePrivileges(String roleName, Set<TSentryPrivilege> tPrivileges, Map<TSentryPrivilege, Updateable.Update> privilegesUpdateMap) throws Exception {
        Preconditions.checkNotNull(privilegesUpdateMap);
        this.alterSentryRevokePrivileges(ServiceConstants.SentryPrincipalType.ROLE, roleName, tPrivileges, new ArrayList<Updateable.Update>(privilegesUpdateMap.values()));
    }

    private void alterSentryRevokePrivilegeCore(PersistenceManager pm, ServiceConstants.SentryPrincipalType type, String entityName, TSentryPrivilege tPrivilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        PrivilegePrincipal mEntity;
        if (entityName == null) {
            throw new SentryInvalidInputException("Null entityName");
        }
        entityName = entityName.trim();
        if (type.equals((Object)ServiceConstants.SentryPrincipalType.ROLE)) {
            entityName = entityName.toLowerCase();
        }
        if ((mEntity = this.getEntity(pm, entityName, type)) == null) {
            if (type == ServiceConstants.SentryPrincipalType.ROLE) {
                throw SentryStore.noSuchRole(entityName);
            }
            if (type == ServiceConstants.SentryPrincipalType.USER) {
                throw SentryStore.noSuchUser(entityName);
            }
        }
        if (tPrivilege.getPrivilegeScope().equalsIgnoreCase(ApiConstants.PrivilegeScope.URI.name()) && StringUtils.isBlank((String)tPrivilege.getURI())) {
            throw new SentryInvalidInputException("cannot revoke URI privileges from Null or EMPTY location");
        }
        LOGGER.debug("tPrivilege to drop: {}", (Object)tPrivilege.toString());
        MSentryPrivilege mPrivilege = this.getMSentryPrivilege(tPrivilege, pm);
        if (mPrivilege == null) {
            LOGGER.debug("mPrivilege is null");
            mPrivilege = this.convertToMSentryPrivilege(tPrivilege);
        } else {
            LOGGER.debug("mPrivilege is found: {}", (Object)mPrivilege.toString());
            mPrivilege = (MSentryPrivilege)pm.detachCopy((Object)mPrivilege);
        }
        HashSet<MSentryPrivilege> privilegeGraph = new HashSet<MSentryPrivilege>();
        Set<String> allEquivalentActions = this.getAllEquivalentActions(mPrivilege.getAction());
        for (String equivalentAction : allEquivalentActions) {
            MSentryPrivilege newActionPrivilege = new MSentryPrivilege(mPrivilege);
            newActionPrivilege.setAction(equivalentAction);
            if (newActionPrivilege.getGrantOption() != null) {
                privilegeGraph.add(newActionPrivilege);
                continue;
            }
            MSentryPrivilege mTure = new MSentryPrivilege(newActionPrivilege);
            mTure.setGrantOption(true);
            privilegeGraph.add(mTure);
            MSentryPrivilege mFalse = new MSentryPrivilege(newActionPrivilege);
            mFalse.setGrantOption(false);
            privilegeGraph.add(mFalse);
        }
        this.populateChildren(pm, type, Sets.newHashSet((Object[])new String[]{entityName}), mPrivilege, privilegeGraph);
        for (MSentryPrivilege childPriv : privilegeGraph) {
            this.revokePrivilege(pm, tPrivilege, mEntity, childPriv);
        }
        this.persistEntity(pm, type, mEntity);
    }

    private void revokePartial(PersistenceManager pm, TSentryPrivilege requestedPrivToRevoke, PrivilegePrincipal mEntity, MSentryPrivilege currentPrivilege) throws SentryInvalidInputException {
        MSentryPrivilege persistedPriv = this.getMSentryPrivilege(this.convertToTSentryPrivilege(currentPrivilege), pm);
        if (persistedPriv == null) {
            persistedPriv = this.convertToMSentryPrivilege(this.convertToTSentryPrivilege(currentPrivilege));
        }
        if (requestedPrivToRevoke.getAction().equalsIgnoreCase("*") || requestedPrivToRevoke.getAction().equalsIgnoreCase("ALL")) {
            if (!(persistedPriv.getRoles().isEmpty() && persistedPriv.getUsers().isEmpty() || mEntity == null)) {
                persistedPriv.removePrincipal(mEntity);
                this.persistPrivilege(pm, persistedPriv);
            }
        } else {
            HashSet<String> addActions = new HashSet<String>();
            for (String actionToAdd : PARTIAL_REVOKE_ACTIONS) {
                if (requestedPrivToRevoke.getAction().equalsIgnoreCase(actionToAdd) || currentPrivilege.getAction().equalsIgnoreCase(actionToAdd) || "*".equalsIgnoreCase(actionToAdd) || "ALL".equalsIgnoreCase(actionToAdd)) continue;
                addActions.add(actionToAdd);
            }
            if (mEntity != null) {
                this.revokePrivilegeAndGrantPartial(pm, mEntity, currentPrivilege, persistedPriv, addActions);
            }
        }
    }

    private void persistEntity(PersistenceManager pm, ServiceConstants.SentryPrincipalType type, PrivilegePrincipal principal) {
        if (type == ServiceConstants.SentryPrincipalType.USER && this.isUserStale((MSentryUser)principal)) {
            pm.deletePersistent((Object)principal);
            return;
        }
        pm.makePersistent((Object)principal);
    }

    private boolean isUserStale(MSentryUser user) {
        return user.getPrivileges().isEmpty() && user.getRoles().isEmpty();
    }

    private void persistPrivilege(PersistenceManager pm, MSentryPrivilege privilege) {
        if (this.isPrivilegeStale(privilege)) {
            pm.deletePersistent((Object)privilege);
            return;
        }
        pm.makePersistent((Object)privilege);
    }

    private boolean isPrivilegeStale(MSentryPrivilege privilege) {
        return privilege.getUsers().isEmpty() && privilege.getRoles().isEmpty();
    }

    private boolean isPrivilegeStale(MSentryGMPrivilege privilege) {
        return privilege.getRoles().isEmpty();
    }

    private void revokePrivilegeAndGrantPartial(PersistenceManager pm, PrivilegePrincipal mEntity, MSentryPrivilege currentPrivilege, MSentryPrivilege persistedPriv, Set<String> addActions) throws SentryInvalidInputException {
        if ((persistedPriv = this.getMSentryPrivilege(this.convertToTSentryPrivilege(persistedPriv), pm)) != null) {
            persistedPriv.removePrincipal(mEntity);
            this.persistPrivilege(pm, persistedPriv);
        }
        currentPrivilege.setAction("*");
        persistedPriv = this.getMSentryPrivilege(this.convertToTSentryPrivilege(currentPrivilege), pm);
        if (persistedPriv != null && mEntity.getPrivileges().contains(persistedPriv)) {
            persistedPriv.removePrincipal(mEntity);
            this.persistPrivilege(pm, persistedPriv);
            for (String addAction : addActions) {
                currentPrivilege.setAction(addAction);
                TSentryPrivilege tSentryPrivilege = this.convertToTSentryPrivilege(currentPrivilege);
                persistedPriv = this.getMSentryPrivilege(tSentryPrivilege, pm);
                if (persistedPriv == null) {
                    persistedPriv = this.convertToMSentryPrivilege(tSentryPrivilege);
                }
                mEntity.appendPrivilege(persistedPriv);
            }
            persistedPriv.appendPrincipal(mEntity);
            pm.makePersistent((Object)persistedPriv);
        }
    }

    private void revokePrivilege(PersistenceManager pm, TSentryPrivilege tPrivilege, PrivilegePrincipal mEntity, MSentryPrivilege mPrivilege) throws SentryInvalidInputException {
        if (PARTIAL_REVOKE_ACTIONS.contains(mPrivilege.getAction())) {
            this.revokePartial(pm, tPrivilege, mEntity, mPrivilege);
        } else {
            MSentryPrivilege persistedPriv = this.getMSentryPrivilege(this.convertToTSentryPrivilege(mPrivilege), pm);
            if (persistedPriv != null) {
                persistedPriv.removePrincipal(mEntity);
                this.persistPrivilege(pm, persistedPriv);
            }
        }
    }

    private void populateChildren(PersistenceManager pm, ServiceConstants.SentryPrincipalType entityType, Set<String> entityNames, MSentryPrivilege priv, Collection<MSentryPrivilege> children) throws SentryInvalidInputException {
        Preconditions.checkNotNull((Object)pm);
        if (!(SentryUtils.isNULL((String)priv.getServerName()) && SentryUtils.isNULL((String)priv.getDbName()) && SentryUtils.isNULL((String)priv.getTableName()))) {
            Set<MSentryPrivilege> childPrivs = this.getChildPrivileges(pm, entityType, entityNames, priv);
            for (MSentryPrivilege childPriv : childPrivs) {
                if (!(SentryUtils.isNULL((String)childPriv.getDbName()) || SentryUtils.isNULL((String)childPriv.getTableName()) || SentryUtils.isNULL((String)childPriv.getColumnName()))) {
                    this.populateChildren(pm, entityType, entityNames, childPriv, children);
                }
                if (!priv.isActionALL()) {
                    if (childPriv.isActionALL()) {
                        childPriv.setAction(priv.getAction());
                    }
                    if (!priv.implies(childPriv)) continue;
                }
                children.add(childPriv);
            }
        }
    }

    private Set<MSentryPrivilege> getChildPrivileges(PersistenceManager pm, ServiceConstants.SentryPrincipalType entityType, Set<String> entityNames, MSentryPrivilege parent) throws SentryInvalidInputException {
        if (!SentryUtils.isNULL((String)parent.getColumnName()) || !SentryUtils.isNULL((String)parent.getURI())) {
            return Collections.emptySet();
        }
        Query query = pm.newQuery(MSentryPrivilege.class);
        QueryParamBuilder paramBuilder = null;
        if (entityType == ServiceConstants.SentryPrincipalType.ROLE) {
            paramBuilder = QueryParamBuilder.addRolesFilter(query, null, entityNames).add("serverName", parent.getServerName());
        } else if (entityType == ServiceConstants.SentryPrincipalType.USER) {
            paramBuilder = QueryParamBuilder.addUsersFilter(query, null, entityNames).add("serverName", parent.getServerName());
        } else {
            throw new SentryInvalidInputException("entityType" + entityType + " is not valid");
        }
        if (!SentryUtils.isNULL((String)parent.getDbName())) {
            paramBuilder.add("dbName", parent.getDbName());
            if (!SentryUtils.isNULL((String)parent.getTableName())) {
                paramBuilder.add("tableName", parent.getTableName()).addNotNull("columnName");
            } else {
                paramBuilder.addNotNull("tableName");
            }
        } else {
            paramBuilder.newChild().addNotNull("dbName").addNotNull("URI");
        }
        query.setFilter(paramBuilder.toString());
        query.setResult("privilegeScope, serverName, dbName, tableName, columnName, URI, action, grantOption");
        List privObjects = (List)query.executeWithMap(paramBuilder.getArguments());
        HashSet<MSentryPrivilege> privileges = new HashSet<MSentryPrivilege>(privObjects.size());
        for (Object[] privObj : privObjects) {
            String scope = (String)privObj[0];
            String serverName = (String)privObj[1];
            String dbName = (String)privObj[2];
            String tableName = (String)privObj[3];
            String columnName = (String)privObj[4];
            String URI2 = (String)privObj[5];
            String action = (String)privObj[6];
            Boolean grantOption = (Boolean)privObj[7];
            MSentryPrivilege priv = new MSentryPrivilege(scope, serverName, dbName, tableName, columnName, URI2, action, grantOption);
            privileges.add(priv);
        }
        return privileges;
    }

    public void dropSentryUser(final String userName) throws Exception {
        this.tm.executeTransactionWithRetry(new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                SentryStore.this.dropSentryUserCore(pm, userName);
                return null;
            }
        });
    }

    public synchronized void dropSentryUser(final String userName, Updateable.Update update) throws Exception {
        this.execute(update, new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                SentryStore.this.dropSentryUserCore(pm, userName);
                return null;
            }
        });
    }

    private void dropSentryUserCore(PersistenceManager pm, String userName) throws SentryNoSuchObjectException {
        String lUserName = userName.trim();
        MSentryUser sentryUser = this.getUser(pm, lUserName);
        if (sentryUser == null) {
            throw SentryStore.noSuchUser(lUserName);
        }
        this.removePrivilegesForUser(pm, sentryUser);
        pm.deletePersistent((Object)sentryUser);
    }

    private void removePrivilegesForUser(PersistenceManager pm, MSentryUser sentryUser) {
        ArrayList<MSentryPrivilege> privilegesCopy = new ArrayList<MSentryPrivilege>(sentryUser.getPrivileges());
        sentryUser.removePrivileges();
        this.removeStaledPrivileges(pm, privilegesCopy);
    }

    private List<MSentryPrivilege> getMSentryPrivileges(TSentryPrivilege tPriv, PersistenceManager pm) {
        Query query = pm.newQuery(MSentryPrivilege.class);
        QueryParamBuilder paramBuilder = QueryParamBuilder.newQueryParamBuilder();
        paramBuilder.add("serverName", tPriv.getServerName()).add("action", tPriv.getAction());
        if (!SentryUtils.isNULL((String)tPriv.getDbName())) {
            paramBuilder.add("dbName", tPriv.getDbName());
            if (!SentryUtils.isNULL((String)tPriv.getTableName())) {
                paramBuilder.add("tableName", tPriv.getTableName());
                if (!SentryUtils.isNULL((String)tPriv.getColumnName())) {
                    paramBuilder.add("columnName", tPriv.getColumnName());
                }
            }
        } else if (!SentryUtils.isNULL((String)tPriv.getURI())) {
            paramBuilder.add("URI", tPriv.getURI(), true);
        }
        query.setFilter(paramBuilder.toString());
        FetchGroup grp = pm.getFetchGroup(MSentryPrivilege.class, "fetchRolesUsers");
        grp.addMember("roles").addMember("users");
        pm.getFetchPlan().addGroup("fetchRolesUsers");
        return (List)query.executeWithMap(paramBuilder.getArguments());
    }

    private List<MSentryPrivilege> getMSentryPrivilegesExactMatch(TSentryPrivilege tPriv, PersistenceManager pm) {
        Query query = pm.newQuery(MSentryPrivilege.class);
        QueryParamBuilder paramBuilder = QueryParamBuilder.newQueryParamBuilder();
        paramBuilder.add("serverName", tPriv.getServerName()).add("action", tPriv.getAction()).add("dbName", tPriv.getDbName()).add("tableName", tPriv.getTableName()).add("columnName", tPriv.getColumnName()).add("URI", tPriv.getURI(), true);
        query.setFilter(paramBuilder.toString());
        return (List)query.executeWithMap(paramBuilder.getArguments());
    }

    private MSentryPrivilege getMSentryPrivilege(TSentryPrivilege tPriv, PersistenceManager pm) {
        Boolean grantOption = null;
        if (tPriv.getGrantOption().equals((Object)TSentryGrantOption.TRUE)) {
            grantOption = true;
        } else if (tPriv.getGrantOption().equals((Object)TSentryGrantOption.FALSE)) {
            grantOption = false;
        }
        QueryParamBuilder paramBuilder = QueryParamBuilder.newQueryParamBuilder();
        paramBuilder.add("serverName", tPriv.getServerName()).add("dbName", tPriv.getDbName()).add("tableName", tPriv.getTableName()).add("columnName", tPriv.getColumnName()).add("URI", tPriv.getURI(), true).add("action", tPriv.getAction()).addObject("grantOption", grantOption);
        LOGGER.debug("getMSentryPrivilege query filter: {}", (Object)paramBuilder.toString());
        Query query = pm.newQuery(MSentryPrivilege.class);
        query.setUnique(true);
        query.setFilter(paramBuilder.toString());
        return (MSentryPrivilege)query.executeWithMap(paramBuilder.getArguments());
    }

    private Set<String> getAllEquivalentActions(String inputAction) {
        if ("*".equalsIgnoreCase(inputAction) || "ALL".equalsIgnoreCase(inputAction)) {
            return Sets.newHashSet((Object[])new String[]{"*", "ALL", "ALL".toLowerCase()});
        }
        return Sets.newHashSet((Object[])new String[]{inputAction});
    }

    @Override
    public void dropSentryRole(String roleName) throws Exception {
        this.tm.executeTransactionWithRetry(pm -> {
            pm.setDetachAllOnCommit(false);
            this.dropSentryRoleCore(pm, roleName);
            return null;
        });
    }

    @Override
    public synchronized void dropSentryRole(String roleName, Updateable.Update update) throws Exception {
        this.execute(update, (PersistenceManager pm) -> {
            pm.setDetachAllOnCommit(false);
            this.dropSentryRoleCore(pm, roleName);
            return null;
        });
    }

    private void dropSentryRoleCore(PersistenceManager pm, String roleName) throws SentryNoSuchObjectException {
        String lRoleName = this.trimAndLower(roleName);
        MSentryRole sentryRole = this.getRole(pm, lRoleName);
        if (sentryRole == null) {
            throw SentryStore.noSuchRole(lRoleName);
        }
        this.removePrivileges(pm, sentryRole);
        pm.deletePersistent((Object)sentryRole);
    }

    private void removePrivileges(PersistenceManager pm, MSentryRole sentryRole) {
        ArrayList<MSentryPrivilege> privilegesCopy = new ArrayList<MSentryPrivilege>(sentryRole.getPrivileges());
        ArrayList<MSentryGMPrivilege> gmPrivilegesCopy = new ArrayList<MSentryGMPrivilege>(sentryRole.getGmPrivileges());
        sentryRole.removePrivileges();
        sentryRole.removeGMPrivileges();
        this.removeStaledPrivileges(pm, privilegesCopy);
        this.removeStaledGMPrivileges(pm, gmPrivilegesCopy);
    }

    private void removeStaledPrivileges(PersistenceManager pm, List<MSentryPrivilege> privilegesCopy) {
        ArrayList<MSentryPrivilege> stalePrivileges = new ArrayList<MSentryPrivilege>(0);
        for (MSentryPrivilege privilege : privilegesCopy) {
            if (!this.isPrivilegeStale(privilege)) continue;
            stalePrivileges.add(privilege);
        }
        if (!stalePrivileges.isEmpty()) {
            pm.deletePersistentAll(stalePrivileges);
        }
    }

    private void removeStaledGMPrivileges(PersistenceManager pm, List<MSentryGMPrivilege> privilegesCopy) {
        ArrayList<MSentryGMPrivilege> stalePrivileges = new ArrayList<MSentryGMPrivilege>(0);
        for (MSentryGMPrivilege privilege : privilegesCopy) {
            if (!this.isPrivilegeStale(privilege)) continue;
            stalePrivileges.add(privilege);
        }
        if (!stalePrivileges.isEmpty()) {
            pm.deletePersistentAll(stalePrivileges);
        }
    }

    @Override
    public void alterSentryRoleAddGroups(String grantorPrincipal, String roleName, Set<TSentryGroup> groupNames) throws Exception {
        this.tm.executeTransactionWithRetry(pm -> {
            pm.setDetachAllOnCommit(false);
            this.alterSentryRoleAddGroupsCore(pm, roleName, groupNames);
            return null;
        });
    }

    @Override
    public synchronized void alterSentryRoleAddGroups(String grantorPrincipal, String roleName, Set<TSentryGroup> groupNames, Updateable.Update update) throws Exception {
        this.execute(update, (PersistenceManager pm) -> {
            pm.setDetachAllOnCommit(false);
            this.alterSentryRoleAddGroupsCore(pm, roleName, groupNames);
            return null;
        });
    }

    private void alterSentryRoleAddGroupsCore(PersistenceManager pm, String roleName, Set<TSentryGroup> groupNames) throws SentryNoSuchObjectException {
        String lRoleName = this.trimAndLower(roleName);
        MSentryRole role = this.getRole(pm, lRoleName);
        if (role == null) {
            throw SentryStore.noSuchRole(lRoleName);
        }
        Query query = pm.newQuery(MSentryGroup.class);
        query.setFilter("this.groupName == :groupName");
        query.setUnique(true);
        ArrayList groups = Lists.newArrayList();
        for (TSentryGroup tGroup : groupNames) {
            String groupName = tGroup.getGroupName().trim();
            MSentryGroup group = (MSentryGroup)query.execute((Object)groupName);
            if (group == null) {
                group = new MSentryGroup(groupName, System.currentTimeMillis(), Sets.newHashSet((Object[])new MSentryRole[]{role}));
            }
            group.appendRole(role);
            groups.add(group);
        }
        pm.makePersistentAll((Collection)groups);
    }

    @Override
    public void alterSentryRoleAddUsers(String roleName, Set<String> userNames) throws Exception {
        this.tm.executeTransactionWithRetry(pm -> {
            pm.setDetachAllOnCommit(false);
            this.alterSentryRoleAddUsersCore(pm, roleName, userNames);
            return null;
        });
    }

    private void alterSentryRoleAddUsersCore(PersistenceManager pm, String roleName, Set<String> userNames) throws SentryNoSuchObjectException {
        String trimmedRoleName = this.trimAndLower(roleName);
        MSentryRole role = this.getRole(pm, trimmedRoleName);
        if (role == null) {
            throw SentryStore.noSuchRole(trimmedRoleName);
        }
        Query query = pm.newQuery(MSentryUser.class);
        query.setFilter("this.userName == :userName");
        query.setUnique(true);
        ArrayList users = Lists.newArrayList();
        for (String userName : userNames) {
            MSentryUser user = (MSentryUser)query.execute((Object)(userName = userName.trim()));
            if (user == null) {
                user = new MSentryUser(userName, System.currentTimeMillis(), Sets.newHashSet((Object[])new MSentryRole[]{role}));
            }
            user.appendRole(role);
            users.add(user);
        }
        pm.makePersistentAll((Collection)users);
    }

    @Override
    public void alterSentryRoleDeleteUsers(String roleName, Set<String> userNames) throws Exception {
        this.tm.executeTransactionWithRetry(pm -> {
            pm.setDetachAllOnCommit(false);
            String trimmedRoleName = this.trimAndLower(roleName);
            MSentryRole role = this.getRole(pm, trimmedRoleName);
            if (role == null) {
                throw SentryStore.noSuchRole(trimmedRoleName);
            }
            Query query = pm.newQuery(MSentryUser.class);
            query.setFilter("this.userName == :userName");
            query.setUnique(true);
            ArrayList usersToSave = Lists.newArrayList();
            ArrayList usersToDelete = Lists.newArrayList();
            for (String userName : userNames) {
                MSentryUser user = (MSentryUser)query.execute((Object)(userName = userName.trim()));
                if (user == null) continue;
                user.removeRole(role);
                if (this.isUserStale(user)) {
                    usersToDelete.add(user);
                    continue;
                }
                usersToSave.add(user);
            }
            pm.deletePersistentAll((Collection)usersToDelete);
            pm.makePersistentAll((Collection)usersToSave);
            return null;
        });
    }

    @Override
    public void alterSentryRoleDeleteGroups(String roleName, Set<TSentryGroup> groupNames) throws Exception {
        this.tm.executeTransactionWithRetry(pm -> {
            pm.setDetachAllOnCommit(false);
            String trimmedRoleName = this.trimAndLower(roleName);
            MSentryRole role = this.getRole(pm, trimmedRoleName);
            if (role == null) {
                throw SentryStore.noSuchRole(trimmedRoleName);
            }
            Query query = pm.newQuery(MSentryGroup.class);
            query.setFilter("this.groupName == :groupName");
            query.setUnique(true);
            ArrayList groups = Lists.newArrayList();
            for (TSentryGroup tGroup : groupNames) {
                String groupName = tGroup.getGroupName().trim();
                MSentryGroup group = (MSentryGroup)query.execute((Object)groupName);
                if (group == null) continue;
                group.removeRole(role);
                groups.add(group);
            }
            pm.makePersistentAll((Collection)groups);
            return null;
        });
    }

    @Override
    public synchronized void alterSentryRoleDeleteGroups(String roleName, Set<TSentryGroup> groupNames, Updateable.Update update) throws Exception {
        this.execute(update, (PersistenceManager pm) -> {
            pm.setDetachAllOnCommit(false);
            String trimmedRoleName = this.trimAndLower(roleName);
            MSentryRole role = this.getRole(pm, trimmedRoleName);
            if (role == null) {
                throw SentryStore.noSuchRole(trimmedRoleName);
            }
            Query query = pm.newQuery(MSentryGroup.class);
            query.setFilter("this.groupName == :groupName");
            query.setUnique(true);
            ArrayList groups = Lists.newArrayList();
            for (TSentryGroup tGroup : groupNames) {
                String groupName = tGroup.getGroupName().trim();
                MSentryGroup group = (MSentryGroup)query.execute((Object)groupName);
                if (group == null) continue;
                group.removeRole(role);
                groups.add(group);
            }
            pm.makePersistentAll((Collection)groups);
            return null;
        });
    }

    @VisibleForTesting
    public MSentryRole getMSentryRoleByName(String roleName) throws Exception {
        return this.tm.executeTransaction(pm -> {
            String trimmedRoleName = this.trimAndLower(roleName);
            MSentryRole sentryRole = this.getRole(pm, trimmedRoleName);
            if (sentryRole == null) {
                throw SentryStore.noSuchRole(trimmedRoleName);
            }
            return sentryRole;
        });
    }

    @VisibleForTesting
    MSentryPrivilege findMSentryPrivilegeFromTSentryPrivilege(TSentryPrivilege tPrivilege) throws Exception {
        return this.tm.executeTransaction(pm -> this.getMSentryPrivilege(tPrivilege, pm));
    }

    @VisibleForTesting
    List<MSentryPrivilege> getAllMSentryPrivileges() throws Exception {
        return this.tm.executeTransaction(pm -> this.getAllMSentryPrivilegesCore(pm));
    }

    private List<MSentryPrivilege> getAllMSentryPrivilegesCore(PersistenceManager pm) {
        Query query = pm.newQuery(MSentryPrivilege.class);
        return (List)query.execute();
    }

    private boolean hasAnyServerPrivileges(Set<String> roleNames, String serverName) throws Exception {
        if (roleNames == null || roleNames.isEmpty()) {
            return false;
        }
        return this.tm.executeTransaction(pm -> {
            pm.setDetachAllOnCommit(false);
            Query query = pm.newQuery(MSentryPrivilege.class);
            query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
            QueryParamBuilder paramBuilder = QueryParamBuilder.addRolesFilter(query, null, roleNames);
            paramBuilder.add("serverName", serverName);
            query.setFilter(paramBuilder.toString());
            query.setResult("count(this)");
            Long numPrivs = (Long)query.executeWithMap(paramBuilder.getArguments());
            return numPrivs > 0L;
        });
    }

    private List<MSentryPrivilege> getMSentryPrivileges(ServiceConstants.SentryPrincipalType entityType, Set<String> entityNames, TSentryAuthorizable authHierarchy) throws Exception {
        if (entityNames == null || entityNames.isEmpty()) {
            return Collections.emptyList();
        }
        return this.tm.executeTransaction(pm -> {
            FetchGroup grp;
            Query query = pm.newQuery(MSentryPrivilege.class);
            QueryParamBuilder paramBuilder = null;
            if (entityType == ServiceConstants.SentryPrincipalType.ROLE) {
                paramBuilder = QueryParamBuilder.addRolesFilter(query, null, entityNames);
            } else if (entityType == ServiceConstants.SentryPrincipalType.USER) {
                paramBuilder = QueryParamBuilder.addUsersFilter(query, null, entityNames);
            } else {
                throw new SentryInvalidInputException("entityType" + entityType + " is not valid");
            }
            if (authHierarchy != null && authHierarchy.getServer() != null) {
                paramBuilder.add("serverName", authHierarchy.getServer());
                if (authHierarchy.getDb() != null) {
                    paramBuilder.addNull("URI").newChild().add("dbName", authHierarchy.getDb()).addNull("dbName");
                    if (authHierarchy.getTable() != null && !"*".equalsIgnoreCase(authHierarchy.getTable())) {
                        if (!"+".equalsIgnoreCase(authHierarchy.getTable())) {
                            paramBuilder.addNull("URI").newChild().add("tableName", authHierarchy.getTable()).addNull("tableName");
                        }
                        if (authHierarchy.getColumn() != null && !"*".equalsIgnoreCase(authHierarchy.getColumn()) && !"+".equalsIgnoreCase(authHierarchy.getColumn())) {
                            paramBuilder.addNull("URI").newChild().add("columnName", authHierarchy.getColumn()).addNull("columnName");
                        }
                    }
                }
                if (authHierarchy.getUri() != null) {
                    paramBuilder.addNull("dbName").newChild().addNull("URI").newChild().addNotNull("URI").addCustomParam("(:authURI.startsWith(URI))", "authURI", authHierarchy.getUri());
                }
            }
            if (entityType == ServiceConstants.SentryPrincipalType.ROLE) {
                grp = pm.getFetchGroup(MSentryPrivilege.class, "fetchRoles");
                grp.addMember("roles");
                pm.getFetchPlan().addGroup("fetchRoles");
            } else if (entityType == ServiceConstants.SentryPrincipalType.USER) {
                grp = pm.getFetchGroup(MSentryPrivilege.class, "fetchUsers");
                grp.addMember("users");
                pm.getFetchPlan().addGroup("fetchUsers");
            }
            query.setFilter(paramBuilder.toString());
            List result = (List)query.executeWithMap(paramBuilder.getArguments());
            return result;
        });
    }

    private List<MSentryPrivilege> getMSentryPrivilegesByAuth(ServiceConstants.SentryPrincipalType entityType, Set<String> entityNames, TSentryAuthorizable authHierarchy) throws Exception {
        return this.tm.executeTransaction(pm -> {
            FetchGroup grp;
            Query query = pm.newQuery(MSentryPrivilege.class);
            QueryParamBuilder paramBuilder = QueryParamBuilder.newQueryParamBuilder();
            if (entityNames == null || entityNames.isEmpty()) {
                if (entityType == ServiceConstants.SentryPrincipalType.ROLE) {
                    paramBuilder.addString("!roles.isEmpty()");
                } else {
                    if (entityType != ServiceConstants.SentryPrincipalType.USER) throw new SentryInvalidInputException("entityType: " + entityType + " is invalid");
                    paramBuilder.addString("!users.isEmpty()");
                }
            } else if (entityType == ServiceConstants.SentryPrincipalType.ROLE) {
                QueryParamBuilder.addRolesFilter(query, paramBuilder, entityNames);
            } else {
                if (entityType != ServiceConstants.SentryPrincipalType.USER) throw new SentryInvalidInputException("entityType" + entityType + " is not valid");
                QueryParamBuilder.addUsersFilter(query, paramBuilder, entityNames);
            }
            if (authHierarchy.getServer() == null) return Collections.emptyList();
            paramBuilder.add("serverName", authHierarchy.getServer());
            if (authHierarchy.getDb() != null) {
                paramBuilder.add("dbName", authHierarchy.getDb()).addNull("URI");
                if (authHierarchy.getTable() != null) {
                    paramBuilder.add("tableName", authHierarchy.getTable());
                } else {
                    paramBuilder.addNull("tableName");
                }
            } else if (authHierarchy.getUri() != null) {
                paramBuilder.addNotNull("URI").addNull("dbName").addCustomParam("(:authURI.startsWith(URI))", "authURI", authHierarchy.getUri());
            } else {
                paramBuilder.addNull("dbName").addNull("URI");
            }
            if (entityType == ServiceConstants.SentryPrincipalType.ROLE) {
                grp = pm.getFetchGroup(MSentryPrivilege.class, "fetchRoles");
                grp.addMember("roles");
                pm.getFetchPlan().addGroup("fetchRoles");
            } else if (entityType == ServiceConstants.SentryPrincipalType.USER) {
                grp = pm.getFetchGroup(MSentryPrivilege.class, "fetchUsers");
                grp.addMember("users");
                pm.getFetchPlan().addGroup("fetchUsers");
            }
            query.setFilter(paramBuilder.toString());
            return (List)query.executeWithMap(paramBuilder.getArguments());
        });
    }

    private List<MSentryPrivilege> getMSentryOwnerPrivilegesByAuth(PersistenceManager pm, TSentryAuthorizable authHierarchy) throws Exception {
        Query query = pm.newQuery(MSentryPrivilege.class);
        QueryParamBuilder paramBuilder = QueryParamBuilder.newQueryParamBuilder();
        if (authHierarchy.getServer() != null) {
            paramBuilder.add("serverName", authHierarchy.getServer());
            if (authHierarchy.getDb() != null) {
                paramBuilder.add("dbName", authHierarchy.getDb()).addNull("URI");
                if (authHierarchy.getTable() != null) {
                    paramBuilder.add("tableName", authHierarchy.getTable());
                } else {
                    paramBuilder.addNull("tableName");
                }
            } else if (authHierarchy.getUri() != null) {
                paramBuilder.addNotNull("URI").addNull("dbName").addCustomParam("(:authURI.startsWith(URI))", "authURI", authHierarchy.getUri());
            } else {
                paramBuilder.addNull("dbName").addNull("URI");
            }
        } else {
            return Collections.emptyList();
        }
        paramBuilder.add("action", "OWNER");
        query.setFilter(paramBuilder.toString());
        FetchGroup grp = pm.getFetchGroup(MSentryPrivilege.class, "fetchRolesUsers");
        grp.addMember("roles").addMember("users");
        pm.getFetchPlan().addGroup("fetchRolesUsers");
        List result = (List)query.executeWithMap(paramBuilder.getArguments());
        return result;
    }

    private Set<MSentryPrivilege> getMSentryPrivilegesByUserName(String userName) throws Exception {
        MSentryUser mSentryUser = this.getMSentryUserByName(userName);
        return mSentryUser.getPrivileges();
    }

    @Override
    public Set<TSentryPrivilege> getAllTSentryPrivilegesByUserName(String userName) throws Exception {
        return this.convertToTSentryPrivileges(this.getMSentryPrivilegesByUserName(userName));
    }

    @Override
    public TSentryPrivilegeMap listSentryPrivilegesByAuthorizable(Set<String> groups, TSentryActiveRoleSet activeRoles, TSentryAuthorizable authHierarchy, boolean isAdmin) throws Exception {
        TreeMap resultPrivilegeMap = Maps.newTreeMap();
        Set<String> roles = this.getRolesToQuery(groups, null, new TSentryActiveRoleSet(true, null));
        if (activeRoles != null && !activeRoles.isAll()) {
            for (String aRole : activeRoles.getRoles()) {
                roles.add(aRole.toLowerCase());
            }
        }
        if (isAdmin || !roles.isEmpty()) {
            List<MSentryPrivilege> mSentryPrivileges = this.getMSentryPrivilegesByAuth(ServiceConstants.SentryPrincipalType.ROLE, roles, authHierarchy);
            for (MSentryPrivilege priv : mSentryPrivileges) {
                for (MSentryRole role : priv.getRoles()) {
                    TSentryPrivilege tPriv = this.convertToTSentryPrivilege(priv);
                    if (resultPrivilegeMap.containsKey(role.getRoleName())) {
                        ((Set)resultPrivilegeMap.get(role.getRoleName())).add(tPriv);
                        continue;
                    }
                    TreeSet tPrivSet = Sets.newTreeSet();
                    tPrivSet.add(tPriv);
                    resultPrivilegeMap.put(role.getRoleName(), tPrivSet);
                }
            }
        }
        return new TSentryPrivilegeMap((Map)resultPrivilegeMap);
    }

    @Override
    public List<SentryOwnerInfo> listOwnersByAuthorizable(TSentryAuthorizable authorizable) throws Exception {
        ArrayList ownerInfolist = new ArrayList();
        return this.tm.executeTransaction(pm -> {
            List<MSentryPrivilege> mSentryPrivileges = this.getMSentryOwnerPrivilegesByAuth(pm, authorizable);
            for (MSentryPrivilege priv : mSentryPrivileges) {
                for (PrivilegePrincipal privilegePrincipal : priv.getUsers()) {
                    ownerInfolist.add(new SentryOwnerInfo(privilegePrincipal.getPrincipalType(), privilegePrincipal.getPrincipalName()));
                }
                for (PrivilegePrincipal privilegePrincipal : priv.getRoles()) {
                    ownerInfolist.add(new SentryOwnerInfo(privilegePrincipal.getPrincipalType(), privilegePrincipal.getPrincipalName()));
                }
            }
            return ownerInfolist;
        });
    }

    @Override
    public TSentryPrivilegeMap listSentryPrivilegesByAuthorizableForUser(Set<String> userNames, TSentryAuthorizable authHierarchy, boolean isAdmin) throws Exception {
        TreeMap resultPrivilegeMap = Maps.newTreeMap();
        if (isAdmin || userNames != null && !userNames.isEmpty()) {
            List<MSentryPrivilege> mSentryPrivileges = this.getMSentryPrivilegesByAuth(ServiceConstants.SentryPrincipalType.USER, userNames, authHierarchy);
            for (MSentryPrivilege priv : mSentryPrivileges) {
                for (MSentryUser user : priv.getUsers()) {
                    TSentryPrivilege tPriv = this.convertToTSentryPrivilege(priv);
                    if (resultPrivilegeMap.containsKey(user.getUserName())) {
                        ((Set)resultPrivilegeMap.get(user.getUserName())).add(tPriv);
                        continue;
                    }
                    TreeSet tPrivSet = Sets.newTreeSet();
                    tPrivSet.add(tPriv);
                    resultPrivilegeMap.put(user.getUserName(), tPrivSet);
                }
            }
        }
        return new TSentryPrivilegeMap((Map)resultPrivilegeMap);
    }

    private Set<MSentryPrivilege> getMSentryPrivilegesByRoleName(String roleName) throws Exception {
        MSentryRole mSentryRole = this.getMSentryRoleByName(roleName);
        return mSentryRole.getPrivileges();
    }

    @Override
    public Set<TSentryPrivilege> getAllTSentryPrivilegesByRoleName(String roleName) throws Exception {
        return this.convertToTSentryPrivileges(this.getMSentryPrivilegesByRoleName(roleName));
    }

    @Override
    public Set<TSentryPrivilege> getTSentryPrivileges(ServiceConstants.SentryPrincipalType principalType, Set<String> principalNames, TSentryAuthorizable authHierarchy) throws Exception {
        if (authHierarchy.getServer() == null) {
            throw new SentryInvalidInputException("serverName cannot be null !!");
        }
        if (authHierarchy.getTable() != null && authHierarchy.getDb() == null) {
            throw new SentryInvalidInputException("dbName cannot be null when tableName is present !!");
        }
        if (authHierarchy.getColumn() != null && authHierarchy.getTable() == null) {
            throw new SentryInvalidInputException("tableName cannot be null when columnName is present !!");
        }
        if (authHierarchy.getUri() == null && authHierarchy.getDb() == null) {
            throw new SentryInvalidInputException("One of uri or dbName must not be null !!");
        }
        return this.convertToTSentryPrivileges(this.getMSentryPrivileges(principalType, principalNames, authHierarchy));
    }

    @Override
    public Set<TSentryRole> getTSentryRolesByGroupName(Set<String> groupNames, boolean checkAllGroups) throws Exception {
        if (groupNames.isEmpty()) {
            return Collections.emptySet();
        }
        return this.tm.executeTransaction(pm -> {
            pm.setDetachAllOnCommit(false);
            HashSet<String> roleNames = new HashSet<String>(1024);
            HashSet<TSentryRole> result = new HashSet<TSentryRole>(1024);
            for (String group : groupNames) {
                if (group == null) {
                    List<MSentryRole> roles = this.getAllRoles(pm);
                    for (MSentryRole role : roles) {
                        result.add(this.convertToTSentryRole(role));
                    }
                    return result;
                }
                String trimmedGroup = group.trim();
                Query query = pm.newQuery(MSentryGroup.class);
                query.setFilter("this.groupName == :groupName");
                query.setUnique(true);
                FetchGroup grp = pm.getFetchGroup(MSentryGroup.class, "fetchRoles");
                grp.addMember("roles");
                pm.getFetchPlan().addGroup("fetchRoles");
                MSentryGroup mGroup = (MSentryGroup)query.execute((Object)trimmedGroup);
                if (mGroup != null) {
                    for (MSentryRole role : mGroup.getRoles()) {
                        String roleName = role.getRoleName();
                        if (!roleNames.add(roleName)) continue;
                        result.add(this.convertToTSentryRole(role));
                    }
                } else if (!checkAllGroups) {
                    throw SentryStore.noSuchGroup(trimmedGroup);
                }
                query.closeAll();
            }
            return result;
        });
    }

    @Override
    public Set<String> getRoleNamesForGroups(Set<String> groups) throws Exception {
        if (groups == null || groups.isEmpty()) {
            return ImmutableSet.of();
        }
        return this.tm.executeTransaction(pm -> {
            pm.setDetachAllOnCommit(false);
            return this.getRoleNamesForGroupsCore(pm, groups);
        });
    }

    private Set<String> getRoleNamesForGroupsCore(PersistenceManager pm, Set<String> groups) {
        return this.convertToRoleNameSet(this.getRolesForGroups(pm, groups));
    }

    public Set<String> getRoleNamesForUsers(Set<String> users) throws Exception {
        if (users == null || users.isEmpty()) {
            return ImmutableSet.of();
        }
        return this.tm.executeTransaction(pm -> {
            pm.setDetachAllOnCommit(false);
            return this.getRoleNamesForUsersCore(pm, users);
        });
    }

    private Set<String> getRoleNamesForUsersCore(PersistenceManager pm, Set<String> users) {
        return this.convertToRoleNameSet(this.getRolesForUsers(pm, users));
    }

    @Override
    public Set<TSentryRole> getTSentryRolesByUserNames(Set<String> users) throws Exception {
        return this.tm.executeTransaction(pm -> {
            pm.setDetachAllOnCommit(false);
            Set<MSentryRole> mSentryRoles = this.getRolesForUsers(pm, users);
            return this.convertToTSentryRoles(mSentryRoles);
        });
    }

    public Set<MSentryRole> getRolesForGroups(PersistenceManager pm, Set<String> groups) {
        HashSet result = Sets.newHashSet();
        if (groups != null) {
            Query query = pm.newQuery(MSentryGroup.class);
            query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
            query.setFilter(":p1.contains(this.groupName)");
            FetchGroup grp = pm.getFetchGroup(MSentryGroup.class, "fetchRoles");
            grp.addMember("roles");
            pm.getFetchPlan().addGroup("fetchRoles");
            List sentryGroups = (List)query.execute((Object)groups.toArray());
            if (sentryGroups != null) {
                for (MSentryGroup sentryGroup : sentryGroups) {
                    result.addAll(sentryGroup.getRoles());
                }
            }
        }
        return result;
    }

    private Set<MSentryRole> getRolesForUsers(PersistenceManager pm, Set<String> users) {
        HashSet result = Sets.newHashSet();
        if (users != null) {
            Query query = pm.newQuery(MSentryUser.class);
            query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
            query.setFilter(":p1.contains(this.userName)");
            FetchGroup grp = pm.getFetchGroup(MSentryUser.class, "fetchRoles");
            grp.addMember("roles");
            pm.getFetchPlan().addGroup("fetchRoles");
            List sentryUsers = (List)query.execute((Object)users.toArray());
            if (sentryUsers != null) {
                for (MSentryUser sentryUser : sentryUsers) {
                    result.addAll(sentryUser.getRoles());
                }
            }
        }
        return result;
    }

    @Override
    public Set<TSentryPrivilege> listSentryPrivilegesByUsersAndGroups(Set<String> groups, Set<String> users, TSentryActiveRoleSet roleSet, TSentryAuthorizable authHierarchy) throws Exception {
        return this.convertToTSentryPrivileges(this.listSentryPrivilegesForProviderCore(groups, users, roleSet, authHierarchy));
    }

    Set<String> listAllSentryPrivilegesForProvider(Set<String> groups, Set<String> users, TSentryActiveRoleSet roleSet) throws Exception {
        return this.listSentryPrivilegesForProvider(groups, users, roleSet, null);
    }

    @Override
    public Set<String> listSentryPrivilegesForProvider(Set<String> groups, Set<String> users, TSentryActiveRoleSet roleSet, TSentryAuthorizable authHierarchy) throws Exception {
        HashSet result = Sets.newHashSet();
        Set<MSentryPrivilege> mSentryPrivileges = this.listSentryPrivilegesForProviderCore(groups, users, roleSet, authHierarchy);
        for (MSentryPrivilege priv : mSentryPrivileges) {
            result.add(SentryStore.toAuthorizable(priv));
        }
        return result;
    }

    private Set<MSentryPrivilege> listSentryPrivilegesForProviderCore(Set<String> groups, Set<String> users, TSentryActiveRoleSet roleSet, TSentryAuthorizable authHierarchy) throws Exception {
        HashSet privilegeSet = Sets.newHashSet();
        Set<String> rolesToQuery = this.getRolesToQuery(groups, users, roleSet);
        privilegeSet.addAll(this.getMSentryPrivileges(ServiceConstants.SentryPrincipalType.ROLE, rolesToQuery, authHierarchy));
        privilegeSet.addAll(this.getMSentryPrivileges(ServiceConstants.SentryPrincipalType.USER, users, authHierarchy));
        return privilegeSet;
    }

    @Override
    public boolean hasAnyServerPrivileges(Set<String> groups, Set<String> users, TSentryActiveRoleSet roleSet, String server) throws Exception {
        Set<String> rolesToQuery = this.getRolesToQuery(groups, users, roleSet);
        if (this.hasAnyServerPrivileges(rolesToQuery, server)) {
            return true;
        }
        return this.hasAnyServerPrivilegesForUser(users, server);
    }

    private boolean hasAnyServerPrivilegesForUser(final Set<String> userNames, final String serverName) throws Exception {
        if (userNames == null || userNames.isEmpty()) {
            return false;
        }
        return this.tm.executeTransaction(new TransactionBlock<Boolean>(){

            @Override
            public Boolean execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                Query query = pm.newQuery(MSentryPrivilege.class);
                query.addExtension(SentryStore.LOAD_RESULTS_AT_COMMIT, (Object)"false");
                QueryParamBuilder paramBuilder = QueryParamBuilder.addUsersFilter(query, null, userNames);
                paramBuilder.add("serverName", serverName);
                query.setFilter(paramBuilder.toString());
                query.setResult("count(this)");
                Long numPrivs = (Long)query.executeWithMap(paramBuilder.getArguments());
                return numPrivs > 0L;
            }
        });
    }

    private Set<String> getRolesToQuery(Set<String> groups, Set<String> users, TSentryActiveRoleSet roleSet) throws Exception {
        return this.tm.executeTransaction(pm -> {
            pm.setDetachAllOnCommit(false);
            Set<String> activeRoleNames = SentryStore.toTrimedLower(roleSet.getRoles());
            HashSet roleNames = Sets.newHashSet();
            roleNames.addAll(SentryStore.toTrimedLower(this.getRoleNamesForGroupsCore(pm, groups)));
            roleNames.addAll(SentryStore.toTrimedLower(this.getRoleNamesForUsersCore(pm, users)));
            return roleSet.isAll() ? roleNames : Sets.intersection(activeRoleNames, (Set)roleNames);
        });
    }

    @VisibleForTesting
    static String toAuthorizable(MSentryPrivilege privilege) {
        ArrayList<String> authorizable = new ArrayList<String>(4);
        authorizable.add(SentryConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.Server.name().toLowerCase(), (Object)privilege.getServerName(), new Object[0]));
        if (SentryUtils.isNULL((String)privilege.getURI())) {
            if (!SentryUtils.isNULL((String)privilege.getDbName())) {
                authorizable.add(SentryConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.Db.name().toLowerCase(), (Object)privilege.getDbName(), new Object[0]));
                if (!SentryUtils.isNULL((String)privilege.getTableName())) {
                    authorizable.add(SentryConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.Table.name().toLowerCase(), (Object)privilege.getTableName(), new Object[0]));
                    if (!SentryUtils.isNULL((String)privilege.getColumnName())) {
                        authorizable.add(SentryConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.Column.name().toLowerCase(), (Object)privilege.getColumnName(), new Object[0]));
                    }
                }
            }
        } else {
            authorizable.add(SentryConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.URI.name().toLowerCase(), (Object)privilege.getURI(), new Object[0]));
        }
        if (!SentryUtils.isNULL((String)privilege.getAction()) && !privilege.getAction().equalsIgnoreCase("*")) {
            authorizable.add(SentryConstants.KV_JOINER.join((Object)"action".toLowerCase(), (Object)privilege.getAction(), new Object[0]));
        }
        if (privilege.getGrantOption().booleanValue()) {
            authorizable.add(SentryConstants.KV_JOINER.join((Object)"grantOption".toLowerCase(), (Object)privilege.getGrantOption(), new Object[0]));
        }
        return SentryConstants.AUTHORIZABLE_JOINER.join(authorizable);
    }

    @VisibleForTesting
    public static Set<String> toTrimedLower(Set<String> s) {
        if (s == null || s.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet result = Sets.newHashSet();
        for (String v : s) {
            result.add(v.trim().toLowerCase());
        }
        return result;
    }

    private Set<TSentryPrivilege> convertToTSentryPrivileges(Collection<MSentryPrivilege> mSentryPrivileges) {
        if (mSentryPrivileges.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<TSentryPrivilege> privileges = new HashSet<TSentryPrivilege>(mSentryPrivileges.size());
        for (MSentryPrivilege mSentryPrivilege : mSentryPrivileges) {
            privileges.add(this.convertToTSentryPrivilege(mSentryPrivilege));
        }
        return privileges;
    }

    private Set<TSentryRole> convertToTSentryRoles(Set<MSentryRole> mSentryRoles) {
        if (mSentryRoles.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<TSentryRole> roles = new HashSet<TSentryRole>(mSentryRoles.size());
        for (MSentryRole mSentryRole : mSentryRoles) {
            roles.add(this.convertToTSentryRole(mSentryRole));
        }
        return roles;
    }

    private Set<String> convertToRoleNameSet(Set<MSentryRole> mSentryRoles) {
        if (mSentryRoles.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> roleNameSet = new HashSet<String>(mSentryRoles.size());
        for (MSentryRole role : mSentryRoles) {
            roleNameSet.add(role.getRoleName());
        }
        return roleNameSet;
    }

    private TSentryRole convertToTSentryRole(MSentryRole mSentryRole) {
        String roleName = mSentryRole.getRoleName().intern();
        Set<MSentryGroup> groups = mSentryRole.getGroups();
        HashSet<TSentryGroup> sentryGroups = new HashSet<TSentryGroup>(groups.size());
        for (MSentryGroup mSentryGroup : groups) {
            TSentryGroup group = this.convertToTSentryGroup(mSentryGroup);
            sentryGroups.add(group);
        }
        return new TSentryRole(roleName, sentryGroups, EMPTY_GRANTOR_PRINCIPAL);
    }

    private TSentryGroup convertToTSentryGroup(MSentryGroup mSentryGroup) {
        return new TSentryGroup(mSentryGroup.getGroupName().intern());
    }

    TSentryPrivilege convertToTSentryPrivilege(MSentryPrivilege mSentryPrivilege) {
        TSentryPrivilege privilege = new TSentryPrivilege();
        this.convertToTSentryPrivilege(mSentryPrivilege, privilege);
        return privilege;
    }

    private void convertToTSentryPrivilege(MSentryPrivilege mSentryPrivilege, TSentryPrivilege privilege) {
        privilege.setCreateTime(mSentryPrivilege.getCreateTime());
        privilege.setAction(SentryStore.fromNULLCol(mSentryPrivilege.getAction()));
        privilege.setPrivilegeScope(mSentryPrivilege.getPrivilegeScope());
        privilege.setServerName(SentryStore.fromNULLCol(mSentryPrivilege.getServerName()));
        privilege.setDbName(SentryStore.fromNULLCol(mSentryPrivilege.getDbName()));
        privilege.setTableName(SentryStore.fromNULLCol(mSentryPrivilege.getTableName()));
        privilege.setColumnName(SentryStore.fromNULLCol(mSentryPrivilege.getColumnName()));
        privilege.setURI(SentryStore.fromNULLCol(mSentryPrivilege.getURI()));
        if (mSentryPrivilege.getGrantOption() != null) {
            privilege.setGrantOption(TSentryGrantOption.valueOf((String)mSentryPrivilege.getGrantOption().toString().toUpperCase()));
        } else {
            privilege.setGrantOption(TSentryGrantOption.UNSET);
        }
    }

    private MSentryPrivilege convertToMSentryPrivilege(TSentryPrivilege privilege) throws SentryInvalidInputException {
        MSentryPrivilege mSentryPrivilege = new MSentryPrivilege();
        mSentryPrivilege.setServerName(SentryStore.toNULLCol(SentryStore.safeTrimLower(privilege.getServerName())));
        mSentryPrivilege.setDbName(SentryStore.toNULLCol(SentryStore.safeTrimLower(privilege.getDbName())));
        mSentryPrivilege.setTableName(SentryStore.toNULLCol(SentryStore.safeTrimLower(privilege.getTableName())));
        mSentryPrivilege.setColumnName(SentryStore.toNULLCol(SentryStore.safeTrimLower(privilege.getColumnName())));
        mSentryPrivilege.setPrivilegeScope(SentryStore.safeTrim(privilege.getPrivilegeScope()));
        mSentryPrivilege.setAction(SentryStore.toNULLCol(SentryStore.safeTrimLower(privilege.getAction())));
        mSentryPrivilege.setCreateTime(System.currentTimeMillis());
        mSentryPrivilege.setURI(SentryStore.toNULLCol(SentryStore.safeTrim(privilege.getURI())));
        if (!privilege.getGrantOption().equals((Object)TSentryGrantOption.UNSET)) {
            mSentryPrivilege.setGrantOption(Boolean.valueOf(privilege.getGrantOption().toString()));
        } else {
            mSentryPrivilege.setGrantOption(null);
        }
        return mSentryPrivilege;
    }

    static String safeTrim(String s) {
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    static String safeTrimLower(String s) {
        if (s == null) {
            return null;
        }
        return s.trim().toLowerCase();
    }

    String getSentryVersion() throws Exception {
        MSentryVersion mVersion = this.getMSentryVersion();
        return mVersion.getSchemaVersion();
    }

    void setSentryVersion(String newVersion, String verComment) throws Exception {
        this.tm.executeTransaction(pm -> {
            MSentryVersion mVersion;
            try {
                mVersion = this.getMSentryVersion();
                if (newVersion.equals(mVersion.getSchemaVersion())) {
                    return null;
                }
            }
            catch (SentryNoSuchObjectException e) {
                mVersion = new MSentryVersion();
            }
            mVersion.setSchemaVersion(newVersion);
            mVersion.setVersionComment(verComment);
            pm.makePersistent((Object)mVersion);
            return null;
        });
    }

    private MSentryVersion getMSentryVersion() throws Exception {
        return this.tm.executeTransaction(pm -> {
            try {
                Query query = pm.newQuery(MSentryVersion.class);
                List mSentryVersions = (List)query.execute();
                pm.retrieveAll((Collection)mSentryVersions);
                if (mSentryVersions.isEmpty()) {
                    throw new SentryNoSuchObjectException("Matching Version");
                }
                if (mSentryVersions.size() > 1) {
                    throw new SentryAccessDeniedException("Metastore contains multiple versions");
                }
                return (MSentryVersion)mSentryVersions.get(0);
            }
            catch (JDODataStoreException e) {
                if (e.getCause() instanceof MissingTableException) {
                    throw new SentryAccessDeniedException("Version table not found. The sentry store is not set or corrupt ");
                }
                throw e;
            }
        });
    }

    @Override
    public void dropPrivilege(TSentryAuthorizable tAuthorizable) throws Exception {
        this.tm.executeTransactionWithRetry(pm -> {
            pm.setDetachAllOnCommit(false);
            this.dropPrivilegeCore(pm, tAuthorizable);
            return null;
        });
    }

    @Override
    public synchronized void dropPrivilege(TSentryAuthorizable tAuthorizable, Updateable.Update update) throws Exception {
        this.execute(update, (PersistenceManager pm) -> {
            pm.setDetachAllOnCommit(false);
            this.dropPrivilegeCore(pm, tAuthorizable);
            return null;
        });
    }

    private void dropPrivilegeCore(PersistenceManager pm, TSentryAuthorizable tAuthorizable) throws Exception {
        TSentryPrivilege tPrivilege = this.toSentryPrivilege(tAuthorizable);
        tPrivilege.setGrantOption(TSentryGrantOption.UNSET);
        try {
            if (this.isMultiActionsSupported(tPrivilege)) {
                for (String privilegeAction : ALL_ACTIONS) {
                    tPrivilege.setAction(privilegeAction);
                    this.dropPrivilegeForAllEntities(pm, new TSentryPrivilege(tPrivilege));
                }
            } else {
                this.dropPrivilegeForAllEntities(pm, new TSentryPrivilege(tPrivilege));
            }
        }
        catch (JDODataStoreException e) {
            throw new SentryInvalidInputException("Failed to get privileges: " + e.getMessage());
        }
    }

    @Override
    public synchronized void updateOwnerPrivilege(TSentryAuthorizable tAuthorizable, String ownerName, ServiceConstants.SentryPrincipalType principalType, List<Updateable.Update> updates) throws Exception {
        this.execute(updates, (PersistenceManager pm) -> {
            if (principalType == null) {
                LOGGER.info("Invalid principal Type");
            }
            pm.setDetachAllOnCommit(false);
            TSentryPrivilege tOwnerPrivilege = this.toSentryPrivilege(tAuthorizable);
            tOwnerPrivilege.setAction("OWNER");
            this.revokeOwnerPrivilegesCore(pm, tAuthorizable);
            try {
                if (this.ownerPrivilegeWithGrant) {
                    tOwnerPrivilege.setGrantOption(TSentryGrantOption.TRUE);
                }
                this.alterSentryGrantPrivilegeCore(pm, principalType, ownerName, tOwnerPrivilege);
                return null;
            }
            catch (JDODataStoreException e) {
                throw new SentryInvalidInputException("Failed to grant owner privilege on Authorizable : " + tAuthorizable.toString() + " to " + principalType.toString() + ": " + ownerName + " " + e.getMessage());
            }
        });
    }

    @Override
    public void alterSentryRevokeOwnerPrivilege(TSentryAuthorizable tAuthorizable, List<Updateable.Update> updates) throws Exception {
        this.execute(updates, (PersistenceManager pm) -> {
            pm.setDetachAllOnCommit(false);
            this.revokeOwnerPrivilegesCore(pm, tAuthorizable);
            return null;
        });
    }

    public void revokeOwnerPrivilegesCore(PersistenceManager pm, TSentryAuthorizable tAuthorizable) throws Exception {
        TSentryPrivilege tOwnerPrivilege = this.toSentryPrivilege(tAuthorizable);
        tOwnerPrivilege.setAction("OWNER");
        List<MSentryPrivilege> mOwnerPrivileges = this.getMSentryPrivilegesExactMatch(tOwnerPrivilege, pm);
        for (MSentryPrivilege mOwnerPriv : mOwnerPrivileges) {
            Set<MSentryUser> users = mOwnerPriv.getUsers();
            for (MSentryUser user : users) {
                user.removePrivilege(mOwnerPriv);
                this.persistEntity(pm, ServiceConstants.SentryPrincipalType.USER, user);
            }
        }
        pm.deletePersistentAll(mOwnerPrivileges);
    }

    @Override
    public void renamePrivilege(TSentryAuthorizable oldTAuthorizable, TSentryAuthorizable newTAuthorizable) throws Exception {
        this.tm.executeTransactionWithRetry(pm -> {
            pm.setDetachAllOnCommit(false);
            this.renamePrivilegeCore(pm, oldTAuthorizable, newTAuthorizable);
            return null;
        });
    }

    @Override
    public synchronized void renamePrivilege(TSentryAuthorizable oldTAuthorizable, TSentryAuthorizable newTAuthorizable, Updateable.Update update) throws Exception {
        this.execute(update, (PersistenceManager pm) -> {
            pm.setDetachAllOnCommit(false);
            this.renamePrivilegeCore(pm, oldTAuthorizable, newTAuthorizable);
            return null;
        });
    }

    private void renamePrivilegeCore(PersistenceManager pm, TSentryAuthorizable oldTAuthorizable, TSentryAuthorizable newTAuthorizable) throws Exception {
        TSentryPrivilege tPrivilege = this.toSentryPrivilege(oldTAuthorizable);
        TSentryPrivilege newPrivilege = this.toSentryPrivilege(newTAuthorizable);
        tPrivilege.setGrantOption(TSentryGrantOption.FALSE);
        newPrivilege.setGrantOption(TSentryGrantOption.FALSE);
        this.renamePrivilegeCore(pm, tPrivilege, newPrivilege);
        tPrivilege.setGrantOption(TSentryGrantOption.TRUE);
        newPrivilege.setGrantOption(TSentryGrantOption.TRUE);
        this.renamePrivilegeCore(pm, tPrivilege, newPrivilege);
    }

    private void renamePrivilegeCore(PersistenceManager pm, TSentryPrivilege tPrivilege, TSentryPrivilege newPrivilege) throws Exception {
        try {
            if (this.isMultiActionsSupported(tPrivilege)) {
                for (String privilegeAction : ALL_ACTIONS) {
                    tPrivilege.setAction(privilegeAction);
                    newPrivilege.setAction(privilegeAction);
                    this.renamePrivilegeForAllEntities(pm, tPrivilege, newPrivilege);
                }
            } else {
                this.renamePrivilegeForAllEntities(pm, tPrivilege, newPrivilege);
            }
        }
        catch (JDODataStoreException e) {
            throw new SentryInvalidInputException("Failed to get privileges: " + e.getMessage());
        }
    }

    private boolean isMultiActionsSupported(TSentryPrivilege tPrivilege) {
        return tPrivilege.getDbName() != null;
    }

    private void renamePrivilegeForAllEntities(PersistenceManager pm, TSentryPrivilege tPrivilege, TSentryPrivilege newPrivilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        this.dropOrRenamePrivilegeForAllEntities(pm, tPrivilege, newPrivilege);
    }

    private void dropPrivilegeForAllEntities(PersistenceManager pm, TSentryPrivilege tPrivilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        this.dropOrRenamePrivilegeForAllEntities(pm, tPrivilege, null);
    }

    private void dropOrRenamePrivilegeForAllEntities(PersistenceManager pm, TSentryPrivilege tPrivilege, TSentryPrivilege newTPrivilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        HashSet entitySet = new HashSet();
        List<MSentryPrivilege> mPrivileges = this.getMSentryPrivileges(tPrivilege, pm);
        for (MSentryPrivilege mPrivilege : mPrivileges) {
            entitySet.addAll(ImmutableSet.copyOf(mPrivilege.getRoles()));
            entitySet.addAll(ImmutableSet.copyOf(mPrivilege.getUsers()));
        }
        if (newTPrivilege == null) {
            for (PrivilegePrincipal principal : entitySet) {
                this.alterSentryRevokePrivilegeCore(pm, principal.getPrincipalType(), principal.getPrincipalName(), tPrivilege);
            }
            return;
        }
        MSentryPrivilege parent = this.getMSentryPrivilege(tPrivilege, pm);
        if (parent != null) {
            parent = (MSentryPrivilege)pm.detachCopy((Object)parent);
        }
        for (PrivilegePrincipal principal : entitySet) {
            PrivilegePrincipal detachedEntity = (PrivilegePrincipal)pm.detachCopy((Object)principal);
            HashSet<MSentryPrivilege> privilegeGraph = new HashSet<MSentryPrivilege>();
            if (parent != null) {
                privilegeGraph.add(parent);
                this.populateChildren(pm, detachedEntity.getPrincipalType(), Sets.newHashSet((Object[])new String[]{detachedEntity.getPrincipalName()}), parent, privilegeGraph);
            } else {
                this.populateChildren(pm, detachedEntity.getPrincipalType(), Sets.newHashSet((Object[])new String[]{detachedEntity.getPrincipalName()}), this.convertToMSentryPrivilege(tPrivilege), privilegeGraph);
            }
            this.alterSentryRevokePrivilegeCore(pm, detachedEntity.getPrincipalType(), detachedEntity.getPrincipalName(), tPrivilege);
            for (MSentryPrivilege mPriv : privilegeGraph) {
                TSentryPrivilege tPriv = this.convertToTSentryPrivilege(mPriv);
                if (newTPrivilege.getPrivilegeScope().equals(ApiConstants.PrivilegeScope.DATABASE.name())) {
                    tPriv.setDbName(newTPrivilege.getDbName());
                } else if (newTPrivilege.getPrivilegeScope().equals(ApiConstants.PrivilegeScope.TABLE.name())) {
                    tPriv.setDbName(newTPrivilege.getDbName());
                    tPriv.setTableName(newTPrivilege.getTableName());
                }
                this.alterSentryGrantPrivilegeCore(pm, detachedEntity.getPrincipalType(), detachedEntity.getPrincipalName(), tPriv);
            }
        }
    }

    private TSentryPrivilege toSentryPrivilege(TSentryAuthorizable tAuthorizable) throws SentryInvalidInputException {
        TSentryPrivilege tSentryPrivilege = new TSentryPrivilege();
        tSentryPrivilege.setDbName(SentryStore.fromNULLCol(tAuthorizable.getDb()));
        tSentryPrivilege.setServerName(SentryStore.fromNULLCol(tAuthorizable.getServer()));
        tSentryPrivilege.setTableName(SentryStore.fromNULLCol(tAuthorizable.getTable()));
        tSentryPrivilege.setColumnName(SentryStore.fromNULLCol(tAuthorizable.getColumn()));
        tSentryPrivilege.setURI(SentryStore.fromNULLCol(tAuthorizable.getUri()));
        ApiConstants.PrivilegeScope scope = !SentryUtils.isNULL((String)tSentryPrivilege.getColumnName()) ? ApiConstants.PrivilegeScope.COLUMN : (!SentryUtils.isNULL((String)tSentryPrivilege.getTableName()) ? ApiConstants.PrivilegeScope.TABLE : (!SentryUtils.isNULL((String)tSentryPrivilege.getDbName()) ? ApiConstants.PrivilegeScope.DATABASE : (!SentryUtils.isNULL((String)tSentryPrivilege.getURI()) ? ApiConstants.PrivilegeScope.URI : ApiConstants.PrivilegeScope.SERVER)));
        tSentryPrivilege.setPrivilegeScope(scope.name());
        tSentryPrivilege.setAction("*");
        return tSentryPrivilege;
    }

    public static String toNULLCol(String s) {
        return Strings.isNullOrEmpty((String)s) ? "__NULL__" : s;
    }

    private static String fromNULLCol(String s) {
        return SentryUtils.isNULL((String)s) ? "" : s;
    }

    @Override
    public PermissionsImage retrieveFullPermssionsImage() throws Exception {
        return this.tm.executeTransaction(pm -> {
            pm.setDetachAllOnCommit(false);
            long curChangeID = SentryStore.getLastProcessedChangeIDCore(pm, MSentryPermChange.class);
            Map<String, List<String>> roleImage = this.retrieveFullRoleImageCore(pm);
            Map<String, Map<TPrivilegePrincipal, String>> privilegeMap = this.retrieveFullPrivilegeImageCore(pm);
            return new PermissionsImage(roleImage, privilegeMap, curChangeID);
        });
    }

    private Map<String, Map<TPrivilegePrincipal, String>> retrieveFullPrivilegeImageCore(PersistenceManager pm) throws Exception {
        pm.setDetachAllOnCommit(false);
        HashMap<String, Map<TPrivilegePrincipal, String>> retVal = new HashMap<String, Map<TPrivilegePrincipal, String>>();
        Query query = pm.newQuery(MSentryPrivilege.class);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        QueryParamBuilder paramBuilder = QueryParamBuilder.newQueryParamBuilder();
        paramBuilder.addNotNull("serverName").addNotNull("dbName").addNull("URI");
        query.setFilter(paramBuilder.toString());
        query.setOrdering("serverName ascending, dbName ascending, tableName ascending");
        FetchGroup grp = pm.getFetchGroup(MSentryPrivilege.class, "fetchRolesUsers");
        grp.addMember("roles").addMember("users");
        pm.getFetchPlan().addGroup("fetchRolesUsers");
        List privileges = (List)query.executeWithMap(paramBuilder.getArguments());
        for (MSentryPrivilege mPriv : privileges) {
            Map<TPrivilegePrincipal, String> pUpdate;
            String authzObj = mPriv.getDbName();
            if (!SentryUtils.isNULL((String)mPriv.getTableName())) {
                authzObj = authzObj + "." + mPriv.getTableName();
            }
            if ((pUpdate = (HashMap<TPrivilegePrincipal, String>)retVal.get(authzObj)) == null) {
                pUpdate = new HashMap<TPrivilegePrincipal, String>();
                retVal.put(authzObj, pUpdate);
            }
            for (MSentryRole mRole : mPriv.getRoles()) {
                pUpdate = SentryStore.addPrivilegeEntry(mPriv, TPrivilegePrincipalType.ROLE, mRole.getRoleName(), pUpdate);
            }
            for (MSentryUser mUser : mPriv.getUsers()) {
                pUpdate = SentryStore.addPrivilegeEntry(mPriv, TPrivilegePrincipalType.USER, mUser.getUserName(), pUpdate);
            }
        }
        query.closeAll();
        return retVal;
    }

    private static Map<TPrivilegePrincipal, String> addPrivilegeEntry(MSentryPrivilege mPriv, TPrivilegePrincipalType tEntityType, String principal, Map<TPrivilegePrincipal, String> update) {
        TPrivilegePrincipal tPrivilegePrincipal = new TPrivilegePrincipal(tEntityType, principal);
        String existingPriv = update.get(tPrivilegePrincipal);
        String action = mPriv.getAction().toUpperCase();
        String newAction = mPriv.getAction().toUpperCase();
        if (action.equals("OWNER")) {
            newAction = "ALL";
        }
        if (existingPriv == null) {
            update.put(tPrivilegePrincipal, newAction);
        } else {
            update.put(tPrivilegePrincipal, existingPriv + "," + newAction);
        }
        return update;
    }

    private Map<String, List<String>> retrieveFullRoleImageCore(PersistenceManager pm) throws Exception {
        pm.setDetachAllOnCommit(false);
        Query query = pm.newQuery(MSentryGroup.class);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        FetchGroup grp = pm.getFetchGroup(MSentryGroup.class, "fetchRoles");
        grp.addMember("roles");
        pm.getFetchPlan().addGroup("fetchRoles");
        List groups = (List)query.execute();
        if (groups.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> retVal = new HashMap<String, List<String>>();
        for (MSentryGroup mGroup : groups) {
            for (MSentryRole role : mGroup.getRoles()) {
                ArrayList<String> rUpdate = (ArrayList<String>)retVal.get(role.getRoleName());
                if (rUpdate == null) {
                    rUpdate = new ArrayList<String>();
                    retVal.put(role.getRoleName(), rUpdate);
                }
                rUpdate.add(mGroup.getGroupName());
            }
        }
        query.closeAll();
        return retVal;
    }

    public PathsImage retrieveFullPathsImage() throws Exception {
        return (PathsImage)this.tm.executeTransaction(new TransactionBlock(){

            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                long curChangeID = SentryStore.getLastProcessedChangeIDCore(pm, MSentryPathChange.class);
                long curImageID = SentryStore.getCurrentAuthzPathsSnapshotID(pm);
                Map pathImage = SentryStore.this.retrieveFullPathsImageCore(pm, curImageID);
                return new PathsImage(pathImage, curChangeID, curImageID);
            }
        });
    }

    @Override
    public PathsUpdate retrieveFullPathsImageUpdate(String[] prefixes) throws Exception {
        return this.tm.executeTransaction(pm -> {
            pm.setDetachAllOnCommit(false);
            long curImageID = SentryStore.getCurrentAuthzPathsSnapshotID(pm);
            long curChangeID = SentryStore.getLastProcessedChangeIDCore(pm, MSentryPathChange.class);
            PathsUpdate pathUpdate = new PathsUpdate(curChangeID, curImageID, true);
            UpdateableAuthzPaths authzPaths = new UpdateableAuthzPaths(prefixes);
            this.retrieveFullPathsImageCore(pm, curImageID, authzPaths);
            pathUpdate.toThrift().setPathsDump(authzPaths.getPathsDump().createPathsDump(true));
            return pathUpdate;
        });
    }

    private Map<String, Collection<String>> retrieveFullPathsImageCore(PersistenceManager pm, long currentSnapshotID) {
        if (currentSnapshotID <= 0L) {
            return Collections.emptyMap();
        }
        Query query = pm.newQuery(MAuthzPathsMapping.class);
        query.setFilter("this.authzSnapshotID == currentSnapshotID");
        query.declareParameters("long currentSnapshotID");
        Collection authzToPathsMappings = (Collection)query.execute((Object)currentSnapshotID);
        if (authzToPathsMappings.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Collection<String>> retVal = new HashMap<String, Collection<String>>(authzToPathsMappings.size());
        for (MAuthzPathsMapping authzToPaths : authzToPathsMappings) {
            retVal.put(authzToPaths.getAuthzObjName(), authzToPaths.getPathStrings());
        }
        return retVal;
    }

    private void retrieveFullPathsImageCore(PersistenceManager pm, long currentSnapshotID, UpdateableAuthzPaths pathUpdate) {
        Query query = pm.newQuery(MAuthzPathsMapping.class);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        query.setFilter("this.authzSnapshotID == currentSnapshotID");
        query.declareParameters("long currentSnapshotID");
        pm.getFetchPlan().addGroup("includingPaths");
        Collection authzToPathsMappings = (Collection)query.execute((Object)currentSnapshotID);
        for (MAuthzPathsMapping authzToPaths : authzToPathsMappings) {
            String objName = authzToPaths.getAuthzObjName();
            for (String path : authzToPaths.getPathStrings()) {
                String[] pathComponents = PathUtils.splitPath((String)path);
                ArrayList paths = new ArrayList(pathComponents.length);
                Collections.addAll(paths, pathComponents);
                pathUpdate.applyAddChanges(objName, Collections.singletonList(paths));
            }
        }
    }

    private void deleteNotificationsSince(PersistenceManager pm, long id) {
        Query query = pm.newQuery(MSentryHmsNotification.class);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        query.setFilter("notificationId >= currentNotificationId");
        query.declareParameters("long currentNotificationId");
        long numDeleted = query.deletePersistentAll(new Object[]{id});
        if (numDeleted > 0L) {
            LOGGER.info("Purged {} notification entries starting from {}", (Object)numDeleted, (Object)id);
        }
    }

    @Override
    public void persistFullPathsImage(Map<String, Collection<String>> authzPaths, long notificationID) throws Exception {
        this.tm.executeTransactionWithRetry(pm -> {
            int totalNumberOfObjectsToPersist = authzPaths.size();
            int totalNumberOfPathsToPersist = authzPaths.values().stream().mapToInt(Collection::size).sum();
            int objectsPersistedCount = 0;
            int pathsPersistedCount = 0;
            this.logPersistingFullSnapshotState(totalNumberOfObjectsToPersist, totalNumberOfPathsToPersist, objectsPersistedCount, pathsPersistedCount);
            pm.setDetachAllOnCommit(false);
            this.deleteNotificationsSince(pm, notificationID + 1L);
            pm.makePersistent((Object)new MSentryHmsNotification(notificationID));
            long snapshotID = SentryStore.getCurrentAuthzPathsSnapshotID(pm);
            long nextObjectId = SentryStore.getNextAuthzObjectID(pm);
            long nextSnapshotID = snapshotID + 1L;
            pm.makePersistent((Object)new MAuthzPathsSnapshotId(nextSnapshotID));
            LOGGER.info("Attempting to commit new HMS snapshot with ID = {}", (Object)nextSnapshotID);
            long lastProgressTime = System.currentTimeMillis();
            for (Map.Entry authzPath : authzPaths.entrySet()) {
                MAuthzPathsMapping mapping = new MAuthzPathsMapping(nextSnapshotID, nextObjectId++, (String)authzPath.getKey(), (Collection)authzPath.getValue());
                mapping.makePersistent(pm);
                ++objectsPersistedCount;
                pathsPersistedCount += ((Collection)authzPath.getValue()).size();
                long currentTime = System.currentTimeMillis();
                if (currentTime - lastProgressTime <= 300000L) continue;
                this.logPersistingFullSnapshotState(totalNumberOfObjectsToPersist, totalNumberOfPathsToPersist, objectsPersistedCount, pathsPersistedCount);
                lastProgressTime = currentTime;
            }
            return null;
        });
    }

    public void logPersistingFullSnapshotState(int totalNumberOfObjectsToPersist, int totalNumberOfPathsToPersist, int objectsPersistedCount, int pathsPersistedCount) {
        LOGGER.info(String.format("Persisting HMS Paths on Snapshot: authz_objs_persisted=%d(%.2f%%) authz_paths_persisted=%d(%.2f%%) authz_objs_total=%d authz_paths_total=%d", objectsPersistedCount, totalNumberOfObjectsToPersist > 0 ? 100.0 * ((double)objectsPersistedCount / (double)totalNumberOfObjectsToPersist) : 0.0, pathsPersistedCount, totalNumberOfPathsToPersist > 0 ? 100.0 * ((double)pathsPersistedCount / (double)totalNumberOfPathsToPersist) : 0.0, totalNumberOfObjectsToPersist, totalNumberOfPathsToPersist));
    }

    private static long getNextAuthzObjectID(PersistenceManager pm) {
        return SentryStore.getMaxPersistedIDCore(pm, MAuthzPathsMapping.class, "authzObjectId", 0L) + 1L;
    }

    private static long getCurrentAuthzPathsSnapshotID(PersistenceManager pm) {
        return SentryStore.getMaxPersistedIDCore(pm, MAuthzPathsSnapshotId.class, "authzSnapshotID", 0L);
    }

    @VisibleForTesting
    long getCurrentAuthzPathsSnapshotID() throws Exception {
        return this.tm.executeTransaction(SentryStore::getCurrentAuthzPathsSnapshotID);
    }

    @Override
    public void addAuthzPathsMapping(String authzObj, Collection<String> paths, UniquePathsUpdate update) throws Exception {
        this.execute((Updateable.Update)update, (PersistenceManager pm) -> {
            pm.setDetachAllOnCommit(false);
            this.addAuthzPathsMappingCore(pm, authzObj, paths);
            return null;
        });
    }

    private void addAuthzPathsMappingCore(PersistenceManager pm, String authzObj, Collection<String> paths) {
        MAuthzPathsMapping mAuthzPathsMapping;
        long currentSnapshotID = SentryStore.getCurrentAuthzPathsSnapshotID(pm);
        if (currentSnapshotID <= 0L) {
            LOGGER.warn("AuthzObj: {} cannot be persisted if paths snapshot ID does not exist yet.", (Object)authzObj);
        }
        if ((mAuthzPathsMapping = this.getMAuthzPathsMappingCore(pm, currentSnapshotID, authzObj)) == null) {
            mAuthzPathsMapping = new MAuthzPathsMapping(currentSnapshotID, SentryStore.getNextAuthzObjectID(pm), authzObj, paths);
        } else {
            mAuthzPathsMapping.addPathToPersist(paths);
        }
        mAuthzPathsMapping.makePersistent(pm);
    }

    @Override
    public void deleteAuthzPathsMapping(String authzObj, Collection<String> paths, UniquePathsUpdate update) throws Exception {
        this.execute((Updateable.Update)update, (PersistenceManager pm) -> {
            pm.setDetachAllOnCommit(false);
            this.deleteAuthzPathsMappingCore(pm, authzObj, paths);
            return null;
        });
    }

    private void deleteAuthzPathsMappingCore(PersistenceManager pm, String authzObj, Collection<String> paths) {
        MAuthzPathsMapping mAuthzPathsMapping;
        long currentSnapshotID = SentryStore.getCurrentAuthzPathsSnapshotID(pm);
        if (currentSnapshotID <= 0L) {
            LOGGER.error("No paths snapshot ID is found. Cannot delete authzoObj: {}", (Object)authzObj);
        }
        if ((mAuthzPathsMapping = this.getMAuthzPathsMappingCore(pm, currentSnapshotID, authzObj)) != null) {
            mAuthzPathsMapping.deletePersistent(pm, paths);
        } else {
            LOGGER.error("nonexistent authzObj: {} on current paths snapshot ID #{}", (Object)authzObj, (Object)currentSnapshotID);
        }
    }

    @Override
    public void deleteAllAuthzPathsMapping(String authzObj, UniquePathsUpdate update) throws Exception {
        this.execute((Updateable.Update)update, (PersistenceManager pm) -> {
            pm.setDetachAllOnCommit(false);
            this.deleteAllAuthzPathsMappingCore(pm, authzObj);
            return null;
        });
    }

    private void deleteAllAuthzPathsMappingCore(PersistenceManager pm, String authzObj) {
        MAuthzPathsMapping mAuthzPathsMapping;
        long currentSnapshotID = SentryStore.getCurrentAuthzPathsSnapshotID(pm);
        if (currentSnapshotID <= 0L) {
            LOGGER.error("No paths snapshot ID is found. Cannot delete authzoObj: {}", (Object)authzObj);
        }
        if ((mAuthzPathsMapping = this.getMAuthzPathsMappingCore(pm, currentSnapshotID, authzObj)) != null) {
            pm.deletePersistent((Object)mAuthzPathsMapping);
        } else {
            LOGGER.error("nonexistent authzObj: {} on current paths snapshot ID #{}", (Object)authzObj, (Object)currentSnapshotID);
        }
    }

    @Override
    public void renameAuthzPathsMapping(String oldObj, String newObj, String oldPath, String newPath, UniquePathsUpdate update) throws Exception {
        this.execute((Updateable.Update)update, (PersistenceManager pm) -> {
            pm.setDetachAllOnCommit(false);
            this.renameAuthzPathsMappingCore(pm, oldObj, newObj, oldPath, newPath);
            return null;
        });
    }

    private void renameAuthzPathsMappingCore(PersistenceManager pm, String oldObj, String newObj, String oldPath, String newPath) {
        MAuthzPathsMapping mAuthzPathsMapping;
        long currentSnapshotID = SentryStore.getCurrentAuthzPathsSnapshotID(pm);
        if (currentSnapshotID <= 0L) {
            LOGGER.error("No paths snapshot ID is found. Cannot rename authzoObj: {}", (Object)oldObj);
        }
        if ((mAuthzPathsMapping = this.getMAuthzPathsMappingCore(pm, currentSnapshotID, oldObj)) != null) {
            mAuthzPathsMapping.deletePersistent(pm, Collections.singleton(oldPath));
            mAuthzPathsMapping.setAuthzObjName(newObj);
            mAuthzPathsMapping.addPathToPersist(Collections.singleton(newPath));
            mAuthzPathsMapping.makePersistent(pm);
        } else {
            LOGGER.error("nonexistent authzObj: {} on current paths snapshot ID #{}", (Object)oldObj, (Object)currentSnapshotID);
        }
    }

    @Override
    public void renameAuthzObj(String oldObj, String newObj, UniquePathsUpdate update) throws Exception {
        this.execute((Updateable.Update)update, (PersistenceManager pm) -> {
            pm.setDetachAllOnCommit(false);
            this.renameAuthzObjCore(pm, oldObj, newObj);
            return null;
        });
    }

    private void renameAuthzObjCore(PersistenceManager pm, String oldObj, String newObj) {
        MAuthzPathsMapping mAuthzPathsMapping;
        long currentSnapshotID = SentryStore.getCurrentAuthzPathsSnapshotID(pm);
        if (currentSnapshotID <= 0L) {
            LOGGER.error("No paths snapshot ID is found. Cannot rename authzoObj: {}", (Object)oldObj);
        }
        if ((mAuthzPathsMapping = this.getMAuthzPathsMappingCore(pm, currentSnapshotID, oldObj)) != null) {
            mAuthzPathsMapping.setAuthzObjName(newObj);
            pm.makePersistent((Object)mAuthzPathsMapping);
        } else {
            LOGGER.error("nonexistent authzObj: {} on current paths snapshot ID #{}", (Object)oldObj, (Object)currentSnapshotID);
        }
    }

    public boolean isAuthzPathsMappingEmpty() throws Exception {
        return this.tm.executeTransactionWithRetry(pm -> {
            pm.setDetachAllOnCommit(false);
            return this.isTableEmptyCore(pm, MAuthzPathsMapping.class);
        });
    }

    @Override
    public boolean isHmsNotificationEmpty() throws Exception {
        return this.tm.executeTransactionWithRetry(pm -> {
            pm.setDetachAllOnCommit(false);
            return this.isTableEmptyCore(pm, MSentryHmsNotification.class);
        });
    }

    @Override
    public boolean isAuthzPathsSnapshotEmpty() throws Exception {
        return this.tm.executeTransactionWithRetry(pm -> {
            pm.setDetachAllOnCommit(false);
            return this.isTableEmptyCore(pm, MAuthzPathsMapping.class);
        });
    }

    @Override
    public void updateAuthzPathsMapping(String authzObj, String oldPath, String newPath, UniquePathsUpdate update) throws Exception {
        this.execute((Updateable.Update)update, (PersistenceManager pm) -> {
            pm.setDetachAllOnCommit(false);
            this.updateAuthzPathsMappingCore(pm, authzObj, oldPath, newPath);
            return null;
        });
    }

    private void updateAuthzPathsMappingCore(PersistenceManager pm, String authzObj, String oldPath, String newPath) {
        MAuthzPathsMapping mAuthzPathsMapping;
        long currentSnapshotID = SentryStore.getCurrentAuthzPathsSnapshotID(pm);
        if (currentSnapshotID <= 0L) {
            LOGGER.error("No paths snapshot ID is found. Cannot update authzoObj: {}", (Object)authzObj);
        }
        if ((mAuthzPathsMapping = this.getMAuthzPathsMappingCore(pm, currentSnapshotID, authzObj)) == null) {
            mAuthzPathsMapping = new MAuthzPathsMapping(currentSnapshotID, SentryStore.getNextAuthzObjectID(pm), authzObj, Collections.singleton(newPath));
        } else {
            mAuthzPathsMapping.deletePersistent(pm, Collections.singleton(oldPath));
            mAuthzPathsMapping.addPathToPersist(Collections.singleton(newPath));
        }
        mAuthzPathsMapping.makePersistent(pm);
    }

    @VisibleForTesting
    Set<MPath> getMAuthzPaths(long authzSnapshotID, String authzObj) throws Exception {
        return this.tm.executeTransactionWithRetry(pm -> {
            MAuthzPathsMapping mapping = null;
            pm.setDetachAllOnCommit(true);
            mapping = this.getMAuthzPathsMappingCore(pm, authzSnapshotID, authzObj);
            if (mapping != null) {
                Set<MPath> paths = mapping.getPathsPersisted();
                return paths;
            }
            return Collections.emptySet();
        });
    }

    private MAuthzPathsMapping getMAuthzPathsMappingCore(PersistenceManager pm, long authzSnapshotID, String authzObj) {
        Query query = pm.newQuery(MAuthzPathsMapping.class);
        query.setFilter("this.authzSnapshotID == authzSnapshotID && this.authzObjName == authzObjName");
        query.declareParameters("long authzSnapshotID, java.lang.String authzObjName");
        query.setUnique(true);
        return (MAuthzPathsMapping)query.execute((Object)authzSnapshotID, (Object)authzObj);
    }

    private boolean isTableEmptyCore(PersistenceManager pm, Class clazz) {
        Query query = pm.newQuery(clazz);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        query.setRange(0L, 1L);
        return ((List)query.execute()).isEmpty();
    }

    private static long getMaxPersistedIDCore(PersistenceManager pm, Class clazz, String columnName, long defaultValue) {
        Query query = pm.newQuery(clazz);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        query.setResult(String.format("max(%s)", columnName));
        Long maxValue = (Long)query.execute();
        return maxValue != null ? maxValue : defaultValue;
    }

    @VisibleForTesting
    List<MPath> getMPaths() throws Exception {
        return this.tm.executeTransaction(pm -> {
            long currentSnapshotID = SentryStore.getCurrentAuthzPathsSnapshotID(pm);
            Query query = pm.newQuery("SQL", (Object)"SELECT p.PATH_NAME FROM AUTHZ_PATH p JOIN AUTHZ_PATHS_MAPPING a ON a.AUTHZ_OBJ_ID = p.AUTHZ_OBJ_ID WHERE a.AUTHZ_SNAPSHOT_ID = ?");
            query.setResultClass(MPath.class);
            return (List)query.execute((Object)currentSnapshotID);
        });
    }

    @VisibleForTesting
    long getPathCount() {
        return this.getCount(MPath.class);
    }

    @VisibleForTesting
    Boolean findOrphanedPrivileges() throws Exception {
        return this.tm.executeTransaction(pm -> this.findOrphanedPrivilegesCore(pm));
    }

    Boolean findOrphanedPrivilegesCore(PersistenceManager pm) {
        List<MSentryPrivilege> results = this.getAllMSentryPrivilegesCore(pm);
        ArrayList<Object> idList = new ArrayList<Object>(results.size());
        for (MSentryPrivilege mSentryPrivilege : results) {
            idList.add(pm.getObjectId((Object)mSentryPrivilege));
        }
        if (idList.isEmpty()) {
            return false;
        }
        pm.refreshAll();
        for (MSentryPrivilege mSentryPrivilege : idList) {
            MSentryPrivilege priv = (MSentryPrivilege)pm.getObjectById((Object)mSentryPrivilege);
            if (!priv.getRoles().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Map<String, Set<String>>> getGroupUserRoleMapList(Collection<String> roleNames) throws Exception {
        return this.tm.executeTransaction(pm -> {
            List mSentryRoles;
            pm.setDetachAllOnCommit(false);
            Query query = pm.newQuery(MSentryRole.class);
            query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
            FetchGroup grp = pm.getFetchGroup(MSentryRole.class, "fetchGroupsUsers");
            grp.addMember("groups").addMember("users");
            pm.getFetchPlan().addGroup("fetchGroupsUsers");
            if (roleNames == null || roleNames.isEmpty()) {
                mSentryRoles = (List)query.execute();
            } else {
                QueryParamBuilder paramBuilder = QueryParamBuilder.newQueryParamBuilder(QueryParamBuilder.Op.OR);
                paramBuilder.addSet("roleName == ", roleNames, true);
                query.setFilter(paramBuilder.toString());
                mSentryRoles = (List)query.executeWithMap(paramBuilder.getArguments());
            }
            Map<String, Set<String>> groupRolesMap = this.getGroupRolesMap(mSentryRoles);
            Map<String, Set<String>> userRolesMap = this.getUserRolesMap(mSentryRoles);
            ArrayList<Map<String, Set<String>>> mapsList = new ArrayList<Map<String, Set<String>>>();
            mapsList.add(0, groupRolesMap);
            mapsList.add(1, userRolesMap);
            return mapsList;
        });
    }

    private Map<String, Set<String>> getGroupRolesMap(Collection<MSentryRole> mSentryRoles) {
        if (mSentryRoles.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> groupRolesMap = new HashMap<String, Set<String>>();
        for (MSentryRole mSentryRole : mSentryRoles) {
            Set<MSentryGroup> groups = mSentryRole.getGroups();
            for (MSentryGroup group : groups) {
                String groupName = group.getGroupName();
                HashSet<String> rNames = (HashSet<String>)groupRolesMap.get(groupName);
                if (rNames == null) {
                    rNames = new HashSet<String>();
                }
                rNames.add(mSentryRole.getRoleName());
                groupRolesMap.put(groupName, rNames);
            }
        }
        return groupRolesMap;
    }

    private Map<String, Set<String>> getUserRolesMap(Collection<MSentryRole> mSentryRoles) {
        if (mSentryRoles.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> userRolesMap = new HashMap<String, Set<String>>();
        for (MSentryRole mSentryRole : mSentryRoles) {
            Set<MSentryUser> users = mSentryRole.getUsers();
            for (MSentryUser user : users) {
                String userName = user.getUserName();
                HashSet<String> rNames = (HashSet<String>)userRolesMap.get(userName);
                if (rNames == null) {
                    rNames = new HashSet<String>();
                }
                rNames.add(mSentryRole.getRoleName());
                userRolesMap.put(userName, rNames);
            }
        }
        return userRolesMap;
    }

    Map<String, Set<TSentryPrivilege>> getRoleNameTPrivilegesMap() throws Exception {
        return this.getRoleNameTPrivilegesMap(null, null);
    }

    @Override
    public Map<String, Set<TSentryPrivilege>> getRoleNameTPrivilegesMap(String dbName, String tableName) throws Exception {
        return this.tm.executeTransaction(pm -> {
            pm.setDetachAllOnCommit(false);
            Query query = pm.newQuery(MSentryPrivilege.class);
            query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
            QueryParamBuilder paramBuilder = QueryParamBuilder.newQueryParamBuilder();
            if (!StringUtils.isEmpty((String)dbName)) {
                paramBuilder.add("dbName", dbName);
            }
            if (!StringUtils.isEmpty((String)tableName)) {
                paramBuilder.add("tableName", tableName);
            }
            query.setFilter(paramBuilder.toString());
            FetchGroup grp = pm.getFetchGroup(MSentryPrivilege.class, "fetchRoles");
            grp.addMember("roles");
            pm.getFetchPlan().addGroup("fetchRoles");
            List mSentryPrivileges = (List)query.executeWithMap(paramBuilder.getArguments());
            return this.getRolePrivilegesMap(mSentryPrivileges);
        });
    }

    private Map<String, Set<TSentryPrivilege>> getRolePrivilegesMap(Collection<MSentryPrivilege> mSentryPrivileges) {
        if (mSentryPrivileges.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<TSentryPrivilege>> rolePrivilegesMap = new HashMap<String, Set<TSentryPrivilege>>();
        for (MSentryPrivilege mSentryPrivilege : mSentryPrivileges) {
            TSentryPrivilege privilege = this.convertToTSentryPrivilege(mSentryPrivilege);
            for (MSentryRole mSentryRole : mSentryPrivilege.getRoles()) {
                String roleName = mSentryRole.getRoleName();
                HashSet<TSentryPrivilege> privileges = (HashSet<TSentryPrivilege>)rolePrivilegesMap.get(roleName);
                if (privileges == null) {
                    privileges = new HashSet<TSentryPrivilege>();
                }
                privileges.add(privilege);
                rolePrivilegesMap.put(roleName, privileges);
            }
        }
        return rolePrivilegesMap;
    }

    public Set<String> getAllRoleNames() throws Exception {
        return this.tm.executeTransaction(pm -> {
            pm.setDetachAllOnCommit(false);
            return this.getAllRoleNamesCore(pm);
        });
    }

    private Set<String> getAllRoleNamesCore(PersistenceManager pm) {
        List<MSentryRole> mSentryRoles = this.getAllRoles(pm);
        if (mSentryRoles.isEmpty()) {
            return Collections.emptySet();
        }
        return SentryStore.rolesToRoleNames(mSentryRoles);
    }

    private Map<String, MSentryGroup> getGroupNameTGroupMap(PersistenceManager pm) {
        Query query = pm.newQuery(MSentryGroup.class);
        List mSentryGroups = (List)query.execute();
        if (mSentryGroups.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, MSentryGroup> existGroupsMap = new HashMap<String, MSentryGroup>(mSentryGroups.size());
        for (MSentryGroup mSentryGroup : mSentryGroups) {
            existGroupsMap.put(mSentryGroup.getGroupName(), mSentryGroup);
        }
        return existGroupsMap;
    }

    private Map<String, MSentryUser> getUserNameToUserMap(PersistenceManager pm) {
        Query query = pm.newQuery(MSentryUser.class);
        List users = (List)query.execute();
        if (users.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, MSentryUser> existUsersMap = new HashMap<String, MSentryUser>(users.size());
        for (MSentryUser user : users) {
            existUsersMap.put(user.getUserName(), user);
        }
        return existUsersMap;
    }

    @VisibleForTesting
    Map<String, MSentryRole> getRolesMap() throws Exception {
        return this.tm.executeTransaction(pm -> {
            pm.setDetachAllOnCommit(false);
            List<MSentryRole> mSentryRoles = this.getAllRoles(pm);
            if (mSentryRoles.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<String, MSentryRole> existRolesMap = new HashMap<String, MSentryRole>(mSentryRoles.size());
            for (MSentryRole mSentryRole : mSentryRoles) {
                existRolesMap.put(mSentryRole.getRoleName(), mSentryRole);
            }
            return existRolesMap;
        });
    }

    @VisibleForTesting
    Map<String, MSentryGroup> getGroupNameToGroupMap() throws Exception {
        return this.tm.executeTransaction(this::getGroupNameTGroupMap);
    }

    @VisibleForTesting
    Map<String, MSentryUser> getUserNameToUserMap() throws Exception {
        return this.tm.executeTransaction(this::getUserNameToUserMap);
    }

    @VisibleForTesting
    List<MSentryPrivilege> getPrivilegesList() throws Exception {
        return this.tm.executeTransaction(pm -> {
            Query query = pm.newQuery(MSentryPrivilege.class);
            return (List)query.execute();
        });
    }

    @Override
    public void importSentryMetaData(TSentryMappingData tSentryMappingData, boolean isOverwriteForRole) throws Exception {
        this.tm.executeTransaction(pm -> {
            pm.setDetachAllOnCommit(false);
            TSentryMappingData mappingData = this.lowercaseRoleName(tSentryMappingData);
            Set<String> roleNames = this.getAllRoleNamesCore(pm);
            Map<String, Set<TSentryGroup>> importedRoleGroupsMap = this.covertToRoleNameTGroupsMap(mappingData.getGroupRolesMap());
            Map<String, Set<String>> importedRoleUsersMap = this.covertToRoleUsersMap(mappingData.getUserRolesMap());
            Set<String> importedRoleNames = importedRoleGroupsMap.keySet();
            if (isOverwriteForRole) {
                this.dropDuplicatedRoleForImport(pm, roleNames, importedRoleNames);
                roleNames = this.getAllRoleNamesCore(pm);
            }
            if (roleNames.isEmpty()) {
                roleNames = new HashSet<String>();
            }
            this.importRolePrivilegeMapping(pm, roleNames, mappingData.getRolePrivilegesMap());
            this.importRoleGroupMapping(pm, roleNames, importedRoleGroupsMap);
            this.importRoleUserMapping(pm, roleNames, importedRoleUsersMap);
            return null;
        });
    }

    private Map<String, Set<TSentryGroup>> covertToRoleNameTGroupsMap(Map<String, Set<String>> groupRolesMap) {
        if (groupRolesMap == null || groupRolesMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap roleGroupsMap = Maps.newHashMap();
        for (Map.Entry<String, Set<String>> entry : groupRolesMap.entrySet()) {
            Set<String> roleNames = entry.getValue();
            if (roleNames == null) continue;
            for (String roleName : roleNames) {
                HashSet<TSentryGroup> tSentryGroups = (HashSet<TSentryGroup>)roleGroupsMap.get(roleName);
                if (tSentryGroups == null) {
                    tSentryGroups = new HashSet<TSentryGroup>();
                }
                tSentryGroups.add(new TSentryGroup(entry.getKey()));
                roleGroupsMap.put(roleName, tSentryGroups);
            }
        }
        return roleGroupsMap;
    }

    private Map<String, Set<String>> covertToRoleUsersMap(Map<String, Set<String>> userRolesMap) {
        if (userRolesMap == null || userRolesMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> roleUsersMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : userRolesMap.entrySet()) {
            Set<String> roleNames = entry.getValue();
            if (roleNames == null) continue;
            for (String roleName : roleNames) {
                HashSet<String> users = (HashSet<String>)roleUsersMap.get(roleName);
                if (users == null) {
                    users = new HashSet<String>();
                }
                users.add(entry.getKey());
                roleUsersMap.put(roleName, users);
            }
        }
        return roleUsersMap;
    }

    private void importRoleGroupMapping(PersistenceManager pm, Set<String> existRoleNames, Map<String, Set<TSentryGroup>> importedRoleGroupsMap) throws Exception {
        if (importedRoleGroupsMap == null || importedRoleGroupsMap.keySet() == null) {
            return;
        }
        for (Map.Entry<String, Set<TSentryGroup>> entry : importedRoleGroupsMap.entrySet()) {
            this.createRoleIfNotExist(pm, existRoleNames, entry.getKey());
            this.alterSentryRoleAddGroupsCore(pm, entry.getKey(), entry.getValue());
        }
    }

    private void importRoleUserMapping(PersistenceManager pm, Set<String> existRoleNames, Map<String, Set<String>> importedRoleUsersMap) throws Exception {
        if (importedRoleUsersMap == null || importedRoleUsersMap.keySet() == null) {
            return;
        }
        for (Map.Entry<String, Set<String>> entry : importedRoleUsersMap.entrySet()) {
            this.createRoleIfNotExist(pm, existRoleNames, entry.getKey());
            this.alterSentryRoleAddUsersCore(pm, entry.getKey(), entry.getValue());
        }
    }

    private void dropDuplicatedRoleForImport(PersistenceManager pm, Set<String> existRoleNames, Set<String> importedRoleNames) throws Exception {
        Sets.SetView duplicatedRoleNames = Sets.intersection(existRoleNames, importedRoleNames);
        for (String droppedRoleName : duplicatedRoleNames) {
            this.dropSentryRoleCore(pm, droppedRoleName);
        }
    }

    private TSentryMappingData lowercaseRoleName(TSentryMappingData tSentryMappingData) {
        Map sentryGroupRolesMap = tSentryMappingData.getGroupRolesMap();
        Map sentryRolePrivilegesMap = tSentryMappingData.getRolePrivilegesMap();
        HashMap newSentryGroupRolesMap = new HashMap();
        HashMap newSentryRolePrivilegesMap = new HashMap();
        for (Map.Entry entry : sentryGroupRolesMap.entrySet()) {
            Collection lowcaseRoles = Collections2.transform((Collection)((Collection)entry.getValue()), (Function)new Function<String, String>(){

                public String apply(String input) {
                    return input.toLowerCase();
                }
            });
            newSentryGroupRolesMap.put(entry.getKey(), new HashSet(lowcaseRoles));
        }
        for (Map.Entry entry : sentryRolePrivilegesMap.entrySet()) {
            newSentryRolePrivilegesMap.put(((String)entry.getKey()).toLowerCase(), entry.getValue());
        }
        tSentryMappingData.setGroupRolesMap(newSentryGroupRolesMap);
        tSentryMappingData.setRolePrivilegesMap(newSentryRolePrivilegesMap);
        return tSentryMappingData;
    }

    private void importRolePrivilegeMapping(PersistenceManager pm, Set<String> existRoleNames, Map<String, Set<TSentryPrivilege>> sentryRolePrivilegesMap) throws Exception {
        if (sentryRolePrivilegesMap != null) {
            for (Map.Entry<String, Set<TSentryPrivilege>> entry : sentryRolePrivilegesMap.entrySet()) {
                this.createRoleIfNotExist(pm, existRoleNames, entry.getKey());
                Set<TSentryPrivilege> tSentryPrivileges = entry.getValue();
                for (TSentryPrivilege tSentryPrivilege : tSentryPrivileges) {
                    this.alterSentryGrantPrivilegeCore(pm, ServiceConstants.SentryPrincipalType.ROLE, entry.getKey(), tSentryPrivilege);
                }
            }
        }
    }

    private void createRoleIfNotExist(PersistenceManager pm, Set<String> existRoleNames, String roleName) throws Exception {
        String lowerRoleName = this.trimAndLower(roleName);
        if (!existRoleNames.contains(lowerRoleName)) {
            existRoleNames.add(lowerRoleName);
            pm.makePersistent((Object)new MSentryRole(this.trimAndLower(roleName)));
        }
    }

    public static Set<String> rolesToRoleNames(Iterable<MSentryRole> roles) {
        HashSet<String> roleNames = new HashSet<String>();
        for (MSentryRole mSentryRole : roles) {
            roleNames.add(mSentryRole.getRoleName());
        }
        return roleNames;
    }

    private static SentryNoSuchObjectException noSuchRole(String roleName) {
        return new SentryNoSuchObjectException("Role " + roleName);
    }

    private static SentryNoSuchObjectException noSuchUser(String userName) {
        return new SentryNoSuchObjectException("nonexistent user " + userName);
    }

    private static SentryNoSuchObjectException noSuchGroup(String groupName) {
        return new SentryNoSuchObjectException("Group " + groupName);
    }

    private SentryNoSuchObjectException noSuchUpdate(long changeID) {
        return new SentryNoSuchObjectException("nonexistent update + " + changeID);
    }

    static <T extends MSentryChange> Long getLastProcessedChangeIDCore(PersistenceManager pm, Class<T> changeCls) {
        return SentryStore.getMaxPersistedIDCore(pm, changeCls, "changeID", 0L);
    }

    static Long getLastProcessedNotificationIDCore(PersistenceManager pm) {
        return SentryStore.getMaxPersistedIDCore(pm, MSentryHmsNotification.class, "notificationId", 0L);
    }

    @Override
    public void setLastProcessedNotificationID(Long notificationId) throws Exception {
        LOGGER.debug("Persisting Last Processed Notification ID {}", (Object)notificationId);
        this.tm.executeTransaction(pm -> {
            this.deleteNotificationsSince(pm, notificationId + 1L);
            return (MSentryHmsNotification)pm.makePersistent((Object)new MSentryHmsNotification(notificationId));
        });
    }

    @Override
    public void persistLastProcessedNotificationID(Long notificationId) throws Exception {
        LOGGER.debug("Persisting Last Processed Notification ID {}", (Object)notificationId);
        this.tm.executeTransaction(pm -> (MSentryHmsNotification)pm.makePersistent((Object)new MSentryHmsNotification(notificationId)));
    }

    @Override
    public Long getLastProcessedPermChangeID() throws Exception {
        return this.tm.executeTransaction(pm -> {
            pm.setDetachAllOnCommit(false);
            return SentryStore.getLastProcessedChangeIDCore(pm, MSentryPermChange.class);
        });
    }

    @Override
    public Long getLastProcessedPathChangeID() throws Exception {
        return this.tm.executeTransaction(pm -> {
            pm.setDetachAllOnCommit(false);
            return SentryStore.getLastProcessedChangeIDCore(pm, MSentryPathChange.class);
        });
    }

    @Override
    public Long getLastProcessedNotificationID() throws Exception {
        long notificationId = this.tm.executeTransaction(pm -> {
            long notificationId1 = SentryStore.getLastProcessedNotificationIDCore(pm);
            return notificationId1;
        });
        LOGGER.debug("Retrieving Last Processed Notification ID {}", (Object)notificationId);
        return notificationId;
    }

    @Override
    public long getLastProcessedImageID() throws Exception {
        return this.tm.executeTransaction(pm -> {
            pm.setDetachAllOnCommit(false);
            return SentryStore.getCurrentAuthzPathsSnapshotID(pm);
        });
    }

    public MSentryPermChange getMSentryPermChangeByID(long changeID) throws Exception {
        return this.tm.executeTransaction(pm -> {
            Query query = pm.newQuery(MSentryPermChange.class);
            query.setFilter("this.changeID == id");
            query.declareParameters("long id");
            List permChanges = (List)query.execute((Object)changeID);
            if (permChanges == null) {
                throw this.noSuchUpdate(changeID);
            }
            if (permChanges.size() > 1) {
                throw new Exception("Inconsistent permission delta: " + permChanges.size() + " permissions for the same id, " + changeID);
            }
            return (MSentryPermChange)permChanges.get(0);
        });
    }

    private <T extends MSentryChange> List<T> getMSentryChanges(Class<T> cls) throws Exception {
        return this.tm.executeTransaction(pm -> {
            Query query = pm.newQuery(cls);
            return (List)query.execute();
        });
    }

    @VisibleForTesting
    List<MSentryPermChange> getMSentryPermChanges() throws Exception {
        return this.getMSentryChanges(MSentryPermChange.class);
    }

    @VisibleForTesting
    List<MSentryHmsNotification> getMSentryHmsNotificationCore() throws Exception {
        return this.tm.executeTransaction(pm -> {
            Query query = pm.newQuery(MSentryHmsNotification.class);
            return (List)query.execute();
        });
    }

    private <T extends MSentryChange> Boolean changeExistsCore(PersistenceManager pm, Class<T> changeCls, long changeID) throws Exception {
        Query query = pm.newQuery(changeCls);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        query.setFilter("this.changeID == id");
        query.declareParameters("long id");
        List changes = (List)query.execute((Object)changeID);
        return !changes.isEmpty();
    }

    @Override
    public Boolean permChangeExists(long changeID) throws Exception {
        return this.tm.executeTransaction(pm -> {
            pm.setDetachAllOnCommit(false);
            return this.changeExistsCore(pm, MSentryPermChange.class, changeID);
        });
    }

    @Override
    public Boolean pathChangeExists(long changeID) throws Exception {
        return this.tm.executeTransaction(pm -> {
            pm.setDetachAllOnCommit(false);
            return this.changeExistsCore(pm, MSentryPathChange.class, changeID);
        });
    }

    public MSentryPathChange getMSentryPathChangeByID(long changeID) throws Exception {
        return this.tm.executeTransaction(pm -> {
            Query query = pm.newQuery(MSentryPathChange.class);
            query.setFilter("this.changeID == id");
            query.declareParameters("long id");
            List pathChanges = (List)query.execute((Object)changeID);
            if (pathChanges == null) {
                throw this.noSuchUpdate(changeID);
            }
            if (pathChanges.size() > 1) {
                throw new Exception("Inconsistent path delta: " + pathChanges.size() + " paths for the same id, " + changeID);
            }
            return (MSentryPathChange)pathChanges.get(0);
        });
    }

    @VisibleForTesting
    List<MSentryPathChange> getMSentryPathChanges() throws Exception {
        return this.getMSentryChanges(MSentryPathChange.class);
    }

    private <T extends MSentryChange> List<T> getMSentryChangesCore(PersistenceManager pm, Class<T> changeCls, long changeID) throws Exception {
        Query query = pm.newQuery(changeCls);
        query.setFilter("this.changeID >= t");
        query.declareParameters("long t");
        query.setOrdering("this.changeID ascending");
        return (List)query.execute((Object)changeID);
    }

    @Override
    public List<MSentryPathChange> getMSentryPathChanges(long changeID) throws Exception {
        return this.tm.executeTransaction(pm -> {
            List<MSentryPathChange> pathChanges = this.getMSentryChangesCore(pm, MSentryPathChange.class, changeID);
            if (this.validateDeltaChanges(changeID, pathChanges)) {
                return pathChanges;
            }
            return Collections.emptyList();
        });
    }

    @Override
    public List<MSentryPermChange> getMSentryPermChanges(long changeID) throws Exception {
        return this.tm.executeTransaction(pm -> {
            List<MSentryPermChange> permChanges = this.getMSentryChangesCore(pm, MSentryPermChange.class, changeID);
            if (this.validateDeltaChanges(changeID, permChanges)) {
                return permChanges;
            }
            return Collections.emptyList();
        });
    }

    public <T extends MSentryChange> boolean validateDeltaChanges(long changeID, List<T> changes) {
        if (changes.isEmpty()) {
            return true;
        }
        if (((MSentryChange)changes.get(0)).getChangeID() != changeID) {
            LOGGER.debug(String.format("Starting delta change from %s is off from the requested id. Requested changeID: %s, Missing delta count: %s", ((MSentryChange)changes.get(0)).getClass().getCanonicalName(), changeID, ((MSentryChange)changes.get(0)).getChangeID() - changeID));
            return false;
        }
        if (!MSentryUtil.isConsecutive(changes)) {
            String pathChangesIds = MSentryUtil.collapseChangeIDsToString(changes);
            LOGGER.error(String.format("Certain delta is missing in %s! The table may get corrupted. Start changeID %s, Current size of elements = %s. path changeID list: %s", ((MSentryChange)changes.get(0)).getClass().getCanonicalName(), changeID, changes.size(), pathChangesIds));
            return false;
        }
        return true;
    }

    private void execute(Updateable.Update update, TransactionBlock<Object> transactionBlock) throws Exception {
        this.execute(update != null ? Collections.singletonList(update) : Collections.emptyList(), transactionBlock);
    }

    private void execute(List<Updateable.Update> updates, TransactionBlock<Object> transactionBlock) throws Exception {
        ArrayList tbs = new ArrayList(3);
        if (this.persistUpdateDeltas && updates != null && updates.size() > 0) {
            for (Updateable.Update update : updates) {
                tbs.add(new DeltaTransactionBlock(update));
            }
        }
        tbs.add(transactionBlock);
        this.tm.executeTransactionBlocksWithRetry(tbs);
    }

    @Override
    public boolean isNotificationProcessed(String hash) throws Exception {
        return this.tm.executeTransactionWithRetry(pm -> {
            pm.setDetachAllOnCommit(false);
            Query query = pm.newQuery(MSentryPathChange.class);
            query.setFilter("this.notificationHash == hash");
            query.setUnique(true);
            query.declareParameters("java.lang.String hash");
            MSentryPathChange changes = (MSentryPathChange)query.execute((Object)hash);
            return changes != null;
        });
    }

    public PrivilegePrincipal getEntity(PersistenceManager pm, String name, ServiceConstants.SentryPrincipalType type) {
        Query query;
        if (type == ServiceConstants.SentryPrincipalType.ROLE) {
            query = pm.newQuery(MSentryRole.class);
            query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
            query.setFilter("this.roleName == :roleName");
            query.setUnique(true);
            FetchGroup grp = pm.getFetchGroup(MSentryRole.class, "fetchPrivileges");
            grp.addMember("privileges");
            pm.getFetchPlan().addGroup("fetchPrivileges");
        } else {
            query = pm.newQuery(MSentryUser.class);
            query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
            query.setFilter("this.userName == :userName");
            query.setUnique(true);
            FetchGroup grp = pm.getFetchGroup(MSentryUser.class, "fetchPrivileges");
            grp.addMember("privileges");
            pm.getFetchPlan().addGroup("fetchPrivileges");
        }
        return (PrivilegePrincipal)query.execute((Object)name);
    }

    @Override
    public Map<String, Set<TSentryPrivilege>> getAllRolesPrivileges() throws Exception {
        return this.tm.executeTransaction(pm -> {
            pm.setDetachAllOnCommit(false);
            Query query = pm.newQuery(MSentryRole.class);
            query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
            FetchGroup grp = pm.getFetchGroup(MSentryRole.class, "fetchPrivileges");
            grp.addMember("privileges");
            pm.getFetchPlan().addGroup("fetchPrivileges");
            List mSentryRoles = (List)query.execute();
            if (mSentryRoles == null || mSentryRoles.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap allRolesPrivileges = Maps.newHashMap();
            for (MSentryRole mSentryRole : mSentryRoles) {
                Set<TSentryPrivilege> tPrivileges = this.convertToTSentryPrivileges(mSentryRole.getPrivileges());
                allRolesPrivileges.put(mSentryRole.getRoleName(), tPrivileges);
            }
            return allRolesPrivileges;
        });
    }

    @Override
    public Map<String, Set<TSentryPrivilege>> getAllUsersPrivileges() throws Exception {
        return this.tm.executeTransaction(pm -> {
            pm.setDetachAllOnCommit(false);
            Query query = pm.newQuery(MSentryUser.class);
            query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
            FetchGroup grp = pm.getFetchGroup(MSentryUser.class, "fetchPrivileges");
            grp.addMember("privileges");
            pm.getFetchPlan().addGroup("fetchPrivileges");
            List mSentryUsers = (List)query.execute();
            if (mSentryUsers == null || mSentryUsers.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap allUsersPrivileges = Maps.newHashMap();
            for (MSentryUser mSentryUser : mSentryUsers) {
                Set<TSentryPrivilege> tPrivileges = this.convertToTSentryPrivileges(mSentryUser.getPrivileges());
                allUsersPrivileges.put(mSentryUser.getUserName(), tPrivileges);
            }
            return allUsersPrivileges;
        });
    }
}

