/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.NotThreadSafe;
import javax.jdo.Query;
import org.apache.sentry.provider.db.service.model.MSentryRole;
import org.apache.sentry.provider.db.service.model.MSentryUser;
import org.apache.sentry.provider.db.service.persistent.SentryStore;

@NotThreadSafe
public class QueryParamBuilder {
    private final List<String> queryParts = new LinkedList<String>();
    private List<QueryParamBuilder> children;
    private final Map<String, Object> arguments;
    private final AtomicLong paramId;
    private final String operation;

    public static QueryParamBuilder newQueryParamBuilder() {
        return new QueryParamBuilder();
    }

    public static QueryParamBuilder newQueryParamBuilder(Op operation) {
        return new QueryParamBuilder(operation);
    }

    public QueryParamBuilder newChild() {
        Op operation = this.operation.equals(Op.AND.toString()) ? Op.OR : Op.AND;
        return this.newChild(operation);
    }

    private QueryParamBuilder newChild(Op operation) {
        QueryParamBuilder child = new QueryParamBuilder(this, operation);
        if (this.children == null) {
            this.children = new LinkedList<QueryParamBuilder>();
        }
        this.children.add(child);
        return child;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public String toString() {
        if (this.children == null && this.queryParts.isEmpty()) {
            return "";
        }
        if (this.children == null) {
            return "(" + Joiner.on((String)this.operation).join(this.queryParts) + ")";
        }
        LinkedList<String> result = new LinkedList<String>(this.queryParts);
        for (QueryParamBuilder child : this.children) {
            result.add(((Object)child).toString());
        }
        return "(" + Joiner.on((String)this.operation).join(result) + ")";
    }

    public QueryParamBuilder addObject(String fieldName, Object value) {
        return this.addCustomParam("this." + fieldName + " == :" + fieldName, fieldName, value);
    }

    public QueryParamBuilder add(String fieldName, String value) {
        return this.addCommon(fieldName, value, false);
    }

    public QueryParamBuilder add(String fieldName, String value, boolean preserveCase) {
        return this.addCommon(fieldName, value, preserveCase);
    }

    public QueryParamBuilder addNotNull(String fieldName) {
        this.queryParts.add(String.format("this.%s != \"%s\"", fieldName, "__NULL__"));
        return this;
    }

    public QueryParamBuilder addNull(String fieldName) {
        this.queryParts.add(String.format("this.%s == \"%s\"", fieldName, "__NULL__"));
        return this;
    }

    QueryParamBuilder addCustomParam(String expr, String paramName, Object value) {
        this.arguments.put(paramName, value);
        this.queryParts.add(expr);
        return this;
    }

    QueryParamBuilder addString(String expr) {
        this.queryParts.add(expr);
        return this;
    }

    public static QueryParamBuilder addRolesFilter(Query query, QueryParamBuilder paramBuilder, Set<String> roleNames) {
        query.declareVariables(MSentryRole.class.getName() + " role");
        if (paramBuilder == null) {
            paramBuilder = new QueryParamBuilder();
        }
        if (roleNames == null || roleNames.isEmpty()) {
            return paramBuilder;
        }
        paramBuilder.newChild().addSet("role.roleName == ", roleNames, true);
        paramBuilder.addString("roles.contains(role)");
        return paramBuilder;
    }

    public static QueryParamBuilder addUsersFilter(Query query, QueryParamBuilder paramBuilder, Set<String> userNames) {
        query.declareVariables(MSentryUser.class.getName() + " user");
        if (paramBuilder == null) {
            paramBuilder = new QueryParamBuilder();
        }
        if (userNames == null || userNames.isEmpty()) {
            return paramBuilder;
        }
        paramBuilder.newChild().addSet("user.userName == ", userNames, false);
        paramBuilder.addString("users.contains(user)");
        return paramBuilder;
    }

    public static QueryParamBuilder addPathFilter(QueryParamBuilder paramBuilder, Collection<String> paths) {
        if (paramBuilder == null) {
            paramBuilder = new QueryParamBuilder();
        }
        if (paths == null || paths.isEmpty()) {
            return paramBuilder;
        }
        paramBuilder.newChild().addSet("this.path == ", paths, false);
        return paramBuilder;
    }

    public static QueryParamBuilder addActionFilter(QueryParamBuilder paramBuilder, Collection<String> actions) {
        if (paramBuilder == null) {
            paramBuilder = new QueryParamBuilder();
        }
        if (actions == null || actions.isEmpty()) {
            return paramBuilder;
        }
        paramBuilder.newChild().addSet("this.action == ", actions, false);
        return paramBuilder;
    }

    QueryParamBuilder addSet(String prefix, Iterable<String> values, boolean toLowerCase) {
        if (values == null) {
            return this;
        }
        for (String name : values) {
            String vName = "var" + this.paramId.toString();
            this.addCustomParam(prefix + ":" + vName, vName, toLowerCase ? name.trim().toLowerCase() : name.trim());
            this.paramId.incrementAndGet();
        }
        return this;
    }

    private QueryParamBuilder() {
        this(Op.AND);
    }

    private QueryParamBuilder(Op operation) {
        this.arguments = new HashMap<String, Object>();
        this.operation = operation.toString();
        this.paramId = new AtomicLong(0L);
    }

    private QueryParamBuilder(QueryParamBuilder parent, Op operation) {
        this.arguments = parent.getArguments();
        this.operation = operation.toString();
        this.paramId = parent.paramId;
    }

    private QueryParamBuilder addCommon(String fieldName, String value, boolean preserveCase) {
        Object oldValue = preserveCase ? this.arguments.put(fieldName, SentryStore.toNULLCol(SentryStore.safeTrim(value))) : this.arguments.put(fieldName, SentryStore.toNULLCol(SentryStore.safeTrimLower(value)));
        if (oldValue != null) {
            throw new IllegalArgumentException("field " + fieldName + "already exists");
        }
        this.queryParts.add("this." + fieldName + " == :" + fieldName);
        return this;
    }

    static enum Op {
        AND(" && "),
        OR(" || ");

        private final String value;

        public String toString() {
            return this.value;
        }

        private Op(String val) {
            this.value = val;
        }
    }
}

