/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.annotation.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CounterWait {
    private static final Logger LOGGER = LoggerFactory.getLogger(CounterWait.class);
    private final AtomicLong currentId = new AtomicLong(0L);
    private final long waitTimeout;
    private final TimeUnit waitTimeUnit;
    private final PriorityBlockingQueue<ValueEvent> waiters = new PriorityBlockingQueue();

    public CounterWait() {
        this(0L, TimeUnit.SECONDS);
    }

    public CounterWait(long waitTimeoutSec) {
        this(waitTimeoutSec, TimeUnit.SECONDS);
    }

    public CounterWait(long waitTimeout, TimeUnit waitTimeUnit) {
        this.waitTimeout = waitTimeout;
        this.waitTimeUnit = waitTimeUnit;
    }

    public synchronized void update(long newValue) {
        long oldValue = this.currentId.get();
        LOGGER.debug("CounterWait update: oldValue = {}, newValue = {}", (Object)oldValue, (Object)newValue);
        if (oldValue == newValue) {
            return;
        }
        if (newValue < oldValue) {
            LOGGER.error("new counter value {} is smaller then the previous one {}", (Object)newValue, (Object)oldValue);
            return;
        }
        this.currentId.set(newValue);
        this.wakeup(newValue);
    }

    public synchronized void reset(long newValue) {
        long oldValue = this.currentId.get();
        LOGGER.debug("CounterWait reset: oldValue = {}, newValue = {}", (Object)oldValue, (Object)newValue);
        if (newValue > oldValue) {
            this.update(newValue);
        } else if (newValue < oldValue) {
            LOGGER.warn("resetting counter from {} to smaller value {}", (Object)oldValue, (Object)newValue);
            this.currentId.set(newValue);
        }
    }

    public long waitFor(long value) throws InterruptedException, TimeoutException {
        if (value <= this.currentId.get()) {
            LOGGER.debug("Value {} reached", (Object)value);
            return this.currentId.get();
        }
        ValueEvent eid = new ValueEvent(value);
        this.waiters.put(eid);
        if (value <= this.currentId.get()) {
            LOGGER.debug("Value {} reached", (Object)value);
            return this.currentId.get();
        }
        LOGGER.debug("Blocked, waiting for value {}", (Object)value);
        eid.waitFor();
        return this.currentId.get();
    }

    private void wakeup(long value) {
        ValueEvent e;
        while ((e = this.waiters.poll()) != null) {
            if (e.getValue() > value) {
                this.waiters.add(e);
                return;
            }
            LOGGER.debug("Unblocking, Value {} reached", (Object)e.getValue());
            e.wakeup();
        }
        return;
    }

    public String toString() {
        return "CounterWait{currentId=" + this.currentId + ", waiters=" + this.waiters + "}";
    }

    public int waitersCount() {
        return this.waiters.size();
    }

    private class ValueEvent
    implements Comparable<ValueEvent> {
        private final long value;
        private final Semaphore semaphore = new Semaphore(1);

        ValueEvent(long v) {
            this.value = v;
            this.semaphore.acquireUninterruptibly();
        }

        void waitFor() throws InterruptedException, TimeoutException {
            if (CounterWait.this.waitTimeout == 0L) {
                this.semaphore.acquire();
                return;
            }
            if (!this.semaphore.tryAcquire(CounterWait.this.waitTimeout, CounterWait.this.waitTimeUnit)) {
                throw new TimeoutException();
            }
        }

        long getValue() {
            return this.value;
        }

        void wakeup() {
            this.semaphore.release();
        }

        @Override
        public int compareTo(ValueEvent o) {
            return this.value == o.value ? 0 : (this.value < o.value ? -1 : 1);
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

