/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.model;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import javax.jdo.annotations.NotPersistent;
import javax.jdo.annotations.PersistenceCapable;
import org.apache.sentry.provider.db.service.model.MPath;
import org.apache.sentry.provider.db.service.model.MSentryUtil;
import org.apache.sentry.provider.db.service.persistent.QueryParamBuilder;
import org.datanucleus.enhancement.Detachable;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.identity.LongId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PersistenceCapable
public class MAuthzPathsMapping
implements Detachable,
Persistable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MAuthzPathsMapping.class);
    private long authzObjectId;
    private long authzSnapshotID;
    private String authzObjName;
    private Set<MPath> pathsPersisted;
    @NotPersistent
    private Set<String> pathsToPersist;
    private long createTimeMs;
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    protected Object[] dnDetachedState;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    public MAuthzPathsMapping(long authzSnapshotID, long authzObjectId, String authzObjName, Collection<String> paths) {
        this.authzSnapshotID = authzSnapshotID;
        this.authzObjectId = authzObjectId;
        this.authzObjName = MSentryUtil.safeIntern(authzObjName);
        this.pathsPersisted = Collections.EMPTY_SET;
        if (paths != null && !paths.isEmpty()) {
            this.pathsToPersist = new HashSet<String>(paths.size());
            for (String path : paths) {
                this.pathsToPersist.add(path);
            }
        }
        this.createTimeMs = System.currentTimeMillis();
    }

    public long getAuthzObjectId() {
        return MAuthzPathsMapping.dnGetauthzObjectId(this);
    }

    public long getCreateTime() {
        return MAuthzPathsMapping.dnGetcreateTimeMs(this);
    }

    public void setCreateTime(long createTime) {
        MAuthzPathsMapping.dnSetcreateTimeMs(this, createTime);
    }

    public String getAuthzObjName() {
        return MAuthzPathsMapping.dnGetauthzObjName(this);
    }

    public void setAuthzObjName(String authzObjName) {
        MAuthzPathsMapping.dnSetauthzObjName(this, authzObjName);
    }

    public Set<MPath> getPathsPersisted() {
        return MAuthzPathsMapping.dnGetpathsPersisted(this);
    }

    public void addPathToPersist(Collection<String> paths) {
        if (paths == null || paths.isEmpty()) {
            return;
        }
        if (this.pathsToPersist == null) {
            this.pathsToPersist = new HashSet<String>(paths.size());
        }
        this.pathsToPersist.addAll(paths);
    }

    public MPath getPathsPersisted(String path) {
        for (MPath mPath : MAuthzPathsMapping.dnGetpathsPersisted(this)) {
            if (!mPath.getPath().equals(path)) continue;
            return mPath;
        }
        return null;
    }

    public Collection<String> getPathStrings() {
        ArrayList<String> pathValues = new ArrayList<String>(MAuthzPathsMapping.dnGetpathsPersisted(this).size());
        for (MPath path : MAuthzPathsMapping.dnGetpathsPersisted(this)) {
            pathValues.add(path.getPath());
        }
        return pathValues;
    }

    public String toString() {
        return "MSentryPathsUpdate authzSnapshotID=[" + MAuthzPathsMapping.dnGetauthzSnapshotID(this) + "], authzObjectId=[" + MAuthzPathsMapping.dnGetauthzObjectId(this) + "],authzObj=[" + MAuthzPathsMapping.dnGetauthzObjName(this) + "], mPaths=[" + (MAuthzPathsMapping.dnGetpathsPersisted(this) != null ? MAuthzPathsMapping.dnGetpathsPersisted(this).toString() : "") + "], paths=[" + (this.pathsToPersist != null ? this.pathsToPersist.toString() : "") + "],createTimeMs=[" + MAuthzPathsMapping.dnGetcreateTimeMs(this) + "]";
    }

    public int hashCode() {
        return MAuthzPathsMapping.dnGetauthzObjName(this) == null ? 0 : MAuthzPathsMapping.dnGetauthzObjName(this).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MAuthzPathsMapping other = (MAuthzPathsMapping)obj;
        if (MAuthzPathsMapping.dnGetauthzObjName(this) == null) {
            if (MAuthzPathsMapping.dnGetauthzObjName(other) != null) {
                return false;
            }
        } else {
            if (!MAuthzPathsMapping.dnGetauthzObjName(this).equals(MAuthzPathsMapping.dnGetauthzObjName(other))) {
                return false;
            }
            if (MAuthzPathsMapping.dnGetauthzSnapshotID(this) != MAuthzPathsMapping.dnGetauthzSnapshotID(other)) {
                return false;
            }
            if (MAuthzPathsMapping.dnGetauthzObjectId(this) != MAuthzPathsMapping.dnGetauthzObjectId(other)) {
                return false;
            }
        }
        return true;
    }

    public void makePersistent(PersistenceManager pm) {
        pm.makePersistent((Object)this);
        if (this.pathsToPersist == null || this.pathsToPersist.isEmpty()) {
            return;
        }
        for (String path : this.pathsToPersist) {
            pm.makePersistent((Object)new MPathToPersist(MAuthzPathsMapping.dnGetauthzObjectId(this), path));
        }
        this.pathsToPersist.clear();
    }

    public void deletePersistent(PersistenceManager pm, Collection<String> paths) {
        Query query = pm.newQuery(MPathToPersist.class);
        QueryParamBuilder paramBuilder = QueryParamBuilder.addPathFilter(null, paths).addObject("authzObjectId", MAuthzPathsMapping.dnGetauthzObjectId(this));
        query.setFilter(paramBuilder.toString());
        long delCount = query.deletePersistentAll(paramBuilder.getArguments());
        LOGGER.debug("Entries deleted are %d", (Object)delCount);
    }

    static {
        dnFieldNames = MAuthzPathsMapping.__dnFieldNamesInit();
        dnFieldTypes = MAuthzPathsMapping.__dnFieldTypesInit();
        dnFieldFlags = MAuthzPathsMapping.__dnFieldFlagsInit();
        dnInheritedFieldCount = MAuthzPathsMapping.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = MAuthzPathsMapping.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)MAuthzPathsMapping.___dn$loadClass("org.apache.sentry.provider.db.service.model.MAuthzPathsMapping"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new MAuthzPathsMapping());
    }

    protected MAuthzPathsMapping() {
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("oid is not instanceof org.datanucleus.identity.LongId");
        }
        LongId o = (LongId)oid;
        fc.storeLongField(1, o.getKey());
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("key class is not org.datanucleus.identity.LongId or null");
        }
        LongId o = (LongId)oid;
        this.authzObjectId = o.getKey();
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object paramObject) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        if (!this.dnIsDetached()) {
            return null;
        }
        return this.dnDetachedState[0];
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        if (!this.dnIsDetached()) {
            return null;
        }
        return this.dnDetachedState[1];
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContext((Persistable)this) : null;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        if (!this.dnIsDetached()) {
            return false;
        }
        return ((BitSet)this.dnDetachedState[3]).length() > 0;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
        if (this.dnIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < dnFieldNames.length) {
                if (dnFieldNames[i].equals(fldName)) {
                    if (((BitSet)this.dnDetachedState[2]).get(i + dnInheritedFieldCount)) {
                        ((BitSet)this.dnDetachedState[3]).set(i + dnInheritedFieldCount);
                        return;
                    }
                    throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                }
                ++i;
            }
        }
    }

    public Object dnNewObjectIdInstance() {
        return new LongId(this.getClass(), this.authzObjectId);
    }

    public Object dnNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new LongId(this.getClass(), (Long)key);
        }
        return new LongId(this.getClass(), (String)key);
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            EnhancementHelper.checkAuthorizedStateManager((StateManager)sm);
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public final synchronized void dnReplaceDetachedState() {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.dnDetachedState = this.dnStateManager.replacingDetachedState((Detachable)this, this.dnDetachedState);
    }

    public boolean dnIsDetached() {
        return this.dnStateManager == null && this.dnDetachedState != null;
    }

    public Persistable dnNewInstance(StateManager sm) {
        MAuthzPathsMapping result = new MAuthzPathsMapping();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        MAuthzPathsMapping result = new MAuthzPathsMapping();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.authzObjName = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 1: {
                this.authzObjectId = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 2: {
                this.authzSnapshotID = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 3: {
                this.createTimeMs = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 4: {
                this.pathsPersisted = (Set)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.authzObjName);
                break;
            }
            case 1: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.authzObjectId);
                break;
            }
            case 2: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.authzSnapshotID);
                break;
            }
            case 3: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.createTimeMs);
                break;
            }
            case 4: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.pathsPersisted);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(MAuthzPathsMapping obj, int index) {
        switch (index) {
            case 0: {
                this.authzObjName = obj.authzObjName;
                break;
            }
            case 1: {
                this.authzObjectId = obj.authzObjectId;
                break;
            }
            case 2: {
                this.authzSnapshotID = obj.authzSnapshotID;
                break;
            }
            case 3: {
                this.createTimeMs = obj.createTimeMs;
                break;
            }
            case 4: {
                this.pathsPersisted = obj.pathsPersisted;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof MAuthzPathsMapping)) {
            throw new IllegalArgumentException("object is not an object of type org.apache.sentry.provider.db.service.model.MAuthzPathsMapping");
        }
        MAuthzPathsMapping other = (MAuthzPathsMapping)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"authzObjName", "authzObjectId", "authzSnapshotID", "createTimeMs", "pathsPersisted"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{MAuthzPathsMapping.___dn$loadClass("java.lang.String"), Long.TYPE, Long.TYPE, Long.TYPE, MAuthzPathsMapping.___dn$loadClass("java.util.Set")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{21, 24, 21, 21, 10};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 5;
    }

    private static Class __dnPersistableSuperclassInit() {
        return null;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        MAuthzPathsMapping o = (MAuthzPathsMapping)super.clone();
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static String dnGetauthzObjName(MAuthzPathsMapping objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 0, objPC.authzObjName);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"authzObjName\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.authzObjName;
    }

    private static void dnSetauthzObjName(MAuthzPathsMapping objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 0, objPC.authzObjName, val);
        } else {
            objPC.authzObjName = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(0);
            }
        }
    }

    private static long dnGetauthzObjectId(MAuthzPathsMapping objPC) {
        return objPC.authzObjectId;
    }

    private static void dnSetauthzObjectId(MAuthzPathsMapping objPC, long val) {
        if (objPC.dnStateManager == null) {
            objPC.authzObjectId = val;
        } else {
            objPC.dnStateManager.setLongField((Persistable)objPC, 1, objPC.authzObjectId, val);
        }
        if (objPC.dnIsDetached()) {
            ((BitSet)objPC.dnDetachedState[3]).set(1);
        }
    }

    private static long dnGetauthzSnapshotID(MAuthzPathsMapping objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 2, objPC.authzSnapshotID);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"authzSnapshotID\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.authzSnapshotID;
    }

    private static void dnSetauthzSnapshotID(MAuthzPathsMapping objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 2, objPC.authzSnapshotID, val);
        } else {
            objPC.authzSnapshotID = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(2);
            }
        }
    }

    private static long dnGetcreateTimeMs(MAuthzPathsMapping objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 3, objPC.createTimeMs);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"createTimeMs\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.createTimeMs;
    }

    private static void dnSetcreateTimeMs(MAuthzPathsMapping objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 3, objPC.createTimeMs, val);
        } else {
            objPC.createTimeMs = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(3);
            }
        }
    }

    private static Set dnGetpathsPersisted(MAuthzPathsMapping objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4)) {
            return (Set)objPC.dnStateManager.getObjectField((Persistable)objPC, 4, objPC.pathsPersisted);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(4) && !((BitSet)objPC.dnDetachedState[3]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"pathsPersisted\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.pathsPersisted;
    }

    private static void dnSetpathsPersisted(MAuthzPathsMapping objPC, Set val) {
        if (objPC.dnStateManager == null) {
            objPC.pathsPersisted = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 4, objPC.pathsPersisted, (Object)val);
        }
        if (objPC.dnIsDetached()) {
            ((BitSet)objPC.dnDetachedState[3]).set(4);
        }
    }

    @PersistenceCapable
    public static class MPathToPersist
    implements Detachable,
    Persistable {
        private String path;
        private long authzObjectId;
        protected transient StateManager dnStateManager;
        protected transient byte dnFlags;
        protected Object[] dnDetachedState;
        private static final byte[] dnFieldFlags;
        private static final Class dnPersistableSuperclass;
        private static final Class[] dnFieldTypes;
        private static final String[] dnFieldNames;
        private static final int dnInheritedFieldCount;

        public MPathToPersist(long authzObjectId, String path) {
            this.authzObjectId = authzObjectId;
            this.path = MSentryUtil.safeIntern(path);
        }

        public String getPath() {
            return MPathToPersist.dnGetpath(this);
        }

        public void setPath(String path) {
            MPathToPersist.dnSetpath(this, path);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (MPathToPersist.dnGetpath(this) == null ? 0 : MPathToPersist.dnGetpath(this).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MPathToPersist other = (MPathToPersist)obj;
            if (MPathToPersist.dnGetpath(this) == null) {
                return MPathToPersist.dnGetpath(other) == null;
            }
            if (MPathToPersist.dnGetauthzObjectId(this) != MPathToPersist.dnGetauthzObjectId(other)) {
                return false;
            }
            return MPathToPersist.dnGetpath(this).equals(MPathToPersist.dnGetpath(other));
        }

        static {
            dnFieldNames = MPathToPersist.__dnFieldNamesInit();
            dnFieldTypes = MPathToPersist.__dnFieldTypesInit();
            dnFieldFlags = MPathToPersist.__dnFieldFlagsInit();
            dnInheritedFieldCount = MPathToPersist.__dnGetInheritedFieldCount();
            dnPersistableSuperclass = MPathToPersist.__dnPersistableSuperclassInit();
            EnhancementHelper.registerClass((Class)MPathToPersist.___dn$loadClass("org.apache.sentry.provider.db.service.model.MAuthzPathsMapping$MPathToPersist"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new MPathToPersist());
        }

        protected MPathToPersist() {
        }

        public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
        }

        protected void dnCopyKeyFieldsFromObjectId(Object oid) {
        }

        public void dnCopyKeyFieldsToObjectId(Object oid) {
        }

        public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object oid) {
        }

        public final Object dnGetObjectId() {
            if (this.dnStateManager != null) {
                return this.dnStateManager.getObjectId((Persistable)this);
            }
            if (!this.dnIsDetached()) {
                return null;
            }
            return this.dnDetachedState[0];
        }

        public final Object dnGetVersion() {
            if (this.dnStateManager != null) {
                return this.dnStateManager.getVersion((Persistable)this);
            }
            if (!this.dnIsDetached()) {
                return null;
            }
            return this.dnDetachedState[1];
        }

        protected final void dnPreSerialize() {
            if (this.dnStateManager != null) {
                this.dnStateManager.preSerialize((Persistable)this);
            }
        }

        public final ExecutionContextReference dnGetExecutionContext() {
            return this.dnStateManager != null ? this.dnStateManager.getExecutionContext((Persistable)this) : null;
        }

        public final Object dnGetTransactionalObjectId() {
            return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
        }

        public final boolean dnIsDeleted() {
            return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
        }

        public final boolean dnIsDirty() {
            if (this.dnStateManager != null) {
                return this.dnStateManager.isDirty((Persistable)this);
            }
            if (!this.dnIsDetached()) {
                return false;
            }
            return ((BitSet)this.dnDetachedState[3]).length() > 0;
        }

        public final boolean dnIsNew() {
            return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
        }

        public final boolean dnIsPersistent() {
            return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
        }

        public final boolean dnIsTransactional() {
            return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
        }

        public void dnMakeDirty(String fieldName) {
            if (this.dnStateManager != null) {
                this.dnStateManager.makeDirty((Persistable)this, fieldName);
            }
            if (this.dnIsDetached() && fieldName != null) {
                String fldName = null;
                fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
                int i = 0;
                while (i < dnFieldNames.length) {
                    if (dnFieldNames[i].equals(fldName)) {
                        if (((BitSet)this.dnDetachedState[2]).get(i + dnInheritedFieldCount)) {
                            ((BitSet)this.dnDetachedState[3]).set(i + dnInheritedFieldCount);
                            return;
                        }
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ++i;
                }
            }
        }

        public Object dnNewObjectIdInstance() {
            return null;
        }

        public Object dnNewObjectIdInstance(Object key) {
            return null;
        }

        public final void dnProvideFields(int[] indices) {
            if (indices == null) {
                throw new IllegalArgumentException("argment is null");
            }
            int i = indices.length - 1;
            if (i >= 0) {
                do {
                    this.dnProvideField(indices[i]);
                } while (--i >= 0);
            }
        }

        public final void dnReplaceFields(int[] indices) {
            if (indices == null) {
                throw new IllegalArgumentException("argument is null");
            }
            int i = indices.length;
            if (i > 0) {
                int j = 0;
                do {
                    this.dnReplaceField(indices[j]);
                } while (++j < i);
            }
        }

        public final void dnReplaceFlags() {
            if (this.dnStateManager != null) {
                this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
            }
        }

        public final synchronized void dnReplaceStateManager(StateManager sm) {
            if (this.dnStateManager != null) {
                this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
            } else {
                EnhancementHelper.checkAuthorizedStateManager((StateManager)sm);
                this.dnStateManager = sm;
                this.dnFlags = 1;
            }
        }

        public final synchronized void dnReplaceDetachedState() {
            if (this.dnStateManager == null) {
                throw new IllegalStateException("state manager is null");
            }
            this.dnDetachedState = this.dnStateManager.replacingDetachedState((Detachable)this, this.dnDetachedState);
        }

        public boolean dnIsDetached() {
            return this.dnStateManager == null && this.dnDetachedState != null;
        }

        public Persistable dnNewInstance(StateManager sm) {
            MPathToPersist result = new MPathToPersist();
            result.dnFlags = 1;
            result.dnStateManager = sm;
            return result;
        }

        public Persistable dnNewInstance(StateManager sm, Object obj) {
            MPathToPersist result = new MPathToPersist();
            result.dnFlags = 1;
            result.dnStateManager = sm;
            result.dnCopyKeyFieldsFromObjectId(obj);
            return result;
        }

        public void dnReplaceField(int index) {
            if (this.dnStateManager == null) {
                throw new IllegalStateException("state manager is null");
            }
            switch (index) {
                case 0: {
                    this.authzObjectId = this.dnStateManager.replacingLongField((Persistable)this, index);
                    break;
                }
                case 1: {
                    this.path = this.dnStateManager.replacingStringField((Persistable)this, index);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
                }
            }
        }

        public void dnProvideField(int index) {
            if (this.dnStateManager == null) {
                throw new IllegalStateException("state manager is null");
            }
            switch (index) {
                case 0: {
                    this.dnStateManager.providedLongField((Persistable)this, index, this.authzObjectId);
                    break;
                }
                case 1: {
                    this.dnStateManager.providedStringField((Persistable)this, index, this.path);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
                }
            }
        }

        protected final void dnCopyField(MPathToPersist obj, int index) {
            switch (index) {
                case 0: {
                    this.authzObjectId = obj.authzObjectId;
                    break;
                }
                case 1: {
                    this.path = obj.path;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
                }
            }
        }

        public void dnCopyFields(Object obj, int[] indices) {
            if (this.dnStateManager == null) {
                throw new IllegalStateException("state manager is null");
            }
            if (indices == null) {
                throw new IllegalStateException("fieldNumbers is null");
            }
            if (!(obj instanceof MPathToPersist)) {
                throw new IllegalArgumentException("object is not an object of type org.apache.sentry.provider.db.service.model.MAuthzPathsMapping$MPathToPersist");
            }
            MPathToPersist other = (MPathToPersist)obj;
            if (this.dnStateManager != other.dnStateManager) {
                throw new IllegalArgumentException("state managers do not match");
            }
            int i = indices.length - 1;
            if (i >= 0) {
                do {
                    this.dnCopyField(other, indices[i]);
                } while (--i >= 0);
            }
        }

        private static final String[] __dnFieldNamesInit() {
            return new String[]{"authzObjectId", "path"};
        }

        private static final Class[] __dnFieldTypesInit() {
            return new Class[]{Long.TYPE, MPathToPersist.___dn$loadClass("java.lang.String")};
        }

        private static final byte[] __dnFieldFlagsInit() {
            return new byte[]{21, 21};
        }

        protected static int __dnGetInheritedFieldCount() {
            return 0;
        }

        protected static int dnGetManagedFieldCount() {
            return 2;
        }

        private static Class __dnPersistableSuperclassInit() {
            return null;
        }

        public static Class ___dn$loadClass(String className) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
        }

        private Object dnSuperClone() throws CloneNotSupportedException {
            MPathToPersist o = (MPathToPersist)super.clone();
            o.dnFlags = 0;
            o.dnStateManager = null;
            return o;
        }

        private static long dnGetauthzObjectId(MPathToPersist objPC) {
            if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
                return objPC.dnStateManager.getLongField((Persistable)objPC, 0, objPC.authzObjectId);
            }
            if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(0)) {
                throw new JDODetachedFieldAccessException("You have just attempted to access field \"authzObjectId\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
            }
            return objPC.authzObjectId;
        }

        private static void dnSetauthzObjectId(MPathToPersist objPC, long val) {
            if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
                objPC.dnStateManager.setLongField((Persistable)objPC, 0, objPC.authzObjectId, val);
            } else {
                objPC.authzObjectId = val;
                if (objPC.dnIsDetached()) {
                    ((BitSet)objPC.dnDetachedState[3]).set(0);
                }
            }
        }

        private static String dnGetpath(MPathToPersist objPC) {
            if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1)) {
                return objPC.dnStateManager.getStringField((Persistable)objPC, 1, objPC.path);
            }
            if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(1)) {
                throw new JDODetachedFieldAccessException("You have just attempted to access field \"path\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
            }
            return objPC.path;
        }

        private static void dnSetpath(MPathToPersist objPC, String val) {
            if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
                objPC.dnStateManager.setStringField((Persistable)objPC, 1, objPC.path, val);
            } else {
                objPC.path = val;
                if (objPC.dnIsDetached()) {
                    ((BitSet)objPC.dnDetachedState[3]).set(1);
                }
            }
        }
    }
}

