/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.log.util;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.apache.sentry.api.common.ApiConstants;
import org.apache.sentry.api.generic.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.api.generic.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.api.generic.thrift.TAuthorizable;
import org.apache.sentry.api.generic.thrift.TSentryPrivilege;
import org.apache.sentry.api.service.thrift.TSentryAuthorizable;
import org.apache.sentry.api.service.thrift.TSentryGrantOption;
import org.apache.sentry.api.service.thrift.TSentryPrincipalType;
import org.datanucleus.util.StringUtils;

public final class CommandUtil {
    public static String createCmdForCreateOrDropRole(String roleName, boolean isCreate) {
        if (isCreate) {
            return "CREATE ROLE " + roleName;
        }
        return "DROP ROLE " + roleName;
    }

    public static String createCmdForRoleAddGroup(String roleName, String groups) {
        return CommandUtil.createCmdForRoleGrant(roleName, groups, true, true);
    }

    public static String createCmdForRoleDeleteGroup(String roleName, String groups) {
        return CommandUtil.createCmdForRoleGrant(roleName, groups, false, true);
    }

    private static String createCmdForRoleGrant(String roleName, String principals, boolean isGrant, boolean isGroup) {
        String principalType;
        StringBuilder sb = new StringBuilder();
        if (isGrant) {
            sb.append("GRANT ROLE ");
        } else {
            sb.append("REVOKE ROLE ");
        }
        sb.append(roleName);
        if (isGrant) {
            sb.append(" TO ");
        } else {
            sb.append(" FROM ");
        }
        String string = principalType = isGroup ? "GROUP" : "USER";
        if (!StringUtils.isEmpty((String)principals)) {
            sb.append(principalType).append(" ").append(principals);
        } else {
            sb = new StringBuilder("Missing " + principalType + " information.");
        }
        return sb.toString();
    }

    public static String createCmdForRoleAddUser(String roleName, String users) {
        return CommandUtil.createCmdForRoleGrant(roleName, users, true, false);
    }

    public static String createCmdForRoleDeleteUser(String roleName, String users) {
        return CommandUtil.createCmdForRoleGrant(roleName, users, false, false);
    }

    public static String createCmdForGrantPrivilege(org.apache.sentry.api.service.thrift.TAlterSentryRoleGrantPrivilegeRequest request) {
        return CommandUtil.createCmdForGrantOrRevokePrivileges(request.getRoleName(), request.getPrivileges(), true);
    }

    public static String createCmdForRevokePrivilege(org.apache.sentry.api.service.thrift.TAlterSentryRoleRevokePrivilegeRequest request) {
        return CommandUtil.createCmdForGrantOrRevokePrivileges(request.getRoleName(), request.getPrivileges(), false);
    }

    private static String createCmdForGrantOrRevokePrivileges(String roleName, Set<org.apache.sentry.api.service.thrift.TSentryPrivilege> privileges, boolean isGrant) {
        StringBuilder sb = new StringBuilder();
        if (privileges != null) {
            for (org.apache.sentry.api.service.thrift.TSentryPrivilege privilege : privileges) {
                sb.append(CommandUtil.createCmdForGrantOrRevokePrivilege(roleName, privilege, isGrant));
            }
        }
        return sb.toString();
    }

    private static String createCmdForGrantOrRevokePrivilege(String roleName, org.apache.sentry.api.service.thrift.TSentryPrivilege privilege, boolean isGrant) {
        StringBuilder sb = new StringBuilder();
        if (isGrant) {
            sb.append("GRANT ");
        } else {
            sb.append("REVOKE ");
        }
        String action = privilege.getAction();
        String privilegeScope = privilege.getPrivilegeScope();
        if ("*".equalsIgnoreCase(action)) {
            sb.append("ALL");
        } else {
            if (action != null) {
                action = action.toUpperCase();
            }
            sb.append(action);
        }
        sb.append(" ON ").append(privilege.getPrivilegeScope()).append(" ");
        if (ApiConstants.PrivilegeScope.DATABASE.name().equalsIgnoreCase(privilegeScope)) {
            sb.append(privilege.getDbName());
        } else if (ApiConstants.PrivilegeScope.TABLE.name().equalsIgnoreCase(privilegeScope)) {
            sb.append(privilege.getTableName());
        } else if (ApiConstants.PrivilegeScope.SERVER.name().equalsIgnoreCase(privilegeScope)) {
            sb.append(privilege.getServerName());
        } else if (ApiConstants.PrivilegeScope.URI.name().equalsIgnoreCase(privilegeScope)) {
            sb.append(privilege.getURI());
        }
        if (isGrant) {
            sb.append(" TO ROLE ");
        } else {
            sb.append(" FROM ROLE ");
        }
        sb.append(roleName);
        if (privilege.getGrantOption() == TSentryGrantOption.TRUE) {
            sb.append(" WITH GRANT OPTION");
        }
        return sb.toString();
    }

    public static String createCmdForGrantGMPrivilege(TAlterSentryRoleGrantPrivilegeRequest request) {
        return CommandUtil.createCmdForGrantOrRevokeGMPrivilege(request.getRoleName(), request.getPrivilege(), true);
    }

    public static String createCmdForRevokeGMPrivilege(TAlterSentryRoleRevokePrivilegeRequest request) {
        return CommandUtil.createCmdForGrantOrRevokeGMPrivilege(request.getRoleName(), request.getPrivilege(), false);
    }

    private static String createCmdForGrantOrRevokeGMPrivilege(String roleName, TSentryPrivilege privilege, boolean isGrant) {
        StringBuilder sb = new StringBuilder();
        if (isGrant) {
            sb.append("GRANT ");
        } else {
            sb.append("REVOKE ");
        }
        String action = privilege.getAction();
        if ("*".equalsIgnoreCase(action)) {
            sb.append("ALL");
        } else {
            if (action != null) {
                action = action.toUpperCase();
            }
            sb.append(action);
        }
        sb.append(" ON");
        List authorizables = privilege.getAuthorizables();
        if (authorizables != null) {
            for (TAuthorizable authorizable : authorizables) {
                sb.append(" ").append(authorizable.getType()).append(" ").append(authorizable.getName());
            }
        }
        if (isGrant) {
            sb.append(" TO ROLE ");
        } else {
            sb.append(" FROM ROLE ");
        }
        sb.append(roleName);
        if (privilege.getGrantOption() == org.apache.sentry.api.generic.thrift.TSentryGrantOption.TRUE) {
            sb.append(" WITH GRANT OPTION");
        }
        return sb.toString();
    }

    public static String createCmdForImplicitGrantOwnerPrivilege(TSentryPrincipalType ownerType, String ownerName, TSentryAuthorizable authorizable) {
        StringBuilder sb = new StringBuilder();
        sb.append("OWNER privilege on");
        if (StringUtils.isEmpty((String)authorizable.getTable())) {
            sb.append(" database ");
            sb.append(authorizable.getDb());
        } else {
            sb.append(" table ");
            sb.append(authorizable.getDb());
            sb.append(".");
            sb.append(authorizable.getTable());
        }
        sb.append(" is granted to ");
        sb.append(ownerType.toString()).append(": ");
        sb.append(ownerName);
        return sb.toString();
    }

    public static String createCmdForImplicitTransferOwnerPrivilege(TSentryPrincipalType ownerType, String ownerName, TSentryAuthorizable authorizable) {
        StringBuilder sb = new StringBuilder();
        sb.append("OWNER privilege on");
        if (StringUtils.isEmpty((String)authorizable.getTable())) {
            sb.append(" database ");
            sb.append(authorizable.getDb());
        } else {
            sb.append(" table ");
            sb.append(authorizable.getDb());
            sb.append(".");
            sb.append(authorizable.getTable());
        }
        sb.append(" is transferred to ");
        sb.append(ownerType.toString()).append(": ");
        sb.append(ownerName);
        return sb.toString();
    }

    @VisibleForTesting
    public static boolean assertIPInAuditLog(String ipInAuditLog) throws Exception {
        if (ipInAuditLog == null) {
            return false;
        }
        Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> ips = ni.getInetAddresses();
            while (ips.hasMoreElements()) {
                if (ipInAuditLog.indexOf(ips.nextElement().getHostAddress()) == -1) continue;
                return true;
            }
        }
        return false;
    }
}

