/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.log.entity;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sentry.provider.db.log.entity.AuditMetadataLogEntity;
import org.codehaus.jackson.JsonGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMAuditMetadataLogEntity
extends AuditMetadataLogEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(GMAuditMetadataLogEntity.class);
    private static final Set<String> opsWithoutComponent = new HashSet<String>(Arrays.asList("CREATE_ROLE", "DROP_ROLE", "ADD_ROLE_TO_GROUP", "DELETE_ROLE_FROM_GROUP"));
    private Map<String, String> privilegesMap;

    public GMAuditMetadataLogEntity() {
        this.privilegesMap = new LinkedHashMap<String, String>();
    }

    public GMAuditMetadataLogEntity(String serviceName, String userName, String impersonator, String ipAddress, String operation, String eventTime, String operationText, String allowed, String objectType, String component, Map<String, String> privilegesMap) {
        this.setCommonAttr(serviceName, userName, impersonator, ipAddress, operation, eventTime, operationText, allowed, objectType, component);
        this.privilegesMap = privilegesMap;
    }

    @Override
    public String toJsonFormatLog() throws Exception {
        StringWriter stringWriter = new StringWriter();
        JsonGenerator json = null;
        try {
            json = factory.createJsonGenerator((Writer)stringWriter);
            json.writeStartObject();
            json.writeStringField("serviceName", this.getServiceName());
            json.writeStringField("userName", this.getUserName());
            json.writeStringField("impersonator", this.getImpersonator());
            json.writeStringField("ipAddress", this.getIpAddress());
            json.writeStringField("operation", this.getOperation());
            json.writeStringField("eventTime", this.getEventTime());
            StringBuilder operationTextSB = new StringBuilder(this.getOperationText());
            if (!opsWithoutComponent.contains(this.getOperation())) {
                operationTextSB.append(" ON COMPONENT " + this.getComponent());
            }
            json.writeStringField("operationText", operationTextSB.toString());
            json.writeStringField("allowed", this.getAllowed());
            LinkedHashMap<String, Boolean> privHasObject = new LinkedHashMap<String, Boolean>();
            privHasObject.put("databaseName", false);
            privHasObject.put("tableName", false);
            privHasObject.put("column", false);
            privHasObject.put("resourcePath", false);
            for (Map.Entry<String, String> entry : this.privilegesMap.entrySet()) {
                if (!privHasObject.containsKey(entry.getKey())) continue;
                json.writeStringField(entry.getKey(), entry.getValue());
                privHasObject.put(entry.getKey(), true);
            }
            for (Map.Entry<String, String> entry : privHasObject.entrySet()) {
                if (!Boolean.FALSE.equals(entry.getValue())) continue;
                json.writeStringField(entry.getKey(), null);
            }
            json.writeStringField("objectType", this.getObjectType());
            json.writeEndObject();
            json.flush();
        }
        catch (IOException e) {
            String msg = "Error creating audit log in json format: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (json != null) {
                    json.close();
                }
            }
            catch (IOException e) {
                String msg = "Error when close json object: " + e.getMessage();
                LOGGER.error(msg, (Throwable)e);
                throw e;
            }
        }
        return stringWriter.toString();
    }

    public Map<String, String> getPrivilegesMap() {
        return this.privilegesMap;
    }

    public void setPrivilegesMap(Map<String, String> privilegesMap) {
        this.privilegesMap = privilegesMap;
    }
}

