/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.service.persistent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.api.generic.thrift.TSentryRole;
import org.apache.sentry.api.service.thrift.SentryPolicyStoreProcessor;
import org.apache.sentry.api.service.thrift.TSentryGroup;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.exception.SentryAccessDeniedException;
import org.apache.sentry.core.common.exception.SentryGrantDeniedException;
import org.apache.sentry.core.common.exception.SentryInvalidInputException;
import org.apache.sentry.core.common.exception.SentryNoSuchObjectException;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.provider.db.generic.service.persistent.PrivilegeObject;
import org.apache.sentry.provider.db.generic.service.persistent.PrivilegeOperatePersistence;
import org.apache.sentry.provider.db.generic.service.persistent.SentryStoreLayer;
import org.apache.sentry.provider.db.service.model.MSentryGMPrivilege;
import org.apache.sentry.provider.db.service.model.MSentryGroup;
import org.apache.sentry.provider.db.service.model.MSentryRole;
import org.apache.sentry.provider.db.service.persistent.QueryParamBuilder;
import org.apache.sentry.provider.db.service.persistent.SentryStore;
import org.apache.sentry.provider.db.service.persistent.TransactionBlock;

public class DelegateSentryStore
implements SentryStoreLayer {
    private SentryStore delegate;
    private Configuration conf;
    private Set<String> adminGroups;
    private PrivilegeOperatePersistence privilegeOperator;

    public DelegateSentryStore(Configuration conf) throws Exception {
        this.privilegeOperator = new PrivilegeOperatePersistence(conf);
        this.conf = conf;
        this.delegate = new SentryStore(conf);
        this.adminGroups = ImmutableSet.copyOf(DelegateSentryStore.toTrimmed(Sets.newHashSet((Object[])conf.getStrings("sentry.service.admin.group", new String[0]))));
    }

    private MSentryRole getRole(String roleName, PersistenceManager pm) {
        return this.delegate.getRole(pm, roleName);
    }

    @Override
    public Object createRole(String component, String role, String requestor) throws Exception {
        this.delegate.createSentryRole(role);
        return null;
    }

    @Override
    public Object dropRole(String component, String role, String requestor) throws Exception {
        this.delegate.dropSentryRole(DelegateSentryStore.toTrimmedLower(role));
        return null;
    }

    @Override
    public Set<String> getAllRoleNames() throws Exception {
        return this.delegate.getAllRoleNames();
    }

    @Override
    public Object alterRoleAddGroups(String component, String role, Set<String> groups, String requestor) throws Exception {
        this.delegate.alterSentryRoleAddGroups(requestor, role, this.toTSentryGroups(groups));
        return null;
    }

    @Override
    public Object alterRoleDeleteGroups(String component, String role, Set<String> groups, String requestor) throws Exception {
        this.delegate.alterSentryRoleDeleteGroups(role, this.toTSentryGroups(groups));
        return null;
    }

    @Override
    public Object alterRoleGrantPrivilege(String component, String role, PrivilegeObject privilege, String grantorPrincipal) throws Exception {
        this.delegate.getTransactionManager().executeTransactionWithRetry(pm -> {
            pm.setDetachAllOnCommit(false);
            String trimmedRole = DelegateSentryStore.toTrimmedLower(role);
            MSentryRole mRole = this.getRole(trimmedRole, pm);
            if (mRole == null) {
                throw new SentryNoSuchObjectException("Role: " + trimmedRole);
            }
            this.grantOptionCheck(privilege, grantorPrincipal, pm);
            this.privilegeOperator.grantPrivilege(privilege, mRole, pm);
            return null;
        });
        return null;
    }

    @Override
    public Object alterRoleRevokePrivilege(String component, String role, PrivilegeObject privilege, String grantorPrincipal) throws Exception {
        this.delegate.getTransactionManager().executeTransactionWithRetry(pm -> {
            pm.setDetachAllOnCommit(false);
            String trimmedRole = DelegateSentryStore.toTrimmedLower(role);
            MSentryRole mRole = this.getRole(trimmedRole, pm);
            if (mRole == null) {
                throw new SentryNoSuchObjectException("Role: " + trimmedRole);
            }
            this.grantOptionCheck(privilege, grantorPrincipal, pm);
            this.privilegeOperator.revokePrivilege(privilege, mRole, pm);
            return null;
        });
        return null;
    }

    @Override
    public Object renamePrivilege(String component, String service, List<? extends Authorizable> oldAuthorizables, List<? extends Authorizable> newAuthorizables, String requestor) throws Exception {
        Preconditions.checkNotNull((Object)component);
        Preconditions.checkNotNull((Object)service);
        Preconditions.checkNotNull(oldAuthorizables);
        Preconditions.checkNotNull(newAuthorizables);
        if (oldAuthorizables.size() != newAuthorizables.size()) {
            throw new SentryAccessDeniedException("rename privilege denied: the size of oldAuthorizables must equals the newAuthorizables oldAuthorizables:" + Arrays.toString(oldAuthorizables.toArray()) + " newAuthorizables:" + Arrays.toString(newAuthorizables.toArray()));
        }
        this.delegate.getTransactionManager().executeTransactionWithRetry(pm -> {
            pm.setDetachAllOnCommit(false);
            this.privilegeOperator.renamePrivilege(DelegateSentryStore.toTrimmedLower(component), DelegateSentryStore.toTrimmedLower(service), oldAuthorizables, newAuthorizables, requestor, pm);
            return null;
        });
        return null;
    }

    @Override
    public Object dropPrivilege(String component, PrivilegeObject privilege, String requestor) throws Exception {
        Preconditions.checkNotNull((Object)requestor);
        this.delegate.getTransactionManager().executeTransactionWithRetry(pm -> {
            pm.setDetachAllOnCommit(false);
            this.privilegeOperator.dropPrivilege(privilege, pm);
            return null;
        });
        return null;
    }

    private void grantOptionCheck(PrivilegeObject requestPrivilege, String grantorPrincipal, PersistenceManager pm) throws SentryUserException {
        if (Strings.isNullOrEmpty((String)grantorPrincipal)) {
            throw new SentryInvalidInputException("grantorPrincipal should not be null or empty");
        }
        Set<String> groups = this.getRequestorGroups(grantorPrincipal);
        if (groups == null || groups.isEmpty()) {
            throw new SentryGrantDeniedException(grantorPrincipal + " has no grant!");
        }
        if (!Sets.intersection(this.adminGroups, DelegateSentryStore.toTrimmed(groups)).isEmpty()) {
            return;
        }
        Set<MSentryRole> mRoles = this.delegate.getRolesForGroups(pm, groups);
        if (!this.privilegeOperator.checkPrivilegeOption(mRoles, requestPrivilege, pm)) {
            throw new SentryGrantDeniedException(grantorPrincipal + " has no grant!");
        }
    }

    @Override
    public Set<String> getRolesByGroups(String component, Set<String> groups) throws Exception {
        if (groups == null || groups.isEmpty()) {
            return Collections.emptySet();
        }
        Set<Object> roles = Sets.newHashSet();
        roles = groups.contains(null) ? this.delegate.getAllRoleNames() : this.delegate.getRoleNamesForGroups(groups);
        return roles;
    }

    @Override
    public Set<TSentryRole> getTSentryRolesByGroupName(String component, final Set<String> groups) throws Exception {
        if (groups == null || groups.isEmpty()) {
            return Collections.emptySet();
        }
        return this.delegate.getTransactionManager().executeTransaction(new TransactionBlock<Set<TSentryRole>>(){

            @Override
            public Set<TSentryRole> execute(PersistenceManager pm) throws Exception {
                HashSet tRoles = Sets.newHashSet();
                pm.setDetachAllOnCommit(false);
                Set<Object> mSentryRoles = Sets.newHashSet();
                if (groups.contains(null)) {
                    mSentryRoles.addAll(DelegateSentryStore.this.delegate.getAllRoles(pm));
                } else {
                    mSentryRoles = DelegateSentryStore.this.delegate.getRolesForGroups(pm, groups);
                }
                for (MSentryRole mSentryRole : mSentryRoles) {
                    String roleName = mSentryRole.getRoleName().intern();
                    HashSet groupNames = Sets.newHashSet();
                    Set<MSentryGroup> mSentryGroups = mSentryRole.getGroups();
                    for (MSentryGroup mSentryGroup : mSentryGroups) {
                        groupNames.add(mSentryGroup.getGroupName());
                    }
                    tRoles.add(new TSentryRole(roleName, (Set)groupNames));
                }
                return tRoles;
            }
        });
    }

    @Override
    public Set<String> getGroupsByRoles(String component, final Set<String> roles) throws Exception {
        if (roles.isEmpty()) {
            return Collections.emptySet();
        }
        return this.delegate.getTransactionManager().executeTransaction(new TransactionBlock<Set<String>>(){

            @Override
            public Set<String> execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                Query query = pm.newQuery(MSentryGroup.class);
                QueryParamBuilder paramBuilder = QueryParamBuilder.addRolesFilter(query, null, roles);
                query.setFilter(paramBuilder.toString());
                List mGroups = (List)query.executeWithMap(paramBuilder.getArguments());
                HashSet<String> groupNames = new HashSet<String>();
                for (MSentryGroup g : mGroups) {
                    groupNames.add(g.getGroupName());
                }
                return groupNames;
            }
        });
    }

    @Override
    public Set<PrivilegeObject> getPrivilegesByRole(String component, Set<String> roles) throws Exception {
        Preconditions.checkNotNull(roles);
        if (roles.isEmpty()) {
            return Collections.emptySet();
        }
        return this.delegate.getTransactionManager().executeTransaction(pm -> {
            pm.setDetachAllOnCommit(false);
            HashSet<MSentryRole> mRoles = new HashSet<MSentryRole>();
            for (String role : roles) {
                MSentryRole mRole = this.getRole(DelegateSentryStore.toTrimmedLower(role), pm);
                if (mRole == null) continue;
                mRoles.add(mRole);
            }
            return new HashSet<PrivilegeObject>(this.privilegeOperator.getPrivilegesByRole(mRoles, pm));
        });
    }

    @Override
    public Set<PrivilegeObject> getPrivilegesByProvider(String component, String service, Set<String> roles, Set<String> groups, List<? extends Authorizable> authorizables) throws Exception {
        Preconditions.checkNotNull((Object)component);
        Preconditions.checkNotNull((Object)service);
        return this.delegate.getTransactionManager().executeTransaction(pm -> {
            pm.setDetachAllOnCommit(false);
            String trimmedComponent = DelegateSentryStore.toTrimmedLower(component);
            String trimmedService = DelegateSentryStore.toTrimmedLower(service);
            Set<String> trimmedRoles = SentryStore.toTrimedLower(roles);
            if (groups != null) {
                trimmedRoles.addAll(this.delegate.getRoleNamesForGroups(groups));
            }
            if (trimmedRoles.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet<MSentryRole> mRoles = new HashSet<MSentryRole>(trimmedRoles.size());
            for (String role : trimmedRoles) {
                MSentryRole mRole = this.getRole(role, pm);
                if (mRole == null) continue;
                mRoles.add(mRole);
            }
            HashSet<PrivilegeObject> privileges = new HashSet<PrivilegeObject>();
            privileges.addAll(this.privilegeOperator.getPrivilegesByProvider(trimmedComponent, trimmedService, mRoles, authorizables, pm));
            return privileges;
        });
    }

    @Override
    public Set<MSentryGMPrivilege> getPrivilegesByAuthorizable(String component, String service, Set<String> validActiveRoles, List<? extends Authorizable> authorizables) throws Exception {
        if (validActiveRoles == null || validActiveRoles.isEmpty()) {
            return Collections.emptySet();
        }
        Preconditions.checkNotNull((Object)component);
        Preconditions.checkNotNull((Object)service);
        return this.delegate.getTransactionManager().executeTransaction(pm -> {
            String lComponent = DelegateSentryStore.toTrimmedLower(component);
            String lService = DelegateSentryStore.toTrimmedLower(service);
            HashSet<MSentryRole> mRoles = new HashSet<MSentryRole>(validActiveRoles.size());
            for (String role : validActiveRoles) {
                MSentryRole mRole = this.getRole(role, pm);
                if (mRole == null) continue;
                mRoles.add(mRole);
            }
            Set<MSentryGMPrivilege> mSentryGMPrivileges = this.privilegeOperator.getPrivilegesByAuthorizable(lComponent, lService, mRoles, authorizables, pm);
            HashSet<MSentryGMPrivilege> privileges = new HashSet<MSentryGMPrivilege>(mSentryGMPrivileges.size());
            for (MSentryGMPrivilege mSentryGMPrivilege : mSentryGMPrivileges) {
                pm.retrieve((Object)mSentryGMPrivilege);
                privileges.add(mSentryGMPrivilege);
            }
            return privileges;
        });
    }

    @Override
    public void close() {
        this.delegate.stop();
    }

    private Set<TSentryGroup> toTSentryGroups(Set<String> groups) {
        if (groups.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<TSentryGroup> tSentryGroups = new HashSet<TSentryGroup>(groups.size());
        for (String group : groups) {
            tSentryGroups.add(new TSentryGroup(group));
        }
        return tSentryGroups;
    }

    private static Set<String> toTrimmed(Set<String> s) {
        if (s.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>(s.size());
        for (String v : s) {
            result.add(v.trim());
        }
        return result;
    }

    private static String toTrimmedLower(String s) {
        if (s == null) {
            return "";
        }
        return s.trim().toLowerCase();
    }

    private Set<String> getRequestorGroups(String userName) throws SentryUserException {
        return SentryPolicyStoreProcessor.getGroupsFromUserName(this.conf, userName);
    }

    @VisibleForTesting
    void clearAllTables() throws Exception {
        this.delegate.getTransactionManager().executeTransaction(pm -> {
            pm.newQuery(MSentryRole.class).deletePersistentAll();
            pm.newQuery(MSentryGroup.class).deletePersistentAll();
            pm.newQuery(MSentryGMPrivilege.class).deletePersistentAll();
            return null;
        });
    }
}

