/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.api.service.thrift;

import org.apache.sentry.api.service.thrift.TSentryPrivilege;
import org.apache.sentry.core.common.utils.PathUtils;
import org.apache.sentry.core.common.utils.SentryUtils;

public class SentryPolicyStoreUtils {
    private SentryPolicyStoreUtils() {
    }

    static boolean privilegeImplies(TSentryPrivilege privilege, TSentryPrivilege other) {
        String action;
        if (SentryUtils.isNULL((String)privilege.getServerName()) || SentryUtils.isNULL((String)other.getServerName())) {
            return false;
        }
        if (!privilege.getServerName().equals(other.getServerName())) {
            return false;
        }
        if (!SentryUtils.isNULL((String)privilege.getURI()) && !SentryUtils.isNULL((String)other.getURI())) {
            if (!PathUtils.impliesURI((String)privilege.getURI(), (String)other.getURI())) {
                return false;
            }
        } else if (SentryUtils.isNULL((String)privilege.getURI()) && SentryUtils.isNULL((String)other.getURI())) {
            if (!SentryUtils.isNULL((String)privilege.getDbName())) {
                if (SentryUtils.isNULL((String)other.getDbName())) {
                    return false;
                }
                if (!privilege.getDbName().equals(other.getDbName())) {
                    return false;
                }
            }
            if (!SentryUtils.isNULL((String)privilege.getTableName())) {
                if (SentryUtils.isNULL((String)other.getTableName())) {
                    return false;
                }
                if (!privilege.getTableName().equals(other.getTableName())) {
                    return false;
                }
            }
            if (!SentryUtils.isNULL((String)privilege.getColumnName())) {
                if (SentryUtils.isNULL((String)other.getColumnName())) {
                    return false;
                }
                if (!privilege.getColumnName().equals(other.getColumnName())) {
                    return false;
                }
            }
        } else if (!SentryUtils.isNULL((String)privilege.getURI()) && SentryUtils.isNULL((String)other.getURI())) {
            return false;
        }
        return (action = privilege.getAction()).equalsIgnoreCase("*") || action.equalsIgnoreCase("OWNER") || action.equalsIgnoreCase(other.getAction()) || action.equalsIgnoreCase("ALL");
    }
}

