/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.api.service.thrift;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.log4j.Logger;
import org.apache.sentry.api.common.SentryServiceUtil;
import org.apache.sentry.api.common.Status;
import org.apache.sentry.api.service.thrift.NotificationHandler;
import org.apache.sentry.api.service.thrift.NotificationHandlerInvoker;
import org.apache.sentry.api.service.thrift.SentryMetrics;
import org.apache.sentry.api.service.thrift.SentryPolicyService;
import org.apache.sentry.api.service.thrift.SentryPolicyStoreUtils;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleAddGroupsRequest;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleAddGroupsResponse;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleAddUsersRequest;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleAddUsersResponse;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleDeleteGroupsRequest;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleDeleteGroupsResponse;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleDeleteUsersRequest;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleDeleteUsersResponse;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleGrantPrivilegeResponse;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleRevokePrivilegeResponse;
import org.apache.sentry.api.service.thrift.TCreateSentryRoleRequest;
import org.apache.sentry.api.service.thrift.TCreateSentryRoleResponse;
import org.apache.sentry.api.service.thrift.TDropPrivilegesRequest;
import org.apache.sentry.api.service.thrift.TDropPrivilegesResponse;
import org.apache.sentry.api.service.thrift.TDropSentryRoleRequest;
import org.apache.sentry.api.service.thrift.TDropSentryRoleResponse;
import org.apache.sentry.api.service.thrift.TIsSentryAdminRequest;
import org.apache.sentry.api.service.thrift.TIsSentryAdminResponse;
import org.apache.sentry.api.service.thrift.TListSentryPrivilegesByAuthRequest;
import org.apache.sentry.api.service.thrift.TListSentryPrivilegesByAuthResponse;
import org.apache.sentry.api.service.thrift.TListSentryPrivilegesByAuthUserRequest;
import org.apache.sentry.api.service.thrift.TListSentryPrivilegesByAuthUserResponse;
import org.apache.sentry.api.service.thrift.TListSentryPrivilegesForProviderRequest;
import org.apache.sentry.api.service.thrift.TListSentryPrivilegesForProviderResponse;
import org.apache.sentry.api.service.thrift.TListSentryPrivilegesRequest;
import org.apache.sentry.api.service.thrift.TListSentryPrivilegesResponse;
import org.apache.sentry.api.service.thrift.TListSentryRolesForUserRequest;
import org.apache.sentry.api.service.thrift.TListSentryRolesRequest;
import org.apache.sentry.api.service.thrift.TListSentryRolesResponse;
import org.apache.sentry.api.service.thrift.TRenamePrivilegesRequest;
import org.apache.sentry.api.service.thrift.TRenamePrivilegesResponse;
import org.apache.sentry.api.service.thrift.TSentryActiveRoleSet;
import org.apache.sentry.api.service.thrift.TSentryAuthorizable;
import org.apache.sentry.api.service.thrift.TSentryConfigValueRequest;
import org.apache.sentry.api.service.thrift.TSentryConfigValueResponse;
import org.apache.sentry.api.service.thrift.TSentryExportMappingDataRequest;
import org.apache.sentry.api.service.thrift.TSentryExportMappingDataResponse;
import org.apache.sentry.api.service.thrift.TSentryGrantOption;
import org.apache.sentry.api.service.thrift.TSentryHmsEventNotification;
import org.apache.sentry.api.service.thrift.TSentryHmsEventNotificationResponse;
import org.apache.sentry.api.service.thrift.TSentryImportMappingDataRequest;
import org.apache.sentry.api.service.thrift.TSentryImportMappingDataResponse;
import org.apache.sentry.api.service.thrift.TSentryMappingData;
import org.apache.sentry.api.service.thrift.TSentryPrincipalType;
import org.apache.sentry.api.service.thrift.TSentryPrivilege;
import org.apache.sentry.api.service.thrift.TSentryPrivilegeMap;
import org.apache.sentry.api.service.thrift.TSentryPrivilegesRequest;
import org.apache.sentry.api.service.thrift.TSentryPrivilegesResponse;
import org.apache.sentry.api.service.thrift.TSentrySyncIDRequest;
import org.apache.sentry.api.service.thrift.TSentrySyncIDResponse;
import org.apache.sentry.api.service.thrift.validator.GrantPrivilegeRequestValidator;
import org.apache.sentry.api.service.thrift.validator.RevokePrivilegeRequestValidator;
import org.apache.sentry.core.common.exception.SentryAccessDeniedException;
import org.apache.sentry.core.common.exception.SentryAlreadyExistsException;
import org.apache.sentry.core.common.exception.SentryGrantDeniedException;
import org.apache.sentry.core.common.exception.SentryGroupNotFoundException;
import org.apache.sentry.core.common.exception.SentryInvalidInputException;
import org.apache.sentry.core.common.exception.SentryNoSuchObjectException;
import org.apache.sentry.core.common.exception.SentrySiteConfigurationException;
import org.apache.sentry.core.common.exception.SentryThriftAPIMismatchException;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.hdfs.Updateable;
import org.apache.sentry.provider.common.GroupMappingService;
import org.apache.sentry.provider.db.SentryPolicyStorePlugin;
import org.apache.sentry.provider.db.audit.SentryAuditLogger;
import org.apache.sentry.provider.db.service.persistent.SentryStoreInterface;
import org.apache.sentry.service.common.ServiceConstants;
import org.apache.sentry.service.thrift.FullUpdateInitializerState;
import org.apache.sentry.service.thrift.SentryStateBank;
import org.apache.sentry.service.thrift.TSentryResponseStatus;
import org.apache.thrift.TException;
import sentry.com.codahale.metrics.MetricRegistry;
import sentry.com.codahale.metrics.Timer;

public class SentryPolicyStoreProcessor
implements SentryPolicyService.Iface {
    private static final Logger LOGGER = Logger.getLogger(SentryPolicyStoreProcessor.class);
    private static final Logger AUDIT_LOGGER = Logger.getLogger((String)"sentry.hive.authorization.ddl.logger");
    private static final Map<TSentryPrincipalType, ServiceConstants.SentryPrincipalType> mapOwnerType = ImmutableMap.of((Object)TSentryPrincipalType.ROLE, (Object)ServiceConstants.SentryPrincipalType.ROLE, (Object)TSentryPrincipalType.USER, (Object)ServiceConstants.SentryPrincipalType.USER);
    private final String name;
    private final Configuration conf;
    private final SentryStoreInterface sentryStore;
    private final NotificationHandlerInvoker notificationHandlerInvoker;
    private final ImmutableSet<String> adminGroups;
    private SentryMetrics sentryMetrics;
    private final Timer hmsWaitTimer = SentryMetrics.getInstance().getTimer(MetricRegistry.name(SentryPolicyStoreProcessor.class, "hms", "wait"));
    private final SentryAuditLogger audit;
    private List<SentryPolicyStorePlugin> sentryPlugins = new LinkedList<SentryPolicyStorePlugin>();

    SentryPolicyStoreProcessor(String name, Configuration conf, SentryStoreInterface store) throws Exception {
        this.name = name;
        this.conf = conf;
        this.sentryStore = store;
        this.notificationHandlerInvoker = new NotificationHandlerInvoker(conf, SentryPolicyStoreProcessor.createHandlers(conf));
        this.audit = new SentryAuditLogger(conf);
        this.adminGroups = ImmutableSet.copyOf(SentryPolicyStoreProcessor.toTrimedLower(Sets.newHashSet((Object[])conf.getStrings("sentry.service.admin.group", new String[0]))));
        Iterable pluginClasses = ServiceConstants.ConfUtilties.CLASS_SPLITTER.split((CharSequence)conf.get("sentry.policy.store.plugins", "").trim());
        for (String pluginClassStr : pluginClasses) {
            Class clazz = conf.getClassByName(pluginClassStr);
            if (!SentryPolicyStorePlugin.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Sentry Plugin [" + pluginClassStr + "] is not a " + SentryPolicyStorePlugin.class.getName());
            }
            SentryPolicyStorePlugin plugin = (SentryPolicyStorePlugin)clazz.newInstance();
            plugin.initialize(conf, this.sentryStore);
            this.sentryPlugins.add(plugin);
        }
        this.initMetrics();
    }

    private void initMetrics() {
        this.sentryMetrics = SentryMetrics.getInstance();
        this.sentryMetrics.addSentryStoreGauges(this.sentryStore);
        this.sentryMetrics.initReporting(this.conf);
    }

    public void stop() {
        this.sentryStore.stop();
    }

    public void registerPlugin(SentryPolicyStorePlugin plugin) throws SentryPolicyStorePlugin.SentryPluginException {
        plugin.initialize(this.conf, this.sentryStore);
        this.sentryPlugins.add(plugin);
    }

    @VisibleForTesting
    static List<NotificationHandler> createHandlers(Configuration conf) throws SentrySiteConfigurationException {
        ArrayList handlers = Lists.newArrayList();
        Iterable notificationHandlers = Splitter.onPattern((String)"[\\s,]").trimResults().omitEmptyStrings().split((CharSequence)conf.get("sentry.policy.store.notification.handlers", ""));
        for (String notificationHandler : notificationHandlers) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(notificationHandler);
                if (!NotificationHandler.class.isAssignableFrom(clazz)) {
                    throw new SentrySiteConfigurationException("Class " + notificationHandler + " is not a " + NotificationHandler.class.getName());
                }
            }
            catch (ClassNotFoundException e) {
                throw new SentrySiteConfigurationException("Value " + notificationHandler + " is not a class", (Throwable)e);
            }
            Preconditions.checkNotNull(clazz, (Object)"Error class cannot be null");
            try {
                Constructor<?> constructor = clazz.getConstructor(Configuration.class);
                handlers.add((NotificationHandler)constructor.newInstance(conf));
            }
            catch (Exception e) {
                throw new SentrySiteConfigurationException("Error attempting to create " + notificationHandler, (Throwable)e);
            }
        }
        return handlers;
    }

    @VisibleForTesting
    public Configuration getSentryStoreConf() {
        return this.conf;
    }

    private static Set<String> toTrimedLower(Set<String> s) {
        HashSet result = Sets.newHashSet();
        for (String v : s) {
            result.add(v.trim().toLowerCase());
        }
        return result;
    }

    private boolean inAdminGroups(Set<String> requestorGroups) {
        Set<String> trimmedRequestorGroups = SentryPolicyStoreProcessor.toTrimedLower(requestorGroups);
        return !Sets.intersection(this.adminGroups, trimmedRequestorGroups).isEmpty();
    }

    private void authorize(String requestorUser, Set<String> requestorGroups) throws SentryAccessDeniedException {
        if (!this.inAdminGroups(requestorGroups)) {
            String msg = "User: " + requestorUser + " is part of " + requestorGroups + " which does not, intersect admin groups " + this.adminGroups;
            LOGGER.warn((Object)msg);
            throw new SentryAccessDeniedException("Access denied to " + requestorUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIsSentryAdminResponse is_sentry_admin(TIsSentryAdminRequest request) throws TException {
        Timer.Context timerContext = this.sentryMetrics.isSentryAdminTimer.time();
        TIsSentryAdminResponse response = new TIsSentryAdminResponse();
        String user = request.getUserName();
        try {
            SentryPolicyStoreProcessor.validateClientVersion(request.getProtocol_version());
            Set<String> groups = this.getRequestorGroups(user);
            response.setIsAdmin(this.inAdminGroups(groups));
            response.setStatus(Status.OK());
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryUserException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        finally {
            timerContext.stop();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCreateSentryRoleResponse create_sentry_role(TCreateSentryRoleRequest request) throws TException {
        Timer.Context timerContext = this.sentryMetrics.createRoleTimer.time();
        TCreateSentryRoleResponse response = new TCreateSentryRoleResponse();
        try {
            SentryPolicyStoreProcessor.validateClientVersion(request.getProtocol_version());
            this.authorize(request.getRequestorUserName(), this.getRequestorGroups(request.getRequestorUserName()));
            this.sentryStore.createSentryRole(request.getRoleName());
            response.setStatus(Status.OK());
            this.notificationHandlerInvoker.create_sentry_role(request, response);
        }
        catch (SentryAlreadyExistsException e) {
            String msg = "Role: " + request + " already exists.";
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.AlreadyExists((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryGroupNotFoundException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        finally {
            timerContext.stop();
        }
        this.audit.onCreateRole(request, response);
        return response;
    }

    private void checkGrantOptionPrivileges(String grantorUser, Set<TSentryPrivilege> checkPrivileges) throws Exception {
        Preconditions.checkNotNull(checkPrivileges, (Object)"Privileges to check for grant option must not be null.");
        Set<String> groups = SentryPolicyStoreProcessor.getGroupsFromUserName(this.conf, grantorUser);
        if (groups != null && this.inAdminGroups(groups)) {
            return;
        }
        Set<TSentryPrivilege> userPrivileges = this.sentryStore.listSentryPrivilegesByUsersAndGroups(groups, Collections.singleton(grantorUser), new TSentryActiveRoleSet(true, null), null);
        if (userPrivileges == null || userPrivileges.isEmpty()) {
            throw new SentryGrantDeniedException(String.format("User %s does not have privileges to grant.", grantorUser));
        }
        for (TSentryPrivilege checkPrivilege : checkPrivileges) {
            boolean hasGrant = false;
            for (TSentryPrivilege p : userPrivileges) {
                if (p.getGrantOption() != TSentryGrantOption.TRUE || !SentryPolicyStoreUtils.privilegeImplies(p, checkPrivilege)) continue;
                hasGrant = true;
                break;
            }
            if (hasGrant) continue;
            throw new SentryGrantDeniedException(String.format("User %s does not have privileges to grant %s.", grantorUser, checkPrivilege.getAction().toUpperCase()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TAlterSentryRoleGrantPrivilegeResponse alter_sentry_role_grant_privilege(TAlterSentryRoleGrantPrivilegeRequest request) throws TException {
        Timer.Context timerContext = this.sentryMetrics.grantTimer.time();
        TAlterSentryRoleGrantPrivilegeResponse response = new TAlterSentryRoleGrantPrivilegeResponse();
        try {
            SentryPolicyStoreProcessor.validateClientVersion(request.getProtocol_version());
            if (!(request.isSetPrivileges() ^ request.isSetPrivilege())) {
                throw new SentryUserException("SENTRY API version is not right!");
            }
            if (request.isSetPrivilege()) {
                request.setPrivileges((Set)Sets.newHashSet((Object[])new TSentryPrivilege[]{request.getPrivilege()}));
            }
            SentryServiceUtil.checkDbExplicitGrantsPermitted((Configuration)this.conf, (Set)request.getPrivileges());
            this.checkGrantOptionPrivileges(request.getRequestorUserName(), request.getPrivileges());
            Preconditions.checkState((this.sentryPlugins.size() <= 1 ? 1 : 0) != 0);
            HashMap<TSentryPrivilege, Updateable.Update> privilegesUpdateMap = new HashMap<TSentryPrivilege, Updateable.Update>();
            for (SentryPolicyStorePlugin plugin : this.sentryPlugins) {
                plugin.onAlterSentryRoleGrantPrivilege(request.getRoleName(), request.getPrivileges(), privilegesUpdateMap);
            }
            if (!privilegesUpdateMap.isEmpty()) {
                this.sentryStore.alterSentryRoleGrantPrivileges(request.getRoleName(), request.getPrivileges(), privilegesUpdateMap);
            } else {
                this.sentryStore.alterSentryRoleGrantPrivileges(request.getRoleName(), request.getPrivileges());
            }
            GrantPrivilegeRequestValidator.validate((TAlterSentryRoleGrantPrivilegeRequest)request);
            response.setStatus(Status.OK());
            response.setPrivileges(request.getPrivileges());
            if (response.isSetPrivileges() && response.getPrivileges().size() == 1) {
                response.setPrivilege((TSentryPrivilege)response.getPrivileges().iterator().next());
            }
            this.notificationHandlerInvoker.alter_sentry_role_grant_privilege(request, response);
        }
        catch (SentryNoSuchObjectException e) {
            String msg = "Role: " + request.getRoleName() + " doesn't exist";
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.NoSuchObject((String)msg, (Throwable)e));
        }
        catch (SentryInvalidInputException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.InvalidInput((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryGroupNotFoundException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        finally {
            timerContext.stop();
        }
        this.audit.onGrantRolePrivilege(request, response);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TAlterSentryRoleRevokePrivilegeResponse alter_sentry_role_revoke_privilege(TAlterSentryRoleRevokePrivilegeRequest request) throws TException {
        Timer.Context timerContext = this.sentryMetrics.revokeTimer.time();
        TAlterSentryRoleRevokePrivilegeResponse response = new TAlterSentryRoleRevokePrivilegeResponse();
        try {
            SentryPolicyStoreProcessor.validateClientVersion(request.getProtocol_version());
            if (!(request.isSetPrivileges() ^ request.isSetPrivilege())) {
                throw new SentryUserException("SENTRY API version is not right!");
            }
            if (request.isSetPrivilege()) {
                request.setPrivileges((Set)Sets.newHashSet((Object[])new TSentryPrivilege[]{request.getPrivilege()}));
            }
            this.checkGrantOptionPrivileges(request.getRequestorUserName(), request.getPrivileges());
            Preconditions.checkState((this.sentryPlugins.size() <= 1 ? 1 : 0) != 0);
            HashMap<TSentryPrivilege, Updateable.Update> privilegesUpdateMap = new HashMap<TSentryPrivilege, Updateable.Update>();
            for (SentryPolicyStorePlugin plugin : this.sentryPlugins) {
                plugin.onAlterSentryRoleRevokePrivilege(request.getRoleName(), request.getPrivileges(), privilegesUpdateMap);
            }
            if (!privilegesUpdateMap.isEmpty()) {
                this.sentryStore.alterSentryRoleRevokePrivileges(request.getRoleName(), request.getPrivileges(), privilegesUpdateMap);
            } else {
                this.sentryStore.alterSentryRoleRevokePrivileges(request.getRoleName(), request.getPrivileges());
            }
            RevokePrivilegeRequestValidator.validate((TAlterSentryRoleRevokePrivilegeRequest)request);
            response.setStatus(Status.OK());
            this.notificationHandlerInvoker.alter_sentry_role_revoke_privilege(request, response);
        }
        catch (SentryNoSuchObjectException e) {
            StringBuilder msg = new StringBuilder();
            if (request.getPrivileges().size() > 0) {
                for (TSentryPrivilege privilege : request.getPrivileges()) {
                    msg.append("Privilege: [server=");
                    msg.append(privilege.getServerName());
                    msg.append(",db=");
                    msg.append(privilege.getDbName());
                    msg.append(",table=");
                    msg.append(privilege.getTableName());
                    msg.append(",URI=");
                    msg.append(privilege.getURI());
                    msg.append(",action=");
                    msg.append(privilege.getAction());
                    msg.append("] ");
                }
                msg.append("doesn't exist.");
            }
            LOGGER.error((Object)msg.toString(), (Throwable)e);
            response.setStatus(Status.NoSuchObject((String)msg.toString(), (Throwable)e));
        }
        catch (SentryInvalidInputException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.InvalidInput((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryGroupNotFoundException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        finally {
            timerContext.stop();
        }
        this.audit.onRevokeRolePrivilege(request, response);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TDropSentryRoleResponse drop_sentry_role(TDropSentryRoleRequest request) throws TException {
        Timer.Context timerContext = this.sentryMetrics.dropRoleTimer.time();
        TDropSentryRoleResponse response = new TDropSentryRoleResponse();
        try {
            SentryPolicyStoreProcessor.validateClientVersion(request.getProtocol_version());
            this.authorize(request.getRequestorUserName(), this.getRequestorGroups(request.getRequestorUserName()));
            Preconditions.checkState((this.sentryPlugins.size() <= 1 ? 1 : 0) != 0);
            Updateable.Update update = null;
            for (SentryPolicyStorePlugin plugin : this.sentryPlugins) {
                update = plugin.onDropSentryRole(request);
            }
            if (update != null) {
                this.sentryStore.dropSentryRole(request.getRoleName(), update);
            } else {
                this.sentryStore.dropSentryRole(request.getRoleName());
            }
            response.setStatus(Status.OK());
            this.notificationHandlerInvoker.drop_sentry_role(request, response);
        }
        catch (SentryNoSuchObjectException e) {
            String msg = "Role :" + request + " doesn't exist";
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.NoSuchObject((String)msg, (Throwable)e));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryGroupNotFoundException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        finally {
            timerContext.stop();
        }
        this.audit.onDropRole(request, response);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TAlterSentryRoleAddGroupsResponse alter_sentry_role_add_groups(TAlterSentryRoleAddGroupsRequest request) throws TException {
        Timer.Context timerContext = this.sentryMetrics.grantRoleTimer.time();
        TAlterSentryRoleAddGroupsResponse response = new TAlterSentryRoleAddGroupsResponse();
        try {
            SentryPolicyStoreProcessor.validateClientVersion(request.getProtocol_version());
            this.authorize(request.getRequestorUserName(), this.getRequestorGroups(request.getRequestorUserName()));
            Preconditions.checkState((this.sentryPlugins.size() <= 1 ? 1 : 0) != 0);
            Updateable.Update update = null;
            for (SentryPolicyStorePlugin plugin : this.sentryPlugins) {
                update = plugin.onAlterSentryRoleAddGroups(request);
            }
            if (update != null) {
                this.sentryStore.alterSentryRoleAddGroups(request.getRequestorUserName(), request.getRoleName(), request.getGroups(), update);
            } else {
                this.sentryStore.alterSentryRoleAddGroups(request.getRequestorUserName(), request.getRoleName(), request.getGroups());
            }
            response.setStatus(Status.OK());
            this.notificationHandlerInvoker.alter_sentry_role_add_groups(request, response);
        }
        catch (SentryNoSuchObjectException e) {
            String msg = "Role: " + request + " doesn't exist";
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.NoSuchObject((String)msg, (Throwable)e));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryGroupNotFoundException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        finally {
            timerContext.stop();
        }
        this.audit.onGrantRoleToGroup(request, response);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TAlterSentryRoleAddUsersResponse alter_sentry_role_add_users(TAlterSentryRoleAddUsersRequest request) throws TException {
        Timer.Context timerContext = this.sentryMetrics.grantRoleTimer.time();
        TAlterSentryRoleAddUsersResponse response = new TAlterSentryRoleAddUsersResponse();
        try {
            SentryPolicyStoreProcessor.validateClientVersion(request.getProtocol_version());
            this.authorize(request.getRequestorUserName(), this.getRequestorGroups(request.getRequestorUserName()));
            this.sentryStore.alterSentryRoleAddUsers(request.getRoleName(), request.getUsers());
            response.setStatus(Status.OK());
            this.notificationHandlerInvoker.alter_sentry_role_add_users(request, response);
        }
        catch (SentryNoSuchObjectException e) {
            String msg = "Role: " + request + " does not exist.";
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.NoSuchObject((String)msg, (Throwable)e));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryGroupNotFoundException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        finally {
            timerContext.stop();
        }
        this.audit.onGrantRoleToUser(request, response);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TAlterSentryRoleDeleteUsersResponse alter_sentry_role_delete_users(TAlterSentryRoleDeleteUsersRequest request) throws TException {
        Timer.Context timerContext = this.sentryMetrics.grantRoleTimer.time();
        TAlterSentryRoleDeleteUsersResponse response = new TAlterSentryRoleDeleteUsersResponse();
        try {
            SentryPolicyStoreProcessor.validateClientVersion(request.getProtocol_version());
            this.authorize(request.getRequestorUserName(), this.getRequestorGroups(request.getRequestorUserName()));
            this.sentryStore.alterSentryRoleDeleteUsers(request.getRoleName(), request.getUsers());
            response.setStatus(Status.OK());
            this.notificationHandlerInvoker.alter_sentry_role_delete_users(request, response);
        }
        catch (SentryNoSuchObjectException e) {
            String msg = "Role: " + request + " does not exist.";
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.NoSuchObject((String)msg, (Throwable)e));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryGroupNotFoundException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        finally {
            timerContext.stop();
        }
        this.audit.onRevokeRoleFromUser(request, response);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TAlterSentryRoleDeleteGroupsResponse alter_sentry_role_delete_groups(TAlterSentryRoleDeleteGroupsRequest request) throws TException {
        Timer.Context timerContext = this.sentryMetrics.revokeRoleTimer.time();
        TAlterSentryRoleDeleteGroupsResponse response = new TAlterSentryRoleDeleteGroupsResponse();
        try {
            SentryPolicyStoreProcessor.validateClientVersion(request.getProtocol_version());
            this.authorize(request.getRequestorUserName(), this.getRequestorGroups(request.getRequestorUserName()));
            Preconditions.checkState((this.sentryPlugins.size() <= 1 ? 1 : 0) != 0);
            Updateable.Update update = null;
            for (SentryPolicyStorePlugin plugin : this.sentryPlugins) {
                update = plugin.onAlterSentryRoleDeleteGroups(request);
            }
            if (update != null) {
                this.sentryStore.alterSentryRoleDeleteGroups(request.getRoleName(), request.getGroups(), update);
            } else {
                this.sentryStore.alterSentryRoleDeleteGroups(request.getRoleName(), request.getGroups());
            }
            response.setStatus(Status.OK());
            this.notificationHandlerInvoker.alter_sentry_role_delete_groups(request, response);
        }
        catch (SentryNoSuchObjectException e) {
            String msg = "Role: " + request + " does not exist.";
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.NoSuchObject((String)msg, (Throwable)e));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryGroupNotFoundException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            String msg = "Unknown error adding groups to role: " + request;
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        finally {
            timerContext.stop();
        }
        this.audit.onRevokeRoleFromGroup(request, response);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TListSentryRolesResponse list_sentry_roles_by_group(TListSentryRolesRequest request) throws TException {
        Timer.Context timerContext = this.sentryMetrics.listRolesByGroupTimer.time();
        TListSentryRolesResponse response = new TListSentryRolesResponse();
        Set<Object> roleSet = new HashSet();
        String subject = request.getRequestorUserName();
        boolean checkAllGroups = false;
        try {
            SentryPolicyStoreProcessor.validateClientVersion(request.getProtocol_version());
            Set<String> groups = this.getRequestorGroups(subject);
            if ("*".equalsIgnoreCase(request.getGroupName())) {
                checkAllGroups = true;
            } else {
                boolean admin = this.inAdminGroups(groups);
                if (!(admin || request.getGroupName() != null && groups.contains(request.getGroupName()))) {
                    throw new SentryAccessDeniedException("Access denied to " + subject);
                }
                groups.clear();
                groups.add(request.getGroupName());
            }
            roleSet = this.sentryStore.getTSentryRolesByGroupName(groups, checkAllGroups);
            response.setRoles(roleSet);
            response.setStatus(Status.OK());
        }
        catch (SentryNoSuchObjectException e) {
            response.setRoles(roleSet);
            String msg = "Request: " + request + " couldn't be completed, message: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.NoSuchObject((String)msg, (Throwable)e));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryGroupNotFoundException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        finally {
            timerContext.stop();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TListSentryRolesResponse list_sentry_roles_by_user(TListSentryRolesForUserRequest request) throws TException {
        String msg;
        Timer.Context timerContext = this.sentryMetrics.listRolesByGroupTimer.time();
        TListSentryRolesResponse response = new TListSentryRolesResponse();
        Set<Object> roleSet = new HashSet();
        String requestor = request.getRequestorUserName();
        String userName = request.getUserName();
        boolean checkAllGroups = false;
        try {
            Set<String> requestorGroups;
            SentryPolicyStoreProcessor.validateClientVersion(request.getProtocol_version());
            if (StringUtils.isEmpty((String)userName)) {
                throw new SentryAccessDeniedException("The user name can't be empty.");
            }
            try {
                requestorGroups = this.getRequestorGroups(requestor);
            }
            catch (SentryGroupNotFoundException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
                TListSentryRolesResponse tListSentryRolesResponse = response;
                timerContext.stop();
                return tListSentryRolesResponse;
            }
            try {
                Set<String> userGroups = this.getRequestorGroups(userName);
            }
            catch (SentryGroupNotFoundException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                String msg2 = "Groups for user " + userName + " do not exist: " + e.getMessage();
                response.setStatus(Status.AccessDenied((String)msg2, (Throwable)e));
                TListSentryRolesResponse tListSentryRolesResponse = response;
                timerContext.stop();
                return tListSentryRolesResponse;
            }
            boolean isAdmin = this.inAdminGroups(requestorGroups);
            if (!isAdmin && !userName.equals(requestor)) {
                throw new SentryAccessDeniedException("Access denied to list the roles for " + userName);
            }
            roleSet = this.sentryStore.getTSentryRolesByUserNames(Sets.newHashSet((Object[])new String[]{userName}));
            response.setRoles(roleSet);
            response.setStatus(Status.OK());
        }
        catch (SentryNoSuchObjectException e) {
            response.setRoles(roleSet);
            msg = "Role: " + request + " couldn't be retrieved.";
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.NoSuchObject((String)msg, (Throwable)e));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        finally {
            timerContext.stop();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TListSentryPrivilegesResponse list_sentry_privileges_by_role(TListSentryPrivilegesRequest request) throws TException {
        Timer.Context timerContext = this.sentryMetrics.listPrivilegesByRoleTimer.time();
        TListSentryPrivilegesResponse response = new TListSentryPrivilegesResponse();
        Set<Object> privilegeSet = new HashSet();
        String subject = request.getRequestorUserName();
        String roleName = request.getPrincipalName() != null ? request.getPrincipalName() : request.getRoleName();
        try {
            Set<String> roleNamesForGroups;
            SentryPolicyStoreProcessor.validateClientVersion(request.getProtocol_version());
            Set<String> groups = this.getRequestorGroups(subject);
            Boolean admin = this.inAdminGroups(groups);
            if (!admin.booleanValue() && !(roleNamesForGroups = SentryPolicyStoreProcessor.toTrimedLower(this.sentryStore.getRoleNamesForGroups(groups))).contains(roleName.trim().toLowerCase())) {
                throw new SentryAccessDeniedException("Access denied to " + subject);
            }
            if (request.isSetAuthorizableHierarchy()) {
                TSentryAuthorizable authorizableHierarchy = request.getAuthorizableHierarchy();
                privilegeSet = this.sentryStore.getTSentryPrivileges(ServiceConstants.SentryPrincipalType.ROLE, Sets.newHashSet((Object[])new String[]{roleName}), authorizableHierarchy);
            } else {
                privilegeSet = this.sentryStore.getAllTSentryPrivilegesByRoleName(roleName);
            }
            response.setPrivileges(privilegeSet);
            response.setStatus(Status.OK());
        }
        catch (SentryNoSuchObjectException e) {
            response.setPrivileges(privilegeSet);
            String msg = "Privilege: " + request + " couldn't be retrieved.";
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.NoSuchObject((String)msg, (Throwable)e));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryGroupNotFoundException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        finally {
            timerContext.stop();
        }
        return response;
    }

    private TSentryResponseStatus checkRequiredParameter(Object param, String message) {
        if (param == null) {
            LOGGER.warn((Object)message);
            return Status.InvalidInput((String)message, (Throwable)new SentryInvalidInputException(message));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TListSentryPrivilegesResponse list_sentry_privileges_by_user(TListSentryPrivilegesRequest request) throws TException {
        Timer.Context timerContext = this.sentryMetrics.listPrivilegesByUserTimer.time();
        TListSentryPrivilegesResponse response = new TListSentryPrivilegesResponse();
        Set<Object> privilegeSet = new HashSet();
        String subject = request.getRequestorUserName();
        TSentryResponseStatus status = this.checkRequiredParameter(request.getPrincipalName(), "principalName parameter must not be null");
        if (status != null) {
            response.setStatus(status);
            return response;
        }
        String userName = request.getPrincipalName().trim();
        try {
            SentryPolicyStoreProcessor.validateClientVersion(request.getProtocol_version());
            Set<String> groups = this.getRequestorGroups(subject);
            Boolean admin = this.inAdminGroups(groups);
            if (!admin.booleanValue() && !userName.equalsIgnoreCase(subject)) {
                throw new SentryAccessDeniedException("Access denied to " + subject);
            }
            if (request.isSetAuthorizableHierarchy()) {
                TSentryAuthorizable authorizableHierarchy = request.getAuthorizableHierarchy();
                privilegeSet = this.sentryStore.getTSentryPrivileges(ServiceConstants.SentryPrincipalType.USER, Sets.newHashSet((Object[])new String[]{userName}), authorizableHierarchy);
            } else {
                privilegeSet = this.sentryStore.getAllTSentryPrivilegesByUserName(userName);
            }
            response.setPrivileges(privilegeSet);
            response.setStatus(Status.OK());
        }
        catch (SentryNoSuchObjectException e) {
            response.setPrivileges(privilegeSet);
            String msg = "Privilege: " + request + " couldn't be retrieved.";
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.NoSuchObject((String)msg, (Throwable)e));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryGroupNotFoundException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        finally {
            timerContext.stop();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TListSentryPrivilegesResponse list_sentry_privileges_by_user_and_itsgroups(TListSentryPrivilegesRequest request) throws TException {
        Timer.Context timerContext = this.sentryMetrics.listPrivilegesForUserTimer.time();
        TListSentryPrivilegesResponse response = new TListSentryPrivilegesResponse();
        TSentryResponseStatus status = this.checkRequiredParameter(request.getPrincipalName(), "principalName parameter must not be null");
        if (status != null) {
            response.setStatus(status);
            return response;
        }
        String requestor = request.getRequestorUserName();
        String principalName = request.getPrincipalName().trim();
        HashSet<TSentryPrivilege> privilegeSet = new HashSet<TSentryPrivilege>();
        try {
            SentryPolicyStoreProcessor.validateClientVersion(request.getProtocol_version());
            Set<String> requestorGroups = this.getRequestorGroups(requestor);
            Boolean admin = this.inAdminGroups(requestorGroups);
            if (!admin.booleanValue() && !principalName.equalsIgnoreCase(requestor)) {
                throw new SentryAccessDeniedException("Access denied to " + requestor);
            }
            Set<String> principalGroups = principalName.equals(requestor) ? requestorGroups : this.getRequestorGroups(principalName);
            HashSet<String> principalUsers = new HashSet<String>();
            principalUsers.add(principalName);
            privilegeSet.addAll(this.sentryStore.listSentryPrivilegesByUsersAndGroups(principalGroups, principalUsers, new TSentryActiveRoleSet(true, null), request.getAuthorizableHierarchy()));
            response.setPrivileges(privilegeSet);
            response.setStatus(Status.OK());
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryInvalidInputException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.InvalidInput((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryUserException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        finally {
            timerContext.stop();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TListSentryPrivilegesForProviderResponse list_sentry_privileges_for_provider(TListSentryPrivilegesForProviderRequest request) throws TException {
        Timer.Context timerContext = this.sentryMetrics.listPrivilegesForProviderTimer.time();
        TListSentryPrivilegesForProviderResponse response = new TListSentryPrivilegesForProviderResponse();
        response.setPrivileges(new HashSet());
        try {
            SentryPolicyStoreProcessor.validateClientVersion(request.getProtocol_version());
            Set<String> privilegesForProvider = this.sentryStore.listSentryPrivilegesForProvider(request.getGroups(), request.getUsers(), request.getRoleSet(), request.getAuthorizableHierarchy());
            response.setPrivileges(privilegesForProvider);
            if (privilegesForProvider == null || privilegesForProvider.size() == 0 && request.getAuthorizableHierarchy() != null && this.sentryStore.hasAnyServerPrivileges(request.getGroups(), request.getUsers(), request.getRoleSet(), request.getAuthorizableHierarchy().getServer())) {
                HashSet serverPriv = Sets.newHashSet((Object[])new String[]{"server=+"});
                response.setPrivileges((Set)serverPriv);
            }
            response.setStatus(Status.OK());
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        finally {
            timerContext.stop();
        }
        return response;
    }

    private Set<String> getRequestorGroups(String userName) throws SentryUserException {
        return SentryPolicyStoreProcessor.getGroupsFromUserName(this.conf, userName);
    }

    public static Set<String> getGroupsFromUserName(Configuration conf, String userName) throws SentryUserException {
        GroupMappingService groupMappingService;
        String groupMapping = conf.get("sentry.store.group.mapping", "org.apache.sentry.provider.common.HadoopGroupMappingService");
        String authResoruce = conf.get("sentry.store.group.mapping.resource");
        try {
            Constructor<?> constrctor = Class.forName(groupMapping).getDeclaredConstructor(Configuration.class, String.class);
            constrctor.setAccessible(true);
            groupMappingService = (GroupMappingService)constrctor.newInstance(conf, authResoruce);
        }
        catch (NoSuchMethodException e) {
            throw new SentryUserException("Unable to instantiate group mapping", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new SentryUserException("Unable to instantiate group mapping", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new SentryUserException("Unable to instantiate group mapping", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new SentryUserException("Unable to instantiate group mapping", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SentryUserException("Unable to instantiate group mapping", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new SentryUserException("Unable to instantiate group mapping", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new SentryUserException("Unable to instantiate group mapping", (Throwable)e);
        }
        return groupMappingService.getGroups(userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TDropPrivilegesResponse drop_sentry_privilege(TDropPrivilegesRequest request) throws TException {
        Timer.Context timerContext = this.sentryMetrics.dropPrivilegeTimer.time();
        TDropPrivilegesResponse response = new TDropPrivilegesResponse();
        try {
            SentryPolicyStoreProcessor.validateClientVersion(request.getProtocol_version());
            this.authorize(request.getRequestorUserName(), (Set<String>)this.adminGroups);
            Preconditions.checkState((this.sentryPlugins.size() <= 1 ? 1 : 0) != 0);
            Updateable.Update update = null;
            for (SentryPolicyStorePlugin plugin : this.sentryPlugins) {
                update = plugin.onDropSentryPrivilege(request);
            }
            if (update != null) {
                this.sentryStore.dropPrivilege(request.getAuthorizable(), update);
            } else {
                this.sentryStore.dropPrivilege(request.getAuthorizable());
            }
            response.setStatus(Status.OK());
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryGroupNotFoundException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        finally {
            timerContext.stop();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRenamePrivilegesResponse rename_sentry_privilege(TRenamePrivilegesRequest request) throws TException {
        TRenamePrivilegesResponse response = new TRenamePrivilegesResponse();
        try (Timer.Context timerContext = this.sentryMetrics.renamePrivilegeTimer.time();){
            SentryPolicyStoreProcessor.validateClientVersion(request.getProtocol_version());
            this.authorize(request.getRequestorUserName(), (Set<String>)this.adminGroups);
            Preconditions.checkState((this.sentryPlugins.size() <= 1 ? 1 : 0) != 0);
            Updateable.Update update = null;
            for (SentryPolicyStorePlugin plugin : this.sentryPlugins) {
                update = plugin.onRenameSentryPrivilege(request);
            }
            if (update != null) {
                this.sentryStore.renamePrivilege(request.getOldAuthorizable(), request.getNewAuthorizable(), update);
            } else {
                this.sentryStore.renamePrivilege(request.getOldAuthorizable(), request.getNewAuthorizable());
            }
            response.setStatus(Status.OK());
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TListSentryPrivilegesByAuthResponse list_sentry_privileges_by_authorizable(TListSentryPrivilegesByAuthRequest request) throws TException {
        Timer.Context timerContext = this.sentryMetrics.listPrivilegesByAuthorizableTimer.time();
        TListSentryPrivilegesByAuthResponse response = new TListSentryPrivilegesByAuthResponse();
        HashMap authRoleMap = Maps.newHashMap();
        HashMap authUserMap = Maps.newHashMap();
        String subject = request.getRequestorUserName();
        Set<String> requestedGroups = request.getGroups();
        Set requestedUsers = request.getUsers();
        TSentryActiveRoleSet requestedRoleSet = request.getRoleSet();
        try {
            SentryPolicyStoreProcessor.validateClientVersion(request.getProtocol_version());
            Set<String> memberGroups = this.getRequestorGroups(subject);
            if (!this.inAdminGroups(memberGroups)) {
                if (requestedGroups != null && !requestedGroups.isEmpty()) {
                    for (String string : requestedGroups) {
                        if (memberGroups.contains(string)) continue;
                        throw new SentryAccessDeniedException("Access denied to " + subject);
                    }
                } else {
                    requestedGroups = memberGroups;
                }
                if (requestedRoleSet != null && !requestedRoleSet.isAll()) {
                    Set<String> roles = SentryPolicyStoreProcessor.toTrimedLower(this.sentryStore.getRoleNamesForGroups(memberGroups));
                    for (String role : SentryPolicyStoreProcessor.toTrimedLower(requestedRoleSet.getRoles())) {
                        if (roles.contains(role)) continue;
                        throw new SentryAccessDeniedException("Access denied to " + subject);
                    }
                }
                if (requestedUsers != null && !requestedUsers.isEmpty()) {
                    for (String string : requestedUsers) {
                        if (string.equalsIgnoreCase(subject)) continue;
                        throw new SentryAccessDeniedException("Access denied to " + subject);
                    }
                }
            }
            for (TSentryAuthorizable tSentryAuthorizable : request.getAuthorizableSet()) {
                authRoleMap.put(tSentryAuthorizable, this.sentryStore.listSentryPrivilegesByAuthorizable(requestedGroups, request.getRoleSet(), tSentryAuthorizable, this.inAdminGroups(memberGroups)));
                authUserMap.put(tSentryAuthorizable, this.sentryStore.listSentryPrivilegesByAuthorizableForUser(requestedUsers, tSentryAuthorizable, this.inAdminGroups(memberGroups)));
            }
            response.setPrivilegesMapByAuth((Map)authRoleMap);
            response.setPrivilegesMapByAuthForUsers((Map)authUserMap);
            response.setStatus(Status.OK());
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryGroupNotFoundException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        finally {
            timerContext.stop();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TListSentryPrivilegesByAuthUserResponse list_sentry_privileges_by_authorizable_and_user(TListSentryPrivilegesByAuthUserRequest request) throws TException {
        Timer.Context timerContext = this.sentryMetrics.listPrivilegesByAuthorizableAndUserTimer.time();
        TListSentryPrivilegesByAuthUserResponse response = new TListSentryPrivilegesByAuthUserResponse();
        String requestor = request.getRequestorUserName();
        String principalName = request.getUser();
        TSentryResponseStatus status = this.checkRequiredParameter(requestor, "requestor parameter must not be null");
        TSentryResponseStatus tSentryResponseStatus = status = status != null ? status : this.checkRequiredParameter(principalName, "user parameter must not be null");
        if (status != null) {
            response.setStatus(status);
            return response;
        }
        principalName = principalName.trim();
        HashMap authMap = Maps.newHashMap();
        try {
            SentryPolicyStoreProcessor.validateClientVersion(request.getProtocol_version());
            Set<String> requestorGroups = this.getRequestorGroups(requestor);
            Boolean admin = this.inAdminGroups(requestorGroups);
            if (!admin.booleanValue() && !principalName.equalsIgnoreCase(requestor)) {
                throw new SentryAccessDeniedException("Access denied to " + requestor);
            }
            Set<String> principalGroups = principalName.equals(requestor) ? requestorGroups : this.getRequestorGroups(principalName);
            HashSet<String> principalUsers = new HashSet<String>();
            principalUsers.add(principalName);
            for (TSentryAuthorizable authorizable : request.getAuthorizableSet()) {
                TSentryPrivilegeMap userMap;
                HashSet privileges = new HashSet();
                TSentryPrivilegeMap groupMap = this.sentryStore.listSentryPrivilegesByAuthorizable(principalGroups, null, authorizable, false);
                if (groupMap.getPrivilegeMap() != null) {
                    for (Set groupPrivilege : groupMap.getPrivilegeMap().values()) {
                        privileges.addAll(groupPrivilege);
                    }
                }
                if ((userMap = this.sentryStore.listSentryPrivilegesByAuthorizableForUser(principalUsers, authorizable, false)).getPrivilegeMap() != null) {
                    for (Set userPrivilege : userMap.getPrivilegeMap().values()) {
                        privileges.addAll(userPrivilege);
                    }
                }
                authMap.put(authorizable, privileges);
            }
            response.setPrivilegesMapByAuth((Map)authMap);
            response.setStatus(Status.OK());
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryGroupNotFoundException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryInvalidInputException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.InvalidInput((String)e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        finally {
            timerContext.stop();
        }
        return response;
    }

    public TSentryConfigValueResponse get_sentry_config_value(TSentryConfigValueRequest request) throws TException {
        String requirePattern = "^sentry\\..*";
        String excludePattern = ".*keytab.*|.*\\.jdbc\\..*|.*password.*";
        TSentryConfigValueResponse response = new TSentryConfigValueResponse();
        String attr = request.getPropertyName();
        try {
            SentryPolicyStoreProcessor.validateClientVersion(request.getProtocol_version());
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e));
        }
        if (!Pattern.matches("^sentry\\..*", attr) || Pattern.matches(".*keytab.*|.*\\.jdbc\\..*|.*password.*", attr)) {
            String msg = "Attempted access of the configuration property " + attr + " was denied";
            LOGGER.error((Object)msg);
            response.setStatus(Status.AccessDenied((String)msg, (Throwable)new SentryAccessDeniedException(msg)));
            return response;
        }
        response.setValue(this.conf.get(attr, request.getDefaultValue()));
        response.setStatus(Status.OK());
        return response;
    }

    @VisibleForTesting
    static void validateClientVersion(int protocolVersion) throws SentryThriftAPIMismatchException {
        if (2 != protocolVersion) {
            String msg = "Sentry thrift API protocol version mismatch: Client thrift version is: " + protocolVersion + " , server thrift verion is " + 2;
            throw new SentryThriftAPIMismatchException(msg);
        }
    }

    public TSentryExportMappingDataResponse export_sentry_mapping_data(TSentryExportMappingDataRequest request) throws TException {
        TSentryExportMappingDataResponse response = new TSentryExportMappingDataResponse();
        try {
            String requestor = request.getRequestorUserName();
            Set<String> memberGroups = this.getRequestorGroups(requestor);
            String objectPath = request.getObjectPath();
            String databaseName = null;
            String tableName = null;
            Map objectMap = SentryServiceUtil.parseObjectPath((String)objectPath);
            databaseName = (String)objectMap.get("db");
            tableName = (String)objectMap.get("table");
            if (!this.inAdminGroups(memberGroups)) {
                throw new SentryAccessDeniedException("Access denied to " + requestor + " for export the metadata of sentry.");
            }
            TSentryMappingData tSentryMappingData = new TSentryMappingData();
            Map<String, Set<TSentryPrivilege>> rolePrivileges = this.sentryStore.getRoleNameTPrivilegesMap(databaseName, tableName);
            tSentryMappingData.setRolePrivilegesMap(rolePrivileges);
            Set<String> roleNames = rolePrivileges.keySet();
            if (databaseName == null && tableName == null) {
                roleNames = null;
            }
            List<Map<String, Set<String>>> mapList = this.sentryStore.getGroupUserRoleMapList(roleNames);
            tSentryMappingData.setGroupRolesMap(mapList.get(0));
            tSentryMappingData.setUserRolesMap(mapList.get(1));
            response.setMappingData(tSentryMappingData);
            response.setStatus(Status.OK());
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryGroupNotFoundException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setMappingData(new TSentryMappingData());
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        return response;
    }

    public TSentryImportMappingDataResponse import_sentry_mapping_data(TSentryImportMappingDataRequest request) throws TException {
        TSentryImportMappingDataResponse response = new TSentryImportMappingDataResponse();
        try {
            String requestor = request.getRequestorUserName();
            Set<String> memberGroups = this.getRequestorGroups(requestor);
            if (!this.inAdminGroups(memberGroups)) {
                throw new SentryAccessDeniedException("Access denied to " + requestor + " for import the metadata of sentry.");
            }
            this.sentryStore.importSentryMetaData(request.getMappingData(), request.isOverwriteRole());
            response.setStatus(Status.OK());
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryGroupNotFoundException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryInvalidInputException e) {
            String msg = "Invalid input privilege object";
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.InvalidInput((String)msg, (Throwable)e));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        return response;
    }

    public TSentrySyncIDResponse sentry_sync_notifications(TSentrySyncIDRequest request) throws TException {
        TSentrySyncIDResponse response = new TSentrySyncIDResponse();
        try (Timer.Context timerContext = this.hmsWaitTimer.time();){
            response.setId(this.sentryStore.getCounterWait().waitFor(request.getId()));
            response.setStatus(Status.OK());
        }
        catch (InterruptedException e) {
            String msg = String.format("wait request for id %d is interrupted", request.getId());
            LOGGER.error((Object)msg, (Throwable)e);
            response.setId(0L);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException e) {
            String msg = String.format("timed out wait request for id %d", request.getId());
            LOGGER.warn((Object)msg, (Throwable)e);
            response.setId(0L);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        return response;
    }

    public TSentryHmsEventNotificationResponse sentry_notify_hms_event(TSentryHmsEventNotification request) throws TException {
        TSentryHmsEventNotificationResponse response = new TSentryHmsEventNotificationResponse();
        EventMessage.EventType eventType = EventMessage.EventType.valueOf((String)request.getEventType());
        try (Timer.Context timerContext = this.sentryMetrics.notificationProcessTimer.time();){
            switch (eventType) {
                case CREATE_DATABASE: 
                case CREATE_TABLE: {
                    if (request.getId() > 0L) {
                        response.setId(this.syncEventId(request.getId()));
                        break;
                    }
                    response.setId(0L);
                    break;
                }
                case DROP_DATABASE: 
                case DROP_TABLE: {
                    if (request.getId() > 0L) {
                        response.setId(this.syncEventId(request.getId()));
                        break;
                    }
                    response.setId(0L);
                    break;
                }
                case ALTER_TABLE: 
                case ALTER_DATABASE: {
                    if (request.getId() > 0L) {
                        response.setId(this.syncEventId(request.getId()));
                        break;
                    }
                    response.setId(0L);
                    break;
                }
                default: {
                    LOGGER.info((Object)("Processing HMS Event of Type: " + eventType.toString() + " skipped"));
                }
            }
            response.setStatus(Status.OK());
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        return response;
    }

    public TSentryPrivilegesResponse list_roles_privileges(TSentryPrivilegesRequest request) throws TException {
        TSentryPrivilegesResponse response = new TSentryPrivilegesResponse();
        String requestor = request.getRequestorUserName();
        try (Timer.Context timerContext = this.sentryMetrics.listRolesPrivilegesTimer.time();){
            SentryPolicyStoreProcessor.validateClientVersion(request.getProtocol_version());
            this.authorize(requestor, this.getRequestorGroups(requestor));
            response.setPrivilegesMap(this.sentryStore.getAllRolesPrivileges());
            response.setStatus(Status.OK());
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryUserException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            String msg = "Could not read roles and privileges from the database: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        return response;
    }

    public TSentryPrivilegesResponse list_users_privileges(TSentryPrivilegesRequest request) throws TException {
        TSentryPrivilegesResponse response = new TSentryPrivilegesResponse();
        String requestor = request.getRequestorUserName();
        try (Timer.Context timerContext = this.sentryMetrics.listUsersPrivilegesTimer.time();){
            SentryPolicyStoreProcessor.validateClientVersion(request.getProtocol_version());
            this.authorize(requestor, this.getRequestorGroups(requestor));
            response.setPrivilegesMap(this.sentryStore.getAllUsersPrivileges());
            response.setStatus(Status.OK());
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryUserException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            String msg = "Could not read users and privileges from the database: " + e.getMessage();
            LOGGER.error((Object)msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        return response;
    }

    long syncEventId(long eventId) {
        try {
            if (!SentryStateBank.isEnabled("FullUpdateInitializer", FullUpdateInitializerState.FULL_SNAPSHOT_INPROGRESS)) {
                return this.sentryStore.getCounterWait().waitFor(eventId);
            }
            LOGGER.info((Object)"HMS event synchronization is disabled temporarily as sentry is in the process of fetching full snapshot. No action needed");
            return eventId;
        }
        catch (InterruptedException e) {
            String msg = String.format("wait request for id %d is interrupted", eventId);
            LOGGER.error((Object)msg, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException e) {
            String msg = String.format("timed out wait request for id %d", eventId);
            LOGGER.warn((Object)msg, (Throwable)e);
        }
        return 0L;
    }
}

