/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.api.service.thrift;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.api.common.SentryServiceUtil;
import org.apache.sentry.api.service.thrift.SentryMetricsServletContextListener;
import org.apache.sentry.api.service.thrift.SentryPolicyStoreProcessor;
import org.apache.sentry.provider.db.service.persistent.SentryStore;
import org.apache.sentry.provider.db.service.persistent.SentryStoreInterface;
import org.apache.sentry.service.thrift.FullUpdateInitializer;
import org.apache.sentry.service.thrift.SentryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sentry.com.codahale.metrics.ConsoleReporter;
import sentry.com.codahale.metrics.Counter;
import sentry.com.codahale.metrics.Gauge;
import sentry.com.codahale.metrics.Histogram;
import sentry.com.codahale.metrics.JmxReporter;
import sentry.com.codahale.metrics.Metric;
import sentry.com.codahale.metrics.MetricRegistry;
import sentry.com.codahale.metrics.MetricSet;
import sentry.com.codahale.metrics.Slf4jReporter;
import sentry.com.codahale.metrics.Timer;
import sentry.com.codahale.metrics.json.MetricsModule;
import sentry.com.codahale.metrics.jvm.BufferPoolMetricSet;
import sentry.com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import sentry.com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import sentry.com.codahale.metrics.jvm.ThreadStatesGaugeSet;

public final class SentryMetrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryMetrics.class);
    private static SentryMetrics sentryMetrics = null;
    private final AtomicBoolean reportingInitialized = new AtomicBoolean();
    private boolean gaugesAdded = false;
    private boolean sentryServiceGaugesAdded = false;
    final Timer isSentryAdminTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, "is-sentry-admin"));
    final Timer createRoleTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, "create-role"));
    final Timer dropRoleTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, "drop-role"));
    final Timer grantRoleTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, "grant-role"));
    final Timer revokeRoleTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, "revoke-role"));
    final Timer grantTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, "grant-privilege"));
    final Timer revokeTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, "revoke-privilege"));
    final Timer dropPrivilegeTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, "drop-privilege"));
    final Timer renamePrivilegeTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, "rename-privilege"));
    final Timer listRolesByGroupTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, "list-roles-by-group"));
    final Timer listPrivilegesByRoleTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, "list-privileges-by-role"));
    final Timer listPrivilegesByUserTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, "list-privileges-by-user"));
    final Timer listPrivilegesForUserTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, "list-sentry-privileges-by-user-and-itsgroups"));
    final Timer listPrivilegesForProviderTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, "list-privileges-for-provider"));
    final Timer listPrivilegesByAuthorizableTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, "list-privileges-by-authorizable"));
    final Timer listPrivilegesByAuthorizableAndUserTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, "list-privileges-by-authorizable-and-user"));
    final Timer listRolesPrivilegesTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, "list-roles-privileges"));
    final Timer listUsersPrivilegesTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, "list-users-privileges"));
    final Timer notificationProcessTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(SentryPolicyStoreProcessor.class, "process-hsm-notification"));
    public final Timer getFullHMSSnapshotTimer = SentryMetricsServletContextListener.METRIC_REGISTRY.timer(MetricRegistry.name(FullUpdateInitializer.class, "fetch-full-snapshot"));
    public final Counter databaseCount = SentryMetricsServletContextListener.METRIC_REGISTRY.counter(MetricRegistry.name(FullUpdateInitializer.class, "total", "db"));
    public final Counter tableCount = SentryMetricsServletContextListener.METRIC_REGISTRY.counter(MetricRegistry.name(FullUpdateInitializer.class, "total", "tables"));
    public final Counter partitionCount = SentryMetricsServletContextListener.METRIC_REGISTRY.counter(MetricRegistry.name(FullUpdateInitializer.class, "total", "partitions"));

    public Timer getTimer(String name) {
        return SentryMetricsServletContextListener.METRIC_REGISTRY.timer(name);
    }

    public Histogram getHistogram(String name) {
        return SentryMetricsServletContextListener.METRIC_REGISTRY.histogram(name);
    }

    public Counter getCounter(String name) {
        return SentryMetricsServletContextListener.METRIC_REGISTRY.counter(name);
    }

    private SentryMetrics() {
        this.registerMetricSet("gc", new GarbageCollectorMetricSet(), SentryMetricsServletContextListener.METRIC_REGISTRY);
        this.registerMetricSet("buffers", new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()), SentryMetricsServletContextListener.METRIC_REGISTRY);
        this.registerMetricSet("memory", new MemoryUsageGaugeSet(), SentryMetricsServletContextListener.METRIC_REGISTRY);
        this.registerMetricSet("threads", new ThreadStatesGaugeSet(), SentryMetricsServletContextListener.METRIC_REGISTRY);
    }

    public static synchronized SentryMetrics getInstance() {
        if (sentryMetrics == null) {
            sentryMetrics = new SentryMetrics();
        }
        return sentryMetrics;
    }

    void addSentryStoreGauges(SentryStoreInterface sentryStore) {
        if (!this.gaugesAdded) {
            this.addGauge(SentryStore.class, "role_count", sentryStore.getRoleCountGauge());
            this.addGauge(SentryStore.class, "privilege_count", sentryStore.getPrivilegeCountGauge());
            this.addGauge(SentryStore.class, "gm_privilege_count", sentryStore.getGenericModelPrivilegeCountGauge());
            this.addGauge(SentryStore.class, "group_count", sentryStore.getGroupCountGauge());
            this.addGauge(SentryStore.class, "hms.waiters", sentryStore.getHMSWaitersCountGauge());
            this.addGauge(SentryStore.class, "hms.notification.id", sentryStore.getLastNotificationIdGauge());
            this.addGauge(SentryStore.class, "hms.snapshot.paths.id", sentryStore.getLastPathsSnapshotIdGauge());
            this.addGauge(SentryStore.class, "hms.perm.change.id", sentryStore.getPermChangeIdGauge());
            this.addGauge(SentryStore.class, "hms.path.change.id", sentryStore.getPathChangeIdGauge());
            this.addGauge(SentryStore.class, "hms.authz_objects_count", sentryStore.getAuthzObjectsCountGauge());
            this.addGauge(SentryStore.class, "hms.authz_paths_count", sentryStore.getAuthzPathsCountGauge());
            this.gaugesAdded = true;
        }
    }

    public void addSentryServiceGauges(SentryService sentryservice) {
        if (!this.sentryServiceGaugesAdded) {
            this.addGauge(SentryService.class, "is_active", sentryservice.getIsActiveGauge());
            this.addGauge(SentryService.class, "activated", sentryservice.getBecomeActiveCount());
            this.sentryServiceGaugesAdded = true;
        }
    }

    void initReporting(Configuration conf) {
        String reporter = conf.get("sentry.service.reporter");
        if (reporter == null || reporter.isEmpty() || this.reportingInitialized.getAndSet(true)) {
            return;
        }
        int reportInterval = conf.getInt("sentry.service.reporter.interval.sec", 300);
        HashSet<String> reporters = new HashSet<String>();
        for (String r : reporter.split(",")) {
            reporters.add(r.trim().toUpperCase());
        }
        if (reporters.isEmpty()) {
            reporters.add(Reporting.JSON.toString());
        }
        block7: for (String r : reporters) {
            switch (Reporting.valueOf(r)) {
                case CONSOLE: {
                    LOGGER.info("Enabled console metrics reporter with {} seconds interval", (Object)reportInterval);
                    ConsoleReporter consoleReporter = ConsoleReporter.forRegistry(SentryMetricsServletContextListener.METRIC_REGISTRY).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                    consoleReporter.start(reportInterval, TimeUnit.SECONDS);
                    continue block7;
                }
                case JMX: {
                    LOGGER.info("Enabled JMX metrics reporter");
                    JmxReporter jmxReporter = JmxReporter.forRegistry(SentryMetricsServletContextListener.METRIC_REGISTRY).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                    jmxReporter.start();
                    continue block7;
                }
                case LOG: {
                    LOGGER.info("Enabled Log4J metrics reporter with {} seconds interval", (Object)reportInterval);
                    Slf4jReporter logReporter = Slf4jReporter.forRegistry(SentryMetricsServletContextListener.METRIC_REGISTRY).outputTo(LOGGER).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                    logReporter.start(reportInterval, TimeUnit.SECONDS);
                    continue block7;
                }
                case JSON: {
                    LOGGER.info("Enabled JSON metrics reporter with {} seconds interval", (Object)reportInterval);
                    JsonFileReporter jsonReporter = new JsonFileReporter(conf, reportInterval, TimeUnit.SECONDS);
                    jsonReporter.start();
                    continue block7;
                }
            }
            LOGGER.warn("Invalid metrics reporter {}", (Object)reporter);
        }
    }

    private <T, V> void addGauge(Class<T> tClass, String gaugeName, Gauge<V> gauge) {
        SentryMetricsServletContextListener.METRIC_REGISTRY.register(MetricRegistry.name(tClass, gaugeName), gauge);
    }

    private void registerMetricSet(String prefix, MetricSet metricSet, MetricRegistry registry) {
        for (Map.Entry<String, Metric> entry : metricSet.getMetrics().entrySet()) {
            if (entry.getValue() instanceof MetricSet) {
                this.registerMetricSet(prefix + "." + entry.getKey(), (MetricSet)entry.getValue(), registry);
                continue;
            }
            registry.register(prefix + "." + entry.getKey(), entry.getValue());
        }
    }

    private static class JsonFileReporter
    implements AutoCloseable,
    Runnable {
        private static final FileAttribute<Set<PosixFilePermission>> FILE_ATTRS = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-r--r--"));
        private static final String JSON_REPORTER_THREAD_NAME = "json-reporter";
        private ScheduledExecutorService executor = null;
        private final ObjectMapper jsonMapper = new ObjectMapper().registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, false));
        private final Configuration conf;
        private final Path path;
        private final Path tmpDir;
        private final long interval;
        private final TimeUnit unit;

        JsonFileReporter(Configuration conf, long interval, TimeUnit unit) {
            this.conf = conf;
            String pathString = conf.get("sentry.service.reporter.file", "/tmp/sentry-metrics.json");
            this.path = Paths.get(pathString, new String[0]).toAbsolutePath();
            LOGGER.info("Reporting metrics to {}", (Object)this.path);
            this.tmpDir = this.path.getParent();
            this.interval = interval;
            this.unit = unit;
        }

        private void start() {
            this.executor = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat(JSON_REPORTER_THREAD_NAME).build());
            this.executor.scheduleAtFixedRate(this, 0L, this.interval, this.unit);
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void close() {
            if (this.executor != null) {
                SentryServiceUtil.shutdownAndAwaitTermination((ExecutorService)this.executor, (String)JSON_REPORTER_THREAD_NAME, (long)1L, (TimeUnit)TimeUnit.MINUTES, (Logger)LOGGER);
                this.executor = null;
            }
            try {
                Files.delete(this.path);
            }
            catch (IOException e) {
                LOGGER.error("Unable to delete {}", (Object)this.path, (Object)e);
            }
        }
    }

    public static enum Reporting {
        JMX,
        CONSOLE,
        LOG,
        JSON;

    }
}

