/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.api.generic.thrift;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.api.common.Status;
import org.apache.sentry.api.generic.thrift.NotificationHandler;
import org.apache.sentry.api.generic.thrift.NotificationHandlerInvoker;
import org.apache.sentry.api.generic.thrift.SentryGenericPolicyService;
import org.apache.sentry.api.generic.thrift.TAlterSentryRoleAddGroupsRequest;
import org.apache.sentry.api.generic.thrift.TAlterSentryRoleAddGroupsResponse;
import org.apache.sentry.api.generic.thrift.TAlterSentryRoleDeleteGroupsRequest;
import org.apache.sentry.api.generic.thrift.TAlterSentryRoleDeleteGroupsResponse;
import org.apache.sentry.api.generic.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.api.generic.thrift.TAlterSentryRoleGrantPrivilegeResponse;
import org.apache.sentry.api.generic.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.api.generic.thrift.TAlterSentryRoleRevokePrivilegeResponse;
import org.apache.sentry.api.generic.thrift.TAuthorizable;
import org.apache.sentry.api.generic.thrift.TCreateSentryRoleRequest;
import org.apache.sentry.api.generic.thrift.TCreateSentryRoleResponse;
import org.apache.sentry.api.generic.thrift.TDropPrivilegesRequest;
import org.apache.sentry.api.generic.thrift.TDropPrivilegesResponse;
import org.apache.sentry.api.generic.thrift.TDropSentryRoleRequest;
import org.apache.sentry.api.generic.thrift.TDropSentryRoleResponse;
import org.apache.sentry.api.generic.thrift.TListSentryPrivilegesByAuthRequest;
import org.apache.sentry.api.generic.thrift.TListSentryPrivilegesByAuthResponse;
import org.apache.sentry.api.generic.thrift.TListSentryPrivilegesForProviderRequest;
import org.apache.sentry.api.generic.thrift.TListSentryPrivilegesForProviderResponse;
import org.apache.sentry.api.generic.thrift.TListSentryPrivilegesRequest;
import org.apache.sentry.api.generic.thrift.TListSentryPrivilegesResponse;
import org.apache.sentry.api.generic.thrift.TListSentryRolesRequest;
import org.apache.sentry.api.generic.thrift.TListSentryRolesResponse;
import org.apache.sentry.api.generic.thrift.TRenamePrivilegesRequest;
import org.apache.sentry.api.generic.thrift.TRenamePrivilegesResponse;
import org.apache.sentry.api.generic.thrift.TSentryActiveRoleSet;
import org.apache.sentry.api.generic.thrift.TSentryGrantOption;
import org.apache.sentry.api.generic.thrift.TSentryPrivilege;
import org.apache.sentry.api.generic.thrift.TSentryPrivilegeMap;
import org.apache.sentry.api.generic.thrift.TSentryRole;
import org.apache.sentry.api.service.thrift.SentryPolicyStoreProcessor;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.exception.SentryAccessDeniedException;
import org.apache.sentry.core.common.exception.SentryAlreadyExistsException;
import org.apache.sentry.core.common.exception.SentryInvalidInputException;
import org.apache.sentry.core.common.exception.SentryNoSuchObjectException;
import org.apache.sentry.core.common.exception.SentrySiteConfigurationException;
import org.apache.sentry.core.common.exception.SentryThriftAPIMismatchException;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.core.common.utils.KeyValue;
import org.apache.sentry.core.common.utils.SentryConstants;
import org.apache.sentry.provider.db.generic.service.persistent.DelegateSentryStore;
import org.apache.sentry.provider.db.generic.service.persistent.PrivilegeObject;
import org.apache.sentry.provider.db.generic.service.persistent.SentryStoreLayer;
import org.apache.sentry.provider.db.log.entity.JsonLogEntityFactory;
import org.apache.sentry.provider.db.service.model.MSentryGMPrivilege;
import org.apache.sentry.provider.db.service.model.MSentryRole;
import org.apache.sentry.service.thrift.TSentryResponseStatus;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryGenericPolicyProcessor
implements SentryGenericPolicyService.Iface {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryGenericPolicyProcessor.class);
    private static final Logger AUDIT_LOGGER = LoggerFactory.getLogger((String)"sentry.generic.authorization.ddl.logger");
    private final Configuration conf;
    private final ImmutableSet<String> adminGroups;
    private final SentryStoreLayer store;
    private final NotificationHandlerInvoker handerInvoker;
    private static final String ACCESS_DENIAL_MESSAGE = "Access denied to ";

    SentryGenericPolicyProcessor(Configuration conf) throws Exception {
        this.store = new DelegateSentryStore(conf);
        this.handerInvoker = new NotificationHandlerInvoker(SentryGenericPolicyProcessor.createHandlers(conf));
        this.conf = conf;
        this.adminGroups = ImmutableSet.copyOf((Collection)Sets.newHashSet((Object[])conf.getStrings("sentry.service.admin.group", new String[0])));
    }

    @VisibleForTesting
    SentryGenericPolicyProcessor(Configuration conf, SentryStoreLayer store) throws Exception {
        this.store = store;
        this.handerInvoker = new NotificationHandlerInvoker(SentryGenericPolicyProcessor.createHandlers(conf));
        this.conf = conf;
        this.adminGroups = ImmutableSet.copyOf(this.toTrimmed(Sets.newHashSet((Object[])conf.getStrings("sentry.service.admin.group", new String[0]))));
    }

    private void authorize(String requestorUser, Set<String> requestorGroups) throws SentryAccessDeniedException {
        if (!this.inAdminGroups(requestorGroups)) {
            String msg = "User: " + requestorUser + " is part of " + requestorGroups + " which does not, intersect admin groups " + this.adminGroups;
            LOGGER.warn(msg);
            throw new SentryAccessDeniedException(ACCESS_DENIAL_MESSAGE + requestorUser);
        }
    }

    private Set<String> toTrimmedLower(Set<String> s) {
        if (s == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>(s.size());
        for (String v : s) {
            result.add(v.trim().toLowerCase());
        }
        return result;
    }

    private Set<String> toTrimmed(Set<String> s) {
        if (s == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>(s.size());
        for (String v : s) {
            result.add(v.trim());
        }
        return result;
    }

    private String toTrimmedLower(String s) {
        if (Strings.isNullOrEmpty((String)s)) {
            return "";
        }
        return s.trim().toLowerCase();
    }

    private static Set<String> getRequestorGroups(Configuration conf, String userName) throws SentryUserException {
        return SentryPolicyStoreProcessor.getGroupsFromUserName(conf, userName);
    }

    private boolean inAdminGroups(Set<String> requestorGroups) {
        return !Sets.intersection(this.adminGroups, requestorGroups).isEmpty();
    }

    static List<NotificationHandler> createHandlers(Configuration conf) throws SentrySiteConfigurationException {
        ArrayList handlers = Lists.newArrayList();
        Iterable notificationHandlers = Splitter.onPattern((String)"[\\s,]").trimResults().omitEmptyStrings().split((CharSequence)conf.get("sentry.generic.policy.notification", ""));
        try {
            for (String notificationHandler : notificationHandlers) {
                handlers.add(SentryGenericPolicyProcessor.createInstance(notificationHandler, conf, NotificationHandler.class));
            }
        }
        catch (Exception e) {
            throw new SentrySiteConfigurationException("Create notificationHandlers error: " + e.getMessage(), (Throwable)e);
        }
        return handlers;
    }

    private static <T> T createInstance(String className, Configuration conf, Class<T> iface) throws Exception {
        Object result;
        try {
            Class<?> clazz = Class.forName(className);
            if (!iface.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Class " + clazz + " is not a " + iface.getName());
            }
            Constructor<?> meth = clazz.getDeclaredConstructor(Configuration.class);
            meth.setAccessible(true);
            result = meth.newInstance(conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    private <T> Response<T> requestHandle(RequestHandler<T> handler) {
        Response response = new Response();
        try {
            response = handler.handle();
        }
        catch (SentryAccessDeniedException e) {
            String msg = "Sentry access denied: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            response.status = Status.AccessDenied((String)e.getMessage(), (Throwable)e);
        }
        catch (SentryAlreadyExistsException e) {
            String msg = "Sentry object already exists: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            response.status = Status.AlreadyExists((String)e.getMessage(), (Throwable)e);
        }
        catch (SentryNoSuchObjectException e) {
            String msg = "Sentry object doesn't exist: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            response.status = Status.NoSuchObject((String)e.getMessage(), (Throwable)e);
        }
        catch (SentryInvalidInputException e) {
            String msg = "Invalid input privilege object: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            response.status = Status.InvalidInput((String)msg, (Throwable)e);
        }
        catch (SentryThriftAPIMismatchException e) {
            String msg = "Sentry thrift API mismatch error: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            response.status = Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            String msg = "Unknown error:" + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            response.status = Status.RuntimeError((String)msg, (Throwable)e);
        }
        return response;
    }

    private PrivilegeObject toPrivilegeObject(TSentryPrivilege tSentryPrivilege) {
        Boolean grantOption = tSentryPrivilege.getGrantOption().equals((Object)TSentryGrantOption.TRUE) ? Boolean.valueOf(true) : (tSentryPrivilege.getGrantOption().equals((Object)TSentryGrantOption.FALSE) ? Boolean.valueOf(false) : null);
        return new PrivilegeObject.Builder().setComponent(tSentryPrivilege.getComponent()).setService(tSentryPrivilege.getServiceName()).setAuthorizables(this.toAuthorizables(tSentryPrivilege.getAuthorizables())).setAction(tSentryPrivilege.getAction()).withGrantOption(grantOption).build();
    }

    private TSentryPrivilege fromPrivilegeObject(PrivilegeObject privilege) {
        TSentryPrivilege tPrivilege = new TSentryPrivilege(privilege.getComponent(), privilege.getService(), this.fromAuthorizable(privilege.getAuthorizables()), privilege.getAction());
        if (privilege.getGrantOption() == null) {
            tPrivilege.setGrantOption(TSentryGrantOption.UNSET);
        } else if (privilege.getGrantOption().booleanValue()) {
            tPrivilege.setGrantOption(TSentryGrantOption.TRUE);
        } else {
            tPrivilege.setGrantOption(TSentryGrantOption.FALSE);
        }
        return tPrivilege;
    }

    private List<TAuthorizable> fromAuthorizable(List<? extends Authorizable> authorizables) {
        ArrayList tAuthorizables = Lists.newArrayList();
        for (Authorizable authorizable : authorizables) {
            tAuthorizables.add(new TAuthorizable(authorizable.getTypeName(), authorizable.getName()));
        }
        return tAuthorizables;
    }

    private String fromAuthorizableToStr(List<? extends Authorizable> authorizables) {
        if (authorizables != null && !authorizables.isEmpty()) {
            ArrayList privileges = Lists.newArrayList();
            for (Authorizable authorizable : authorizables) {
                privileges.add(SentryConstants.KV_JOINER.join((Object)authorizable.getTypeName(), (Object)authorizable.getName(), new Object[0]));
            }
            return SentryConstants.AUTHORIZABLE_JOINER.join((Iterable)privileges);
        }
        return "";
    }

    private List<? extends Authorizable> toAuthorizables(List<TAuthorizable> tAuthorizables) {
        ArrayList authorizables = Lists.newArrayList();
        if (tAuthorizables == null) {
            return authorizables;
        }
        for (final TAuthorizable tAuthorizable : tAuthorizables) {
            authorizables.add(new Authorizable(){

                public String getTypeName() {
                    return tAuthorizable.getType();
                }

                public String getName() {
                    return tAuthorizable.getName();
                }
            });
        }
        return authorizables;
    }

    private List<? extends Authorizable> toAuthorizables(String privilegeStr) {
        ArrayList authorizables = Lists.newArrayList();
        if (privilegeStr == null) {
            return authorizables;
        }
        for (String authorizable : SentryConstants.AUTHORIZABLE_SPLITTER.split((CharSequence)privilegeStr)) {
            KeyValue tempKV = new KeyValue(authorizable);
            final String key = tempKV.getKey();
            final String value = tempKV.getValue();
            authorizables.add(new Authorizable(){

                public String getTypeName() {
                    return key;
                }

                public String getName() {
                    return value;
                }
            });
        }
        return authorizables;
    }

    private TSentryPrivilegeMap toTSentryPrivilegeMap(Set<MSentryGMPrivilege> mPrivileges) {
        TreeMap tPrivilegeMap = Maps.newTreeMap();
        for (MSentryGMPrivilege mPrivilege : mPrivileges) {
            for (MSentryRole role : mPrivilege.getRoles()) {
                TSentryPrivilege tPrivilege = this.toTSentryPrivilege(mPrivilege);
                if (tPrivilegeMap.containsKey(role.getRoleName())) {
                    ((Set)tPrivilegeMap.get(role.getRoleName())).add(tPrivilege);
                    continue;
                }
                TreeSet tPrivilegeSet = Sets.newTreeSet();
                tPrivilegeSet.add(tPrivilege);
                tPrivilegeMap.put(role.getRoleName(), tPrivilegeSet);
            }
        }
        return new TSentryPrivilegeMap((Map)tPrivilegeMap);
    }

    private TSentryPrivilege toTSentryPrivilege(MSentryGMPrivilege mPrivilege) {
        TSentryPrivilege tPrivilege = new TSentryPrivilege(mPrivilege.getComponentName(), mPrivilege.getServiceName(), this.fromAuthorizable(mPrivilege.getAuthorizables()), mPrivilege.getAction());
        if (mPrivilege.getGrantOption() == null) {
            tPrivilege.setGrantOption(TSentryGrantOption.UNSET);
        } else if (mPrivilege.getGrantOption().booleanValue()) {
            tPrivilege.setGrantOption(TSentryGrantOption.TRUE);
        } else {
            tPrivilege.setGrantOption(TSentryGrantOption.FALSE);
        }
        return tPrivilege;
    }

    private Set<String> buildPermissions(Set<PrivilegeObject> privileges) {
        HashSet permissions = Sets.newHashSet();
        for (PrivilegeObject privilege : privileges) {
            ArrayList hierarchy = Lists.newArrayList();
            if (this.hasComponentServerPrivilege(privilege.getComponent())) {
                hierarchy.add(SentryConstants.KV_JOINER.join((Object)"server", (Object)privilege.getService(), new Object[0]));
            }
            for (Authorizable authorizable : privilege.getAuthorizables()) {
                hierarchy.add(SentryConstants.KV_JOINER.join((Object)authorizable.getTypeName(), (Object)authorizable.getName(), new Object[0]));
            }
            hierarchy.add(SentryConstants.KV_JOINER.join((Object)"action", (Object)privilege.getAction(), new Object[0]));
            permissions.add(SentryConstants.AUTHORIZABLE_JOINER.join((Iterable)hierarchy));
        }
        return permissions;
    }

    private boolean hasComponentServerPrivilege(String component) {
        return "sqoop".equalsIgnoreCase(component);
    }

    public TCreateSentryRoleResponse create_sentry_role(final TCreateSentryRoleRequest request) throws TException {
        Response<Void> respose = this.requestHandle(new RequestHandler<Void>(){

            @Override
            public Response<Void> handle() throws Exception {
                SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
                SentryGenericPolicyProcessor.this.authorize(request.getRequestorUserName(), SentryGenericPolicyProcessor.getRequestorGroups(SentryGenericPolicyProcessor.this.conf, request.getRequestorUserName()));
                SentryGenericPolicyProcessor.this.store.createRole(request.getComponent(), request.getRoleName(), request.getRequestorUserName());
                return new Response<Void>(Status.OK());
            }
        });
        TCreateSentryRoleResponse tResponse = new TCreateSentryRoleResponse(((Response)respose).status);
        if (Status.OK.getCode() == ((Response)respose).status.getValue()) {
            this.handerInvoker.create_sentry_role(request, tResponse);
        }
        try {
            AUDIT_LOGGER.info(JsonLogEntityFactory.getInstance().createJsonLogEntity(request, tResponse, this.conf).toJsonFormatLog());
        }
        catch (Exception e) {
            String msg = "Error in creating audit log for create role: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
        }
        return tResponse;
    }

    public TDropSentryRoleResponse drop_sentry_role(final TDropSentryRoleRequest request) throws TException {
        Response<Void> respose = this.requestHandle(new RequestHandler<Void>(){

            @Override
            public Response<Void> handle() throws Exception {
                SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
                SentryGenericPolicyProcessor.this.authorize(request.getRequestorUserName(), SentryGenericPolicyProcessor.getRequestorGroups(SentryGenericPolicyProcessor.this.conf, request.getRequestorUserName()));
                SentryGenericPolicyProcessor.this.store.dropRole(request.getComponent(), request.getRoleName(), request.getRequestorUserName());
                return new Response<Void>(Status.OK());
            }
        });
        TDropSentryRoleResponse tResponse = new TDropSentryRoleResponse(((Response)respose).status);
        if (Status.OK.getCode() == ((Response)respose).status.getValue()) {
            this.handerInvoker.drop_sentry_role(request, tResponse);
        }
        try {
            AUDIT_LOGGER.info(JsonLogEntityFactory.getInstance().createJsonLogEntity(request, tResponse, this.conf).toJsonFormatLog());
        }
        catch (Exception e) {
            String msg = "Error in creating audit log for drop role: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
        }
        return tResponse;
    }

    public TAlterSentryRoleGrantPrivilegeResponse alter_sentry_role_grant_privilege(final TAlterSentryRoleGrantPrivilegeRequest request) throws TException {
        Response<Void> respose = this.requestHandle(new RequestHandler<Void>(){

            @Override
            public Response<Void> handle() throws Exception {
                SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
                SentryGenericPolicyProcessor.this.store.alterRoleGrantPrivilege(request.getComponent(), request.getRoleName(), SentryGenericPolicyProcessor.this.toPrivilegeObject(request.getPrivilege()), request.getRequestorUserName());
                return new Response<Void>(Status.OK());
            }
        });
        TAlterSentryRoleGrantPrivilegeResponse tResponse = new TAlterSentryRoleGrantPrivilegeResponse(((Response)respose).status);
        if (Status.OK.getCode() == ((Response)respose).status.getValue()) {
            this.handerInvoker.alter_sentry_role_grant_privilege(request, tResponse);
        }
        try {
            AUDIT_LOGGER.info(JsonLogEntityFactory.getInstance().createJsonLogEntity(request, tResponse, this.conf).toJsonFormatLog());
        }
        catch (Exception e) {
            String msg = "Error in creating audit log for grant privilege to role: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
        }
        return tResponse;
    }

    public TAlterSentryRoleRevokePrivilegeResponse alter_sentry_role_revoke_privilege(final TAlterSentryRoleRevokePrivilegeRequest request) throws TException {
        Response<Void> respose = this.requestHandle(new RequestHandler<Void>(){

            @Override
            public Response<Void> handle() throws Exception {
                SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
                SentryGenericPolicyProcessor.this.store.alterRoleRevokePrivilege(request.getComponent(), request.getRoleName(), SentryGenericPolicyProcessor.this.toPrivilegeObject(request.getPrivilege()), request.getRequestorUserName());
                return new Response<Void>(Status.OK());
            }
        });
        TAlterSentryRoleRevokePrivilegeResponse tResponse = new TAlterSentryRoleRevokePrivilegeResponse(((Response)respose).status);
        if (Status.OK.getCode() == ((Response)respose).status.getValue()) {
            this.handerInvoker.alter_sentry_role_revoke_privilege(request, tResponse);
        }
        try {
            AUDIT_LOGGER.info(JsonLogEntityFactory.getInstance().createJsonLogEntity(request, tResponse, this.conf).toJsonFormatLog());
        }
        catch (Exception e) {
            String msg = "Error in creating audit log for revoke privilege from role: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
        }
        return tResponse;
    }

    public TAlterSentryRoleAddGroupsResponse alter_sentry_role_add_groups(final TAlterSentryRoleAddGroupsRequest request) throws TException {
        Response<Void> respose = this.requestHandle(new RequestHandler<Void>(){

            @Override
            public Response<Void> handle() throws Exception {
                SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
                SentryGenericPolicyProcessor.this.authorize(request.getRequestorUserName(), SentryGenericPolicyProcessor.getRequestorGroups(SentryGenericPolicyProcessor.this.conf, request.getRequestorUserName()));
                SentryGenericPolicyProcessor.this.store.alterRoleAddGroups(request.getComponent(), request.getRoleName(), request.getGroups(), request.getRequestorUserName());
                return new Response<Void>(Status.OK());
            }
        });
        TAlterSentryRoleAddGroupsResponse tResponse = new TAlterSentryRoleAddGroupsResponse(((Response)respose).status);
        if (Status.OK.getCode() == ((Response)respose).status.getValue()) {
            this.handerInvoker.alter_sentry_role_add_groups(request, tResponse);
        }
        try {
            AUDIT_LOGGER.info(JsonLogEntityFactory.getInstance().createJsonLogEntity(request, tResponse, this.conf).toJsonFormatLog());
        }
        catch (Exception e) {
            String msg = "Error in creating audit log for add role to group: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
        }
        return tResponse;
    }

    public TAlterSentryRoleDeleteGroupsResponse alter_sentry_role_delete_groups(final TAlterSentryRoleDeleteGroupsRequest request) throws TException {
        Response<Void> respose = this.requestHandle(new RequestHandler<Void>(){

            @Override
            public Response<Void> handle() throws Exception {
                SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
                SentryGenericPolicyProcessor.this.authorize(request.getRequestorUserName(), SentryGenericPolicyProcessor.getRequestorGroups(SentryGenericPolicyProcessor.this.conf, request.getRequestorUserName()));
                SentryGenericPolicyProcessor.this.store.alterRoleDeleteGroups(request.getComponent(), request.getRoleName(), request.getGroups(), request.getRequestorUserName());
                return new Response<Void>(Status.OK());
            }
        });
        TAlterSentryRoleDeleteGroupsResponse tResponse = new TAlterSentryRoleDeleteGroupsResponse(((Response)respose).status);
        if (Status.OK.getCode() == ((Response)respose).status.getValue()) {
            this.handerInvoker.alter_sentry_role_delete_groups(request, tResponse);
        }
        try {
            AUDIT_LOGGER.info(JsonLogEntityFactory.getInstance().createJsonLogEntity(request, tResponse, this.conf).toJsonFormatLog());
        }
        catch (Exception e) {
            String msg = "Error in creating audit log for delete role from group: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
        }
        return tResponse;
    }

    public TListSentryRolesResponse list_sentry_roles_by_group(final TListSentryRolesRequest request) throws TException {
        Response<Set<TSentryRole>> respose = this.requestHandle(new RequestHandler<Set<TSentryRole>>(){

            @Override
            public Response<Set<TSentryRole>> handle() throws Exception {
                SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
                Set groups = SentryGenericPolicyProcessor.getRequestorGroups(SentryGenericPolicyProcessor.this.conf, request.getRequestorUserName());
                if (!"*".equalsIgnoreCase(request.getGroupName())) {
                    boolean admin = SentryGenericPolicyProcessor.this.inAdminGroups(groups);
                    if (!(admin || request.getGroupName() != null && groups.contains(request.getGroupName()))) {
                        throw new SentryAccessDeniedException(SentryGenericPolicyProcessor.ACCESS_DENIAL_MESSAGE + request.getRequestorUserName());
                    }
                    groups.clear();
                    groups.add(request.getGroupName());
                }
                Set<TSentryRole> tSentryRoles = SentryGenericPolicyProcessor.this.store.getTSentryRolesByGroupName(request.getComponent(), groups);
                return new Response<Set<TSentryRole>>(Status.OK(), tSentryRoles);
            }
        });
        TListSentryRolesResponse tResponse = new TListSentryRolesResponse();
        tResponse.setStatus(((Response)respose).status);
        tResponse.setRoles((Set)((Response)respose).content);
        return tResponse;
    }

    public TListSentryPrivilegesResponse list_sentry_privileges_by_role(final TListSentryPrivilegesRequest request) throws TException {
        Response<Set<TSentryPrivilege>> respose = this.requestHandle(new RequestHandler<Set<TSentryPrivilege>>(){

            @Override
            public Response<Set<TSentryPrivilege>> handle() throws Exception {
                Set roleNamesForGroups;
                SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
                Set groups = SentryGenericPolicyProcessor.getRequestorGroups(SentryGenericPolicyProcessor.this.conf, request.getRequestorUserName());
                if (!SentryGenericPolicyProcessor.this.inAdminGroups(groups) && !(roleNamesForGroups = SentryGenericPolicyProcessor.this.toTrimmedLower(SentryGenericPolicyProcessor.this.store.getRolesByGroups(request.getComponent(), groups))).contains(SentryGenericPolicyProcessor.this.toTrimmedLower(request.getRoleName()))) {
                    throw new SentryAccessDeniedException(SentryGenericPolicyProcessor.ACCESS_DENIAL_MESSAGE + request.getRequestorUserName());
                }
                Set<PrivilegeObject> privileges = SentryGenericPolicyProcessor.this.store.getPrivilegesByProvider(request.getComponent(), request.getServiceName(), Sets.newHashSet((Object[])new String[]{request.getRoleName()}), null, SentryGenericPolicyProcessor.this.toAuthorizables(request.getAuthorizables()));
                HashSet tSentryPrivileges = Sets.newHashSet();
                for (PrivilegeObject privilege : privileges) {
                    tSentryPrivileges.add(SentryGenericPolicyProcessor.this.fromPrivilegeObject(privilege));
                }
                return new Response<Set<TSentryPrivilege>>(Status.OK(), tSentryPrivileges);
            }
        });
        TListSentryPrivilegesResponse tResponse = new TListSentryPrivilegesResponse();
        tResponse.setStatus(((Response)respose).status);
        tResponse.setPrivileges((Set)((Response)respose).content);
        return tResponse;
    }

    public TListSentryPrivilegesForProviderResponse list_sentry_privileges_for_provider(final TListSentryPrivilegesForProviderRequest request) throws TException {
        Response<Set<String>> respose = this.requestHandle(new RequestHandler<Set<String>>(){

            @Override
            public Response<Set<String>> handle() throws Exception {
                SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
                Set activeRoleNames = SentryGenericPolicyProcessor.this.toTrimmedLower(request.getRoleSet().getRoles());
                Sets.SetView roleNamesForGroups = SentryGenericPolicyProcessor.this.store.getRolesByGroups(request.getComponent(), request.getGroups());
                Sets.SetView rolesToQuery = request.getRoleSet().isAll() ? roleNamesForGroups : Sets.intersection((Set)activeRoleNames, roleNamesForGroups);
                Set<PrivilegeObject> privileges = SentryGenericPolicyProcessor.this.store.getPrivilegesByProvider(request.getComponent(), request.getServiceName(), (Set<String>)rolesToQuery, null, SentryGenericPolicyProcessor.this.toAuthorizables(request.getAuthorizables()));
                return new Response<Set<String>>(Status.OK(), SentryGenericPolicyProcessor.this.buildPermissions(privileges));
            }
        });
        TListSentryPrivilegesForProviderResponse tResponse = new TListSentryPrivilegesForProviderResponse();
        tResponse.setStatus(((Response)respose).status);
        tResponse.setPrivileges((Set)((Response)respose).content);
        return tResponse;
    }

    public TListSentryPrivilegesByAuthResponse list_sentry_privileges_by_authorizable(TListSentryPrivilegesByAuthRequest request) throws TException {
        TListSentryPrivilegesByAuthResponse response = new TListSentryPrivilegesByAuthResponse();
        HashMap authRoleMap = Maps.newHashMap();
        Set<String> requestedGroups = request.getGroups();
        String subject = request.getRequestorUserName();
        TSentryActiveRoleSet activeRoleSet = request.getRoleSet();
        HashSet validActiveRoles = Sets.newHashSet();
        try {
            SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
            Set<String> memberGroups = SentryGenericPolicyProcessor.getRequestorGroups(this.conf, subject);
            if (!this.inAdminGroups(memberGroups)) {
                if (requestedGroups != null && !requestedGroups.isEmpty()) {
                    for (String requestedGroup : requestedGroups) {
                        if (memberGroups.contains(requestedGroup)) continue;
                        throw new SentryAccessDeniedException(ACCESS_DENIAL_MESSAGE + subject);
                    }
                } else {
                    requestedGroups = memberGroups;
                }
                Sets.SetView grantedRoles = this.toTrimmedLower(this.store.getRolesByGroups(request.getComponent(), requestedGroups));
                if (activeRoleSet != null && !activeRoleSet.isAll()) {
                    Set<String> activeRoleNames = this.toTrimmedLower(activeRoleSet.getRoles());
                    for (String activeRole : activeRoleNames) {
                        if (grantedRoles.contains(activeRole)) continue;
                        throw new SentryAccessDeniedException(ACCESS_DENIAL_MESSAGE + subject);
                    }
                    validActiveRoles.addAll(activeRoleSet.isAll() ? grantedRoles : Sets.intersection(activeRoleNames, grantedRoles));
                } else {
                    validActiveRoles.addAll(grantedRoles);
                }
            } else {
                Object requestedRoles = this.toTrimmedLower(this.store.getAllRoleNames());
                if (requestedGroups != null && !requestedGroups.isEmpty()) {
                    requestedRoles = this.toTrimmedLower(this.store.getRolesByGroups(request.getComponent(), requestedGroups));
                }
                if (activeRoleSet != null && !activeRoleSet.isAll()) {
                    validActiveRoles.addAll(Sets.intersection(this.toTrimmedLower(activeRoleSet.getRoles()), requestedRoles));
                } else {
                    validActiveRoles.addAll(requestedRoles);
                }
            }
            if (request.getAuthorizablesSet() != null) {
                for (String authorizablesStr : request.getAuthorizablesSet()) {
                    List<? extends Authorizable> authorizables = this.toAuthorizables(authorizablesStr);
                    Set<MSentryGMPrivilege> sentryPrivileges = this.store.getPrivilegesByAuthorizable(request.getComponent(), request.getServiceName(), validActiveRoles, authorizables);
                    authRoleMap.put(this.fromAuthorizableToStr(authorizables), this.toTSentryPrivilegeMap(sentryPrivileges));
                }
            }
            response.setPrivilegesMapByAuth((Map)authRoleMap);
            response.setStatus(Status.OK());
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            response.setStatus(Status.AccessDenied((String)e.getMessage(), (Throwable)e));
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            response.setStatus(Status.THRIFT_VERSION_MISMATCH((String)e.getMessage(), (Throwable)e));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            response.setStatus(Status.RuntimeError((String)msg, (Throwable)e));
        }
        return response;
    }

    public TDropPrivilegesResponse drop_sentry_privilege(final TDropPrivilegesRequest request) throws TException {
        Response<Void> respose = this.requestHandle(new RequestHandler<Void>(){

            @Override
            public Response<Void> handle() throws Exception {
                SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
                SentryGenericPolicyProcessor.this.authorize(request.getRequestorUserName(), SentryGenericPolicyProcessor.getRequestorGroups(SentryGenericPolicyProcessor.this.conf, request.getRequestorUserName()));
                SentryGenericPolicyProcessor.this.store.dropPrivilege(request.getComponent(), SentryGenericPolicyProcessor.this.toPrivilegeObject(request.getPrivilege()), request.getRequestorUserName());
                return new Response<Void>(Status.OK());
            }
        });
        TDropPrivilegesResponse tResponse = new TDropPrivilegesResponse(((Response)respose).status);
        if (Status.OK.getCode() == ((Response)respose).status.getValue()) {
            this.handerInvoker.drop_sentry_privilege(request, tResponse);
        }
        return tResponse;
    }

    public TRenamePrivilegesResponse rename_sentry_privilege(final TRenamePrivilegesRequest request) throws TException {
        Response<Void> respose = this.requestHandle(new RequestHandler<Void>(){

            @Override
            public Response<Void> handle() throws Exception {
                SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
                SentryGenericPolicyProcessor.this.authorize(request.getRequestorUserName(), SentryGenericPolicyProcessor.getRequestorGroups(SentryGenericPolicyProcessor.this.conf, request.getRequestorUserName()));
                SentryGenericPolicyProcessor.this.store.renamePrivilege(request.getComponent(), request.getServiceName(), SentryGenericPolicyProcessor.this.toAuthorizables(request.getOldAuthorizables()), SentryGenericPolicyProcessor.this.toAuthorizables(request.getNewAuthorizables()), request.getRequestorUserName());
                return new Response<Void>(Status.OK());
            }
        });
        TRenamePrivilegesResponse tResponse = new TRenamePrivilegesResponse(((Response)respose).status);
        if (Status.OK.getCode() == ((Response)respose).status.getValue()) {
            this.handerInvoker.rename_sentry_privilege(request, tResponse);
        }
        return tResponse;
    }

    private static void validateClientVersion(int protocolVersion) throws SentryThriftAPIMismatchException {
        if (2 != protocolVersion) {
            String msg = "Sentry thrift API protocol version mismatch: Client thrift version is: " + protocolVersion + " , server thrift version is " + 2;
            throw new SentryThriftAPIMismatchException(msg);
        }
    }

    private static interface RequestHandler<T> {
        public Response<T> handle() throws Exception;
    }

    private static class Response<T> {
        private TSentryResponseStatus status;
        private T content;

        Response() {
        }

        Response(TSentryResponseStatus status) {
            this(status, null);
        }

        Response(TSentryResponseStatus status, T content) {
            this.status = status;
            this.content = content;
        }
    }
}

