/*
 * Decompiled with CFR 0.152.
 */
package sentry.org.apache.thrift.transport;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.util.Arrays;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import sentry.org.apache.thrift.transport.TServerSocket;
import sentry.org.apache.thrift.transport.TSocket;
import sentry.org.apache.thrift.transport.TTransportException;

public class TSSLTransportFactory {
    public static TServerSocket getServerSocket(int port) throws TTransportException {
        return TSSLTransportFactory.getServerSocket(port, 0);
    }

    public static TServerSocket getServerSocket(int port, int clientTimeout) throws TTransportException {
        return TSSLTransportFactory.getServerSocket(port, clientTimeout, false, null);
    }

    public static TServerSocket getServerSocket(int port, int clientTimeout, boolean clientAuth, InetAddress ifAddress) throws TTransportException {
        SSLServerSocketFactory factory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        return TSSLTransportFactory.createServer(factory, port, clientTimeout, clientAuth, ifAddress, null);
    }

    public static TServerSocket getServerSocket(int port, int clientTimeout, InetAddress ifAddress, TSSLTransportParameters params) throws TTransportException {
        if (params == null || !params.isKeyStoreSet && !params.isTrustStoreSet) {
            throw new TTransportException("Either one of the KeyStore or TrustStore must be set for SSLTransportParameters");
        }
        SSLContext ctx = TSSLTransportFactory.createSSLContext(params);
        return TSSLTransportFactory.createServer(ctx.getServerSocketFactory(), port, clientTimeout, params.clientAuth, ifAddress, params);
    }

    private static TServerSocket createServer(SSLServerSocketFactory factory, int port, int timeout, boolean clientAuth, InetAddress ifAddress, TSSLTransportParameters params) throws TTransportException {
        try {
            SSLServerSocket serverSocket = (SSLServerSocket)factory.createServerSocket(port, 100, ifAddress);
            serverSocket.setSoTimeout(timeout);
            serverSocket.setNeedClientAuth(clientAuth);
            if (params != null && params.cipherSuites != null) {
                serverSocket.setEnabledCipherSuites(params.cipherSuites);
            }
            return new TServerSocket((TServerSocket.ServerSocketTransportArgs)new TServerSocket.ServerSocketTransportArgs().serverSocket(serverSocket).clientTimeout(timeout));
        }
        catch (Exception e) {
            throw new TTransportException("Could not bind to port " + port, (Throwable)e);
        }
    }

    public static TSocket getClientSocket(String host, int port, int timeout) throws TTransportException {
        SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        return TSSLTransportFactory.createClient(factory, host, port, timeout);
    }

    public static TSocket getClientSocket(String host, int port) throws TTransportException {
        return TSSLTransportFactory.getClientSocket(host, port, 0);
    }

    public static TSocket getClientSocket(String host, int port, int timeout, TSSLTransportParameters params) throws TTransportException {
        if (params == null || !params.isKeyStoreSet && !params.isTrustStoreSet) {
            throw new TTransportException("Either one of the KeyStore or TrustStore must be set for SSLTransportParameters");
        }
        SSLContext ctx = TSSLTransportFactory.createSSLContext(params);
        return TSSLTransportFactory.createClient(ctx.getSocketFactory(), host, port, timeout);
    }

    private static SSLContext createSSLContext(TSSLTransportParameters params) throws TTransportException {
        SSLContext ctx;
        InputStream in = null;
        InputStream is = null;
        try {
            ctx = SSLContext.getInstance(params.protocol);
            TrustManagerFactory tmf = null;
            KeyManagerFactory kmf = null;
            if (params.isTrustStoreSet) {
                tmf = TrustManagerFactory.getInstance(params.trustManagerType);
                KeyStore ts = KeyStore.getInstance(params.trustStoreType);
                in = TSSLTransportFactory.getStoreAsStream(params.trustStore);
                ts.load(in, params.trustPass != null ? params.trustPass.toCharArray() : null);
                tmf.init(ts);
            }
            if (params.isKeyStoreSet) {
                kmf = KeyManagerFactory.getInstance(params.keyManagerType);
                KeyStore ks = KeyStore.getInstance(params.keyStoreType);
                is = TSSLTransportFactory.getStoreAsStream(params.keyStore);
                ks.load(is, params.keyPass.toCharArray());
                kmf.init(ks, params.keyPass.toCharArray());
            }
            if (params.isKeyStoreSet && params.isTrustStoreSet) {
                ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            } else if (params.isKeyStoreSet) {
                ctx.init(kmf.getKeyManagers(), null, null);
            } else {
                ctx.init(null, tmf.getTrustManagers(), null);
            }
        }
        catch (Exception e) {
            throw new TTransportException("Error creating the transport", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ctx;
    }

    private static InputStream getStoreAsStream(String store) throws IOException {
        try {
            return new FileInputStream(store);
        }
        catch (FileNotFoundException fileNotFoundException) {
            InputStream storeStream = null;
            try {
                storeStream = new URL(store).openStream();
                if (storeStream != null) {
                    return storeStream;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            storeStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(store);
            if (storeStream != null) {
                return storeStream;
            }
            throw new IOException("Could not load file: " + store);
        }
    }

    private static TSocket createClient(SSLSocketFactory factory, String host, int port, int timeout) throws TTransportException {
        try {
            SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
            socket.setSoTimeout(timeout);
            return new TSocket(socket);
        }
        catch (Exception e) {
            throw new TTransportException("Could not connect to " + host + " on port " + port, (Throwable)e);
        }
    }

    public static class TSSLTransportParameters {
        protected String protocol = "TLS";
        protected String keyStore;
        protected String keyPass;
        protected String keyManagerType = KeyManagerFactory.getDefaultAlgorithm();
        protected String keyStoreType = "JKS";
        protected String trustStore;
        protected String trustPass;
        protected String trustManagerType = TrustManagerFactory.getDefaultAlgorithm();
        protected String trustStoreType = "JKS";
        protected String[] cipherSuites;
        protected boolean clientAuth = false;
        protected boolean isKeyStoreSet = false;
        protected boolean isTrustStoreSet = false;

        public TSSLTransportParameters() {
        }

        public TSSLTransportParameters(String protocol, String[] cipherSuites) {
            this(protocol, cipherSuites, false);
        }

        public TSSLTransportParameters(String protocol, String[] cipherSuites, boolean clientAuth) {
            if (protocol != null) {
                this.protocol = protocol;
            }
            this.cipherSuites = Arrays.copyOf(cipherSuites, cipherSuites.length);
            this.clientAuth = clientAuth;
        }

        public void setKeyStore(String keyStore, String keyPass, String keyManagerType, String keyStoreType) {
            this.keyStore = keyStore;
            this.keyPass = keyPass;
            if (keyManagerType != null) {
                this.keyManagerType = keyManagerType;
            }
            if (keyStoreType != null) {
                this.keyStoreType = keyStoreType;
            }
            this.isKeyStoreSet = true;
        }

        public void setKeyStore(String keyStore, String keyPass) {
            this.setKeyStore(keyStore, keyPass, null, null);
        }

        public void setTrustStore(String trustStore, String trustPass, String trustManagerType, String trustStoreType) {
            this.trustStore = trustStore;
            this.trustPass = trustPass;
            if (trustManagerType != null) {
                this.trustManagerType = trustManagerType;
            }
            if (trustStoreType != null) {
                this.trustStoreType = trustStoreType;
            }
            this.isTrustStoreSet = true;
        }

        public void setTrustStore(String trustStore, String trustPass) {
            this.setTrustStore(trustStore, trustPass, null, null);
        }

        public void requireClientAuth(boolean clientAuth) {
            this.clientAuth = clientAuth;
        }
    }
}

