/*
 * Decompiled with CFR 0.152.
 */
package sentry.org.apache.sentry.core.common.utils;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PubSub {
    private static final Logger LOGGER = LoggerFactory.getLogger(PubSub.class);
    private final Map<Topic, Set<Subscriber>> subscriberMap = new HashMap<Topic, Set<Subscriber>>();
    private static PubSub instance;

    public static synchronized PubSub getInstance() {
        if (instance != null) {
            LOGGER.info(instance + " requested");
        } else {
            instance = new PubSub();
            LOGGER.info(instance + " created");
        }
        return instance;
    }

    private PubSub() {
    }

    public synchronized void publish(Topic topic, String message) {
        Preconditions.checkNotNull((Object)((Object)topic), (Object)"Topic cannot be null");
        Set<Subscriber> subscribers = this.subscriberMap.get((Object)topic);
        if (subscribers == null) {
            throw new IllegalArgumentException("cannot publish to unknown topic " + (Object)((Object)topic) + ", existing topics " + this.subscriberMap.keySet());
        }
        for (Subscriber subscriber : subscribers) {
            try {
                subscriber.onMessage(topic, message);
            }
            catch (Exception e) {
                LOGGER.error("Topic " + (Object)((Object)topic) + ", message " + message + ", delivery error", (Throwable)e);
            }
        }
        LOGGER.info("Topic " + (Object)((Object)topic) + ", message " + message + ": " + subscribers.size() + " subscribers called");
    }

    public synchronized void subscribe(Topic topic, Subscriber subscriber) {
        Preconditions.checkNotNull((Object)((Object)topic), (Object)"Topic cannot be null");
        Preconditions.checkNotNull((Object)subscriber, (String)"Topic %s: Subscriber cannot be null", (Object[])new Object[]{topic});
        Set<Subscriber> subscribers = this.subscriberMap.get((Object)topic);
        if (subscribers == null) {
            LOGGER.info("new topic " + (Object)((Object)topic));
            subscribers = new HashSet<Subscriber>();
            this.subscriberMap.put(topic, subscribers);
        }
        subscribers.add(subscriber);
        LOGGER.info("Topic " + (Object)((Object)topic) + ", added subscriber " + subscriber + ", total topic subscribers: " + subscribers.size());
    }

    public synchronized void unsubscribe(Topic topic, Subscriber subscriber) {
        Preconditions.checkNotNull((Object)((Object)topic), (Object)"Topic cannot be null");
        Preconditions.checkNotNull((Object)subscriber, (String)"Topic %s: Subscriber cannot be null", (Object[])new Object[]{topic});
        Set<Subscriber> subscribers = this.subscriberMap.get((Object)topic);
        if (subscribers == null) {
            throw new IllegalArgumentException("cannot unsubscribe from unknown topic " + (Object)((Object)topic));
        }
        if (!subscribers.remove(subscriber)) {
            throw new IllegalArgumentException("cannot unsubscribe from topic " + (Object)((Object)topic) + ", unknown subscriber");
        }
        LOGGER.info("Topic " + (Object)((Object)topic) + ", unsubscribing subscriber " + subscriber + ", total topic subscribers: " + subscribers.size());
        if (subscribers.isEmpty()) {
            this.subscriberMap.remove((Object)topic);
        }
    }

    public synchronized Set<Topic> getTopics() {
        return this.subscriberMap.keySet();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + Integer.toHexString(this.hashCode());
    }

    public static enum Topic {
        HDFS_SYNC_HMS("hdfs-sync-hms"),
        HDFS_SYNC_NN("hdfs-sync-nn");

        private final String name;
        private static final Map<String, Topic> map;

        public static Topic fromString(String name) {
            Preconditions.checkNotNull((Object)"Enum name cannot be null", (Object)name);
            name = name.trim().toLowerCase();
            if (map.containsKey(name)) {
                return map.get(name);
            }
            throw new NoSuchElementException(name + " not found");
        }

        private Topic(String name) {
            this.name = name.toLowerCase();
        }

        public String getName() {
            return this.name;
        }

        static {
            map = new HashMap<String, Topic>();
            for (Topic t : Topic.values()) {
                map.put(t.name, t);
            }
        }
    }

    public static interface Subscriber {
        public void onMessage(Topic var1, String var2);
    }
}

