/*
 * Decompiled with CFR 0.152.
 */
package sentry.org.apache.sentry.core.common.transport;

import org.apache.hadoop.conf.Configuration;
import sentry.org.apache.sentry.core.common.exception.MissingConfigurationException;
import sentry.org.apache.sentry.core.common.transport.SentryClientTransportConfigInterface;
import sentry.org.apache.sentry.core.common.transport.SentryClientTransportConstants;

public final class SentryPolicyClientTransportConfig
implements SentryClientTransportConfigInterface {
    @Override
    public boolean isKerberosEnabled(Configuration conf) {
        return conf.get("sentry.service.security.mode", "kerberos").trim().equalsIgnoreCase("kerberos");
    }

    @Override
    public int getSentryRpcRetryTotal(Configuration conf) {
        return conf.getInt("sentry.service.client.rpc.retry-total", 5);
    }

    @Override
    public long getSentryRpcConnRetryDelayInMs(Configuration conf) {
        return conf.getLong("sentry.service.client.rpc.retry.interval.msec", SentryClientTransportConstants.PolicyClientConstants.SERVER_RPC_CONN_RETRY_DELAY_MS_DEFAULT);
    }

    @Override
    public boolean useUserGroupInformation(Configuration conf) {
        return Boolean.valueOf(conf.get("sentry.service.security.use.ugi", "true"));
    }

    @Override
    public String getSentryPrincipal(Configuration conf) {
        String principle = conf.get("sentry.service.server.principal");
        if (principle != null && !principle.isEmpty()) {
            return principle;
        }
        throw new MissingConfigurationException("sentry.service.server.principal");
    }

    @Override
    public String getSentryServerRpcAddress(Configuration conf) {
        String serverAddress = conf.get("sentry.service.client.server.rpc-addresses");
        if (serverAddress != null && !serverAddress.isEmpty()) {
            return serverAddress;
        }
        throw new MissingConfigurationException("sentry.service.client.server.rpc-addresses");
    }

    @Override
    public int getServerRpcPort(Configuration conf) {
        return conf.getInt("sentry.service.client.server.rpc-port", 8038);
    }

    @Override
    public int getServerRpcConnTimeoutInMs(Configuration conf) {
        return conf.getInt("sentry.service.client.server.rpc-connection-timeout", 200000);
    }

    @Override
    public int getPoolMaxTotal(Configuration conf) {
        return conf.getInt("sentry.service.client.connection.pool.max-total", -1);
    }

    @Override
    public int getPoolMinIdle(Configuration conf) {
        return conf.getInt("sentry.service.client.connection.pool.min-idle", 10);
    }

    @Override
    public int getPoolMaxIdle(Configuration conf) {
        return conf.getInt("sentry.service.client.connection.pool.max-idle", 100);
    }

    @Override
    public long getMinEvictableTimeSec(Configuration conf) {
        return conf.getLong("sentry.service.client.connection.pool.eviction.mintime.sec", SentryClientTransportConstants.PolicyClientConstants.SENTRY_POOL_MIN_EVICTION_TIME_SEC_DEFAULT);
    }

    @Override
    public long getTimeBetweenEvictionRunsSec(Configuration conf) {
        return conf.getLong("sentry.service.client.connection.pool.eviction.interval.sec", SentryClientTransportConstants.PolicyClientConstants.SENTRY_POOL_EVICTION_INTERVAL_SEC_DEFAULT);
    }

    @Override
    public boolean isLoadBalancingEnabled(Configuration conf) {
        return conf.getBoolean("sentry.service.client.connection.loadbalance", true);
    }

    @Override
    public boolean isTransportPoolEnabled(Configuration conf) {
        return conf.getBoolean("sentry.service.client.connection.pool.enabled", true);
    }
}

