/*
 * Decompiled with CFR 0.152.
 */
package sentry.org.apache.sentry.core.common.transport;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sentry.org.apache.sentry.core.common.exception.SentryHdfsServiceException;
import sentry.org.apache.sentry.core.common.exception.SentryUserException;
import sentry.org.apache.sentry.core.common.transport.SentryClientInvocationHandler;
import sentry.org.apache.sentry.core.common.transport.SentryClientTransportConfigInterface;
import sentry.org.apache.sentry.core.common.transport.SentryConnection;
import sentry.org.apache.thrift.transport.TTransportException;

public final class RetryClientInvocationHandler
extends SentryClientInvocationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryClientInvocationHandler.class);
    private SentryConnection client = null;
    private final int maxRetryCount;
    private final long connRetryDelayInMs;

    public RetryClientInvocationHandler(Configuration conf, SentryConnection clientObject, SentryClientTransportConfigInterface transportConfig) {
        Preconditions.checkNotNull((Object)conf, (Object)"Configuration object cannot be null");
        Preconditions.checkNotNull((Object)clientObject, (Object)"Client Object cannot be null");
        this.client = clientObject;
        this.maxRetryCount = transportConfig.getSentryRpcRetryTotal(conf);
        this.connRetryDelayInMs = transportConfig.getSentryRpcConnRetryDelayInMs(conf);
    }

    @Override
    public synchronized Object invokeImpl(Object proxy, Method method, Object[] args) throws Exception {
        String methodName = method.getName();
        if ("toString".equals(methodName)) {
            return method.invoke((Object)this.client, args);
        }
        TTransportException lastExc = null;
        for (int retryCount = 0; retryCount < this.maxRetryCount; ++retryCount) {
            this.connect();
            try {
                LOGGER.debug("Calling {}", (Object)methodName);
                return method.invoke((Object)this.client, args);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("failed to execute {}", (Object)method.getName(), (Object)e);
                Throwable targetException = e.getCause();
                if (!(targetException instanceof SentryUserException) && !(targetException instanceof SentryHdfsServiceException)) {
                    throw e;
                }
                Throwable sentryTargetException = targetException.getCause();
                if (!(sentryTargetException instanceof TTransportException)) {
                    if (targetException instanceof SentryUserException) {
                        throw (SentryUserException)targetException;
                    }
                    throw (SentryHdfsServiceException)targetException;
                }
                lastExc = new TTransportException(sentryTargetException);
                LOGGER.error("Thrift call failed", (Throwable)lastExc);
                this.client.invalidate();
                continue;
            }
        }
        String error = String.format("Request failed, %d retries attempted ", this.maxRetryCount);
        throw new SentryUserException(error, lastExc);
    }

    private void connect() throws Exception {
        Throwable lastExc = null;
        for (int retryCount = 0; retryCount < this.maxRetryCount; ++retryCount) {
            try {
                this.client.connect();
                return;
            }
            catch (TTransportException failure) {
                LOGGER.error("Failed to connect", (Throwable)failure);
                lastExc = failure;
            }
            catch (Exception failure) {
                Throwable causeException = failure.getCause();
                if (!(causeException instanceof TTransportException)) {
                    LOGGER.error("Failed to connect to Sentry Server", (Throwable)failure);
                    throw new SentryUserException(failure.getMessage(), causeException);
                }
                lastExc = causeException;
            }
            try {
                Thread.sleep(this.connRetryDelayInMs);
                continue;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw ex;
            }
        }
        assert (lastExc != null);
        throw new SentryUserException(lastExc.getMessage(), lastExc);
    }

    @Override
    public synchronized void close() {
        this.client.done();
    }
}

