/*
 * Decompiled with CFR 0.152.
 */
package sentry.com.codahale.metrics.jvm;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import sentry.com.codahale.metrics.Gauge;
import sentry.com.codahale.metrics.Metric;
import sentry.com.codahale.metrics.MetricSet;

public class ClassLoadingGaugeSet
implements MetricSet {
    private final ClassLoadingMXBean mxBean;

    public ClassLoadingGaugeSet() {
        this(ManagementFactory.getClassLoadingMXBean());
    }

    public ClassLoadingGaugeSet(ClassLoadingMXBean mxBean) {
        this.mxBean = mxBean;
    }

    @Override
    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> gauges = new HashMap<String, Metric>();
        gauges.put("loaded", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return ClassLoadingGaugeSet.this.mxBean.getTotalLoadedClassCount();
            }
        });
        gauges.put("unloaded", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return ClassLoadingGaugeSet.this.mxBean.getUnloadedClassCount();
            }
        });
        return gauges;
    }
}

