/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.sentry.hdfs.DBUpdateForwarder;
import org.apache.sentry.hdfs.DeltaRetriever;
import org.apache.sentry.hdfs.PermissionsUpdate;
import org.apache.sentry.hdfs.SentryHdfsMetricsUtil;
import org.apache.sentry.hdfs.service.thrift.TPrivilegeChanges;
import org.apache.sentry.provider.db.service.model.MSentryPermChange;
import org.apache.sentry.provider.db.service.persistent.SentryStoreInterface;
import sentry.com.codahale.metrics.Timer;

@ThreadSafe
public class PermDeltaRetriever
implements DeltaRetriever<PermissionsUpdate> {
    private final SentryStoreInterface sentryStore;

    PermDeltaRetriever(SentryStoreInterface sentryStore) {
        this.sentryStore = sentryStore;
    }

    public List<PermissionsUpdate> retrieveDelta(long seqNum, long imgNum) throws Exception {
        try (Timer.Context timerContext = SentryHdfsMetricsUtil.getDeltaPermChangesTimer.time();){
            List mSentryPermChanges = this.sentryStore.getMSentryPermChanges(seqNum);
            SentryHdfsMetricsUtil.getDeltaPermChangesHistogram.update(mSentryPermChanges.size());
            if (mSentryPermChanges.isEmpty()) {
                List<PermissionsUpdate> list = Collections.emptyList();
                return list;
            }
            ArrayList<PermissionsUpdate> updates = new ArrayList<PermissionsUpdate>(mSentryPermChanges.size());
            for (MSentryPermChange mSentryPermChange : mSentryPermChanges) {
                long changeID = mSentryPermChange.getChangeID();
                PermissionsUpdate permsUpdate = new PermissionsUpdate();
                permsUpdate.JSONDeserialize(mSentryPermChange.getPermChange());
                permsUpdate.setSeqNum(changeID);
                Collection privChanges = permsUpdate.getPrivilegeUpdates();
                for (TPrivilegeChanges privChange : privChanges) {
                    DBUpdateForwarder.translateOwnerPrivileges(privChange.getAddPrivileges());
                    DBUpdateForwarder.translateOwnerPrivileges(privChange.getDelPrivileges());
                }
                updates.add(permsUpdate);
            }
            ArrayList<PermissionsUpdate> arrayList = updates;
            return arrayList;
        }
    }

    public boolean isDeltaAvailable(long seqNum) throws Exception {
        return this.sentryStore.permChangeExists(seqNum);
    }

    public long getLatestDeltaID() throws Exception {
        return this.sentryStore.getLastProcessedPermChangeID();
    }
}

