/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.sentry.hdfs.DeltaRetriever;
import org.apache.sentry.hdfs.PathsUpdate;
import org.apache.sentry.hdfs.SentryHdfsMetricsUtil;
import org.apache.sentry.provider.db.service.model.MSentryPathChange;
import org.apache.sentry.provider.db.service.persistent.SentryStoreInterface;
import sentry.com.codahale.metrics.Timer;

@ThreadSafe
public class PathDeltaRetriever
implements DeltaRetriever<PathsUpdate> {
    private final SentryStoreInterface sentryStore;

    PathDeltaRetriever(SentryStoreInterface sentryStore) {
        this.sentryStore = sentryStore;
    }

    public List<PathsUpdate> retrieveDelta(long seqNum, long imgNum) throws Exception {
        try (Timer.Context timerContext = SentryHdfsMetricsUtil.getDeltaPathChangesTimer.time();){
            List mSentryPathChanges = this.sentryStore.getMSentryPathChanges(seqNum);
            SentryHdfsMetricsUtil.getDeltaPathChangesHistogram.update(mSentryPathChanges.size());
            if (mSentryPathChanges.isEmpty()) {
                List<PathsUpdate> list = Collections.emptyList();
                return list;
            }
            ArrayList<PathsUpdate> updates = new ArrayList<PathsUpdate>(mSentryPathChanges.size());
            for (MSentryPathChange mSentryPathChange : mSentryPathChanges) {
                long changeID = mSentryPathChange.getChangeID();
                PathsUpdate pathsUpdate = new PathsUpdate();
                pathsUpdate.JSONDeserialize(mSentryPathChange.getPathChange());
                pathsUpdate.setSeqNum(changeID);
                pathsUpdate.setImgNum(imgNum);
                updates.add(pathsUpdate);
            }
            ArrayList<PathsUpdate> arrayList = updates;
            return arrayList;
        }
    }

    public boolean isDeltaAvailable(long seqNum) throws Exception {
        return this.sentryStore.pathChangeExists(seqNum);
    }

    public long getLatestDeltaID() throws Exception {
        return this.sentryStore.getLastProcessedPathChangeID();
    }
}

