/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.api.tools;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.sentry.api.generic.thrift.TAuthorizable;
import org.apache.sentry.api.generic.thrift.TSentryGrantOption;
import org.apache.sentry.api.generic.thrift.TSentryPrivilege;
import org.apache.sentry.api.tools.TSentryPrivilegeConverter;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.core.common.utils.KeyValue;
import org.apache.sentry.core.common.utils.SentryConstants;
import org.apache.sentry.core.common.validator.PrivilegeValidator;
import org.apache.sentry.core.common.validator.PrivilegeValidatorContext;
import org.apache.sentry.core.model.indexer.IndexerModelAuthorizables;
import org.apache.sentry.core.model.indexer.IndexerPrivilegeModel;
import org.apache.sentry.core.model.kafka.KafkaAuthorizable;
import org.apache.sentry.core.model.kafka.KafkaModelAuthorizables;
import org.apache.sentry.core.model.kafka.KafkaPrivilegeModel;
import org.apache.sentry.core.model.solr.SolrModelAuthorizables;
import org.apache.sentry.core.model.solr.SolrPrivilegeModel;
import org.apache.shiro.config.ConfigurationException;

public class GenericPrivilegeConverter
implements TSentryPrivilegeConverter {
    private String component;
    private String service;
    private boolean validate;

    public GenericPrivilegeConverter(String component, String service) {
        this(component, service, true);
    }

    public GenericPrivilegeConverter(String component, String service, boolean validate) {
        this.component = component;
        this.service = service;
        this.validate = validate;
    }

    @Override
    public TSentryPrivilege fromString(String privilegeStr) throws SentryUserException {
        privilegeStr = this.parsePrivilegeString(privilegeStr);
        if (this.validate) {
            this.validatePrivilegeHierarchy(privilegeStr);
        }
        TSentryPrivilege tSentryPrivilege = new TSentryPrivilege();
        LinkedList<TAuthorizable> authorizables = new LinkedList<TAuthorizable>();
        for (String authorizable : SentryConstants.AUTHORIZABLE_SPLITTER.split((CharSequence)privilegeStr)) {
            KeyValue keyValue = new KeyValue(authorizable);
            String key = keyValue.getKey();
            String value = keyValue.getValue();
            Authorizable authz = this.getAuthorizable(keyValue);
            if (authz != null) {
                authorizables.add(new TAuthorizable(authz.getTypeName(), authz.getName()));
                continue;
            }
            if ("action".equalsIgnoreCase(key)) {
                tSentryPrivilege.setAction(value);
                continue;
            }
            throw new IllegalArgumentException("Unknown key: " + key);
        }
        if (tSentryPrivilege.getAction() == null) {
            throw new IllegalArgumentException("Privilege is invalid: action required but not specified.");
        }
        tSentryPrivilege.setComponent(this.component);
        tSentryPrivilege.setServiceName(this.service);
        tSentryPrivilege.setAuthorizables(authorizables);
        return tSentryPrivilege;
    }

    @Override
    public String toString(TSentryPrivilege tSentryPrivilege) {
        ArrayList privileges = Lists.newArrayList();
        if (tSentryPrivilege != null) {
            List<TAuthorizable> authorizables = tSentryPrivilege.getAuthorizables();
            String action = tSentryPrivilege.getAction();
            String grantOption = tSentryPrivilege.getGrantOption() == TSentryGrantOption.TRUE ? "true" : "false";
            Iterator<TAuthorizable> it = authorizables.iterator();
            if (it != null) {
                while (it.hasNext()) {
                    TAuthorizable tAuthorizable = it.next();
                    privileges.add(SentryConstants.KV_JOINER.join((Object)tAuthorizable.getType(), (Object)tAuthorizable.getName(), new Object[0]));
                }
            }
            if (!authorizables.isEmpty()) {
                privileges.add(SentryConstants.KV_JOINER.join((Object)"action", (Object)action, new Object[0]));
            }
            if ("true".equals(grantOption)) {
                privileges.add(SentryConstants.KV_JOINER.join((Object)"grantoption", (Object)grantOption, new Object[0]));
            }
        }
        return SentryConstants.AUTHORIZABLE_JOINER.join((Iterable)privileges);
    }

    private String parsePrivilegeString(String privilegeStr) {
        if ("kafka".equals(this.component)) {
            String hostPrefix = KafkaAuthorizable.AuthorizableType.HOST.name() + "=";
            String hostPrefixLowerCase = hostPrefix.toLowerCase();
            if (!privilegeStr.toLowerCase().startsWith(hostPrefixLowerCase)) {
                return hostPrefix + "*" + "->" + privilegeStr;
            }
        }
        return privilegeStr;
    }

    private void validatePrivilegeHierarchy(String privilegeStr) throws SentryUserException {
        List<PrivilegeValidator> validators = this.getPrivilegeValidators();
        PrivilegeValidatorContext context = new PrivilegeValidatorContext(null, privilegeStr);
        for (PrivilegeValidator validator : validators) {
            try {
                validator.validate(context);
            }
            catch (ConfigurationException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    protected List<PrivilegeValidator> getPrivilegeValidators() throws SentryUserException {
        if ("kafka".equals(this.component)) {
            return KafkaPrivilegeModel.getInstance().getPrivilegeValidators();
        }
        if ("SOLR".equals(this.component)) {
            return SolrPrivilegeModel.getInstance().getPrivilegeValidators();
        }
        if ("hbaseindexer".equals(this.component)) {
            return IndexerPrivilegeModel.getInstance().getPrivilegeValidators();
        }
        throw new SentryUserException("Invalid component specified for GenericPrivilegeCoverter: " + this.component);
    }

    protected Authorizable getAuthorizable(KeyValue keyValue) throws SentryUserException {
        if ("kafka".equals(this.component)) {
            return KafkaModelAuthorizables.from((KeyValue)keyValue);
        }
        if ("SOLR".equals(this.component)) {
            return SolrModelAuthorizables.from((KeyValue)keyValue);
        }
        if ("hbaseindexer".equals(this.component)) {
            return IndexerModelAuthorizables.from((KeyValue)keyValue);
        }
        throw new SentryUserException("Invalid component specified for GenericPrivilegeCoverter: " + this.component);
    }
}

