/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.api.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.sentry.api.common.ApiConstants;
import org.apache.sentry.api.service.thrift.TSentryAuthorizable;
import org.apache.sentry.api.service.thrift.TSentryGrantOption;
import org.apache.sentry.api.service.thrift.TSentryPrivilege;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;
import org.apache.sentry.core.common.exception.SentryGrantDeniedException;
import org.apache.sentry.core.common.exception.SentryInvalidInputException;
import org.apache.sentry.core.common.utils.KeyValue;
import org.apache.sentry.core.common.utils.SentryConstants;
import org.slf4j.Logger;

public final class SentryServiceUtil {
    private static boolean firstCallHDFSSyncEnabled = true;
    private static boolean hdfsSyncEnabled = false;

    public static TSentryPrivilege convertToTSentryPrivilege(String privilegeStr) {
        TSentryPrivilege tSentryPrivilege = new TSentryPrivilege();
        for (String authorizable : SentryConstants.AUTHORIZABLE_SPLITTER.split((CharSequence)privilegeStr)) {
            KeyValue tempKV = new KeyValue(authorizable);
            String key = tempKV.getKey();
            String value = tempKV.getValue();
            if ("server".equalsIgnoreCase(key)) {
                tSentryPrivilege.setServerName(value);
                continue;
            }
            if ("db".equalsIgnoreCase(key)) {
                tSentryPrivilege.setDbName(value);
                continue;
            }
            if ("table".equalsIgnoreCase(key)) {
                tSentryPrivilege.setTableName(value);
                continue;
            }
            if ("column".equalsIgnoreCase(key)) {
                tSentryPrivilege.setColumnName(value);
                continue;
            }
            if ("uri".equalsIgnoreCase(key)) {
                tSentryPrivilege.setURI(value);
                continue;
            }
            if ("action".equalsIgnoreCase(key)) {
                tSentryPrivilege.setAction(value);
                continue;
            }
            if (!"grantoption".equalsIgnoreCase(key)) continue;
            TSentryGrantOption grantOption = "true".equalsIgnoreCase(value) ? TSentryGrantOption.TRUE : TSentryGrantOption.FALSE;
            tSentryPrivilege.setGrantOption(grantOption);
        }
        tSentryPrivilege.setPrivilegeScope(SentryServiceUtil.getPrivilegeScope(tSentryPrivilege));
        return tSentryPrivilege;
    }

    public static Map<String, String> parseObjectPath(String objectPath) {
        HashMap<String, String> objectMap = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)objectPath)) {
            return objectMap;
        }
        for (String kvStr : SentryConstants.AUTHORIZABLE_SPLITTER.split((CharSequence)objectPath)) {
            KeyValue kv = new KeyValue(kvStr);
            String key = kv.getKey();
            String value = kv.getValue();
            if ("db".equalsIgnoreCase(key)) {
                objectMap.put("db", value);
                continue;
            }
            if (!"table".equalsIgnoreCase(key)) continue;
            objectMap.put("table", value);
        }
        return objectMap;
    }

    public static String getPrivilegeScope(TSentryPrivilege tSentryPrivilege) {
        ApiConstants.PrivilegeScope privilegeScope = ApiConstants.PrivilegeScope.SERVER;
        if (!StringUtils.isEmpty((String)tSentryPrivilege.getURI())) {
            privilegeScope = ApiConstants.PrivilegeScope.URI;
        } else if (!StringUtils.isEmpty((String)tSentryPrivilege.getColumnName())) {
            privilegeScope = ApiConstants.PrivilegeScope.COLUMN;
        } else if (!StringUtils.isEmpty((String)tSentryPrivilege.getTableName())) {
            privilegeScope = ApiConstants.PrivilegeScope.TABLE;
        } else if (!StringUtils.isEmpty((String)tSentryPrivilege.getDbName())) {
            privilegeScope = ApiConstants.PrivilegeScope.DATABASE;
        }
        return privilegeScope.toString();
    }

    public static String convertTSentryPrivilegeToStr(TSentryPrivilege tSentryPrivilege) {
        ArrayList privileges = Lists.newArrayList();
        if (tSentryPrivilege != null) {
            String grantOption;
            String serverName = tSentryPrivilege.getServerName();
            String dbName = tSentryPrivilege.getDbName();
            String tableName = tSentryPrivilege.getTableName();
            String columnName = tSentryPrivilege.getColumnName();
            String uri = tSentryPrivilege.getURI();
            String action = tSentryPrivilege.getAction();
            String string = grantOption = tSentryPrivilege.getGrantOption() == TSentryGrantOption.TRUE ? "true" : "false";
            if (!StringUtils.isEmpty((String)serverName)) {
                privileges.add(SentryConstants.KV_JOINER.join((Object)"server", (Object)serverName, new Object[0]));
                if (!StringUtils.isEmpty((String)uri)) {
                    privileges.add(SentryConstants.KV_JOINER.join((Object)"uri", (Object)uri, new Object[0]));
                } else if (!StringUtils.isEmpty((String)dbName)) {
                    privileges.add(SentryConstants.KV_JOINER.join((Object)"db", (Object)dbName, new Object[0]));
                    if (!StringUtils.isEmpty((String)tableName)) {
                        privileges.add(SentryConstants.KV_JOINER.join((Object)"table", (Object)tableName, new Object[0]));
                        if (!StringUtils.isEmpty((String)columnName)) {
                            privileges.add(SentryConstants.KV_JOINER.join((Object)"column", (Object)columnName, new Object[0]));
                        }
                    }
                }
                if (!StringUtils.isEmpty((String)action)) {
                    privileges.add(SentryConstants.KV_JOINER.join((Object)"action", (Object)action, new Object[0]));
                }
            }
            if ("true".equals(grantOption)) {
                privileges.add(SentryConstants.KV_JOINER.join((Object)"grantoption", (Object)grantOption, new Object[0]));
            }
        }
        return SentryConstants.AUTHORIZABLE_JOINER.join((Iterable)privileges);
    }

    public static void shutdownAndAwaitTermination(ExecutorService pool, String poolName, long timeout, TimeUnit unit, Logger logger) {
        Preconditions.checkNotNull((Object)pool);
        pool.shutdown();
        try {
            if (!pool.awaitTermination(timeout, unit)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(timeout, unit) && logger != null) {
                    logger.error("Executor service {} did not terminate", (Object)StringUtils.defaultIfBlank((String)poolName, (String)"null"));
                }
            }
        }
        catch (InterruptedException ignored) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static boolean isHDFSSyncEnabled(Configuration conf) {
        if (firstCallHDFSSyncEnabled) {
            List<String> processorFactories = Arrays.asList(conf.get("sentry.service.processor.factories", "").split(","));
            List<String> policyStorePlugins = Arrays.asList(conf.get("sentry.policy.store.plugins", "").split(","));
            hdfsSyncEnabled = processorFactories.contains("org.apache.sentry.hdfs.SentryHDFSServiceProcessorFactory") && policyStorePlugins.contains("org.apache.sentry.hdfs.SentryPlugin");
            firstCallHDFSSyncEnabled = false;
        }
        return hdfsSyncEnabled;
    }

    public static boolean isHDFSSyncEnabledNoCache(Configuration conf) {
        List<String> processorFactories = Arrays.asList(conf.get("sentry.service.processor.factories", "").split(","));
        List<String> policyStorePlugins = Arrays.asList(conf.get("sentry.policy.store.plugins", "").split(","));
        hdfsSyncEnabled = processorFactories.contains("org.apache.sentry.hdfs.SentryHDFSServiceProcessorFactory") && policyStorePlugins.contains("org.apache.sentry.hdfs.SentryPlugin");
        return hdfsSyncEnabled;
    }

    public static boolean isSyncPolicyStoreEnabled(Configuration conf) {
        boolean syncStoreOnCreate = Boolean.parseBoolean(conf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_SYNC_CREATE_WITH_POLICY_STORE.getVar(), HiveAuthzConf.AuthzConfVars.AUTHZ_SYNC_CREATE_WITH_POLICY_STORE.getDefault()));
        boolean syncStoreOnDrop = Boolean.parseBoolean(conf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_SYNC_DROP_WITH_POLICY_STORE.getVar(), HiveAuthzConf.AuthzConfVars.AUTHZ_SYNC_DROP_WITH_POLICY_STORE.getDefault()));
        boolean syncStoreOnAlter = Boolean.parseBoolean(conf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_SYNC_ALTER_WITH_POLICY_STORE.getVar(), HiveAuthzConf.AuthzConfVars.AUTHZ_SYNC_ALTER_WITH_POLICY_STORE.getDefault()));
        return syncStoreOnCreate || syncStoreOnDrop || syncStoreOnAlter;
    }

    public static String getHiveMetastoreURI() {
        HiveConf hiveConf = new HiveConf();
        return hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname);
    }

    public static String getAuthzObj(TSentryAuthorizable authorizable) throws SentryInvalidInputException {
        return SentryServiceUtil.getAuthzObj(authorizable.getDb(), authorizable.getTable());
    }

    public static String getAuthzObj(String dbName, String tblName) throws SentryInvalidInputException {
        if (SentryServiceUtil.isNULL(dbName)) {
            throw new SentryInvalidInputException("Invalif input, DB name is missing");
        }
        return SentryServiceUtil.isNULL(tblName) ? dbName.toLowerCase() : (dbName + "." + tblName).toLowerCase();
    }

    private SentryServiceUtil() {
    }

    private static boolean isNULL(String s) {
        return Strings.isNullOrEmpty((String)s) || s.equals("__NULL__");
    }

    public static void checkDbExplicitGrantsPermitted(Configuration conf, Set<TSentryPrivilege> privileges) throws SentryGrantDeniedException {
        Set<String> permittedGrants = SentryServiceUtil.getDbGrantsPermittedFromConf(conf);
        if (permittedGrants.isEmpty()) {
            return;
        }
        HashSet<String> deniedGrants = new HashSet<String>();
        for (TSentryPrivilege privilege : privileges) {
            String action = privilege.getAction();
            if (action == null || permittedGrants.contains(action = action.trim().toUpperCase())) continue;
            deniedGrants.add(action);
        }
        if (!deniedGrants.isEmpty()) {
            throw new SentryGrantDeniedException(String.format("GRANT privilege for %s not permitted.", deniedGrants));
        }
    }

    private static Set<String> getDbGrantsPermittedFromConf(Configuration conf) {
        String grantsConfig = conf.get("sentry.db.explicit.grants.permitted", "CREATE,REFRESH,SELECT,INSERT,ALL,*").trim();
        if (grantsConfig.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> permittedGrants = new HashSet<String>();
        for (String grant : grantsConfig.split(",")) {
            permittedGrants.add(grant.trim().toUpperCase());
        }
        return permittedGrants;
    }
}

