/*
 * Decompiled with CFR 0.152.
 */
package com.budhash.cliche;

import com.budhash.cliche.CommandTable;
import com.budhash.cliche.ConsoleIO;
import com.budhash.cliche.DashJoinedNamer;
import com.budhash.cliche.HelpCommandHandler;
import com.budhash.cliche.Shell;
import com.budhash.cliche.util.ArrayHashMultiMap;
import com.budhash.cliche.util.EmptyMultiMap;
import com.budhash.cliche.util.MultiMap;
import java.util.ArrayList;

public class ShellFactory {
    private ShellFactory() {
    }

    public static Shell createConsoleShell(String prompt, String appName, Object ... handlers) {
        ConsoleIO io = new ConsoleIO();
        ArrayList<String> path = new ArrayList<String>(1);
        path.add(prompt);
        ArrayHashMultiMap<String, Object> modifAuxHandlers = new ArrayHashMultiMap<String, Object>();
        modifAuxHandlers.put("!", io);
        Shell theShell = new Shell(new Shell.Settings(io, io, modifAuxHandlers, false), new CommandTable(new DashJoinedNamer(true)), path);
        theShell.setAppName(appName);
        theShell.addMainHandler(theShell, "!");
        theShell.addMainHandler(new HelpCommandHandler(), "?");
        for (Object h : handlers) {
            theShell.addMainHandler(h, "");
        }
        return theShell;
    }

    public static Shell createConsoleShell(String prompt, String appName, Object mainHandler, MultiMap<String, Object> auxHandlers) {
        ConsoleIO io = new ConsoleIO();
        ArrayList<String> path = new ArrayList<String>(1);
        path.add(prompt);
        ArrayHashMultiMap<String, Object> modifAuxHandlers = new ArrayHashMultiMap<String, Object>(auxHandlers);
        modifAuxHandlers.put("!", io);
        Shell theShell = new Shell(new Shell.Settings(io, io, modifAuxHandlers, false), new CommandTable(new DashJoinedNamer(true)), path);
        theShell.setAppName(appName);
        theShell.addMainHandler(theShell, "!");
        theShell.addMainHandler(new HelpCommandHandler(), "?");
        theShell.addMainHandler(mainHandler, "");
        return theShell;
    }

    public static Shell createConsoleShell(String prompt, String appName, Object mainHandler) {
        return ShellFactory.createConsoleShell(prompt, appName, mainHandler, new EmptyMultiMap<String, Object>());
    }

    public static Shell createSubshell(String pathElement, Shell parent, String appName, Object mainHandler, MultiMap<String, Object> auxHandlers) {
        ArrayList<String> newPath = new ArrayList<String>(parent.getPath());
        newPath.add(pathElement);
        Shell subshell = new Shell(parent.getSettings().createWithAddedAuxHandlers(auxHandlers), new CommandTable(parent.getCommandTable().getNamer()), newPath);
        subshell.setAppName(appName);
        subshell.addMainHandler(subshell, "!");
        subshell.addMainHandler(new HelpCommandHandler(), "?");
        subshell.addMainHandler(mainHandler, "");
        return subshell;
    }

    public static Shell createSubshell(String pathElement, Shell parent, String appName, Object mainHandler) {
        return ShellFactory.createSubshell(pathElement, parent, appName, mainHandler, new EmptyMultiMap<String, Object>());
    }
}

