/*
 * Decompiled with CFR 0.152.
 */
package com.budhash.cliche;

import com.budhash.cliche.Param;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class ShellCommandParamSpec {
    private String name;
    private String description;
    private int position;
    private Class<?> valueClass;

    static ShellCommandParamSpec[] forMethod(Method theMethod) {
        Class<?>[] paramTypes = theMethod.getParameterTypes();
        ShellCommandParamSpec[] result = new ShellCommandParamSpec[theMethod.getParameterTypes().length];
        Annotation[][] annotations = theMethod.getParameterAnnotations();
        assert (annotations.length == result.length);
        for (int i = 0; i < result.length; ++i) {
            Param paramAnnotation = null;
            for (Annotation a : annotations[i]) {
                if (!(a instanceof Param)) continue;
                paramAnnotation = (Param)a;
                break;
            }
            if (paramAnnotation != null) {
                assert (!paramAnnotation.name().isEmpty()) : "@Param.name mustn't be empty";
                result[i] = new ShellCommandParamSpec(paramAnnotation.name(), paramTypes[i], paramAnnotation.description(), i);
                continue;
            }
            result[i] = new ShellCommandParamSpec(String.format("p%d", i + 1), paramTypes[i], "", i);
        }
        return result;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public int getPosition() {
        return this.position;
    }

    public ShellCommandParamSpec(String name, Class<?> valueClass, String description, int position) {
        this.name = name;
        this.description = description;
        this.position = position;
        this.valueClass = valueClass;
    }
}

