/*
 * Decompiled with CFR 0.152.
 */
package com.budhash.cliche;

import com.budhash.cliche.CLIException;
import com.budhash.cliche.ShellCommandParamSpec;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ShellCommand {
    private String prefix;
    private String name;
    private String description;
    private String abbreviation;
    private String header;
    private Method method;
    private Object handler;
    private ShellCommandParamSpec[] paramSpecs;

    public ShellCommand(Object handler, Method method, String prefix, String name) {
        assert (method != null);
        this.paramSpecs = ShellCommandParamSpec.forMethod(method);
        assert (this.paramSpecs.length == method.getParameterTypes().length);
        this.method = method;
        this.prefix = prefix;
        this.name = name;
        this.handler = handler;
        this.description = ShellCommand.makeCommandDescription(method, this.paramSpecs);
    }

    private static String makeCommandDescription(Method method, ShellCommandParamSpec[] paramSpecs) {
        StringBuilder result = new StringBuilder();
        result.append(method.getName());
        result.append('(');
        Class<?>[] paramTypes = method.getParameterTypes();
        assert (paramTypes.length == paramSpecs.length);
        boolean first = true;
        for (int i = 0; i < paramTypes.length; ++i) {
            if (!first) {
                result.append(", ");
            }
            first = false;
            if (paramSpecs[i] != null) {
                result.append(paramSpecs[i].getName());
                result.append(":");
                result.append(paramTypes[i].getSimpleName());
                continue;
            }
            result.append(paramTypes[i].getSimpleName());
        }
        result.append(") : ");
        result.append(method.getReturnType().getSimpleName());
        return result.toString();
    }

    public Object invoke(Object[] parameters) throws CLIException {
        assert (this.method != null);
        try {
            Object result = this.method.invoke(this.handler, parameters);
            return result;
        }
        catch (InvocationTargetException ite) {
            return ite.getCause();
        }
        catch (Exception ex) {
            throw new CLIException(ex);
        }
    }

    public boolean canBeDenotedBy(String commandName) {
        return commandName.equals(this.prefix + this.name) || commandName.equals(this.prefix + this.abbreviation);
    }

    public int getArity() {
        return this.method.getParameterTypes().length;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getName() {
        return this.name;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public boolean startsWith(String prefix) {
        return (this.prefix + this.abbreviation).startsWith(prefix) || (this.prefix + this.name).startsWith(prefix);
    }

    public String toString() {
        return this.prefix + this.name + "\t" + (this.abbreviation != null ? this.prefix + this.abbreviation : "") + "\t" + this.method.getParameterTypes().length + (this.method.isVarArgs() ? "+" : "") + "\t" + this.description;
    }

    public String getHeader() {
        return this.header;
    }

    public ShellCommandParamSpec[] getParamSpecs() {
        return this.paramSpecs;
    }
}

