/*
 * Decompiled with CFR 0.152.
 */
package com.budhash.cliche;

import com.budhash.cliche.Token;

public class CLIException
extends Exception {
    private static final long serialVersionUID = -3663658057622243617L;

    public CLIException() {
    }

    public CLIException(String message) {
        super(message);
    }

    public CLIException(Throwable cause) {
        super(cause);
    }

    public CLIException(String message, Throwable cause) {
        super(message, cause);
    }

    public static CLIException createCommandNotFound(String commandName) {
        return new CLIException("Unknown command: " + Token.escapeString(commandName));
    }

    public static CLIException createCommandNotFoundForArgNum(String commandName, int argCount) {
        return new CLIException("There's no command " + Token.escapeString(commandName) + " taking " + argCount + " arguments");
    }

    public static CLIException createAmbiguousCommandExc(String commandName, int argCount) {
        return new CLIException("Ambiguous command " + Token.escapeString(commandName) + " taking " + argCount + " arguments");
    }
}

