/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.AtomicUpdateProcessorFactory;
import org.apache.solr.update.processor.DistributedUpdateProcessorFactory;
import org.apache.solr.update.processor.DistributingUpdateProcessorFactory;
import org.apache.solr.update.processor.LogUpdateProcessorFactory;
import org.apache.solr.update.processor.RunUpdateProcessorFactory;
import org.apache.solr.update.processor.TemplateUpdateProcessorFactory;
import org.apache.solr.update.processor.UUIDUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UpdateRequestProcessorChain
implements PluginInfoInitialized {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private List<UpdateRequestProcessorFactory> chain;
    private final SolrCore solrCore;
    public static final Map<String, Class> implicits = new ImmutableMap.Builder().put((Object)"template", TemplateUpdateProcessorFactory.class).put((Object)"atomic", AtomicUpdateProcessorFactory.class).put((Object)"uuid", UUIDUpdateProcessorFactory.class).build();

    public UpdateRequestProcessorChain(SolrCore solrCore) {
        this.solrCore = solrCore;
    }

    @Override
    public void init(PluginInfo info) {
        String infomsg = "updateRequestProcessorChain \"" + (null != info.name ? info.name : "") + "\"" + (info.isDefault() ? " (default)" : "");
        log.debug("creating " + infomsg);
        ArrayList<UpdateRequestProcessorFactory> list = new ArrayList<UpdateRequestProcessorFactory>(this.solrCore.initPlugins(info.getChildren("processor"), UpdateRequestProcessorFactory.class, null));
        if (list.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, infomsg + " require at least one processor");
        }
        int numDistrib = 0;
        int runIndex = -1;
        for (int i = list.size() - 1; 0 <= i; --i) {
            UpdateRequestProcessorFactory factory = (UpdateRequestProcessorFactory)list.get(i);
            if (factory instanceof DistributingUpdateProcessorFactory) {
                ++numDistrib;
            }
            if (!(factory instanceof RunUpdateProcessorFactory)) continue;
            runIndex = i;
        }
        if (1 < numDistrib) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, infomsg + " may not contain more then one instance of DistributingUpdateProcessorFactory");
        }
        if (0 <= runIndex && 0 == numDistrib) {
            DistributedUpdateProcessorFactory distrib = new DistributedUpdateProcessorFactory();
            distrib.init(new NamedList());
            list.add(runIndex, distrib);
            log.debug("inserting DistributedUpdateProcessorFactory into " + infomsg);
        }
        this.chain = list;
        ProcessorInfo processorInfo = new ProcessorInfo((SolrParams)new MapSolrParams(info.attributes));
        if (processorInfo.isEmpty()) {
            return;
        }
        UpdateRequestProcessorChain newChain = UpdateRequestProcessorChain.constructChain(this, processorInfo, this.solrCore);
        this.chain = newChain.chain;
    }

    public UpdateRequestProcessorChain(List<UpdateRequestProcessorFactory> chain, SolrCore solrCore) {
        this.chain = chain;
        this.solrCore = solrCore;
    }

    public UpdateRequestProcessor createProcessor(SolrQueryRequest req, SolrQueryResponse rsp) {
        UpdateRequestProcessor processor = null;
        UpdateRequestProcessor last = null;
        String distribPhase = req.getParams().get("update.distrib");
        boolean skipToDistrib = distribPhase != null;
        boolean afterDistrib = true;
        for (int i = this.chain.size() - 1; i >= 0; --i) {
            UpdateRequestProcessorFactory factory = this.chain.get(i);
            if (skipToDistrib) {
                if (afterDistrib) {
                    if (factory instanceof DistributingUpdateProcessorFactory) {
                        afterDistrib = false;
                    }
                } else if (!(factory instanceof UpdateRequestProcessorFactory.RunAlways)) continue;
            }
            last = (processor = factory.getInstance(req, rsp, last)) == null ? last : processor;
        }
        return last;
    }

    public List<UpdateRequestProcessorFactory> getProcessors() {
        return this.chain;
    }

    public static UpdateRequestProcessorChain constructChain(UpdateRequestProcessorChain defaultUrp, ProcessorInfo processorInfo, SolrCore core) {
        LinkedList<UpdateRequestProcessorFactory> urps = new LinkedList<UpdateRequestProcessorFactory>(defaultUrp.chain);
        List<UpdateRequestProcessorFactory> p = UpdateRequestProcessorChain.getReqProcessors(processorInfo.processor, core);
        List<UpdateRequestProcessorFactory> post = UpdateRequestProcessorChain.getReqProcessors(processorInfo.postProcessor, core);
        UpdateRequestProcessorChain.insertBefore(urps, p, DistributedUpdateProcessorFactory.class, 0);
        UpdateRequestProcessorChain.insertBefore(urps, post, RunUpdateProcessorFactory.class, urps.size() - 1);
        UpdateRequestProcessorChain result = new UpdateRequestProcessorChain(urps, core);
        if (log.isInfoEnabled()) {
            ArrayList<String> names = new ArrayList<String>(urps.size());
            for (UpdateRequestProcessorFactory urp : urps) {
                names.add(urp.getClass().getSimpleName());
            }
            log.debug("New dynamic chain constructed : " + StrUtils.join(names, (char)'>'));
        }
        return result;
    }

    private static void insertBefore(LinkedList<UpdateRequestProcessorFactory> urps, List<UpdateRequestProcessorFactory> newFactories, Class klas, int idx) {
        int i;
        if (newFactories.isEmpty()) {
            return;
        }
        for (i = 0; i < urps.size(); ++i) {
            if (!klas.isInstance(urps.get(i))) continue;
            idx = i;
            if (klas != DistributedUpdateProcessorFactory.class || i <= 0 || !(urps.get(i - 1) instanceof LogUpdateProcessorFactory)) break;
            idx = i - 1;
            break;
        }
        for (i = newFactories.size() - 1; 0 <= i; --i) {
            urps.add(idx, newFactories.get(i));
        }
    }

    static List<UpdateRequestProcessorFactory> getReqProcessors(String processor, SolrCore core) {
        if (processor == null) {
            return Collections.emptyList();
        }
        ArrayList<UpdateRequestProcessorFactory> result = new ArrayList<UpdateRequestProcessorFactory>();
        List names = StrUtils.splitSmart((String)processor, (char)',');
        for (String s : names) {
            if ((s = s.trim()).isEmpty()) continue;
            UpdateRequestProcessorFactory p = core.getUpdateProcessors().get(s);
            if (p == null) {
                Class factoryClass = implicits.get(s);
                if (factoryClass != null) {
                    PluginInfo pluginInfo = new PluginInfo("updateProcessor", Utils.makeMap((Object[])new Object[]{"name", s, "class", factoryClass.getName()}));
                    p = core.getUpdateProcessors().createPlugin(pluginInfo).get();
                    UpdateRequestProcessorFactory plugin = p;
                    if (plugin instanceof SolrCoreAware) {
                        ((SolrCoreAware)((Object)plugin)).inform(core);
                    }
                    core.getUpdateProcessors().put(s, plugin);
                }
                if (p == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such processor " + s);
                }
            }
            result.add(p);
        }
        return result;
    }

    public static class LazyUpdateProcessorFactoryHolder
    extends PluginBag.PluginHolder<UpdateRequestProcessorFactory> {
        private volatile UpdateRequestProcessorFactory lazyFactory;

        public LazyUpdateProcessorFactoryHolder(PluginBag.LazyPluginHolder holder) {
            super(holder.getPluginInfo());
            this.lazyFactory = new LazyUpdateRequestProcessorFactory(holder);
        }

        @Override
        public UpdateRequestProcessorFactory get() {
            return this.lazyFactory;
        }

        public class LazyUpdateRequestProcessorFactory
        extends UpdateRequestProcessorFactory {
            private final PluginBag.LazyPluginHolder holder;
            UpdateRequestProcessorFactory delegate;

            public LazyUpdateRequestProcessorFactory(PluginBag.LazyPluginHolder holder) {
                this.holder = holder;
            }

            public UpdateRequestProcessorFactory getDelegate() {
                return this.delegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
                if (this.delegate != null) {
                    return this.delegate.getInstance(req, rsp, next);
                }
                LazyUpdateRequestProcessorFactory lazyUpdateRequestProcessorFactory = this;
                synchronized (lazyUpdateRequestProcessorFactory) {
                    if (this.delegate == null) {
                        this.delegate = (UpdateRequestProcessorFactory)this.holder.get();
                    }
                }
                return this.delegate.getInstance(req, rsp, next);
            }
        }
    }

    public static class ProcessorInfo {
        public final String processor;
        public final String postProcessor;

        public ProcessorInfo(SolrParams params) {
            this.processor = params.get("processor");
            this.postProcessor = params.get("post-processor");
        }

        public boolean isEmpty() {
            return this.processor == null && this.postProcessor == null;
        }

        public int hashCode() {
            int hash = 0;
            if (this.processor != null) {
                hash += this.processor.hashCode();
            }
            if (this.postProcessor != null) {
                hash += this.postProcessor.hashCode();
            }
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ProcessorInfo)) {
                return false;
            }
            ProcessorInfo that = (ProcessorInfo)obj;
            return Objects.equals(this.processor, that.processor) && Objects.equals(this.postProcessor, that.postProcessor);
        }
    }
}

