/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;

public class IgnoreLargeDocumentProcessorFactory
extends UpdateRequestProcessorFactory {
    public static final String LIMIT_SIZE_PARAM = "limit";
    private long maxDocumentSize = 0x100000L;

    @Override
    public void init(NamedList args) {
        this.maxDocumentSize = args.toSolrParams().required().getLong(LIMIT_SIZE_PARAM);
        args.remove(LIMIT_SIZE_PARAM);
        if (args.size() > 0) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected init param(s): '" + args.getName(0) + "'");
        }
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return new UpdateRequestProcessor(next){

            @Override
            public void processAdd(AddUpdateCommand cmd) throws IOException {
                long docSize = ObjectSizeEstimator.fastEstimate(cmd.getSolrInputDocument());
                if (docSize / 1024L > IgnoreLargeDocumentProcessorFactory.this.maxDocumentSize) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Size of the document " + cmd.getPrintableId() + " is too large, around:" + docSize);
                }
                super.processAdd(cmd);
            }
        };
    }

    static class ObjectSizeEstimator {
        private static final Map<Class<?>, Integer> primitiveSizes = new IdentityHashMap();

        ObjectSizeEstimator() {
        }

        static long fastEstimate(SolrInputDocument doc) {
            if (doc == null) {
                return 0L;
            }
            long size = 0L;
            if (doc.getFieldNames() != null) {
                for (String fieldName : doc.getFieldNames()) {
                    size += ObjectSizeEstimator.fastEstimate(fieldName) + ObjectSizeEstimator.fastEstimate(doc.getField(fieldName).getValue());
                }
            }
            if (doc.hasChildDocuments()) {
                for (SolrInputDocument childDoc : doc.getChildDocuments()) {
                    size += ObjectSizeEstimator.fastEstimate(childDoc);
                }
            }
            return size;
        }

        static long fastEstimate(Object obj) {
            if (obj == null) {
                return 0L;
            }
            long size = ObjectSizeEstimator.primitiveEstimate(obj, -1L);
            if (size != -1L) {
                return size;
            }
            if (obj instanceof Map) {
                return ObjectSizeEstimator.fastEstimate((Map)obj);
            }
            if (obj instanceof Collection) {
                return ObjectSizeEstimator.fastEstimate((Collection)obj);
            }
            return 0L;
        }

        private static long primitiveEstimate(Object obj, long def) {
            Class<?> clazz = obj.getClass();
            if (clazz.isPrimitive()) {
                return primitiveSizes.get(clazz).intValue();
            }
            if (obj instanceof String) {
                return ((String)obj).length() * 2;
            }
            return def;
        }

        private static long fastEstimate(Map<Object, Object> map) {
            if (map.isEmpty()) {
                return 0L;
            }
            long size = 0L;
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                size += ObjectSizeEstimator.primitiveEstimate(entry.getKey(), 0L) + ObjectSizeEstimator.primitiveEstimate(entry.getValue(), 0L);
            }
            return size;
        }

        private static long fastEstimate(Collection collection) {
            if (collection.isEmpty()) {
                return 0L;
            }
            long size = 0L;
            for (Object obj : collection) {
                size += ObjectSizeEstimator.primitiveEstimate(obj, 0L);
            }
            return size;
        }

        static {
            primitiveSizes.put(Boolean.TYPE, 1);
            primitiveSizes.put(Boolean.class, 1);
            primitiveSizes.put(Byte.TYPE, 1);
            primitiveSizes.put(Byte.class, 1);
            primitiveSizes.put(Character.TYPE, 2);
            primitiveSizes.put(Character.class, 2);
            primitiveSizes.put(Short.TYPE, 2);
            primitiveSizes.put(Short.class, 2);
            primitiveSizes.put(Integer.TYPE, 4);
            primitiveSizes.put(Integer.class, 4);
            primitiveSizes.put(Float.TYPE, 4);
            primitiveSizes.put(Float.class, 4);
            primitiveSizes.put(Double.TYPE, 8);
            primitiveSizes.put(Double.class, 8);
            primitiveSizes.put(Long.TYPE, 8);
            primitiveSizes.put(Long.class, 8);
        }
    }
}

