/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.EnumFieldValue;
import org.apache.solr.common.IteratorWriter;
import org.apache.solr.common.MapSerializable;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.PushWriter;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.Base64;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BasicResultContext;
import org.apache.solr.response.DocsStreamer;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.WriteableValue;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocList;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.util.FastWriter;

public abstract class TextResponseWriter
implements PushWriter {
    static final char[] indentChars = new char[81];
    protected final FastWriter writer;
    protected final IndexSchema schema;
    protected final SolrQueryRequest req;
    protected final SolrQueryResponse rsp;
    protected ReturnFields returnFields;
    protected int level;
    protected boolean doIndent;
    protected Calendar cal;

    public TextResponseWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) {
        this.writer = writer == null ? null : FastWriter.wrap(writer);
        this.schema = req.getSchema();
        this.req = req;
        this.rsp = rsp;
        String indent = req.getParams().get("indent");
        if (null == indent || !"off".equals(indent) && !"false".equals(indent)) {
            this.doIndent = true;
        }
        this.returnFields = rsp.getReturnFields();
        if (req.getParams().getBool("omitHeader", false)) {
            rsp.removeResponseHeader();
        }
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.flushBuffer();
        }
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void indent() throws IOException {
        if (this.doIndent) {
            this.indent(this.level);
        }
    }

    public void indent(int lev) throws IOException {
        this.writer.write(indentChars, 0, Math.min((lev << 1) + 1, indentChars.length));
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int level() {
        return this.level;
    }

    public int incLevel() {
        return ++this.level;
    }

    public int decLevel() {
        return --this.level;
    }

    public void setIndent(boolean doIndent) {
        this.doIndent = doIndent;
    }

    public abstract void writeNamedList(String var1, NamedList var2) throws IOException;

    public final void writeVal(String name, Object val) throws IOException {
        if (val == null) {
            this.writeNull(name);
        } else if (val instanceof String) {
            this.writeStr(name, val.toString(), true);
        } else if (val instanceof IndexableField) {
            IndexableField f = (IndexableField)val;
            SchemaField sf = this.schema.getFieldOrNull(f.name());
            if (sf != null) {
                sf.getType().write(this, name, f);
            } else {
                this.writeStr(name, f.stringValue(), true);
            }
        } else if (val instanceof Number) {
            this.writeNumber(name, (Number)val);
        } else if (val instanceof Boolean) {
            this.writeBool(name, (Boolean)val);
        } else if (val instanceof AtomicBoolean) {
            this.writeBool(name, ((AtomicBoolean)val).get());
        } else if (val instanceof Date) {
            this.writeDate(name, (Date)val);
        } else if (val instanceof Document) {
            SolrDocument doc = DocsStreamer.convertLuceneDocToSolrDoc((Document)val, this.schema, this.returnFields);
            this.writeSolrDocument(name, doc, this.returnFields, 0);
        } else if (val instanceof SolrDocument) {
            this.writeSolrDocument(name, (SolrDocument)val, this.returnFields, 0);
        } else if (val instanceof ResultContext) {
            this.writeDocuments(name, (ResultContext)val);
        } else if (val instanceof DocList) {
            BasicResultContext ctx = new BasicResultContext((DocList)val, this.returnFields, null, null, this.req);
            this.writeDocuments(name, ctx);
        } else if (val instanceof SolrDocumentList) {
            this.writeSolrDocumentList(name, (SolrDocumentList)val, this.returnFields);
        } else if (val instanceof NamedList) {
            this.writeNamedList(name, (NamedList)val);
        } else if (val instanceof Path) {
            this.writeStr(name, ((Path)val).toAbsolutePath().toString(), true);
        } else if (val instanceof IteratorWriter) {
            this.writeIterator((IteratorWriter)val);
        } else if (val instanceof MapWriter) {
            this.writeMap((MapWriter)val);
        } else if (val instanceof MapSerializable) {
            this.writeMap(name, ((MapSerializable)val).toMap(new LinkedHashMap()), false, true);
        } else if (val instanceof Map) {
            this.writeMap(name, (Map)val, false, true);
        } else if (val instanceof Iterator) {
            this.writeArray(name, (Iterator)val);
        } else if (val instanceof Iterable) {
            this.writeArray(name, ((Iterable)val).iterator());
        } else if (val instanceof Object[]) {
            this.writeArray(name, (Object[])val);
        } else if (val instanceof byte[]) {
            byte[] arr = (byte[])val;
            this.writeByteArr(name, arr, 0, arr.length);
        } else if (val instanceof BytesRef) {
            BytesRef arr = (BytesRef)val;
            this.writeByteArr(name, arr.bytes, arr.offset, arr.length);
        } else if (val instanceof EnumFieldValue) {
            this.writeStr(name, val.toString(), true);
        } else if (val instanceof WriteableValue) {
            ((WriteableValue)val).write(name, this);
        } else {
            this.writeStr(name, val.getClass().getName() + ':' + val.toString(), true);
        }
    }

    public void writeMap(MapWriter mw) throws IOException {
    }

    public void writeIterator(IteratorWriter iw) throws IOException {
    }

    protected void writeBool(String name, Boolean val) throws IOException {
        this.writeBool(name, val.toString());
    }

    protected void writeNumber(String name, Number val) throws IOException {
        if (val instanceof Integer) {
            this.writeInt(name, val.toString());
        } else if (val instanceof Long) {
            this.writeLong(name, val.toString());
        } else if (val instanceof Float) {
            this.writeFloat(name, val.floatValue());
        } else if (val instanceof Double) {
            this.writeDouble(name, val.doubleValue());
        } else if (val instanceof Short) {
            this.writeInt(name, val.toString());
        } else if (val instanceof Byte) {
            this.writeInt(name, val.toString());
        } else if (val instanceof AtomicInteger) {
            this.writeInt(name, ((AtomicInteger)val).get());
        } else if (val instanceof AtomicLong) {
            this.writeLong(name, ((AtomicLong)val).get());
        } else {
            this.writeStr(name, val.getClass().getName() + ':' + val.toString(), true);
        }
    }

    public abstract void writeStartDocumentList(String var1, long var2, int var4, long var5, Float var7) throws IOException;

    public abstract void writeSolrDocument(String var1, SolrDocument var2, ReturnFields var3, int var4) throws IOException;

    public abstract void writeEndDocumentList() throws IOException;

    public final void writeSolrDocumentList(String name, SolrDocumentList docs, ReturnFields fields) throws IOException {
        this.writeStartDocumentList(name, docs.getStart(), docs.size(), docs.getNumFound(), docs.getMaxScore());
        for (int i = 0; i < docs.size(); ++i) {
            this.writeSolrDocument(null, (SolrDocument)docs.get(i), fields, i);
        }
        this.writeEndDocumentList();
    }

    public final void writeDocuments(String name, ResultContext res) throws IOException {
        DocList ids = res.getDocList();
        Iterator<SolrDocument> docsStreamer = res.getProcessedDocuments();
        this.writeStartDocumentList(name, ids.offset(), ids.size(), ids.matches(), res.wantsScores() ? new Float(ids.maxScore()) : null);
        int idx = 0;
        while (docsStreamer.hasNext()) {
            this.writeSolrDocument(null, docsStreamer.next(), res.getReturnFields(), idx);
            ++idx;
        }
        this.writeEndDocumentList();
    }

    public abstract void writeStr(String var1, String var2, boolean var3) throws IOException;

    public abstract void writeMap(String var1, Map var2, boolean var3, boolean var4) throws IOException;

    public void writeArray(String name, Object[] val) throws IOException {
        this.writeArray(name, Arrays.asList(val));
    }

    public void writeArray(String name, List l) throws IOException {
        this.writeArray(name, l.iterator());
    }

    public abstract void writeArray(String var1, Iterator var2) throws IOException;

    public abstract void writeNull(String var1) throws IOException;

    public abstract void writeInt(String var1, String var2) throws IOException;

    public void writeInt(String name, int val) throws IOException {
        this.writeInt(name, Integer.toString(val));
    }

    public abstract void writeLong(String var1, String var2) throws IOException;

    public void writeLong(String name, long val) throws IOException {
        this.writeLong(name, Long.toString(val));
    }

    public abstract void writeBool(String var1, String var2) throws IOException;

    public void writeBool(String name, boolean val) throws IOException {
        this.writeBool(name, Boolean.toString(val));
    }

    public abstract void writeFloat(String var1, String var2) throws IOException;

    public void writeFloat(String name, float val) throws IOException {
        String s = Float.toString(val);
        if (val > Float.NEGATIVE_INFINITY && val < Float.POSITIVE_INFINITY) {
            this.writeFloat(name, s);
        } else {
            this.writeStr(name, s, false);
        }
    }

    public abstract void writeDouble(String var1, String var2) throws IOException;

    public void writeDouble(String name, double val) throws IOException {
        String s = Double.toString(val);
        if (val > Double.NEGATIVE_INFINITY && val < Double.POSITIVE_INFINITY) {
            this.writeDouble(name, s);
        } else {
            this.writeStr(name, s, false);
        }
    }

    public void writeDate(String name, Date val) throws IOException {
        this.writeDate(name, val.toInstant().toString());
    }

    public abstract void writeDate(String var1, String var2) throws IOException;

    public void writeByteArr(String name, byte[] buf, int offset, int len) throws IOException {
        this.writeStr(name, Base64.byteArrayToBase64((byte[])buf, (int)offset, (int)len), false);
    }

    static {
        Arrays.fill(indentChars, ' ');
        TextResponseWriter.indentChars[0] = 10;
    }
}

