/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStreamImpl;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.spatial.composite.CompositeSpatialStrategy;
import org.apache.lucene.spatial.prefix.HeatmapFacetCounter;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.FacetComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.schema.AbstractSpatialPrefixTreeFieldType;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.RptWithGeometrySpatialField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SpatialRecursivePrefixTreeFieldType;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.DistanceUnits;
import org.apache.solr.util.SpatialUtils;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialHeatmapFacets {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String RESPONSE_KEY = "facet_heatmaps";
    public static final String FORMAT_PNG = "png";
    public static final String FORMAT_INTS2D = "ints2D";
    public static final double DEFAULT_DIST_ERR_PCT = 0.15;

    public static NamedList<Object> getHeatmapForField(String fieldKey, String fieldName, ResponseBuilder rb, SolrParams params, DocSet docSet) throws IOException {
        HeatmapFacetCounter.Heatmap heatmap;
        int gridLevel;
        DistanceUnits distanceUnits;
        PrefixTreeStrategy strategy;
        SchemaField schemaField = rb.req.getSchema().getField(fieldName);
        FieldType type = schemaField.getType();
        if (type instanceof AbstractSpatialPrefixTreeFieldType) {
            AbstractSpatialPrefixTreeFieldType rptType = (AbstractSpatialPrefixTreeFieldType)type;
            strategy = (PrefixTreeStrategy)rptType.getStrategy(fieldName);
            distanceUnits = rptType.getDistanceUnits();
        } else if (type instanceof RptWithGeometrySpatialField) {
            RptWithGeometrySpatialField rptSdvType = (RptWithGeometrySpatialField)type;
            strategy = ((CompositeSpatialStrategy)rptSdvType.getStrategy(fieldName)).getIndexStrategy();
            distanceUnits = rptSdvType.getDistanceUnits();
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "heatmap field needs to be of type " + SpatialRecursivePrefixTreeFieldType.class + " or " + RptWithGeometrySpatialField.class);
        }
        SpatialContext ctx = strategy.getSpatialContext();
        String geomStr = params.getFieldParam(fieldKey, "facet.heatmap.geom");
        Rectangle boundsShape = geomStr == null ? ctx.getWorldBounds() : SpatialUtils.parseGeomSolrException(geomStr, ctx);
        Integer gridLevelObj = params.getFieldInt(fieldKey, "facet.heatmap.gridLevel");
        int maxGridLevel = strategy.getGrid().getMaxLevels();
        if (gridLevelObj != null) {
            gridLevel = gridLevelObj;
            if (gridLevel <= 0 || gridLevel > maxGridLevel) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "facet.heatmap.gridLevel should be > 0 and <= " + maxGridLevel);
            }
        } else {
            SpatialArgs spatialArgs = new SpatialArgs(SpatialOperation.Intersects, (Shape)(boundsShape == null ? ctx.getWorldBounds() : boundsShape));
            Double distErrObj = params.getFieldDouble(fieldKey, "facet.heatmap.distErr");
            if (distErrObj != null) {
                spatialArgs.setDistErr(Double.valueOf(distErrObj * distanceUnits.multiplierFromThisUnitToDegrees()));
            }
            spatialArgs.setDistErrPct(params.getFieldDouble(fieldKey, "facet.heatmap.distErrPct"));
            double distErr = spatialArgs.resolveDistErr(ctx, 0.15);
            if (distErr <= 0.0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "facet.heatmap.distErrPct or facet.heatmap.distErr should be > 0 or instead provide facet.heatmap.gridLevel=" + maxGridLevel + " if you insist on maximum detail");
            }
            gridLevel = strategy.getGrid().getLevelForDistance(distErr);
        }
        try {
            heatmap = HeatmapFacetCounter.calcFacets((PrefixTreeStrategy)strategy, (IndexReaderContext)rb.req.getSearcher().getTopReaderContext(), (Bits)SpatialHeatmapFacets.getTopAcceptDocs(docSet, rb.req.getSearcher()), (Shape)boundsShape, (int)gridLevel, (int)params.getFieldInt(fieldKey, "facet.heatmap.maxCells", 100000));
        }
        catch (IllegalArgumentException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, e.toString(), (Throwable)e);
        }
        NamedList result = new NamedList();
        result.add("gridLevel", (Object)gridLevel);
        result.add("columns", (Object)heatmap.columns);
        result.add("rows", (Object)heatmap.rows);
        result.add("minX", (Object)heatmap.region.getMinX());
        result.add("maxX", (Object)heatmap.region.getMaxX());
        result.add("minY", (Object)heatmap.region.getMinY());
        result.add("maxY", (Object)heatmap.region.getMaxY());
        boolean hasNonZero = false;
        for (int count : heatmap.counts) {
            if (count <= 0) continue;
            hasNonZero = true;
            break;
        }
        SpatialHeatmapFacets.formatCountsAndAddToNL(fieldKey, rb, params, heatmap.columns, heatmap.rows, hasNonZero ? heatmap.counts : null, (NamedList<Object>)result);
        return result;
    }

    private static Bits getTopAcceptDocs(DocSet docSet, SolrIndexSearcher searcher) throws IOException {
        if (searcher.getLiveDocSet() == docSet) {
            return null;
        }
        if (docSet.size() == 0) {
            return new Bits.MatchNoBits(searcher.maxDoc());
        }
        if (docSet instanceof BitDocSet) {
            return ((BitDocSet)docSet).getBits();
        }
        FixedBitSet bits = new FixedBitSet(searcher.maxDoc());
        DocIterator iter = docSet.iterator();
        while (iter.hasNext()) {
            bits.set(iter.nextDoc());
        }
        return bits;
    }

    private static void formatCountsAndAddToNL(String fieldKey, ResponseBuilder rb, SolrParams params, int columns, int rows, int[] counts, NamedList<Object> result) {
        List<List<Integer>> countsVal;
        String format;
        switch (format = params.getFieldParam(fieldKey, "facet.heatmap.format", FORMAT_INTS2D)) {
            case "ints2D": {
                countsVal = counts != null ? SpatialHeatmapFacets.asInts2D(columns, rows, counts) : null;
                break;
            }
            case "png": {
                countsVal = counts != null ? (Object)SpatialHeatmapFacets.asPngBytes(columns, rows, counts, rb) : null;
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "format should be ints2D or png");
            }
        }
        result.add("counts_" + format, countsVal);
    }

    static List<List<Integer>> asInts2D(final int columns, final int rows, final int[] counts) {
        return new AbstractList<List<Integer>>(){

            @Override
            public List<Integer> get(int rowIdx) {
                boolean hasNonZero = false;
                final int y = rows - rowIdx - 1;
                for (int c = 0; c < columns; ++c) {
                    if (counts[c * rows + y] <= 0) continue;
                    hasNonZero = true;
                    break;
                }
                if (!hasNonZero) {
                    return null;
                }
                return new AbstractList<Integer>(){

                    @Override
                    public Integer get(int columnIdx) {
                        return counts[columnIdx * rows + y];
                    }

                    @Override
                    public int size() {
                        return columns;
                    }
                };
            }

            @Override
            public int size() {
                return rows;
            }
        };
    }

    static byte[] asPngBytes(int columns, int rows, int[] counts, ResponseBuilder rb) {
        long startTimeNano = System.nanoTime();
        BufferedImage image = PngHelper.newImage(columns, rows);
        for (int c = 0; c < columns; ++c) {
            for (int r = 0; r < rows; ++r) {
                PngHelper.writeCountAtColumnRow(image, rows, c, r, counts[c * rows + r]);
            }
        }
        byte[] bytes = PngHelper.writeImage(image);
        long durationMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNano);
        log.debug("heatmap nativeSize={} pngSize={} pngTime={}", new Object[]{counts.length * 4, bytes.length, durationMs});
        if (rb != null && rb.isDebugTimings()) {
            rb.addDebug(durationMs, "timing", "heatmap png generation");
        }
        return bytes;
    }

    public static LinkedHashMap<String, HeatmapFacet> distribParse(SolrParams params, ResponseBuilder rb) {
        LinkedHashMap<String, HeatmapFacet> heatmapFacets = new LinkedHashMap<String, HeatmapFacet>();
        String[] heatmapFields = params.getParams("facet.heatmap");
        if (heatmapFields != null) {
            for (String heatmapField : heatmapFields) {
                HeatmapFacet facet = new HeatmapFacet(rb, heatmapField);
                heatmapFacets.put(facet.getKey(), facet);
            }
        }
        return heatmapFacets;
    }

    public static void distribModifyRequest(ShardRequest sreq, LinkedHashMap<String, HeatmapFacet> heatmapFacets) {
        sreq.params.remove("facet.heatmap");
        for (HeatmapFacet facet : heatmapFacets.values()) {
            ModifiableSolrParams newLocalParams = new ModifiableSolrParams();
            if (facet.localParams != null) {
                newLocalParams.add(facet.localParams);
            }
            newLocalParams.set("facet.heatmap.format", new String[]{FORMAT_PNG});
            sreq.params.add("facet.heatmap", new String[]{newLocalParams.toLocalParamsString() + facet.facetOn});
        }
    }

    public static void distribHandleResponse(LinkedHashMap<String, HeatmapFacet> heatmapFacets, NamedList srsp_facet_counts) {
        NamedList facet_heatmaps = (NamedList)srsp_facet_counts.get(RESPONSE_KEY);
        if (facet_heatmaps == null) {
            return;
        }
        for (Map.Entry entry : facet_heatmaps) {
            String fieldKey = (String)entry.getKey();
            NamedList shardNamedList = (NamedList)entry.getValue();
            HeatmapFacet facet = heatmapFacets.get(fieldKey);
            if (facet == null) {
                log.error("received heatmap for field/key {} that we weren't expecting", (Object)fieldKey);
                continue;
            }
            facet.counts = SpatialHeatmapFacets.addPngToIntArray((byte[])shardNamedList.remove("counts_png"), facet.counts);
            if (facet.namedList == null) {
                facet.namedList = shardNamedList;
                continue;
            }
            assert (facet.namedList.equals((Object)shardNamedList));
        }
    }

    static int[] addPngToIntArray(byte[] pngBytes, int[] counts) {
        if (pngBytes == null) {
            return counts;
        }
        BufferedImage image = PngHelper.readImage(pngBytes);
        int columns = image.getWidth();
        int rows = image.getHeight();
        if (counts == null) {
            counts = new int[columns * rows];
        } else assert (counts.length == columns * rows);
        for (int c = 0; c < columns; ++c) {
            for (int r = 0; r < rows; ++r) {
                int n = c * rows + r;
                counts[n] = counts[n] + PngHelper.getCountAtColumnRow(image, rows, c, r);
            }
        }
        return counts;
    }

    public static NamedList distribFinish(LinkedHashMap<String, HeatmapFacet> heatmapInfos, ResponseBuilder rb) {
        SimpleOrderedMap result = new SimpleOrderedMap();
        for (Map.Entry<String, HeatmapFacet> entry : heatmapInfos.entrySet()) {
            HeatmapFacet facet = entry.getValue();
            NamedList<Object> namedList = facet.namedList;
            if (namedList == null) continue;
            SpatialHeatmapFacets.formatCountsAndAddToNL(entry.getKey(), rb, SolrParams.wrapDefaults((SolrParams)facet.localParams, (SolrParams)rb.req.getParams()), (Integer)namedList.get("columns"), (Integer)namedList.get("rows"), facet.counts, namedList);
            result.add(entry.getKey(), namedList);
        }
        return result;
    }

    static class PngHelper {
        static final ImageReaderSpi imageReaderSpi;

        PngHelper() {
        }

        static BufferedImage readImage(final byte[] bytes) {
            ImageInputStreamImpl imageInputStream = new ImageInputStreamImpl(){

                @Override
                public int read() throws IOException {
                    this.checkClosed();
                    this.bitOffset = 0;
                    if (this.streamPos >= (long)bytes.length) {
                        return -1;
                    }
                    return bytes[(int)this.streamPos++];
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    this.checkClosed();
                    this.bitOffset = 0;
                    if (this.streamPos >= (long)bytes.length) {
                        return -1;
                    }
                    int copyLen = Math.min(len, bytes.length - (int)this.streamPos);
                    System.arraycopy(bytes, (int)this.streamPos, b, off, copyLen);
                    this.streamPos += (long)copyLen;
                    return copyLen;
                }

                @Override
                public long length() {
                    return bytes.length;
                }

                @Override
                public boolean isCached() {
                    return true;
                }

                @Override
                public boolean isCachedMemory() {
                    return true;
                }
            };
            try {
                ImageReader imageReader = imageReaderSpi.createReaderInstance();
                imageReader.setInput(imageInputStream, false, true);
                return imageReader.read(0);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Problem reading png heatmap: " + e);
            }
        }

        static byte[] writeImage(BufferedImage image) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(image.getWidth() * image.getHeight() + 1024);
            try {
                ImageIO.write((RenderedImage)image, SpatialHeatmapFacets.FORMAT_PNG, baos);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "While generating PNG: " + e);
            }
            return baos.toByteArray();
        }

        static BufferedImage newImage(int columns, int rows) {
            return new BufferedImage(columns, rows, 6);
        }

        static void writeCountAtColumnRow(BufferedImage image, int rows, int c, int r, int val) {
            image.setRGB(c, rows - 1 - r, val ^ 0xFF000000);
        }

        static int getCountAtColumnRow(BufferedImage image, int rows, int c, int r) {
            return image.getRGB(c, rows - 1 - r) ^ 0xFF000000;
        }

        static {
            Iterator<ImageReader> imageReaders = ImageIO.getImageReadersByFormatName(SpatialHeatmapFacets.FORMAT_PNG);
            if (!imageReaders.hasNext()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't find png image reader, neaded for heatmaps!");
            }
            ImageReader imageReader = imageReaders.next();
            imageReaderSpi = imageReader.getOriginatingProvider();
        }
    }

    public static class HeatmapFacet
    extends FacetComponent.FacetBase {
        public NamedList<Object> namedList;
        public int[] counts;

        public HeatmapFacet(ResponseBuilder rb, String facetStr) {
            super(rb, "facet.heatmap", facetStr);
        }
    }
}

