/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.api.Api;
import org.apache.solr.api.ApiBag;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.LoggingHandler;
import org.apache.solr.handler.admin.PropertiesRequestHandler;
import org.apache.solr.handler.admin.SystemInfoHandler;
import org.apache.solr.handler.admin.ThreadDumpHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;

public class InfoHandler
extends RequestHandlerBase {
    protected final CoreContainer coreContainer;
    private Map<String, RequestHandlerBase> handlers = new ConcurrentHashMap<String, RequestHandlerBase>();

    public InfoHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
        this.handlers.put("threads", new ThreadDumpHandler());
        this.handlers.put("properties", new PropertiesRequestHandler());
        this.handlers.put("logging", new LoggingHandler(coreContainer));
        this.handlers.put("system", new SystemInfoHandler(coreContainer));
    }

    @Override
    public final void init(NamedList args) {
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        CoreContainer cores = this.getCoreContainer();
        if (cores == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        String path = (String)req.getContext().get("path");
        this.handle(req, rsp, path);
    }

    private void handle(SolrQueryRequest req, SolrQueryResponse rsp, String path) {
        int i = path.lastIndexOf(47);
        String name = path.substring(i + 1, path.length());
        RequestHandlerBase handler = this.handlers.get(name.toLowerCase(Locale.ROOT));
        if (handler == null) {
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "No handler by name " + name + " available names are " + this.handlers.keySet());
        }
        handler.handleRequest(req, rsp);
        rsp.setHttpCaching(false);
    }

    @Override
    public String getDescription() {
        return "System Information";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    protected PropertiesRequestHandler getPropertiesHandler() {
        return (PropertiesRequestHandler)this.handlers.get("properties");
    }

    protected ThreadDumpHandler getThreadDumpHandler() {
        return (ThreadDumpHandler)this.handlers.get("threads");
    }

    protected LoggingHandler getLoggingHandler() {
        return (LoggingHandler)this.handlers.get("logging");
    }

    protected SystemInfoHandler getSystemInfoHandler() {
        return (SystemInfoHandler)this.handlers.get("system");
    }

    protected void setPropertiesHandler(PropertiesRequestHandler propertiesHandler) {
        this.handlers.put("properties", propertiesHandler);
    }

    protected void setThreadDumpHandler(ThreadDumpHandler threadDumpHandler) {
        this.handlers.put("threads", threadDumpHandler);
    }

    protected void setLoggingHandler(LoggingHandler loggingHandler) {
        this.handlers.put("logging", loggingHandler);
    }

    protected void setSystemInfoHandler(SystemInfoHandler systemInfoHandler) {
        this.handlers.put("system", systemInfoHandler);
    }

    @Override
    public SolrRequestHandler getSubHandler(String subPath) {
        return this;
    }

    @Override
    public Collection<Api> getApis() {
        return Collections.singletonList(new ApiBag.ReqHandlerToApi(this, Utils.getSpec((String)"node.Info")));
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }
}

