/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.io.ModelCache;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.DaemonStream;
import org.apache.solr.client.solrj.io.stream.ExceptionStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.DefaultStreamFactory;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParser;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.AnalyzeEvaluator;
import org.apache.solr.handler.ClassifyStream;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamHandler
extends RequestHandlerBase
implements SolrCoreAware,
PermissionNameProvider {
    static SolrClientCache clientCache = new SolrClientCache();
    static ModelCache modelCache = null;
    private StreamFactory streamFactory = new DefaultStreamFactory();
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String coreName;
    private Map<String, DaemonStream> daemons = Collections.synchronizedMap(new HashMap());

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.READ_PERM;
    }

    public static SolrClientCache getClientCache() {
        return clientCache;
    }

    @Override
    public void inform(SolrCore core) {
        CoreContainer coreContainer = core.getCoreContainer();
        this.coreName = core.getName();
        if (coreContainer.isZooKeeperAware()) {
            String defaultCollection = core.getCoreDescriptor().getCollectionName();
            String defaultZkhost = core.getCoreContainer().getZkController().getZkServerAddress();
            this.streamFactory.withCollectionZkHost(defaultCollection, defaultZkhost);
            this.streamFactory.withDefaultZkHost(defaultZkhost);
            modelCache = new ModelCache(250, defaultZkhost, clientCache);
        }
        this.streamFactory.withFunctionName("analyze", AnalyzeEvaluator.class);
        this.streamFactory.withFunctionName("classify", ClassifyStream.class);
        List<PluginInfo> pluginInfos = core.getSolrConfig().getPluginInfos(Expressible.class.getName());
        for (PluginInfo pluginInfo : pluginInfos) {
            Class<Expressible> clazz = core.getMemClassLoader().findClass(pluginInfo.className, Expressible.class);
            this.streamFactory.withFunctionName(pluginInfo.name, clazz);
        }
        core.addCloseHook(new CloseHook(){

            @Override
            public void preClose(SolrCore core) {
            }

            @Override
            public void postClose(SolrCore core) {
                clientCache.close();
            }
        });
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        TupleStream tupleStream;
        SolrParams params = req.getParams();
        params = this.adjustParams(params);
        req.setParams(params);
        if (params.get("action") != null) {
            this.handleAdmin(req, rsp, params);
            return;
        }
        try {
            StreamExpression streamExpression = StreamExpressionParser.parse((String)params.get("expr"));
            if (this.streamFactory.isEvaluator(streamExpression)) {
                StreamExpression tupleExpression = new StreamExpression("tuple");
                tupleExpression.addParameter((StreamExpressionParameter)new StreamExpressionNamedParameter("return-value", (StreamExpressionParameter)streamExpression));
                tupleStream = this.streamFactory.constructStream(tupleExpression);
            } else {
                tupleStream = this.streamFactory.constructStream(streamExpression);
            }
        }
        catch (Exception e) {
            SolrException.log((Logger)logger, (Throwable)e);
            rsp.add("result-set", (Object)new DummyErrorStream(e));
            return;
        }
        int worker = params.getInt("workerID", 0);
        int numWorkers = params.getInt("numWorkers", 1);
        StreamContext context = new StreamContext();
        context.put((Object)"shards", this.getCollectionShards(params));
        context.workerID = worker;
        context.numWorkers = numWorkers;
        context.setSolrClientCache(clientCache);
        context.setModelCache(modelCache);
        context.put((Object)"core", (Object)this.coreName);
        context.put((Object)"solr-core", (Object)req.getCore());
        tupleStream.setStreamContext(context);
        if (params.getBool("explain", false)) {
            rsp.add("explanation", tupleStream.toExplanation(this.streamFactory));
        }
        if (tupleStream instanceof DaemonStream) {
            DaemonStream daemonStream = (DaemonStream)tupleStream;
            if (this.daemons.containsKey(daemonStream.getId())) {
                this.daemons.remove(daemonStream.getId()).close();
            }
            daemonStream.setDaemons(this.daemons);
            daemonStream.open();
            this.daemons.put(daemonStream.getId(), daemonStream);
            rsp.add("result-set", (Object)new DaemonResponseStream("Deamon:" + daemonStream.getId() + " started on " + this.coreName));
        } else {
            rsp.add("result-set", (Object)new TimerStream((TupleStream)new ExceptionStream(tupleStream)));
        }
    }

    private void handleAdmin(SolrQueryRequest req, SolrQueryResponse rsp, SolrParams params) {
        String action = params.get("action");
        if ("stop".equalsIgnoreCase(action)) {
            String id = params.get("id");
            DaemonStream d = this.daemons.get(id);
            if (d != null) {
                d.close();
                rsp.add("result-set", (Object)new DaemonResponseStream("Deamon:" + id + " stopped on " + this.coreName));
            } else {
                rsp.add("result-set", (Object)new DaemonResponseStream("Deamon:" + id + " not found on " + this.coreName));
            }
        } else if ("start".equalsIgnoreCase(action)) {
            String id = params.get("id");
            DaemonStream d = this.daemons.get(id);
            d.open();
            rsp.add("result-set", (Object)new DaemonResponseStream("Deamon:" + id + " started on " + this.coreName));
        } else if ("list".equalsIgnoreCase(action)) {
            Collection<DaemonStream> vals = this.daemons.values();
            rsp.add("result-set", (Object)new DaemonCollectionStream(vals));
        } else if ("kill".equalsIgnoreCase(action)) {
            String id = params.get("id");
            DaemonStream d = this.daemons.remove(id);
            if (d != null) {
                d.close();
            }
            rsp.add("result-set", (Object)new DaemonResponseStream("Deamon:" + id + " killed on " + this.coreName));
        }
    }

    private SolrParams adjustParams(SolrParams params) {
        ModifiableSolrParams adjustedParams = new ModifiableSolrParams();
        adjustedParams.add(params);
        adjustedParams.add("omitHeader", new String[]{"true"});
        return adjustedParams;
    }

    @Override
    public String getDescription() {
        return "StreamHandler";
    }

    public String getSource() {
        return null;
    }

    private Map<String, List<String>> getCollectionShards(SolrParams params) {
        HashMap<String, List<String>> collectionShards = new HashMap<String, List<String>>();
        Iterator paramsIt = params.getParameterNamesIterator();
        while (paramsIt.hasNext()) {
            String param = (String)paramsIt.next();
            if (param.indexOf(".shards") <= -1) continue;
            String collection = param.split("\\.")[0];
            String shardString = params.get(param);
            String[] shards = shardString.split(",");
            ArrayList<String> shardList = new ArrayList<String>();
            for (String shard : shards) {
                shardList.add(shard);
            }
            collectionShards.put(collection, shardList);
        }
        if (collectionShards.size() > 0) {
            return collectionShards;
        }
        return null;
    }

    public static class TimerStream
    extends TupleStream {
        private long begin;
        private TupleStream tupleStream;

        public TimerStream(TupleStream tupleStream) {
            this.tupleStream = tupleStream;
        }

        public StreamComparator getStreamSort() {
            return this.tupleStream.getStreamSort();
        }

        public void close() throws IOException {
            this.tupleStream.close();
        }

        public void open() throws IOException {
            this.begin = System.nanoTime();
            this.tupleStream.open();
        }

        public void setStreamContext(StreamContext context) {
            this.tupleStream.setStreamContext(context);
        }

        public List<TupleStream> children() {
            return this.tupleStream.children();
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName("timer").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-decorator").withExpression("--non-expressible--");
        }

        public Tuple read() throws IOException {
            Tuple tuple = this.tupleStream.read();
            if (tuple.EOF) {
                long totalTime = (System.nanoTime() - this.begin) / 1000000L;
                tuple.fields.put("RESPONSE_TIME", totalTime);
            }
            return tuple;
        }
    }

    public static class DaemonResponseStream
    extends TupleStream {
        private String message;
        private boolean sendEOF = false;

        public DaemonResponseStream(String message) {
            this.message = message;
        }

        public StreamComparator getStreamSort() {
            return null;
        }

        public void close() {
        }

        public void open() {
        }

        public void setStreamContext(StreamContext context) {
        }

        public List<TupleStream> children() {
            return null;
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName("daemon-response").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-decorator").withExpression("--non-expressible--");
        }

        public Tuple read() {
            if (this.sendEOF) {
                HashMap<String, Boolean> m = new HashMap<String, Boolean>();
                m.put("EOF", true);
                return new Tuple(m);
            }
            this.sendEOF = true;
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("DaemonOp", this.message);
            return new Tuple(m);
        }
    }

    public static class DaemonCollectionStream
    extends TupleStream {
        private Iterator<DaemonStream> it;

        public DaemonCollectionStream(Collection<DaemonStream> col) {
            this.it = col.iterator();
        }

        public StreamComparator getStreamSort() {
            return null;
        }

        public void close() {
        }

        public void open() {
        }

        public void setStreamContext(StreamContext context) {
        }

        public List<TupleStream> children() {
            return null;
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName("daemon-collection").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-decorator").withExpression("--non-expressible--");
        }

        public Tuple read() {
            if (this.it.hasNext()) {
                return this.it.next().getInfo();
            }
            HashMap<String, Boolean> m = new HashMap<String, Boolean>();
            m.put("EOF", true);
            return new Tuple(m);
        }
    }

    public static class DummyErrorStream
    extends TupleStream {
        private Exception e;

        public DummyErrorStream(Exception e) {
            this.e = e;
        }

        public StreamComparator getStreamSort() {
            return null;
        }

        public void close() {
        }

        public void open() {
        }

        public void setStreamContext(StreamContext context) {
        }

        public List<TupleStream> children() {
            return null;
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName("error").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-decorator").withExpression("--non-expressible--");
        }

        public Tuple read() {
            String msg = this.e.getMessage();
            for (Throwable t = this.e.getCause(); t != null; t = t.getCause()) {
                msg = t.getMessage();
            }
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("EOF", true);
            m.put("EXCEPTION", msg);
            return new Tuple(m);
        }
    }
}

