/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.AlreadyExistsException;
import org.apache.solr.client.solrj.cloud.autoscaling.BadVersionException;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventType;
import org.apache.solr.client.solrj.cloud.autoscaling.VersionedData;
import org.apache.solr.cloud.autoscaling.AutoScaling;
import org.apache.solr.cloud.autoscaling.TriggerAction;
import org.apache.solr.cloud.autoscaling.TriggerUtils;
import org.apache.solr.cloud.autoscaling.TriggerValidationException;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TriggerBase
implements AutoScaling.Trigger {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final String name;
    protected SolrCloudManager cloudManager;
    protected SolrResourceLoader loader;
    protected DistribStateManager stateManager;
    protected final Map<String, Object> properties = new HashMap<String, Object>();
    protected final Set<String> validProperties = new HashSet<String>();
    protected final Set<String> requiredProperties = new HashSet<String>();
    protected final TriggerEventType eventType;
    protected int waitForSecond;
    protected Map<String, Object> lastState;
    protected final AtomicReference<AutoScaling.TriggerEventProcessor> processorRef = new AtomicReference();
    protected List<TriggerAction> actions;
    protected boolean enabled;
    protected boolean isClosed;

    protected TriggerBase(TriggerEventType eventType, String name) {
        this.eventType = eventType;
        this.name = name;
        TriggerUtils.validProperties(this.validProperties, "name", "class", "event", "enabled", "waitFor", "actions");
    }

    @Override
    public void configure(SolrResourceLoader loader, SolrCloudManager cloudManager, Map<String, Object> properties) throws TriggerValidationException {
        this.cloudManager = cloudManager;
        this.loader = loader;
        this.stateManager = cloudManager.getDistribStateManager();
        if (properties != null) {
            this.properties.putAll(properties);
        }
        this.enabled = Boolean.parseBoolean(String.valueOf(this.properties.getOrDefault("enabled", "true")));
        this.waitForSecond = ((Number)this.properties.getOrDefault("waitFor", -1L)).intValue();
        List o = (List)properties.get("actions");
        if (o != null && !o.isEmpty()) {
            this.actions = new ArrayList<TriggerAction>(3);
            for (Map map : o) {
                TriggerAction action = null;
                try {
                    action = loader.newInstance((String)map.get("class"), TriggerAction.class);
                }
                catch (Exception e) {
                    throw new TriggerValidationException("action", "exception creating action " + map + ": " + e.toString());
                }
                action.configure(loader, cloudManager, map);
                this.actions.add(action);
            }
        } else {
            this.actions = Collections.emptyList();
        }
        HashMap<String, String> results = new HashMap<String, String>();
        TriggerUtils.checkProperties(this.properties, results, this.requiredProperties, this.validProperties);
        if (!results.isEmpty()) {
            throw new TriggerValidationException(this.name, results);
        }
    }

    @Override
    public void init() throws Exception {
        try {
            if (!this.stateManager.hasData("/autoscaling/triggerState")) {
                this.stateManager.makePath("/autoscaling/triggerState");
            }
        }
        catch (AlreadyExistsException alreadyExistsException) {
        }
        catch (IOException | InterruptedException | KeeperException e) {
            LOG.warn("Exception checking ZK path /autoscaling/triggerState", e);
            throw e;
        }
        for (TriggerAction action : this.actions) {
            action.init();
        }
    }

    @Override
    public void setProcessor(AutoScaling.TriggerEventProcessor processor) {
        this.processorRef.set(processor);
    }

    @Override
    public AutoScaling.TriggerEventProcessor getProcessor() {
        return this.processorRef.get();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TriggerEventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int getWaitForSecond() {
        return this.waitForSecond;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public List<TriggerAction> getActions() {
        return this.actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        TriggerBase triggerBase = this;
        synchronized (triggerBase) {
            return this.isClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        TriggerBase triggerBase = this;
        synchronized (triggerBase) {
            this.isClosed = true;
            IOUtils.closeWhileHandlingException(this.actions);
        }
    }

    public int hashCode() {
        return Objects.hash(this.name, this.properties);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            TriggerBase that = (TriggerBase)obj;
            return this.name.equals(that.name) && this.properties.equals(that.properties);
        }
        return false;
    }

    protected abstract Map<String, Object> getState();

    protected abstract void setState(Map<String, Object> var1);

    @Override
    public void saveState() {
        Map state = Utils.getDeepCopy(this.getState(), (int)10, (boolean)false, (boolean)true);
        if (this.lastState != null && this.lastState.equals(state)) {
            return;
        }
        byte[] data = Utils.toJSON((Object)state);
        String path = "/autoscaling/triggerState/" + this.getName();
        try {
            if (this.stateManager.hasData(path)) {
                this.stateManager.setData(path, data, -1);
            } else {
                this.stateManager.createData(path, data, CreateMode.PERSISTENT);
            }
            this.lastState = state;
        }
        catch (IOException | InterruptedException | AlreadyExistsException | BadVersionException | KeeperException e) {
            LOG.warn("Exception updating trigger state '" + path + "'", e);
        }
    }

    @Override
    public void restoreState() {
        byte[] data = null;
        String path = "/autoscaling/triggerState/" + this.getName();
        try {
            if (this.stateManager.hasData(path)) {
                VersionedData versionedData = this.stateManager.getData(path);
                data = versionedData.getData();
            }
        }
        catch (Exception e) {
            LOG.warn("Exception getting trigger state '" + path + "'", (Throwable)e);
        }
        if (data != null) {
            Map restoredState = (Map)Utils.fromJSON(data);
            restoredState = Utils.getDeepCopy((Map)restoredState, (int)10, (boolean)false, (boolean)true);
            this.setState(restoredState);
            this.lastState = restoredState;
        }
    }
}

