/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventType;
import org.apache.solr.cloud.autoscaling.AutoScaling;
import org.apache.solr.cloud.autoscaling.TriggerBase;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.common.SolrException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeAddedTrigger
extends TriggerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Set<String> lastLiveNodes = new HashSet<String>();
    private Map<String, Long> nodeNameVsTimeAdded = new HashMap<String, Long>();

    public NodeAddedTrigger(String name) {
        super(TriggerEventType.NODEADDED, name);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.lastLiveNodes = new HashSet<String>(this.cloudManager.getClusterStateProvider().getLiveNodes());
        log.debug("NodeAddedTrigger {} - Initial livenodes: {}", (Object)this.name, this.lastLiveNodes);
        log.debug("NodeAddedTrigger {} instantiated with properties: {}", (Object)this.name, (Object)this.properties);
        try {
            List added = this.stateManager.listData("/autoscaling/nodeAdded");
            added.forEach(n -> {
                if (this.lastLiveNodes.contains(n)) {
                    log.debug("Adding node from marker path: {}", n);
                    this.nodeNameVsTimeAdded.put((String)n, this.cloudManager.getTimeSource().getTimeNs());
                }
                this.removeMarker((String)n);
            });
        }
        catch (NoSuchElementException added) {
        }
        catch (Exception e) {
            log.warn("Exception retrieving nodeLost markers", (Throwable)e);
        }
    }

    @Override
    public void restoreState(AutoScaling.Trigger old) {
        NodeAddedTrigger that;
        assert (old.isClosed());
        if (old instanceof NodeAddedTrigger) {
            that = (NodeAddedTrigger)old;
            assert (this.name.equals(that.name));
        } else {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Unable to restore state from an unknown type of trigger");
        }
        this.lastLiveNodes.clear();
        this.lastLiveNodes.addAll(that.lastLiveNodes);
        this.nodeNameVsTimeAdded.clear();
        this.nodeNameVsTimeAdded.putAll(that.nodeNameVsTimeAdded);
    }

    @Override
    protected Map<String, Object> getState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("lastLiveNodes", this.lastLiveNodes);
        state.put("nodeNameVsTimeAdded", this.nodeNameVsTimeAdded);
        return state;
    }

    @Override
    protected void setState(Map<String, Object> state) {
        Map nodeNameVsTimeAdded;
        this.lastLiveNodes.clear();
        this.nodeNameVsTimeAdded.clear();
        Collection lastLiveNodes = (Collection)state.get("lastLiveNodes");
        if (lastLiveNodes != null) {
            this.lastLiveNodes.addAll(lastLiveNodes);
        }
        if ((nodeNameVsTimeAdded = (Map)state.get("nodeNameVsTimeAdded")) != null) {
            this.nodeNameVsTimeAdded.putAll(nodeNameVsTimeAdded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            NodeAddedTrigger nodeAddedTrigger = this;
            synchronized (nodeAddedTrigger) {
                if (this.isClosed) {
                    log.warn("NodeAddedTrigger ran but was already closed");
                    throw new RuntimeException("Trigger has been closed");
                }
            }
            log.debug("Running NodeAddedTrigger {}", (Object)this.name);
            HashSet newLiveNodes = new HashSet(this.cloudManager.getClusterStateProvider().getLiveNodes());
            log.debug("Found livenodes: {}", (Object)newLiveNodes.size());
            Set<String> trackingKeySet = this.nodeNameVsTimeAdded.keySet();
            trackingKeySet.retainAll(newLiveNodes);
            HashSet copyOfNew = new HashSet(newLiveNodes);
            copyOfNew.removeAll(this.lastLiveNodes);
            copyOfNew.forEach(n -> {
                long eventTime = this.cloudManager.getTimeSource().getTimeNs();
                log.debug("Tracking new node: {} at time {}", n, (Object)eventTime);
                this.nodeNameVsTimeAdded.put((String)n, eventTime);
            });
            ArrayList<String> nodeNames = new ArrayList<String>();
            ArrayList<Long> times = new ArrayList<Long>();
            for (Map.Entry<String, Long> entry : this.nodeNameVsTimeAdded.entrySet()) {
                String nodeName = entry.getKey();
                Long timeAdded = entry.getValue();
                long now = this.cloudManager.getTimeSource().getTimeNs();
                if (TimeUnit.SECONDS.convert(now - timeAdded, TimeUnit.NANOSECONDS) < (long)this.getWaitForSecond()) continue;
                nodeNames.add(nodeName);
                times.add(timeAdded);
            }
            AutoScaling.TriggerEventProcessor processor = (AutoScaling.TriggerEventProcessor)this.processorRef.get();
            if (!nodeNames.isEmpty()) {
                if (processor != null) {
                    log.debug("NodeAddedTrigger {} firing registered processor for nodes: {} added at times {}, now={}", new Object[]{this.name, nodeNames, times, this.cloudManager.getTimeSource().getTimeNs()});
                    if (processor.process(new NodeAddedEvent(this.getEventType(), this.getName(), times, nodeNames))) {
                        nodeNames.forEach(n -> {
                            this.nodeNameVsTimeAdded.remove(n);
                            this.removeMarker((String)n);
                        });
                    }
                } else {
                    nodeNames.forEach(n -> {
                        this.nodeNameVsTimeAdded.remove(n);
                        this.removeMarker((String)n);
                    });
                }
            }
            this.lastLiveNodes = new HashSet<String>(newLiveNodes);
        }
        catch (RuntimeException e) {
            log.error("Unexpected exception in NodeAddedTrigger", (Throwable)e);
        }
    }

    private void removeMarker(String nodeName) {
        String path = "/autoscaling/nodeAdded/" + nodeName;
        try {
            log.debug("NodeAddedTrigger {} - removing marker path: {}", (Object)this.name, (Object)path);
            if (this.stateManager.hasData(path)) {
                this.stateManager.removeData(path, -1);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (Exception e) {
            log.debug("Exception removing nodeAdded marker " + nodeName, (Throwable)e);
        }
    }

    public static class NodeAddedEvent
    extends TriggerEvent {
        public NodeAddedEvent(TriggerEventType eventType, String source, List<Long> times, List<String> nodeNames) {
            super(eventType, source, times.get(0), null);
            this.properties.put("nodeNames", nodeNames);
            this.properties.put("eventTimes", times);
        }
    }
}

