/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkSyncTool {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, String> env;

    public ZkSyncTool(Map<String, String> env) {
        this.env = env;
    }

    public static void main(String[] args) {
        ZkSyncTool tool = new ZkSyncTool(System.getenv());
        try {
            tool.sync();
            System.exit(0);
        }
        catch (Exception e) {
            log.error("Unexpected exception " + e.getLocalizedMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    public void sync() throws Exception {
        String solrZkEnsemble = Objects.requireNonNull(this.env.get("SOLR_ZK_ENSEMBLE"), "Please specify SOLR_ZK_ENSEMBLE environment variable");
        String solrSecConfigFile = Objects.requireNonNull(this.env.get("SOLR_SEC_CONFIG_FILE"), "Please specify SOLR_SEC_CONFIG_FILE environment variable");
        String secureZk = this.env.get("SECURE_ZNODE");
        if (secureZk != null) {
            String jaasConf = Objects.requireNonNull(this.env.get("SOLR_AUTHENTICATION_JAAS_CONF"), "Please specify SOLR_AUTHENTICATION_JAAS_CONF environment variable");
            System.setProperty("zkACLProvider", "org.apache.solr.common.cloud.SaslZkACLProvider");
            System.setProperty("java.security.auth.login.config", jaasConf);
        }
        try (SolrZkClient zkClient = new SolrZkClient(solrZkEnsemble, 30000, 30000);){
            String authType = this.env.get("SOLR_AUTHENTICATION_TYPE");
            if (authType != null) {
                Path securityJsonPath = Paths.get(solrSecConfigFile, new String[0]);
                byte[] securityConf = Files.readAllBytes(securityJsonPath);
                Map securityConfigMap = (Map)Utils.fromJSON((byte[])securityConf);
                this.prepareSecurityJson(securityConfigMap);
                boolean sentryFileProviderEnabled = Boolean.parseBoolean(this.env.get("SOLR_SENTRY_ENABLED"));
                boolean sentryServiceEnabled = Boolean.parseBoolean(this.env.get("SOLR_SENTRY_SERVICE_ENABLED"));
                if (!sentryFileProviderEnabled && !sentryServiceEnabled) {
                    log.info("Sentry is not enabled for SOLR. Hence removing the authorization section in security.json");
                    securityConfigMap.remove("authorization");
                }
                this.updateConfig(zkClient, "/security.json", securityConfigMap);
            } else {
                this.deleteConfig(zkClient, "/security.json");
            }
        }
    }

    private void prepareSecurityJson(Map securityConfig) {
        String solrZkEnsemble;
        String[] zkPath;
        String[] proxyUsers;
        Map authConfig = (Map)securityConfig.get("authentication");
        Map authConfigDefaults = authConfig.getOrDefault("defaultConfigs", new HashMap());
        Map proxyUserConfigs = authConfig.getOrDefault("proxyUserConfigs", new HashMap());
        String proxyUsersStr = this.env.getOrDefault("SOLR_SECURITY_ALLOWED_PROXYUSERS", "");
        for (String proxyUser : proxyUsers = proxyUsersStr.split(",")) {
            String groupsConfig;
            String hostsConfig = this.env.get("SOLR_SECURITY_PROXYUSER_" + proxyUser + "_HOSTS");
            if (hostsConfig != null) {
                proxyUserConfigs.put("proxyuser." + proxyUser + ".hosts", hostsConfig);
            }
            if ((groupsConfig = this.env.get("SOLR_SECURITY_PROXYUSER_" + proxyUser + "_GROUPS")) == null) continue;
            proxyUserConfigs.put("proxyuser." + proxyUser + ".groups", groupsConfig);
        }
        String superUser = this.env.getOrDefault("SOLR_AUTHORIZATION_SUPERUSER", "solr");
        if (!proxyUserConfigs.containsKey("proxyuser." + superUser + ".groups") && !proxyUserConfigs.containsKey("proxyuser." + superUser + ".hosts")) {
            proxyUserConfigs.put("proxyuser." + superUser + ".groups", "*");
            proxyUserConfigs.put("proxyuser." + superUser + ".hosts", "*");
        }
        if ((zkPath = (solrZkEnsemble = this.env.get("SOLR_ZK_ENSEMBLE")).split("/", 2)) != null && zkPath.length > 1) {
            String path = zkPath[1].concat("/security/zkdtsm").replace("//", "/");
            authConfigDefaults.put("zk-dt-secret-manager.znodeWorkingPath", path);
        }
        authConfig.put("proxyUserConfigs", proxyUserConfigs);
        authConfig.put("defaultConfigs", authConfigDefaults);
    }

    private void updateConfig(SolrZkClient zkClient, String zkPath, Object proposedConfig) throws KeeperException, InterruptedException {
        boolean done = false;
        while (!done) {
            Stat s = new Stat();
            try {
                if (zkClient.exists(zkPath, true).booleanValue()) {
                    Object currentConfig = Utils.fromJSON((byte[])zkClient.getData(zkPath, null, s, true));
                    if (!Objects.deepEquals(currentConfig, proposedConfig)) {
                        log.info("The current configuration at ZK path {} is different than the proposed configuration. Sync is necessary.", (Object)zkPath);
                        zkClient.setData(zkPath, Utils.toJSON((Object)proposedConfig), s.getVersion(), true);
                    }
                } else {
                    log.info("Configuration missing at path {}. Sync is necessary.", (Object)zkPath);
                    zkClient.create(zkPath, Utils.toJSON((Object)proposedConfig), CreateMode.PERSISTENT, true);
                }
                done = true;
            }
            catch (KeeperException.BadVersionException | KeeperException.NodeExistsException e) {
                log.info("Unable to sync the configuration to Zk due to {}. Retrying...", (Object)e.getLocalizedMessage());
            }
        }
    }

    private void deleteConfig(SolrZkClient zkClient, String zkPath) throws KeeperException, InterruptedException {
        while (zkClient.exists(zkPath, true).booleanValue()) {
            try {
                zkClient.delete(zkPath, -1, true);
                log.info("Configuration at ZK path {} is deleted.", (Object)zkPath);
            }
            catch (KeeperException.NoNodeException noNodeException) {}
        }
    }
}

