/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.model.kafka.validator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.sentry.core.common.utils.SentryConstants;
import org.apache.sentry.core.common.validator.PrivilegeValidator;
import org.apache.sentry.core.common.validator.PrivilegeValidatorContext;
import org.apache.sentry.core.model.kafka.Host;
import org.apache.sentry.core.model.kafka.KafkaActionFactory;
import org.apache.sentry.core.model.kafka.KafkaAuthorizable;
import org.apache.sentry.core.model.kafka.KafkaModelAuthorizables;
import org.apache.shiro.config.ConfigurationException;

public class KafkaPrivilegeValidator
implements PrivilegeValidator {
    public static final String KafkaPrivilegeHelpMsg = "Invalid Kafka privilege. Kafka privilege must be of the form host=<HOST>-><RESOURCE>=<RESOURCE_NAME>->action=<ACTION>, where <HOST> can be '*' or any valid host name, <RESOURCE> can be one of " + Arrays.toString((Object[])KafkaPrivilegeValidator.getKafkaAuthorizablesExceptHost()) + " <RESOURCE_NAME> is name of the resource, <ACTION> can be one of " + Arrays.toString((Object[])KafkaActionFactory.KafkaActionType.values()) + ".";

    private static KafkaAuthorizable.AuthorizableType[] getKafkaAuthorizablesExceptHost() {
        KafkaAuthorizable.AuthorizableType[] authorizableTypes = KafkaAuthorizable.AuthorizableType.values();
        ArrayList<KafkaAuthorizable.AuthorizableType> authorizableTypesWithoutHost = new ArrayList<KafkaAuthorizable.AuthorizableType>(authorizableTypes.length - 1);
        for (KafkaAuthorizable.AuthorizableType authorizableType : authorizableTypes) {
            if (authorizableType.equals((Object)KafkaAuthorizable.AuthorizableType.HOST)) continue;
            authorizableTypesWithoutHost.add(authorizableType);
        }
        return authorizableTypesWithoutHost.toArray(new KafkaAuthorizable.AuthorizableType[authorizableTypesWithoutHost.size()]);
    }

    public void validate(PrivilegeValidatorContext context) throws ConfigurationException {
        ArrayList splits = Lists.newArrayList();
        for (String section : SentryConstants.AUTHORIZABLE_SPLITTER.split((CharSequence)context.getPrivilege())) {
            splits.add(section);
        }
        if (splits.size() < 2 || splits.size() > 3) {
            throw new ConfigurationException(KafkaPrivilegeHelpMsg);
        }
        if (this.isAction((String)splits.get(0))) {
            throw new ConfigurationException("Kafka privilege can not start with an action.\n" + KafkaPrivilegeHelpMsg);
        }
        KafkaAuthorizable hostAuthorizable = KafkaModelAuthorizables.from((String)splits.get(0));
        if (hostAuthorizable == null) {
            throw new ConfigurationException("No Kafka authorizable found for " + (String)splits.get(0) + "\n." + KafkaPrivilegeHelpMsg);
        }
        if (!(hostAuthorizable instanceof Host)) {
            throw new ConfigurationException("Kafka privilege must begin with host authorizable.\n" + KafkaPrivilegeHelpMsg);
        }
        if (splits.size() == 3) {
            if (this.isAction((String)splits.get(1))) {
                throw new ConfigurationException("Kafka privilege can have action only at the end of privilege.\n" + KafkaPrivilegeHelpMsg);
            }
            KafkaAuthorizable authorizable = KafkaModelAuthorizables.from((String)splits.get(1));
            if (authorizable == null) {
                throw new ConfigurationException("No Kafka authorizable found for " + (String)splits.get(1) + "\n." + KafkaPrivilegeHelpMsg);
            }
            if (authorizable instanceof Host) {
                throw new ConfigurationException("Host authorizable can be specified just once in a Kafka privilege.\n" + KafkaPrivilegeHelpMsg);
            }
        }
        if (!this.isAction((String)splits.get(splits.size() - 1))) {
            throw new ConfigurationException("Kafka privilege must end with a valid action.\n" + KafkaPrivilegeHelpMsg);
        }
    }

    private boolean isAction(String privilegePart) {
        String privilege = privilegePart.toLowerCase();
        String action = privilege.replace(SentryConstants.PRIVILEGE_PREFIX, "").toLowerCase();
        return privilege.startsWith(SentryConstants.PRIVILEGE_PREFIX) && KafkaActionFactory.getInstance().getActionByName(action) != null;
    }
}

