/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.kafka.binding;

import com.google.common.base.Strings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.sentry.kafka.binding.KafkaAuthBinding;
import org.apache.sentry.kafka.conf.KafkaAuthConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaAuthBindingSingleton {
    private static Logger log = LoggerFactory.getLogger(KafkaAuthBindingSingleton.class);
    private static KafkaAuthConf kafkaAuthConf = null;
    private KafkaAuthBinding binding;

    private KafkaAuthBindingSingleton() {
    }

    private KafkaAuthConf loadAuthzConf(String sentry_site) {
        if (Strings.isNullOrEmpty((String)sentry_site)) {
            throw new IllegalArgumentException("Configuration key sentry.kafka.site.url value '" + sentry_site + "' is invalid.");
        }
        KafkaAuthConf kafkaAuthConf = null;
        try {
            kafkaAuthConf = new KafkaAuthConf(new URL(sentry_site));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Configuration key sentry.kafka.site.url specifies a malformed URL '" + sentry_site + "'", e);
        }
        return kafkaAuthConf;
    }

    public void configure(String instanceName, String requestorName, String sentry_site, Map<String, ?> kafkaConfigs) {
        try {
            kafkaAuthConf = this.loadAuthzConf(sentry_site);
            this.binding = new KafkaAuthBinding(instanceName, requestorName, kafkaAuthConf, kafkaConfigs);
            log.info("KafkaAuthBinding created successfully");
        }
        catch (Exception ex) {
            log.error("Unable to create KafkaAuthBinding", (Throwable)ex);
            throw new RuntimeException("Unable to create KafkaAuthBinding: " + ex.getMessage(), ex);
        }
    }

    public static KafkaAuthBindingSingleton getInstance() {
        return KafkaAuthBindingSingletonHolder.instance;
    }

    public KafkaAuthBinding getAuthBinding() {
        if (this.binding == null) {
            throw new RuntimeException("KafkaAuthBindingSingleton not configured yet.");
        }
        return this.binding;
    }

    public KafkaAuthConf getKafkaAuthConf() {
        if (this.binding == null) {
            throw new RuntimeException("KafkaAuthBindingSingleton not configured yet.");
        }
        return kafkaAuthConf;
    }

    private static class KafkaAuthBindingSingletonHolder {
        static final KafkaAuthBindingSingleton instance = new KafkaAuthBindingSingleton();

        private KafkaAuthBindingSingletonHolder() {
        }
    }
}

