/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.kafka.binding;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Allow;
import kafka.security.auth.Allow$;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Resource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.sentry.api.generic.thrift.SentryGenericServiceClient;
import org.apache.sentry.api.generic.thrift.SentryGenericServiceClientFactory;
import org.apache.sentry.api.generic.thrift.TAuthorizable;
import org.apache.sentry.api.generic.thrift.TSentryPrivilege;
import org.apache.sentry.api.generic.thrift.TSentryRole;
import org.apache.sentry.api.tools.GenericPrivilegeConverter;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.Model;
import org.apache.sentry.core.common.Subject;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.core.model.kafka.KafkaActionFactory;
import org.apache.sentry.core.model.kafka.KafkaAuthorizable;
import org.apache.sentry.core.model.kafka.KafkaPrivilegeModel;
import org.apache.sentry.kafka.ConvertUtil;
import org.apache.sentry.kafka.conf.KafkaAuthConf;
import org.apache.sentry.policy.common.PolicyEngine;
import org.apache.sentry.provider.common.AuthorizationProvider;
import org.apache.sentry.provider.common.ProviderBackend;
import org.apache.sentry.provider.common.ProviderBackendContext;
import org.apache.sentry.provider.db.generic.SentryGenericProviderBackend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Predef;
import scala.collection.JavaConversions;
import scala.collection.JavaConverters;
import scala.collection.immutable.HashSet;

public class KafkaAuthBinding {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaAuthBinding.class);
    private static final String COMPONENT_TYPE = "kafka";
    private static final String COMPONENT_NAME = "kafka";
    private static Boolean kerberosInit;
    private final Configuration authConf;
    private final AuthorizationProvider authProvider;
    private final KafkaActionFactory actionFactory = KafkaActionFactory.getInstance();
    private ProviderBackend providerBackend;
    private String instanceName;
    private String requestorName;
    private Map<String, ?> kafkaConfigs;

    public KafkaAuthBinding(String instanceName, String requestorName, Configuration authConf, Map<String, ?> kafkaConfigs) throws Exception {
        this.instanceName = instanceName;
        this.requestorName = requestorName;
        this.authConf = authConf;
        this.kafkaConfigs = kafkaConfigs;
        this.authProvider = this.createAuthProvider();
    }

    private AuthorizationProvider createAuthProvider() throws Exception {
        String enableCaching;
        String authProviderName = this.authConf.get(KafkaAuthConf.AuthzConfVars.AUTHZ_PROVIDER.getVar(), KafkaAuthConf.AuthzConfVars.AUTHZ_PROVIDER.getDefault());
        String resourceName = this.authConf.get(KafkaAuthConf.AuthzConfVars.AUTHZ_PROVIDER_RESOURCE.getVar(), KafkaAuthConf.AuthzConfVars.AUTHZ_PROVIDER_RESOURCE.getDefault());
        String providerBackendName = this.authConf.get(KafkaAuthConf.AuthzConfVars.AUTHZ_PROVIDER_BACKEND.getVar(), KafkaAuthConf.AuthzConfVars.AUTHZ_PROVIDER_BACKEND.getDefault());
        String policyEngineName = this.authConf.get(KafkaAuthConf.AuthzConfVars.AUTHZ_POLICY_ENGINE.getVar(), KafkaAuthConf.AuthzConfVars.AUTHZ_POLICY_ENGINE.getDefault());
        if (resourceName != null && resourceName.startsWith("classpath:")) {
            String resourceFileName = resourceName.substring("classpath:".length());
            resourceName = AuthorizationProvider.class.getClassLoader().getResource(resourceFileName).getPath();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using authorization provider " + authProviderName + " with resource " + resourceName + ", policy engine " + policyEngineName + ", provider backend " + providerBackendName);
        }
        if ("kerberos".equals(this.authConf.get("sentry.service.security.mode")) && this.kafkaConfigs != null) {
            String keytabProp = this.kafkaConfigs.get(KafkaAuthConf.AuthzConfVars.AUTHZ_KEYTAB_FILE_NAME.getVar()).toString();
            String principalProp = this.kafkaConfigs.get(KafkaAuthConf.AuthzConfVars.AUTHZ_PRINCIPAL_NAME.getVar()).toString();
            if (keytabProp != null && principalProp != null) {
                String actualHost = this.kafkaConfigs.get(KafkaAuthConf.AuthzConfVars.AUTHZ_PRINCIPAL_HOSTNAME.getVar()).toString();
                if (actualHost != null) {
                    principalProp = SecurityUtil.getServerPrincipal((String)principalProp, (String)actualHost);
                }
                this.initKerberos(keytabProp, principalProp);
            } else {
                LOG.debug("Could not initialize Kerberos.\n" + KafkaAuthConf.AuthzConfVars.AUTHZ_KEYTAB_FILE_NAME.getVar() + " set to " + this.kafkaConfigs.get(KafkaAuthConf.AuthzConfVars.AUTHZ_KEYTAB_FILE_NAME.getVar()).toString() + "\n" + KafkaAuthConf.AuthzConfVars.AUTHZ_PRINCIPAL_NAME.getVar() + " set to " + this.kafkaConfigs.get(KafkaAuthConf.AuthzConfVars.AUTHZ_PRINCIPAL_NAME.getVar()).toString());
            }
        } else {
            LOG.debug("Could not initialize Kerberos as no kafka config provided. " + KafkaAuthConf.AuthzConfVars.AUTHZ_KEYTAB_FILE_NAME.getVar() + " and " + KafkaAuthConf.AuthzConfVars.AUTHZ_PRINCIPAL_NAME.getVar() + " are required configs to be able to initialize Kerberos");
        }
        Object enableCachingConfig = this.kafkaConfigs.get(KafkaAuthConf.AuthzConfVars.AUTHZ_CACHING_ENABLE_NAME.getVar());
        if (enableCachingConfig != null && Boolean.parseBoolean(enableCaching = enableCachingConfig.toString())) {
            Object cacheUpdateFailuresCountConfig;
            this.authConf.set("sentry.provider.backend.generic.cache.enabled", enableCaching);
            Object cacheTtlMsConfig = this.kafkaConfigs.get(KafkaAuthConf.AuthzConfVars.AUTHZ_CACHING_TTL_MS_NAME.getVar());
            if (cacheTtlMsConfig != null) {
                this.authConf.set("sentry.provider.backend.generic.cache.ttl.ms", cacheTtlMsConfig.toString());
            }
            if ((cacheUpdateFailuresCountConfig = this.kafkaConfigs.get(KafkaAuthConf.AuthzConfVars.AUTHZ_CACHING_UPDATE_FAILURES_COUNT_NAME.getVar())) != null) {
                this.authConf.set("sentry.provider.backend.generic.cache.update.failures.count", cacheUpdateFailuresCountConfig.toString());
            }
            if (this.authConf.get("sentry.provider.backend.generic.privilege.converter") == null) {
                this.authConf.set("sentry.provider.backend.generic.privilege.converter", GenericPrivilegeConverter.class.getName());
            }
        }
        Constructor<?> providerBackendConstructor = Class.forName(providerBackendName).getDeclaredConstructor(Configuration.class, String.class);
        providerBackendConstructor.setAccessible(true);
        this.providerBackend = (ProviderBackend)providerBackendConstructor.newInstance(this.authConf, resourceName);
        if (this.providerBackend instanceof SentryGenericProviderBackend) {
            ((SentryGenericProviderBackend)this.providerBackend).setComponentType("kafka");
            ((SentryGenericProviderBackend)this.providerBackend).setServiceName(this.instanceName);
        }
        ProviderBackendContext context = new ProviderBackendContext();
        context.setAllowPerDatabase(false);
        context.setValidators(KafkaPrivilegeModel.getInstance().getPrivilegeValidators());
        this.providerBackend.initialize(context);
        Constructor<?> policyConstructor = Class.forName(policyEngineName).getDeclaredConstructor(ProviderBackend.class);
        policyConstructor.setAccessible(true);
        PolicyEngine policyEngine = (PolicyEngine)policyConstructor.newInstance(this.providerBackend);
        Constructor<?> constructor = Class.forName(authProviderName).getDeclaredConstructor(Configuration.class, String.class, PolicyEngine.class, Model.class);
        constructor.setAccessible(true);
        return (AuthorizationProvider)constructor.newInstance(this.authConf, resourceName, policyEngine, KafkaPrivilegeModel.getInstance());
    }

    public boolean authorize(RequestChannel.Session session, Operation operation, Resource resource) {
        List<Authorizable> authorizables = ConvertUtil.convertResourceToAuthorizable(session.clientAddress().getHostAddress(), resource);
        java.util.HashSet actions = Sets.newHashSet((Object[])new KafkaActionFactory.KafkaAction[]{this.actionFactory.getActionByName(operation.name())});
        return this.authProvider.hasAccess(new Subject(this.getName(session)), authorizables, (Set)actions, ActiveRoleSet.ALL);
    }

    public void addAcls(scala.collection.immutable.Set<Acl> acls, final Resource resource) {
        this.verifyAcls(acls);
        LOG.info("Adding Acl: acl->" + acls + " resource->" + resource);
        for (final Acl acl : acls) {
            final String role = this.getRole(acl);
            if (!this.roleExists(role)) {
                throw new KafkaException("Can not add Acl for non-existent Role: " + role);
            }
            this.execute(new Command<Void>(){

                @Override
                public Void run(SentryGenericServiceClient client) throws Exception {
                    client.grantPrivilege(KafkaAuthBinding.this.requestorName, role, "kafka", KafkaAuthBinding.this.toTSentryPrivilege(acl, resource));
                    return null;
                }
            });
        }
    }

    public boolean removeAcls(scala.collection.immutable.Set<Acl> acls, final Resource resource) {
        this.verifyAcls(acls);
        LOG.info("Removing Acl: acl->" + acls + " resource->" + resource);
        for (final Acl acl : acls) {
            final String role = this.getRole(acl);
            try {
                this.execute(new Command<Void>(){

                    @Override
                    public Void run(SentryGenericServiceClient client) throws Exception {
                        client.dropPrivilege(KafkaAuthBinding.this.requestorName, role, KafkaAuthBinding.this.toTSentryPrivilege(acl, resource));
                        return null;
                    }
                });
            }
            catch (KafkaException kex) {
                LOG.error("Failed to remove acls.", (Throwable)kex);
                return false;
            }
        }
        return true;
    }

    public void addRole(final String role) {
        if (this.roleExists(role)) {
            throw new KafkaException("Can not create an existing role, " + role + ", again.");
        }
        this.execute(new Command<Void>(){

            @Override
            public Void run(SentryGenericServiceClient client) throws Exception {
                client.createRole(KafkaAuthBinding.this.requestorName, role, "kafka");
                return null;
            }
        });
    }

    public void addRoleToGroups(final String role, final Set<String> groups) {
        this.execute(new Command<Void>(){

            @Override
            public Void run(SentryGenericServiceClient client) throws Exception {
                client.grantRoleToGroups(KafkaAuthBinding.this.requestorName, role, "kafka", groups);
                return null;
            }
        });
    }

    public void dropAllRoles() {
        final List<String> roles = this.getAllRoles();
        this.execute(new Command<Void>(){

            @Override
            public Void run(SentryGenericServiceClient client) throws Exception {
                for (String role : roles) {
                    client.dropRole(KafkaAuthBinding.this.requestorName, role, "kafka");
                }
                return null;
            }
        });
    }

    private List<String> getRolesforGroup(final String groupName) {
        final ArrayList<String> roles = new ArrayList<String>();
        this.execute(new Command<Void>(){

            @Override
            public Void run(SentryGenericServiceClient client) throws Exception {
                for (TSentryRole tSentryRole : client.listRolesByGroupName(KafkaAuthBinding.this.requestorName, groupName, "kafka")) {
                    roles.add(tSentryRole.getRoleName());
                }
                return null;
            }
        });
        return roles;
    }

    private SentryGenericServiceClient getClient() throws Exception {
        return SentryGenericServiceClientFactory.create((Configuration)this.authConf);
    }

    public boolean removeAcls(final Resource resource) {
        LOG.info("Removing Acls for Resource: resource->" + resource);
        List<String> roles = this.getAllRoles();
        final List<TSentryPrivilege> tSentryPrivileges = this.getAllPrivileges(roles);
        try {
            this.execute(new Command<Void>(){

                @Override
                public Void run(SentryGenericServiceClient client) throws Exception {
                    for (TSentryPrivilege tSentryPrivilege : tSentryPrivileges) {
                        if (!KafkaAuthBinding.this.isPrivilegeForResource(tSentryPrivilege, resource)) continue;
                        client.dropPrivilege(KafkaAuthBinding.this.requestorName, "kafka", tSentryPrivilege);
                    }
                    return null;
                }
            });
        }
        catch (KafkaException kex) {
            LOG.error("Failed to remove acls.", (Throwable)kex);
            return false;
        }
        return true;
    }

    public scala.collection.immutable.Set<Acl> getAcls(Resource resource) {
        Option acls = this.getAcls().get((Object)resource);
        if (acls.nonEmpty()) {
            return (scala.collection.immutable.Set)acls.get();
        }
        return new HashSet();
    }

    public scala.collection.immutable.Map<Resource, scala.collection.immutable.Set<Acl>> getAcls(KafkaPrincipal principal) {
        if (principal.getPrincipalType().toLowerCase().equals("group")) {
            List<String> roles = this.getRolesforGroup(principal.getName());
            return this.getAclsForRoles(roles);
        }
        LOG.info("Did not recognize Principal type: " + principal.getPrincipalType() + ". Returning Acls for all principals.");
        return this.getAcls();
    }

    public scala.collection.immutable.Map<Resource, scala.collection.immutable.Set<Acl>> getAcls() {
        List<String> roles = this.getAllRoles();
        return this.getAclsForRoles(roles);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T execute(Command<T> cmd) throws KafkaException {
        try (SentryGenericServiceClient client = this.getClient();){
            T t = cmd.run(client);
            return t;
        }
        catch (SentryUserException ex) {
            String msg = "Unable to excute command on sentry server: " + ex.getMessage();
            LOG.error(msg, (Throwable)ex);
            throw new KafkaException(msg, (Throwable)ex);
        }
        catch (Exception ex) {
            String msg = "Unable to obtain client:" + ex.getMessage();
            LOG.error(msg, (Throwable)ex);
            throw new KafkaException(msg, (Throwable)ex);
        }
    }

    private TSentryPrivilege toTSentryPrivilege(Acl acl, Resource resource) {
        List<Authorizable> authorizables = ConvertUtil.convertResourceToAuthorizable(acl.host(), resource);
        ArrayList<TAuthorizable> tAuthorizables = new ArrayList<TAuthorizable>();
        for (Authorizable authorizable : authorizables) {
            tAuthorizables.add(new TAuthorizable(authorizable.getTypeName(), authorizable.getName()));
        }
        TSentryPrivilege tSentryPrivilege = new TSentryPrivilege("kafka", this.instanceName, tAuthorizables, acl.operation().name());
        return tSentryPrivilege;
    }

    private String getRole(Acl acl) {
        return acl.principal().getName();
    }

    private boolean isPrivilegeForResource(TSentryPrivilege tSentryPrivilege, Resource resource) {
        Iterator authorizablesIterator = tSentryPrivilege.getAuthorizablesIterator();
        while (authorizablesIterator.hasNext()) {
            TAuthorizable tAuthorizable = (TAuthorizable)authorizablesIterator.next();
            if (!tAuthorizable.getType().equals(resource.resourceType().name())) continue;
            return true;
        }
        return false;
    }

    private List<TSentryPrivilege> getAllPrivileges(final List<String> roles) {
        final ArrayList<TSentryPrivilege> tSentryPrivileges = new ArrayList<TSentryPrivilege>();
        this.execute(new Command<Void>(){

            @Override
            public Void run(SentryGenericServiceClient client) throws Exception {
                for (String role : roles) {
                    tSentryPrivileges.addAll(client.listAllPrivilegesByRoleName(KafkaAuthBinding.this.requestorName, role, "kafka", KafkaAuthBinding.this.instanceName));
                }
                return null;
            }
        });
        return tSentryPrivileges;
    }

    private List<String> getAllRoles() {
        final ArrayList<String> roles = new ArrayList<String>();
        this.execute(new Command<Void>(){

            @Override
            public Void run(SentryGenericServiceClient client) throws Exception {
                for (TSentryRole tSentryRole : client.listAllRoles(KafkaAuthBinding.this.requestorName, "kafka")) {
                    roles.add(tSentryRole.getRoleName());
                }
                return null;
            }
        });
        return roles;
    }

    private scala.collection.immutable.Map<Resource, scala.collection.immutable.Set<Acl>> getAclsForRoles(List<String> roles) {
        return ((scala.collection.mutable.Map)JavaConverters.mapAsScalaMapConverter(this.rolePrivilegesToResourceAcls(this.getRoleToPrivileges(roles))).asScala()).toMap(Predef.conforms());
    }

    private Map<Resource, scala.collection.immutable.Set<Acl>> rolePrivilegesToResourceAcls(Map<String, scala.collection.immutable.Set<TSentryPrivilege>> rolePrivilegesMap) {
        HashMap<Resource, scala.collection.immutable.Set<Acl>> resourceAclsMap = new HashMap<Resource, scala.collection.immutable.Set<Acl>>();
        for (Map.Entry<String, scala.collection.immutable.Set<TSentryPrivilege>> rolePrivilege : rolePrivilegesMap.entrySet()) {
            scala.collection.immutable.Set<TSentryPrivilege> privileges = rolePrivilege.getValue();
            for (TSentryPrivilege privilege : privileges) {
                List authorizables = privilege.getAuthorizables();
                String host = null;
                String operation = privilege.getAction();
                for (TAuthorizable tAuthorizable : authorizables) {
                    if (tAuthorizable.getType().equals(KafkaAuthorizable.AuthorizableType.HOST.name())) {
                        host = tAuthorizable.getName();
                        continue;
                    }
                    Resource resource = ConvertUtil.convertAuthorizableToResource(tAuthorizable);
                    if (operation.equals("*")) {
                        operation = "All";
                    }
                    Acl acl = new Acl(new KafkaPrincipal("role", rolePrivilege.getKey()), (PermissionType)Allow$.MODULE$, host, Operation$.MODULE$.fromString(operation));
                    java.util.HashSet<Acl> newAclsJava = new java.util.HashSet<Acl>();
                    newAclsJava.add(acl);
                    this.addExistingAclsForResource(resourceAclsMap, resource, newAclsJava);
                    scala.collection.mutable.Set aclScala = JavaConversions.asScalaSet(newAclsJava);
                    resourceAclsMap.put(resource, (scala.collection.immutable.Set<Acl>)aclScala.toSet());
                }
            }
        }
        return resourceAclsMap;
    }

    private Map<String, scala.collection.immutable.Set<TSentryPrivilege>> getRoleToPrivileges(final List<String> roles) {
        final HashMap<String, scala.collection.immutable.Set<TSentryPrivilege>> rolePrivilegesMap = new HashMap<String, scala.collection.immutable.Set<TSentryPrivilege>>();
        this.execute(new Command<Void>(){

            @Override
            public Void run(SentryGenericServiceClient client) throws Exception {
                for (String role : roles) {
                    Set rolePrivileges = client.listAllPrivilegesByRoleName(KafkaAuthBinding.this.requestorName, role, "kafka", KafkaAuthBinding.this.instanceName);
                    scala.collection.immutable.Set rolePrivilegesScala = ((scala.collection.mutable.Set)JavaConverters.asScalaSetConverter((Set)rolePrivileges).asScala()).toSet();
                    rolePrivilegesMap.put(role, rolePrivilegesScala);
                }
                return null;
            }
        });
        return rolePrivilegesMap;
    }

    private void addExistingAclsForResource(Map<Resource, scala.collection.immutable.Set<Acl>> resourceAclsMap, Resource resource, Set<Acl> newAclsJava) {
        scala.collection.immutable.Set<Acl> existingAcls = resourceAclsMap.get(resource);
        if (existingAcls != null) {
            for (Acl curAcl : existingAcls) {
                newAclsJava.add(curAcl);
            }
        }
    }

    private boolean roleExists(String role) {
        return this.getAllRoles().contains(role);
    }

    private void verifyAcls(scala.collection.immutable.Set<Acl> acls) {
        for (Acl acl : acls) {
            assert (acl.principal().getPrincipalType().toLowerCase().equals("role")) : "Only Acls with KafkaPrincipal of type \"role;\" is supported.";
            assert (acl.permissionType().name().equals(Allow.name())) : "Only Acls with Permission of type \"Allow\" is supported.";
        }
    }

    private String getName(RequestChannel.Session session) {
        String principalName = session.principal().getName();
        int start = principalName.indexOf("CN=");
        if (start >= 0) {
            String name = "";
            String tmpName = principalName.substring(start + 3);
            int end = tmpName.indexOf(",");
            name = end > 0 ? tmpName.substring(0, end) : tmpName;
            return name;
        }
        return principalName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initKerberos(String keytabFile, String principal) {
        if (keytabFile == null || keytabFile.length() == 0) {
            throw new IllegalArgumentException("keytabFile required because kerberos is enabled");
        }
        if (principal == null || principal.length() == 0) {
            throw new IllegalArgumentException("principal required because kerberos is enabled");
        }
        Class<KafkaAuthBinding> clazz = KafkaAuthBinding.class;
        synchronized (KafkaAuthBinding.class) {
            if (kerberosInit == null) {
                kerberosInit = Boolean.TRUE;
                Configuration ugiConf = new Configuration();
                ugiConf.set("hadoop.security.authentication", "kerberos");
                UserGroupInformation.setConfiguration((Configuration)ugiConf);
                LOG.info("Attempting to acquire kerberos ticket with keytab: {}, principal: {} ", (Object)keytabFile, (Object)principal);
                try {
                    UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytabFile);
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Failed to login user with Principal: " + principal + " and Keytab file: " + keytabFile, ioe);
                }
                LOG.info("Got Kerberos ticket");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static interface Command<T> {
        public T run(SentryGenericServiceClient var1) throws Exception;
    }
}

