/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.kafka.authorizer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Operation;
import kafka.security.auth.Resource;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.sentry.kafka.binding.KafkaAuthBinding;
import org.apache.sentry.kafka.binding.KafkaAuthBindingSingleton;
import org.apache.sentry.kafka.conf.KafkaAuthConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryKafkaAuthorizer
implements Authorizer {
    private static final Logger LOG = LoggerFactory.getLogger(SentryKafkaAuthorizer.class);
    private static final String INSTANCE_NAME = KafkaAuthConf.AuthzConfVars.getDefault("sentry.kafka.service.instance");
    private KafkaAuthBinding binding;
    private String kafkaServiceInstanceName = INSTANCE_NAME;
    private String requestorName = KafkaAuthConf.AuthzConfVars.getDefault("sentry.kafka.service.user.name");
    String sentry_site = null;
    List<KafkaPrincipal> super_users = null;

    public boolean authorize(RequestChannel.Session session, Operation operation, Resource resource) {
        LOG.debug("Authorizing Session: " + session + " for Operation: " + operation + " on Resource: " + resource);
        KafkaPrincipal user = session.principal();
        if (this.isSuperUser(user)) {
            LOG.debug("Allowing SuperUser: " + user + " in " + session + " for Operation: " + operation + " on Resource: " + resource);
            return true;
        }
        LOG.debug("User: " + user + " is not a SuperUser");
        return this.binding.authorize(session, operation, resource);
    }

    public void addAcls(scala.collection.immutable.Set<Acl> acls, Resource resource) {
        this.binding.addAcls(acls, resource);
    }

    public boolean removeAcls(scala.collection.immutable.Set<Acl> acls, Resource resource) {
        return this.binding.removeAcls(acls, resource);
    }

    public boolean removeAcls(Resource resource) {
        return this.binding.removeAcls(resource);
    }

    public scala.collection.immutable.Set<Acl> getAcls(Resource resource) {
        return this.binding.getAcls(resource);
    }

    public scala.collection.immutable.Map<Resource, scala.collection.immutable.Set<Acl>> getAcls(KafkaPrincipal principal) {
        return this.binding.getAcls(principal);
    }

    public scala.collection.immutable.Map<Resource, scala.collection.immutable.Set<Acl>> getAcls() {
        return this.binding.getAcls();
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
        Object kafkaServiceUserName;
        Object kafkaServiceInstanceName;
        Object kafkaSuperUsersConfig;
        Object sentryKafkaSiteUrlConfig = configs.get("sentry.kafka.site.url");
        if (sentryKafkaSiteUrlConfig != null) {
            this.sentry_site = sentryKafkaSiteUrlConfig.toString();
        }
        if ((kafkaSuperUsersConfig = configs.get("super.users")) != null) {
            this.getSuperUsers(kafkaSuperUsersConfig.toString());
        }
        if ((kafkaServiceInstanceName = configs.get("sentry.kafka.service.instance")) != null) {
            this.kafkaServiceInstanceName = kafkaServiceInstanceName.toString();
        }
        if ((kafkaServiceUserName = configs.get("sentry.kafka.service.user.name")) != null) {
            this.requestorName = kafkaServiceUserName.toString();
        }
        LOG.info("Configuring Sentry KafkaAuthorizer: " + this.sentry_site);
        KafkaAuthBindingSingleton instance = KafkaAuthBindingSingleton.getInstance();
        instance.configure(this.kafkaServiceInstanceName, this.requestorName, this.sentry_site, configs);
        this.binding = instance.getAuthBinding();
    }

    private void getSuperUsers(String kafkaSuperUsers) {
        String[] superUsers;
        this.super_users = new ArrayList<KafkaPrincipal>();
        for (String superUser : superUsers = kafkaSuperUsers.split(";")) {
            if (superUser.isEmpty()) continue;
            String trimmedUser = superUser.trim();
            this.super_users.add(KafkaPrincipal.fromString((String)trimmedUser));
            LOG.debug("Adding " + trimmedUser + " to list of Kafka SuperUsers.");
        }
    }

    private boolean isSuperUser(KafkaPrincipal user) {
        if (this.super_users != null) {
            for (KafkaPrincipal superUser : this.super_users) {
                if (!superUser.equals((Object)user)) continue;
                return true;
            }
        }
        return false;
    }

    public void addRole(String role) {
        this.binding.addRole(role);
    }

    public void addRoleToGroups(String role, Set<String> groups) {
        this.binding.addRoleToGroups(role, groups);
    }

    public void dropAllRoles() {
        this.binding.dropAllRoles();
    }
}

