/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.kafka;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kafka.security.auth.Resource;
import kafka.security.auth.ResourceType$;
import org.apache.sentry.api.generic.thrift.TAuthorizable;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.model.kafka.Host;
import org.apache.sentry.core.model.kafka.KafkaAuthorizable;

public class ConvertUtil {
    public static List<Authorizable> convertResourceToAuthorizable(String hostname, final Resource resource) {
        ArrayList authorizables = Lists.newArrayList();
        authorizables.add(new Host(hostname));
        authorizables.add(new Authorizable(){

            public String getTypeName() {
                String resourceTypeName = resource.resourceType().name();
                if (resourceTypeName.equalsIgnoreCase("group")) {
                    return KafkaAuthorizable.AuthorizableType.CONSUMERGROUP.name();
                }
                return resourceTypeName;
            }

            public String getName() {
                return resource.name();
            }
        });
        return authorizables;
    }

    public static Resource convertAuthorizableToResource(TAuthorizable tAuthorizable) {
        String authorizableType = tAuthorizable.getType().equalsIgnoreCase("consumergroup") ? "group" : tAuthorizable.getType();
        Resource resource = new Resource(ResourceType$.MODULE$.fromString(authorizableType), tAuthorizable.getName());
        return resource;
    }
}

