/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.master;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hbase.master.cleaner.BaseLogCleanerDelegate;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.base.Predicate;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class ReplicationLogCleaner
extends BaseLogCleanerDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationLogCleaner.class);
    private ZKWatcher zkw;
    private ReplicationQueueStorage queueStorage;
    private boolean stopped = false;
    private Set<String> wals;
    private long readZKTimestamp = 0L;

    @Override
    public void preClean() {
        this.readZKTimestamp = EnvironmentEdgeManager.currentTime();
        try {
            this.wals = this.queueStorage.getAllWALs();
        }
        catch (ReplicationException e) {
            LOG.warn("Failed to read zookeeper, skipping checking deletable files");
            this.wals = null;
        }
    }

    @Override
    public Iterable<FileStatus> getDeletableFiles(Iterable<FileStatus> files) {
        if (this.getConf() == null) {
            return files;
        }
        if (this.wals == null) {
            return Collections.emptyList();
        }
        return Iterables.filter(files, (Predicate)new Predicate<FileStatus>(){

            public boolean apply(FileStatus file) {
                String wal = file.getPath().getName();
                boolean logInReplicationQueue = ReplicationLogCleaner.this.wals.contains(wal);
                if (logInReplicationQueue) {
                    LOG.debug("Found up in ZooKeeper, NOT deleting={}", (Object)wal);
                }
                return !logInReplicationQueue && file.getModificationTime() < ReplicationLogCleaner.this.readZKTimestamp;
            }
        });
    }

    public void setConf(Configuration config) {
        Configuration conf = new Configuration(config);
        try {
            this.setConf(conf, new ZKWatcher(conf, "replicationLogCleaner", null));
        }
        catch (IOException e) {
            LOG.error("Error while configuring " + this.getClass().getName(), (Throwable)e);
        }
    }

    @VisibleForTesting
    public void setConf(Configuration conf, ZKWatcher zk) {
        super.setConf(conf);
        try {
            this.zkw = zk;
            this.queueStorage = ReplicationStorageFactory.getReplicationQueueStorage((ZKWatcher)zk, (Configuration)conf);
        }
        catch (Exception e) {
            LOG.error("Error while configuring " + this.getClass().getName(), (Throwable)e);
        }
    }

    public void stop(String why) {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.zkw != null) {
            LOG.info("Stopping " + this.zkw);
            this.zkw.close();
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }
}

