/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.metastore.messaging.json;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hive.hcatalog.messaging.AddPartitionMessage;
import org.apache.hive.hcatalog.messaging.AlterIndexMessage;
import org.apache.hive.hcatalog.messaging.CreateFunctionMessage;
import org.apache.hive.hcatalog.messaging.CreateIndexMessage;
import org.apache.hive.hcatalog.messaging.DropFunctionMessage;
import org.apache.hive.hcatalog.messaging.DropIndexMessage;
import org.apache.hive.hcatalog.messaging.DropPartitionMessage;
import org.apache.hive.hcatalog.messaging.InsertMessage;
import org.apache.hive.hcatalog.messaging.MessageDeserializer;
import org.apache.hive.hcatalog.messaging.MessageFactory;
import org.apache.hive.hcatalog.messaging.json.JSONAlterIndexMessage;
import org.apache.hive.hcatalog.messaging.json.JSONCreateFunctionMessage;
import org.apache.hive.hcatalog.messaging.json.JSONCreateIndexMessage;
import org.apache.hive.hcatalog.messaging.json.JSONDropFunctionMessage;
import org.apache.hive.hcatalog.messaging.json.JSONDropIndexMessage;
import org.apache.hive.hcatalog.messaging.json.JSONInsertMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONAddPartitionMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONAlterDatabaseMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONAlterPartitionMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONAlterTableMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONCreateDatabaseMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONCreateTableMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONDropDatabaseMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONDropPartitionMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONDropTableMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONMessageDeserializer;

public class SentryJSONMessageFactory
extends MessageFactory {
    private static final Log LOG = LogFactory.getLog((String)SentryJSONMessageFactory.class.getName());
    private static SentryJSONMessageDeserializer deserializer = new SentryJSONMessageDeserializer();

    public SentryJSONMessageFactory() {
        LOG.info((Object)"Using SentryJSONMessageFactory for building Notification log messages ");
    }

    public MessageDeserializer getDeserializer() {
        return deserializer;
    }

    public String getVersion() {
        return "0.1";
    }

    public String getMessageFormat() {
        return "json";
    }

    public SentryJSONCreateDatabaseMessage buildCreateDatabaseMessage(Database db) {
        return new SentryJSONCreateDatabaseMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, this.now(), db);
    }

    public SentryJSONAlterDatabaseMessage buildAlterDatabaseMessage(Database before, Database after) {
        return new SentryJSONAlterDatabaseMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, before, after, this.now());
    }

    public SentryJSONDropDatabaseMessage buildDropDatabaseMessage(Database db) {
        return new SentryJSONDropDatabaseMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, db.getName(), this.now(), db.getLocationUri());
    }

    public SentryJSONCreateTableMessage buildCreateTableMessage(Table table) {
        return new SentryJSONCreateTableMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, this.now(), table);
    }

    public SentryJSONAlterTableMessage buildAlterTableMessage(Table before, Table after) {
        return new SentryJSONAlterTableMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, this.now(), before, after);
    }

    public SentryJSONDropTableMessage buildDropTableMessage(Table table) {
        return new SentryJSONDropTableMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, table.getDbName(), table.getTableName(), this.now(), table.getSd().getLocation());
    }

    public SentryJSONAlterPartitionMessage buildAlterPartitionMessage(Table table, Partition before, Partition after) {
        return new SentryJSONAlterPartitionMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, before.getDbName(), before.getTableName(), SentryJSONMessageFactory.getPartitionKeyValues(table, before), after.getValues(), this.now(), before.getSd().getLocation(), after.getSd().getLocation());
    }

    public DropPartitionMessage buildDropPartitionMessage(Table table, Iterator<Partition> partitions) {
        PartitionBasicInfo partitionBasicInfo = this.getPartitionBasicInfo(table, partitions);
        return new SentryJSONDropPartitionMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, table.getDbName(), table.getTableName(), partitionBasicInfo.getPartitionList(), this.now(), partitionBasicInfo.getLocations());
    }

    public CreateFunctionMessage buildCreateFunctionMessage(Function function) {
        return new JSONCreateFunctionMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, function, Long.valueOf(this.now()));
    }

    public DropFunctionMessage buildDropFunctionMessage(Function function) {
        return new JSONDropFunctionMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, function, Long.valueOf(this.now()));
    }

    public CreateIndexMessage buildCreateIndexMessage(Index index) {
        return new JSONCreateIndexMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, index, Long.valueOf(this.now()));
    }

    public DropIndexMessage buildDropIndexMessage(Index index) {
        return new JSONDropIndexMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, index, Long.valueOf(this.now()));
    }

    public AlterIndexMessage buildAlterIndexMessage(Index before, Index after) {
        return new JSONAlterIndexMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, before, after, Long.valueOf(this.now()));
    }

    public InsertMessage buildInsertMessage(String db, String table, Map<String, String> partKeyVals, List<String> files) {
        return new JSONInsertMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, db, table, partKeyVals, files, Long.valueOf(this.now()));
    }

    public AddPartitionMessage buildAddPartitionMessage(Table table, Iterator<Partition> partitionsIterator) {
        PartitionBasicInfo partitionBasicInfo = this.getPartitionBasicInfo(table, partitionsIterator);
        return new SentryJSONAddPartitionMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, table.getDbName(), table.getTableName(), partitionBasicInfo.getPartitionList(), this.now(), partitionBasicInfo.getLocations());
    }

    public AddPartitionMessage buildAddPartitionMessage(Table table, List<Partition> partitions) {
        return this.buildAddPartitionMessage(table, partitions.iterator());
    }

    private PartitionBasicInfo getPartitionBasicInfo(Table table, Iterator<Partition> iterator) {
        PartitionBasicInfo partitionBasicInfo = new PartitionBasicInfo();
        while (iterator.hasNext()) {
            Partition partition = iterator.next();
            partitionBasicInfo.getPartitionList().add(SentryJSONMessageFactory.getPartitionKeyValues(table, partition));
            partitionBasicInfo.getLocations().add(partition.getSd().getLocation());
        }
        return partitionBasicInfo;
    }

    private static Map<String, String> getPartitionKeyValues(Table table, Partition partition) {
        LinkedHashMap<String, String> partitionKeys = new LinkedHashMap<String, String>();
        for (int i = 0; i < table.getPartitionKeysSize(); ++i) {
            partitionKeys.put(((FieldSchema)table.getPartitionKeys().get(i)).getName(), (String)partition.getValues().get(i));
        }
        return partitionKeys;
    }

    private long now() {
        return System.currentTimeMillis() / 1000L;
    }

    private class PartitionBasicInfo {
        private List<Map<String, String>> partitionList = Lists.newLinkedList();
        private List<String> locations = Lists.newArrayList();

        private PartitionBasicInfo() {
        }

        public List<Map<String, String>> getPartitionList() {
            return this.partitionList;
        }

        public List<String> getLocations() {
            return this.locations;
        }
    }
}

