/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.metastore.messaging.json;

import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hive.hcatalog.messaging.json.JSONAlterDatabaseMessage;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONMessageDeserializer;
import org.codehaus.jackson.annotate.JsonProperty;

public class SentryJSONAlterDatabaseMessage
extends JSONAlterDatabaseMessage {
    @JsonProperty
    private String newLocation;
    @JsonProperty
    private String oldLocation;
    @JsonProperty
    private String newDbName;
    @JsonProperty
    private String oldDbName;
    @JsonProperty
    private PrincipalType newOwnerType;
    @JsonProperty
    private PrincipalType oldOwnerType;
    @JsonProperty
    private String newOwnerName;
    @JsonProperty
    private String oldOwnerName;

    public SentryJSONAlterDatabaseMessage() {
    }

    public SentryJSONAlterDatabaseMessage(String server, String servicePrincipal, Database before, Database after, Long timestamp) {
        super(server, servicePrincipal, before, after, timestamp);
        this.newLocation = before.getLocationUri();
        this.oldLocation = after.getLocationUri();
        this.oldDbName = before.getName();
        this.newDbName = after.getName();
        this.oldOwnerType = before.getOwnerType();
        this.newOwnerType = after.getOwnerType();
        this.oldOwnerName = before.getOwnerName();
        this.newOwnerName = after.getOwnerName();
    }

    public String getNewLocation() {
        return this.newLocation;
    }

    public String getOldLocation() {
        return this.oldLocation;
    }

    public String getOldDbName() {
        return this.oldDbName;
    }

    public String getNewDbName() {
        return this.newDbName;
    }

    public PrincipalType getNewOwnerType() {
        return this.newOwnerType;
    }

    public PrincipalType getOldOwnerType() {
        return this.oldOwnerType;
    }

    public String getNewOwnerName() {
        return this.newOwnerName;
    }

    public String getOldOwnerName() {
        return this.oldOwnerName;
    }

    public String toString() {
        return SentryJSONMessageDeserializer.serialize((Object)this);
    }
}

