/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.messaging.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.commons.lang.StringUtils;
import org.apache.hive.hcatalog.messaging.HCatEventMessage;
import org.apache.hive.hcatalog.messaging.MessageFactory;

public class MessagingUtils {
    public static HCatEventMessage getMessage(Message message) {
        try {
            String messageBody = ((TextMessage)message).getText();
            String eventType = message.getStringProperty("HCAT_EVENT");
            String messageVersion = message.getStringProperty("HCAT_MESSAGE_VERSION");
            String messageFormat = message.getStringProperty("HCAT_MESSAGE_FORMAT");
            if (StringUtils.isEmpty((String)messageBody) || StringUtils.isEmpty((String)eventType)) {
                throw new IllegalArgumentException("Could not extract HCatEventMessage. EventType and/or MessageBody is null/empty.");
            }
            return MessageFactory.getDeserializer(messageFormat, messageVersion).getHCatEventMessage(eventType, messageBody);
        }
        catch (JMSException exception) {
            throw new IllegalArgumentException("Could not extract HCatEventMessage. ", exception);
        }
    }

    private MessagingUtils() {
    }
}

