/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.listener;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.RawStoreProxy;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.AddIndexEvent;
import org.apache.hadoop.hive.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.AlterIndexEvent;
import org.apache.hadoop.hive.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.ConfigChangeEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateFunctionEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropFunctionEvent;
import org.apache.hadoop.hive.metastore.events.DropIndexEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.events.InsertEvent;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.metastore.events.LoadPartitionDoneEvent;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbNotificationListener
extends MetaStoreEventListener {
    private static final Logger LOG = LoggerFactory.getLogger((String)DbNotificationListener.class.getName());
    private static CleanerThread cleaner = null;
    private HiveConf hiveConf;
    private MessageFactory msgFactory;
    private final boolean alterStatNotificationDisabled;
    private final boolean alterNotificationsBasic;

    private synchronized void init(HiveConf conf) throws MetaException {
        if (cleaner == null) {
            cleaner = new CleanerThread(conf, RawStoreProxy.getProxy((HiveConf)conf, (Configuration)conf, (String)conf.getVar(HiveConf.ConfVars.METASTORE_RAW_STORE_IMPL), (int)999999));
            cleaner.start();
        }
    }

    public DbNotificationListener(Configuration config) throws MetaException {
        super(config);
        this.hiveConf = (HiveConf)config;
        this.init(this.hiveConf);
        this.alterNotificationsBasic = HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_ALTER_NOTIFICATIONS_BASIC);
        this.alterStatNotificationDisabled = HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_DISABLE_STATS_NOTIFICATIONS);
        this.msgFactory = MessageFactory.getInstance();
    }

    public void onConfigChange(ConfigChangeEvent tableEvent) throws MetaException {
        String key = tableEvent.getKey();
        if (key.equals(HiveConf.ConfVars.METASTORE_EVENT_DB_LISTENER_TTL.toString())) {
            this.hiveConf.set(HiveConf.ConfVars.METASTORE_EVENT_DB_LISTENER_TTL.name(), tableEvent.getNewValue());
            cleaner.setTimeToLive(this.hiveConf.getTimeVar(HiveConf.ConfVars.METASTORE_EVENT_DB_LISTENER_TTL, TimeUnit.SECONDS));
        }
    }

    public void onCreateTable(CreateTableEvent tableEvent) throws MetaException {
        Table t = tableEvent.getTable();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.CREATE_TABLE.toString(), this.msgFactory.buildCreateTableMessage(t).toString());
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        this.enqueue(event, (ListenerEvent)tableEvent);
    }

    public void onDropTable(DropTableEvent tableEvent) throws MetaException {
        Table t = tableEvent.getTable();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.DROP_TABLE.toString(), this.msgFactory.buildDropTableMessage(t).toString());
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        this.enqueue(event, (ListenerEvent)tableEvent);
    }

    public void onAlterTable(AlterTableEvent tableEvent) throws MetaException {
        EnvironmentContext environmentContext = tableEvent.getEnvironmentContext();
        if (this.alterStatNotificationDisabled && environmentContext != null && environmentContext.isSetProperties() && environmentContext.getProperties().containsKey("STATS_GENERATED")) {
            return;
        }
        Table before = tableEvent.getOldTable();
        Table after = tableEvent.getNewTable();
        if (this.alterNotificationsBasic) {
            if (before.getDbName() == null || after.getDbName() == null || before.getTableName() == null || after.getTableName() == null) {
                return;
            }
            if (before.getSd() == null || after.getSd() == null) {
                return;
            }
            if (!this.isVirtualView(before) && before.getSd().getLocation() == null) {
                return;
            }
            if (!this.isVirtualView(after) && after.getSd().getLocation() == null) {
                return;
            }
            if (before.getDbName().equals(after.getDbName()) && before.getTableName().equals(after.getTableName()) && StringUtils.equals((String)before.getSd().getLocation(), (String)after.getSd().getLocation()) && before.getOwnerType() == after.getOwnerType() && StringUtils.equals((String)before.getOwner(), (String)after.getOwner())) {
                return;
            }
        }
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ALTER_TABLE.toString(), this.msgFactory.buildAlterTableMessage(before, after).toString());
        event.setDbName(after.getDbName());
        event.setTableName(after.getTableName());
        this.enqueue(event, (ListenerEvent)tableEvent);
    }

    public void onAddPartition(AddPartitionEvent partitionEvent) throws MetaException {
        Table t = partitionEvent.getTable();
        String msg = this.msgFactory.buildAddPartitionMessage(t, partitionEvent.getPartitionIterator()).toString();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ADD_PARTITION.toString(), msg);
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        this.enqueue(event, (ListenerEvent)partitionEvent);
    }

    public void onDropPartition(DropPartitionEvent partitionEvent) throws MetaException {
        Table t = partitionEvent.getTable();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.DROP_PARTITION.toString(), this.msgFactory.buildDropPartitionMessage(t, partitionEvent.getPartitionIterator()).toString());
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        this.enqueue(event, (ListenerEvent)partitionEvent);
    }

    public void onAlterPartition(AlterPartitionEvent partitionEvent) throws MetaException {
        EnvironmentContext environmentContext = partitionEvent.getEnvironmentContext();
        if (this.alterStatNotificationDisabled && environmentContext != null && environmentContext.isSetProperties() && environmentContext.getProperties().containsKey("STATS_GENERATED")) {
            return;
        }
        Partition before = partitionEvent.getOldPartition();
        Partition after = partitionEvent.getNewPartition();
        if (this.alterNotificationsBasic) {
            if (before.getSd() == null || after.getSd() == null) {
                return;
            }
            if (before.getSd().getLocation() == null || after.getSd().getLocation() == null) {
                return;
            }
            if (before.getDbName().equals(after.getDbName()) && before.getTableName().equals(after.getTableName()) && before.getSd().getLocation().equals(after.getSd().getLocation())) {
                return;
            }
        }
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ALTER_PARTITION.toString(), this.msgFactory.buildAlterPartitionMessage(partitionEvent.getTable(), before, after).toString());
        event.setDbName(before.getDbName());
        event.setTableName(before.getTableName());
        this.enqueue(event, (ListenerEvent)partitionEvent);
    }

    public void onCreateDatabase(CreateDatabaseEvent dbEvent) throws MetaException {
        Database db = dbEvent.getDatabase();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.CREATE_DATABASE.toString(), this.msgFactory.buildCreateDatabaseMessage(db).toString());
        event.setDbName(db.getName());
        this.enqueue(event, (ListenerEvent)dbEvent);
    }

    public void onDropDatabase(DropDatabaseEvent dbEvent) throws MetaException {
        Database db = dbEvent.getDatabase();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.DROP_DATABASE.toString(), this.msgFactory.buildDropDatabaseMessage(db).toString());
        event.setDbName(db.getName());
        this.enqueue(event, (ListenerEvent)dbEvent);
    }

    public void onAlterDatabase(AlterDatabaseEvent dbEvent) throws MetaException {
        Database oldDb = dbEvent.getOldDatabase();
        Database newDb = dbEvent.getNewDatabase();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ALTER_DATABASE.toString(), this.msgFactory.buildAlterDatabaseMessage(oldDb, newDb).toString());
        event.setDbName(oldDb.getName());
        this.enqueue(event, (ListenerEvent)dbEvent);
    }

    public void onCreateFunction(CreateFunctionEvent fnEvent) throws MetaException {
    }

    public void onDropFunction(DropFunctionEvent fnEvent) throws MetaException {
    }

    public void onAddIndex(AddIndexEvent indexEvent) throws MetaException {
        Index index = indexEvent.getIndex();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.CREATE_INDEX.toString(), this.msgFactory.buildCreateIndexMessage(index).toString());
        event.setDbName(index.getDbName());
        event.setTableName(index.getOrigTableName());
        this.enqueue(event, (ListenerEvent)indexEvent);
    }

    public void onDropIndex(DropIndexEvent indexEvent) throws MetaException {
        Index index = indexEvent.getIndex();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.DROP_INDEX.toString(), this.msgFactory.buildDropIndexMessage(index).toString());
        event.setDbName(index.getDbName());
        event.setTableName(index.getOrigTableName());
        this.enqueue(event, (ListenerEvent)indexEvent);
    }

    public void onAlterIndex(AlterIndexEvent indexEvent) throws MetaException {
        Index before = indexEvent.getOldIndex();
        Index after = indexEvent.getNewIndex();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ALTER_INDEX.toString(), this.msgFactory.buildAlterIndexMessage(before, after).toString());
        event.setDbName(before.getDbName());
        event.setTableName(before.getOrigTableName());
        this.enqueue(event, (ListenerEvent)indexEvent);
    }

    public void onInsert(InsertEvent insertEvent) throws MetaException {
        Table tableObj = insertEvent.getTableObj();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.INSERT.toString(), this.msgFactory.buildInsertMessage(tableObj, insertEvent.getPartitionObj(), insertEvent.isReplace(), insertEvent.getFiles()).toString());
        event.setDbName(tableObj.getDbName());
        event.setTableName(tableObj.getTableName());
        this.enqueue(event, (ListenerEvent)insertEvent);
    }

    public void onLoadPartitionDone(LoadPartitionDoneEvent partSetDoneEvent) throws MetaException {
    }

    private int now() {
        long millis = System.currentTimeMillis();
        if ((millis /= 1000L) > Integer.MAX_VALUE) {
            LOG.warn("We've passed max int value in seconds since the epoch, all notification times will be the same!");
            return Integer.MAX_VALUE;
        }
        return (int)millis;
    }

    private boolean isVirtualView(Table table) {
        String tableType = table.getTableType();
        return tableType != null && tableType.equalsIgnoreCase(TableType.VIRTUAL_VIEW.name());
    }

    private void enqueue(NotificationEvent event, ListenerEvent listenerEvent) throws MetaException {
        LOG.debug("DbNotificationListener: Processing : {}:{}", (Object)event.getEventId(), (Object)event.getMessage());
        HiveMetaStore.HMSHandler.getMSForConf((Configuration)this.hiveConf).addNotificationEvent(event);
        if (event.isSetEventId()) {
            listenerEvent.putParameter("DB_NOTIFICATION_EVENT_ID_KEY_NAME", Long.toString(event.getEventId()));
        }
    }

    private static class CleanerThread
    extends Thread {
        private RawStore rs;
        private int ttl;
        private static long sleepTime = 60000L;

        CleanerThread(HiveConf conf, RawStore rs) {
            super("CleanerThread");
            this.rs = rs;
            this.setTimeToLive(conf.getTimeVar(HiveConf.ConfVars.METASTORE_EVENT_DB_LISTENER_TTL, TimeUnit.SECONDS));
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                this.rs.cleanNotificationEvents(this.ttl);
                try {
                    Thread.sleep(sleepTime);
                    continue;
                }
                catch (InterruptedException e) {
                    LOG.info("Cleaner thread sleep interupted", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        public void setTimeToLive(long configTtl) {
            this.ttl = configTtl > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)configTtl;
        }
    }
}

