/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.DeleteTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CreateTableProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.CreateTableState> {
    private static final Logger LOG = LoggerFactory.getLogger(CreateTableProcedure.class);
    private TableDescriptor tableDescriptor;
    private List<RegionInfo> newRegions;

    public CreateTableProcedure() {
    }

    public CreateTableProcedure(MasterProcedureEnv env, TableDescriptor tableDescriptor, RegionInfo[] newRegions) {
        this(env, tableDescriptor, newRegions, null);
    }

    public CreateTableProcedure(MasterProcedureEnv env, TableDescriptor tableDescriptor, RegionInfo[] newRegions, ProcedurePrepareLatch syncLatch) {
        super(env, syncLatch);
        this.tableDescriptor = tableDescriptor;
        this.newRegions = newRegions != null ? Lists.newArrayList((Object[])newRegions) : null;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.CreateTableState state) throws InterruptedException {
        if (LOG.isTraceEnabled()) {
            LOG.trace(this + " execute state=" + state);
        }
        try {
            switch (state) {
                case CREATE_TABLE_PRE_OPERATION: {
                    boolean exists = !this.prepareCreate(env);
                    this.releaseSyncLatch();
                    if (exists) {
                        assert (this.isFailed()) : "the delete should have an exception here";
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    this.preCreate(env);
                    this.setNextState(MasterProcedureProtos.CreateTableState.CREATE_TABLE_WRITE_FS_LAYOUT);
                    break;
                }
                case CREATE_TABLE_WRITE_FS_LAYOUT: {
                    DeleteTableProcedure.deleteFromFs(env, this.getTableName(), this.newRegions, true);
                    this.newRegions = CreateTableProcedure.createFsLayout(env, this.tableDescriptor, this.newRegions);
                    this.setNextState(MasterProcedureProtos.CreateTableState.CREATE_TABLE_ADD_TO_META);
                    break;
                }
                case CREATE_TABLE_ADD_TO_META: {
                    this.newRegions = CreateTableProcedure.addTableToMeta(env, this.tableDescriptor, this.newRegions);
                    this.setNextState(MasterProcedureProtos.CreateTableState.CREATE_TABLE_ASSIGN_REGIONS);
                    break;
                }
                case CREATE_TABLE_ASSIGN_REGIONS: {
                    CreateTableProcedure.setEnablingState(env, this.getTableName());
                    this.addChildProcedure(env.getAssignmentManager().createRoundRobinAssignProcedures(this.newRegions));
                    this.setNextState(MasterProcedureProtos.CreateTableState.CREATE_TABLE_UPDATE_DESC_CACHE);
                    break;
                }
                case CREATE_TABLE_UPDATE_DESC_CACHE: {
                    CreateTableProcedure.setEnabledState(env, this.getTableName());
                    CreateTableProcedure.updateTableDescCache(env, this.getTableName());
                    this.setNextState(MasterProcedureProtos.CreateTableState.CREATE_TABLE_POST_OPERATION);
                    break;
                }
                case CREATE_TABLE_POST_OPERATION: {
                    this.postCreate(env);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            if (this.isRollbackSupported(state)) {
                this.setFailure("master-create-table", e);
            }
            LOG.warn("Retriable error trying to create table=" + this.getTableName() + " state=" + state, (Throwable)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.CreateTableState state) throws IOException {
        if (state == MasterProcedureProtos.CreateTableState.CREATE_TABLE_PRE_OPERATION) {
            DeleteTableProcedure.deleteTableStates(env, this.getTableName());
            this.releaseSyncLatch();
            return;
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected boolean isRollbackSupported(MasterProcedureProtos.CreateTableState state) {
        switch (state) {
            case CREATE_TABLE_PRE_OPERATION: {
                return true;
            }
        }
        return false;
    }

    protected MasterProcedureProtos.CreateTableState getState(int stateId) {
        return MasterProcedureProtos.CreateTableState.valueOf((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.CreateTableState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.CreateTableState getInitialState() {
        return MasterProcedureProtos.CreateTableState.CREATE_TABLE_PRE_OPERATION;
    }

    @Override
    public TableName getTableName() {
        return this.tableDescriptor.getTableName();
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.CREATE;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.CreateTableStateData.Builder state = MasterProcedureProtos.CreateTableStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.getUser())).setTableSchema(ProtobufUtil.toTableSchema((TableDescriptor)this.tableDescriptor));
        if (this.newRegions != null) {
            for (RegionInfo hri : this.newRegions) {
                state.addRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)hri));
            }
        }
        serializer.serialize((Message)state.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.CreateTableStateData state = (MasterProcedureProtos.CreateTableStateData)serializer.deserialize(MasterProcedureProtos.CreateTableStateData.class);
        this.setUser(MasterProcedureUtil.toUserInfo(state.getUserInfo()));
        this.tableDescriptor = ProtobufUtil.toTableDescriptor((HBaseProtos.TableSchema)state.getTableSchema());
        if (state.getRegionInfoCount() == 0) {
            this.newRegions = null;
        } else {
            this.newRegions = new ArrayList<RegionInfo>(state.getRegionInfoCount());
            for (HBaseProtos.RegionInfo hri : state.getRegionInfoList()) {
                this.newRegions.add(ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)hri));
            }
        }
    }

    @Override
    protected boolean waitInitialized(MasterProcedureEnv env) {
        if (this.getTableName().isSystemTable()) {
            return false;
        }
        return super.waitInitialized(env);
    }

    @Override
    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.getProcedureScheduler().waitTableExclusiveLock((Procedure<?>)this, this.getTableName())) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    private boolean prepareCreate(MasterProcedureEnv env) throws IOException {
        TableName tableName = this.getTableName();
        if (MetaTableAccessor.tableExists((Connection)env.getMasterServices().getConnection(), (TableName)tableName)) {
            this.setFailure("master-create-table", (Throwable)new TableExistsException(this.getTableName()));
            return false;
        }
        if (this.tableDescriptor.getColumnFamilyCount() == 0) {
            this.setFailure("master-create-table", (Throwable)new DoNotRetryIOException("Table " + this.getTableName().toString() + " should have at least one column family."));
            return false;
        }
        return true;
    }

    private void preCreate(MasterProcedureEnv env) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost;
        if (!this.getTableName().isSystemTable()) {
            ProcedureSyncWait.getMasterQuotaManager(env).checkNamespaceTableAndRegionQuota(this.getTableName(), this.newRegions != null ? this.newRegions.size() : 0);
        }
        if ((cpHost = env.getMasterCoprocessorHost()) != null) {
            RegionInfo[] regions = this.newRegions == null ? null : this.newRegions.toArray(new RegionInfo[this.newRegions.size()]);
            cpHost.preCreateTableAction(this.tableDescriptor, regions, this.getUser());
        }
    }

    private void postCreate(MasterProcedureEnv env) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            RegionInfo[] regions = this.newRegions == null ? null : this.newRegions.toArray(new RegionInfo[this.newRegions.size()]);
            cpHost.postCompletedCreateTableAction(this.tableDescriptor, regions, this.getUser());
        }
    }

    protected static List<RegionInfo> createFsLayout(MasterProcedureEnv env, final TableDescriptor tableDescriptor, List<RegionInfo> newRegions) throws IOException {
        return CreateTableProcedure.createFsLayout(env, tableDescriptor, newRegions, new CreateHdfsRegions(){

            @Override
            public List<RegionInfo> createHdfsRegions(MasterProcedureEnv env, Path tableRootDir, TableName tableName, List<RegionInfo> newRegions) throws IOException {
                RegionInfo[] regions = newRegions != null ? newRegions.toArray(new RegionInfo[newRegions.size()]) : null;
                return ModifyRegionUtils.createRegions(env.getMasterConfiguration(), tableRootDir, tableDescriptor, regions, null);
            }
        });
    }

    protected static List<RegionInfo> createFsLayout(MasterProcedureEnv env, TableDescriptor tableDescriptor, List<RegionInfo> newRegions, CreateHdfsRegions hdfsRegionHandler) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        Path tempdir = mfs.getTempDir();
        Path tempTableDir = FSUtils.getTableDir((Path)tempdir, (TableName)tableDescriptor.getTableName());
        ((FSTableDescriptors)env.getMasterServices().getTableDescriptors()).createTableDescriptorForTableDirectory(tempTableDir, tableDescriptor, false);
        newRegions = hdfsRegionHandler.createHdfsRegions(env, tempdir, tableDescriptor.getTableName(), newRegions);
        CreateTableProcedure.moveTempDirectoryToHBaseRoot(env, tableDescriptor, tempTableDir);
        return newRegions;
    }

    protected static void moveTempDirectoryToHBaseRoot(MasterProcedureEnv env, TableDescriptor tableDescriptor, Path tempTableDir) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        Path tableDir = FSUtils.getTableDir((Path)mfs.getRootDir(), (TableName)tableDescriptor.getTableName());
        FileSystem fs = mfs.getFileSystem();
        if (!fs.delete(tableDir, true) && fs.exists(tableDir)) {
            throw new IOException("Couldn't delete " + tableDir);
        }
        if (!fs.rename(tempTableDir, tableDir)) {
            throw new IOException("Unable to move table from temp=" + tempTableDir + " to hbase root=" + tableDir);
        }
    }

    protected static List<RegionInfo> addTableToMeta(MasterProcedureEnv env, TableDescriptor tableDescriptor, List<RegionInfo> regions) throws IOException {
        assert (regions != null && regions.size() > 0) : "expected at least 1 region, got " + regions;
        ProcedureSyncWait.waitMetaRegions(env);
        List newRegions = RegionReplicaUtil.addReplicas((TableDescriptor)tableDescriptor, regions, (int)1, (int)tableDescriptor.getRegionReplication());
        CreateTableProcedure.addRegionsToMeta(env, tableDescriptor, newRegions);
        if (tableDescriptor.getRegionReplication() > 1) {
            ServerRegionReplicaUtil.setupRegionReplicaReplication(env.getMasterConfiguration());
        }
        return newRegions;
    }

    protected static void setEnablingState(MasterProcedureEnv env, TableName tableName) throws IOException {
        env.getMasterServices().getTableStateManager().setTableState(tableName, TableState.State.ENABLING);
    }

    protected static void setEnabledState(MasterProcedureEnv env, TableName tableName) throws IOException {
        env.getMasterServices().getTableStateManager().setTableState(tableName, TableState.State.ENABLED);
    }

    private static void addRegionsToMeta(MasterProcedureEnv env, TableDescriptor tableDescriptor, List<RegionInfo> regionInfos) throws IOException {
        MetaTableAccessor.addRegionsToMeta((Connection)env.getMasterServices().getConnection(), regionInfos, (int)tableDescriptor.getRegionReplication());
    }

    protected static void updateTableDescCache(MasterProcedureEnv env, TableName tableName) throws IOException {
        env.getMasterServices().getTableDescriptors().get(tableName);
    }

    protected boolean shouldWaitClientAck(MasterProcedureEnv env) {
        return !this.getTableName().isSystemTable();
    }

    @VisibleForTesting
    RegionInfo getFirstRegionInfo() {
        if (this.newRegions == null || this.newRegions.isEmpty()) {
            return null;
        }
        return this.newRegions.get(0);
    }

    protected static interface CreateHdfsRegions {
        public List<RegionInfo> createHdfsRegions(MasterProcedureEnv var1, Path var2, TableName var3, List<RegionInfo> var4) throws IOException;
    }
}

