/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.Admin;

public class SnapshotTableAction
extends Action {
    private final TableName tableName;
    private final long sleepTime;

    public SnapshotTableAction(TableName tableName) {
        this(-1, tableName);
    }

    public SnapshotTableAction(int sleepTime, TableName tableName) {
        this.tableName = tableName;
        this.sleepTime = sleepTime;
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        String snapshotName = this.tableName + "-it-" + System.currentTimeMillis();
        Admin admin = util.getAdmin();
        if (this.context.isStopping()) {
            return;
        }
        LOG.info("Performing action: Snapshot table " + this.tableName);
        admin.snapshot(snapshotName, this.tableName);
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

