/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Action {
    public static final String KILL_MASTER_TIMEOUT_KEY = "hbase.chaosmonkey.action.killmastertimeout";
    public static final String START_MASTER_TIMEOUT_KEY = "hbase.chaosmonkey.action.startmastertimeout";
    public static final String KILL_RS_TIMEOUT_KEY = "hbase.chaosmonkey.action.killrstimeout";
    public static final String START_RS_TIMEOUT_KEY = "hbase.chaosmonkey.action.startrstimeout";
    public static final String KILL_ZK_NODE_TIMEOUT_KEY = "hbase.chaosmonkey.action.killzknodetimeout";
    public static final String START_ZK_NODE_TIMEOUT_KEY = "hbase.chaosmonkey.action.startzknodetimeout";
    public static final String KILL_DATANODE_TIMEOUT_KEY = "hbase.chaosmonkey.action.killdatanodetimeout";
    public static final String START_DATANODE_TIMEOUT_KEY = "hbase.chaosmonkey.action.startdatanodetimeout";
    protected static final Logger LOG = LoggerFactory.getLogger(Action.class);
    protected static final long KILL_MASTER_TIMEOUT_DEFAULT = 60000L;
    protected static final long START_MASTER_TIMEOUT_DEFAULT = 60000L;
    protected static final long KILL_RS_TIMEOUT_DEFAULT = 60000L;
    protected static final long START_RS_TIMEOUT_DEFAULT = 60000L;
    protected static final long KILL_ZK_NODE_TIMEOUT_DEFAULT = 60000L;
    protected static final long START_ZK_NODE_TIMEOUT_DEFAULT = 60000L;
    protected static final long KILL_DATANODE_TIMEOUT_DEFAULT = 60000L;
    protected static final long START_DATANODE_TIMEOUT_DEFAULT = 60000L;
    protected ActionContext context;
    protected HBaseCluster cluster;
    protected ClusterMetrics initialStatus;
    protected ServerName[] initialServers;
    protected long killMasterTimeout;
    protected long startMasterTimeout;
    protected long killRsTimeout;
    protected long startRsTimeout;
    protected long killZkNodeTimeout;
    protected long startZkNodeTimeout;
    protected long killDataNodeTimeout;
    protected long startDataNodeTimeout;

    public void init(ActionContext context) throws IOException {
        this.context = context;
        this.cluster = context.getHBaseCluster();
        this.initialStatus = this.cluster.getInitialClusterMetrics();
        Set regionServers = this.initialStatus.getLiveServerMetrics().keySet();
        this.initialServers = regionServers.toArray(new ServerName[regionServers.size()]);
        this.killMasterTimeout = this.cluster.getConf().getLong(KILL_MASTER_TIMEOUT_KEY, 60000L);
        this.startMasterTimeout = this.cluster.getConf().getLong(START_MASTER_TIMEOUT_KEY, 60000L);
        this.killRsTimeout = this.cluster.getConf().getLong(KILL_RS_TIMEOUT_KEY, 60000L);
        this.startRsTimeout = this.cluster.getConf().getLong(START_RS_TIMEOUT_KEY, 60000L);
        this.killZkNodeTimeout = this.cluster.getConf().getLong(KILL_ZK_NODE_TIMEOUT_KEY, 60000L);
        this.startZkNodeTimeout = this.cluster.getConf().getLong(START_ZK_NODE_TIMEOUT_KEY, 60000L);
        this.killDataNodeTimeout = this.cluster.getConf().getLong(KILL_DATANODE_TIMEOUT_KEY, 60000L);
        this.startDataNodeTimeout = this.cluster.getConf().getLong(START_DATANODE_TIMEOUT_KEY, 60000L);
    }

    public void perform() throws Exception {
    }

    protected ServerName[] getCurrentServers() throws IOException {
        int count;
        ClusterMetrics clusterStatus = this.cluster.getClusterMetrics();
        Set regionServers = clusterStatus.getLiveServerMetrics().keySet();
        int n = count = regionServers == null ? 0 : regionServers.size();
        if (count <= 0) {
            return new ServerName[0];
        }
        ServerName master = clusterStatus.getMasterName();
        if (master == null || !regionServers.contains(master)) {
            return regionServers.toArray(new ServerName[count]);
        }
        if (count == 1) {
            return new ServerName[0];
        }
        ArrayList tmp = new ArrayList(count);
        tmp.addAll(regionServers);
        tmp.remove(master);
        return tmp.toArray(new ServerName[count - 1]);
    }

    protected void killMaster(ServerName server) throws IOException {
        LOG.info("Killing master " + server);
        this.cluster.killMaster(server);
        this.cluster.waitForMasterToStop(server, this.killMasterTimeout);
        LOG.info("Killed master " + server);
    }

    protected void startMaster(ServerName server) throws IOException {
        LOG.info("Starting master " + server.getHostname());
        this.cluster.startMaster(server.getHostname(), server.getPort());
        this.cluster.waitForActiveAndReadyMaster(this.startMasterTimeout);
        LOG.info("Started master " + server.getHostname());
    }

    protected void killRs(ServerName server) throws IOException {
        LOG.info("Killing regionserver " + server);
        this.cluster.killRegionServer(server);
        this.cluster.waitForRegionServerToStop(server, this.killRsTimeout);
        LOG.info("Killed regionserver " + server + ". Reported num of rs:" + this.cluster.getClusterMetrics().getLiveServerMetrics().size());
    }

    protected void startRs(ServerName server) throws IOException {
        LOG.info("Starting regionserver " + server.getAddress());
        this.cluster.startRegionServer(server.getHostname(), server.getPort());
        this.cluster.waitForRegionServerToStart(server.getHostname(), server.getPort(), this.startRsTimeout);
        LOG.info("Started regionserver " + server.getAddress() + ". Reported num of rs:" + this.cluster.getClusterMetrics().getLiveServerMetrics().size());
    }

    protected void killZKNode(ServerName server) throws IOException {
        LOG.info("Killing zookeeper node " + server);
        this.cluster.killZkNode(server);
        this.cluster.waitForZkNodeToStop(server, this.killZkNodeTimeout);
        LOG.info("Killed zookeeper node " + server + ". Reported num of rs:" + this.cluster.getClusterMetrics().getLiveServerMetrics().size());
    }

    protected void startZKNode(ServerName server) throws IOException {
        LOG.info("Starting zookeeper node " + server.getHostname());
        this.cluster.startZkNode(server.getHostname(), server.getPort());
        this.cluster.waitForZkNodeToStart(server, this.startZkNodeTimeout);
        LOG.info("Started zookeeper node " + server);
    }

    protected void killDataNode(ServerName server) throws IOException {
        LOG.info("Killing datanode " + server);
        this.cluster.killDataNode(server);
        this.cluster.waitForDataNodeToStop(server, this.killDataNodeTimeout);
        LOG.info("Killed datanode " + server + ". Reported num of rs:" + this.cluster.getClusterMetrics().getLiveServerMetrics().size());
    }

    protected void startDataNode(ServerName server) throws IOException {
        LOG.info("Starting datanode " + server.getHostname());
        this.cluster.startDataNode(server);
        this.cluster.waitForDataNodeToStart(server, this.startDataNodeTimeout);
        LOG.info("Started datanode " + server);
    }

    protected void unbalanceRegions(ClusterMetrics clusterStatus, List<ServerName> fromServers, List<ServerName> toServers, double fractionOfRegions) throws Exception {
        LinkedList<byte[]> victimRegions = new LinkedList<byte[]>();
        for (Map.Entry entry : clusterStatus.getLiveServerMetrics().entrySet()) {
            ServerName sn = (ServerName)entry.getKey();
            ServerMetrics serverLoad = (ServerMetrics)entry.getValue();
            LinkedList regions = new LinkedList(serverLoad.getRegionMetrics().keySet());
            int victimRegionCount = (int)Math.ceil(fractionOfRegions * (double)regions.size());
            LOG.debug("Removing " + victimRegionCount + " regions from " + sn);
            for (int i = 0; i < victimRegionCount; ++i) {
                int victimIx = RandomUtils.nextInt((int)0, (int)regions.size());
                String regionId = HRegionInfo.encodeRegionName((byte[])((byte[])regions.remove(victimIx)));
                victimRegions.add(Bytes.toBytes((String)regionId));
            }
        }
        LOG.info("Moving " + victimRegions.size() + " regions from " + fromServers.size() + " servers to " + toServers.size() + " different servers");
        Admin admin = this.context.getHBaseIntegrationTestingUtility().getAdmin();
        for (byte[] victimRegion : victimRegions) {
            if (this.context.isStopping()) break;
            int targetIx = RandomUtils.nextInt((int)0, (int)toServers.size());
            admin.move(victimRegion, Bytes.toBytes((String)toServers.get(targetIx).getServerName()));
        }
    }

    protected void forceBalancer() throws Exception {
        Admin admin = this.context.getHBaseIntegrationTestingUtility().getAdmin();
        boolean result = false;
        try {
            result = admin.balancer();
        }
        catch (Exception e) {
            LOG.warn("Got exception while doing balance ", (Throwable)e);
        }
        if (!result) {
            LOG.error("Balancer didn't succeed");
        }
    }

    public Configuration getConf() {
        return this.cluster.getConf();
    }

    protected void modifyAllTableColumns(TableName tableName, BiConsumer<String, ColumnFamilyDescriptorBuilder> transform) throws IOException {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        Admin admin = util.getAdmin();
        TableDescriptor tableDescriptor = admin.getDescriptor(tableName);
        ColumnFamilyDescriptor[] columnDescriptors = tableDescriptor.getColumnFamilies();
        if (columnDescriptors == null || columnDescriptors.length == 0) {
            return;
        }
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableDescriptor)tableDescriptor);
        for (ColumnFamilyDescriptor descriptor : columnDescriptors) {
            ColumnFamilyDescriptorBuilder cfd = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)descriptor);
            transform.accept(descriptor.getNameAsString(), cfd);
            builder.modifyColumnFamily(cfd.build());
        }
        if (this.context.isStopping()) {
            return;
        }
        admin.modifyTable(builder.build());
    }

    protected void modifyAllTableColumns(TableName tableName, Consumer<ColumnFamilyDescriptorBuilder> transform) throws IOException {
        this.modifyAllTableColumns(tableName, (String name, ColumnFamilyDescriptorBuilder cfd) -> transform.accept((ColumnFamilyDescriptorBuilder)cfd));
    }

    public static class ActionContext {
        private IntegrationTestingUtility util;

        public ActionContext(IntegrationTestingUtility util) {
            this.util = util;
        }

        public IntegrationTestingUtility getHBaseIntegrationTestingUtility() {
            return this.util;
        }

        public HBaseCluster getHBaseCluster() {
            return this.util.getHBaseClusterInterface();
        }

        public boolean isStopping() {
            return false;
        }
    }
}

