/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.example;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.generated.RefreshHFilesProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RefreshHFilesClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(RefreshHFilesClient.class);
    private final Connection connection;

    public RefreshHFilesClient(Configuration cfg) {
        try {
            this.connection = ConnectionFactory.createConnection((Configuration)cfg);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
    }

    public void refreshHFiles(TableName tableName) throws Throwable {
        try (Table table = this.connection.getTable(tableName);){
            this.refreshHFiles(table);
        }
    }

    public void refreshHFiles(Table table) throws Throwable {
        final RefreshHFilesProtos.RefreshHFilesRequest request = RefreshHFilesProtos.RefreshHFilesRequest.getDefaultInstance();
        table.coprocessorService(RefreshHFilesProtos.RefreshHFilesService.class, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, (Batch.Call)new Batch.Call<RefreshHFilesProtos.RefreshHFilesService, RefreshHFilesProtos.RefreshHFilesResponse>(){

            public RefreshHFilesProtos.RefreshHFilesResponse call(RefreshHFilesProtos.RefreshHFilesService refreshHFilesService) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                refreshHFilesService.refreshHFiles((RpcController)controller, request, (RpcCallback<RefreshHFilesProtos.RefreshHFilesResponse>)rpcCallback);
                if (controller.failedOnException()) {
                    throw controller.getFailedOn();
                }
                return (RefreshHFilesProtos.RefreshHFilesResponse)rpcCallback.get();
            }
        });
        LOG.debug("Done refreshing HFiles");
    }
}

