/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.example;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class AsyncClientExample
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncClientExample.class);
    private static final int THREAD_POOL_SIZE = 16;
    private static final int DEFAULT_NUM_OPS = 100;
    private static final byte[] FAMILY = Bytes.toBytes((String)"d");
    private static final byte[] QUAL = Bytes.toBytes((String)"test");
    private final AtomicReference<CompletableFuture<AsyncConnection>> future = new AtomicReference();

    private CompletableFuture<AsyncConnection> getConn() {
        CompletableFuture<AsyncConnection> f = this.future.get();
        if (f != null) {
            return f;
        }
        do {
            if (!this.future.compareAndSet(null, new CompletableFuture())) continue;
            CompletableFuture<AsyncConnection> toComplete = this.future.get();
            ConnectionFactory.createAsyncConnection((Configuration)this.getConf()).whenComplete((conn, error) -> {
                if (error != null) {
                    toComplete.completeExceptionally((Throwable)error);
                    this.future.set(null);
                    return;
                }
                toComplete.complete((AsyncConnection)conn);
            });
            return toComplete;
        } while ((f = this.future.get()) == null);
        return f;
    }

    @SuppressWarnings(value={"NP_NONNULL_PARAM_VIOLATION"}, justification="it is valid to pass NULL to CompletableFuture#completedFuture")
    private CompletableFuture<Void> closeConn() {
        CompletableFuture<AsyncConnection> f = this.future.get();
        if (f == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> closeFuture = new CompletableFuture<Void>();
        f.whenComplete((conn, error) -> {
            if (error == null) {
                IOUtils.closeQuietly((Closeable)conn);
            }
            closeFuture.complete(null);
        });
        return closeFuture;
    }

    private byte[] getKey(int i) {
        return Bytes.toBytes((String)String.format("%08x", i));
    }

    public int run(String[] args) throws Exception {
        if (args.length < 1 || args.length > 2) {
            System.out.println("Usage: " + ((Object)((Object)this)).getClass().getName() + " tableName [num_operations]");
            return -1;
        }
        TableName tableName = TableName.valueOf((String)args[0]);
        int numOps = args.length > 1 ? Integer.parseInt(args[1]) : 100;
        ExecutorService threadPool = Executors.newFixedThreadPool(16, Threads.newDaemonThreadFactory((String)"AsyncClientExample"));
        CountDownLatch latch = new CountDownLatch(numOps);
        IntStream.range(0, numOps).forEach(i -> {
            CompletableFuture<AsyncConnection> future = this.getConn();
            future.whenComplete((conn, error) -> {
                if (error != null) {
                    LOG.warn("failed to get async connection for " + i, error);
                    latch.countDown();
                    return;
                }
                AsyncTable table = conn.getTable(tableName, threadPool);
                table.put(new Put(this.getKey(i)).addColumn(FAMILY, QUAL, Bytes.toBytes((int)i))).whenComplete((putResp, putErr) -> {
                    if (putErr != null) {
                        LOG.warn("put failed for " + i, putErr);
                        latch.countDown();
                        return;
                    }
                    LOG.info("put for " + i + " succeeded, try getting");
                    table.get(new Get(this.getKey(i))).whenComplete((result, getErr) -> {
                        if (getErr != null) {
                            LOG.warn("get failed for " + i);
                            latch.countDown();
                            return;
                        }
                        if (result.isEmpty()) {
                            LOG.warn("get failed for " + i + ", server returns empty result");
                        } else if (!result.containsColumn(FAMILY, QUAL)) {
                            LOG.warn("get failed for " + i + ", the result does not contain " + Bytes.toString((byte[])FAMILY) + ":" + Bytes.toString((byte[])QUAL));
                        } else {
                            int v = Bytes.toInt((byte[])result.getValue(FAMILY, QUAL));
                            if (v != i) {
                                LOG.warn("get failed for " + i + ", the value of " + Bytes.toString((byte[])FAMILY) + ":" + Bytes.toString((byte[])QUAL) + " is " + v + ", exected " + i);
                            } else {
                                LOG.info("get for " + i + " succeeded");
                            }
                        }
                        latch.countDown();
                    });
                });
            });
        });
        latch.await();
        this.closeConn().get();
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new AsyncClientExample(), (String[])args);
    }
}

