/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.CompactedHFilesDischarger;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class, RegionServerTests.class})
public class TestCompactedHFilesDischarger {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCompactedHFilesDischarger.class);
    private final HBaseTestingUtility testUtil = new HBaseTestingUtility();
    private HRegion region;
    private static final byte[] fam = Bytes.toBytes((String)"cf_1");
    private static final byte[] qual1 = Bytes.toBytes((String)"qf_1");
    private static final byte[] val = Bytes.toBytes((String)"val");
    private static CountDownLatch latch = new CountDownLatch(3);
    private static AtomicInteger counter = new AtomicInteger(0);
    private static AtomicInteger scanCompletedCounter = new AtomicInteger(0);
    private RegionServerServices rss;

    @Before
    public void setUp() throws Exception {
        TableName tableName = TableName.valueOf((String)this.getClass().getSimpleName());
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(fam));
        HRegionInfo info = new HRegionInfo(tableName, null, null, false);
        Path path = this.testUtil.getDataTestDir(this.getClass().getSimpleName());
        this.region = HBaseTestingUtility.createRegionAndWAL((RegionInfo)info, path, this.testUtil.getConfiguration(), (TableDescriptor)htd);
        this.rss = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        ArrayList<HRegion> regions = new ArrayList<HRegion>(1);
        regions.add(this.region);
        ((RegionServerServices)Mockito.doReturn(regions).when((Object)this.rss)).getRegions();
    }

    @After
    public void tearDown() throws IOException {
        counter.set(0);
        scanCompletedCounter.set(0);
        latch = new CountDownLatch(3);
        HBaseTestingUtility.closeRegionAndWAL(this.region);
        this.testUtil.cleanupTestDir();
    }

    @Test
    public void testCompactedHFilesCleaner() throws Exception {
        Put p;
        int i;
        CompactedHFilesDischarger cleaner = new CompactedHFilesDischarger(1000, (Stoppable)null, this.rss, false);
        for (i = 1; i < 10; ++i) {
            p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(fam, qual1, val);
            this.region.put(p);
        }
        this.region.flush(true);
        for (i = 11; i < 20; ++i) {
            p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(fam, qual1, val);
            this.region.put(p);
        }
        this.region.flush(true);
        for (i = 21; i < 30; ++i) {
            p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(fam, qual1, val);
            this.region.put(p);
        }
        this.region.flush(true);
        HStore store = this.region.getStore(fam);
        Assert.assertEquals((long)3L, (long)store.getStorefilesCount());
        Collection storefiles = store.getStorefiles();
        Collection compactedfiles = store.getStoreEngine().getStoreFileManager().getCompactedfiles();
        for (HStoreFile file : storefiles) {
            Assert.assertFalse((boolean)file.isCompactedAway());
        }
        cleaner.chore();
        storefiles = store.getStorefiles();
        for (HStoreFile file : storefiles) {
            Assert.assertFalse((boolean)file.isCompactedAway());
        }
        this.region.compact(true);
        Assert.assertEquals((long)1L, (long)store.getStorefilesCount());
        Assert.assertEquals((long)3L, (long)store.getStoreEngine().getStoreFileManager().getCompactedfiles().size());
        cleaner.chore();
        Assert.assertEquals((long)1L, (long)store.getStorefilesCount());
        storefiles = store.getStorefiles();
        for (HStoreFile file : storefiles) {
            Assert.assertFalse((boolean)file.isCompactedAway());
        }
        compactedfiles = store.getStoreEngine().getStoreFileManager().getCompactedfiles();
        Assert.assertTrue((boolean)compactedfiles.isEmpty());
    }

    @Test
    public void testCleanerWithParallelScannersAfterCompaction() throws Exception {
        Put p;
        int i;
        CompactedHFilesDischarger cleaner = new CompactedHFilesDischarger(1000, (Stoppable)null, this.rss, false);
        for (i = 1; i < 10; ++i) {
            p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(fam, qual1, val);
            this.region.put(p);
        }
        this.region.flush(true);
        for (i = 11; i < 20; ++i) {
            p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(fam, qual1, val);
            this.region.put(p);
        }
        this.region.flush(true);
        for (i = 21; i < 30; ++i) {
            p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(fam, qual1, val);
            this.region.put(p);
        }
        this.region.flush(true);
        HStore store = this.region.getStore(fam);
        Assert.assertEquals((long)3L, (long)store.getStorefilesCount());
        Collection storefiles = store.getStorefiles();
        Collection compactedfiles = store.getStoreEngine().getStoreFileManager().getCompactedfiles();
        for (HStoreFile file : storefiles) {
            Assert.assertFalse((boolean)file.isCompactedAway());
        }
        this.region.compact(true);
        this.startScannerThreads();
        storefiles = store.getStorefiles();
        int usedReaderCount = 0;
        int unusedReaderCount = 0;
        for (HStoreFile file : storefiles) {
            if (file.getRefCount() != 3) continue;
            ++usedReaderCount;
        }
        compactedfiles = store.getStoreEngine().getStoreFileManager().getCompactedfiles();
        for (HStoreFile file : compactedfiles) {
            Assert.assertEquals((String)"Refcount should be 3", (long)0L, (long)file.getRefCount());
            ++unusedReaderCount;
        }
        Assert.assertEquals((String)"unused reader count should be 3", (long)3L, (long)unusedReaderCount);
        Assert.assertEquals((String)"used reader count should be 1", (long)1L, (long)usedReaderCount);
        cleaner.chore();
        this.countDown();
        Assert.assertEquals((long)1L, (long)store.getStorefilesCount());
        storefiles = store.getStorefiles();
        for (HStoreFile file : storefiles) {
            Assert.assertFalse((boolean)file.isCompactedAway());
        }
        compactedfiles = store.getStoreEngine().getStoreFileManager().getCompactedfiles();
        Assert.assertTrue((boolean)compactedfiles.isEmpty());
    }

    @Test
    public void testCleanerWithParallelScanners() throws Exception {
        Put p;
        int i;
        CompactedHFilesDischarger cleaner = new CompactedHFilesDischarger(1000, (Stoppable)null, this.rss, false);
        for (i = 1; i < 10; ++i) {
            p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(fam, qual1, val);
            this.region.put(p);
        }
        this.region.flush(true);
        for (i = 11; i < 20; ++i) {
            p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(fam, qual1, val);
            this.region.put(p);
        }
        this.region.flush(true);
        for (i = 21; i < 30; ++i) {
            p = new Put(Bytes.toBytes((String)("row" + i)));
            p.addColumn(fam, qual1, val);
            this.region.put(p);
        }
        this.region.flush(true);
        HStore store = this.region.getStore(fam);
        Assert.assertEquals((long)3L, (long)store.getStorefilesCount());
        Collection storefiles = store.getStorefiles();
        Collection compactedfiles = store.getStoreEngine().getStoreFileManager().getCompactedfiles();
        for (HStoreFile file : storefiles) {
            Assert.assertFalse((boolean)file.isCompactedAway());
        }
        this.startScannerThreads();
        this.region.compact(true);
        storefiles = store.getStorefiles();
        int usedReaderCount = 0;
        int unusedReaderCount = 0;
        for (HStoreFile file : storefiles) {
            if (file.getRefCount() != 0) continue;
            ++unusedReaderCount;
        }
        compactedfiles = store.getStoreEngine().getStoreFileManager().getCompactedfiles();
        for (HStoreFile file : compactedfiles) {
            Assert.assertEquals((String)"Refcount should be 3", (long)3L, (long)file.getRefCount());
            ++usedReaderCount;
        }
        Assert.assertEquals((String)"unused reader count should be 1", (long)1L, (long)unusedReaderCount);
        Assert.assertEquals((String)"used reader count should be 3", (long)3L, (long)usedReaderCount);
        cleaner.chore();
        this.countDown();
        Assert.assertEquals((long)1L, (long)store.getStorefilesCount());
        Assert.assertEquals((long)3L, (long)store.getStoreEngine().getStoreFileManager().getCompactedfiles().size());
        while (scanCompletedCounter.get() != 3) {
            Thread.sleep(100L);
        }
        latch = new CountDownLatch(3);
        scanCompletedCounter.set(0);
        counter.set(0);
        this.startScannerThreads();
        storefiles = store.getStorefiles();
        usedReaderCount = 0;
        unusedReaderCount = 0;
        for (HStoreFile file : storefiles) {
            if (file.getRefCount() != 3) continue;
            ++usedReaderCount;
        }
        compactedfiles = store.getStoreEngine().getStoreFileManager().getCompactedfiles();
        for (HStoreFile file : compactedfiles) {
            Assert.assertEquals((String)"Refcount should be 0", (long)0L, (long)file.getRefCount());
            ++unusedReaderCount;
        }
        Assert.assertEquals((String)"unused reader count should be 3", (long)3L, (long)unusedReaderCount);
        Assert.assertEquals((String)"used reader count should be 1", (long)1L, (long)usedReaderCount);
        this.countDown();
        while (scanCompletedCounter.get() != 3) {
            Thread.sleep(100L);
        }
        cleaner.chore();
        Assert.assertEquals((long)1L, (long)store.getStorefilesCount());
        storefiles = store.getStorefiles();
        for (HStoreFile file : storefiles) {
            Assert.assertFalse((boolean)file.isCompactedAway());
        }
        compactedfiles = store.getStoreEngine().getStoreFileManager().getCompactedfiles();
        Assert.assertTrue((boolean)compactedfiles.isEmpty());
    }

    @Test
    public void testStoreFileMissing() throws Exception {
        this.write("row1");
        this.region.flush(true);
        this.write("row2");
        this.region.flush(true);
        this.write("row3");
        this.region.flush(true);
        Scan scan = new Scan();
        scan.setCaching(1);
        HRegion.RegionScannerImpl scanner = this.region.getScanner(scan);
        ArrayList res = new ArrayList();
        scanner.next(res);
        Assert.assertEquals((Object)"row1", (Object)Bytes.toString((byte[])CellUtil.cloneRow((Cell)((Cell)res.get(0)))));
        res.clear();
        this.write("row4");
        this.region.flush(true);
        this.region.compact(true);
        CompactedHFilesDischarger cleaner = new CompactedHFilesDischarger(1000, (Stoppable)null, this.rss, false);
        cleaner.chore();
        scanner.next(res);
        Assert.assertEquals((Object)"row2", (Object)Bytes.toString((byte[])CellUtil.cloneRow((Cell)((Cell)res.get(0)))));
        scanner.close();
    }

    private void write(String row1) throws IOException {
        byte[] row = Bytes.toBytes((String)row1);
        Put put = new Put(row);
        put.addColumn(fam, qual1, row);
        this.region.put(put);
    }

    protected void countDown() {
        latch.countDown();
        latch.countDown();
        latch.countDown();
    }

    protected void startScannerThreads() throws InterruptedException {
        ScanThread[] scanThreads = new ScanThread[3];
        for (int i = 0; i < 3; ++i) {
            scanThreads[i] = new ScanThread(this.region);
        }
        for (ScanThread thread : scanThreads) {
            thread.start();
        }
        while (counter.get() != 3) {
            Thread.sleep(100L);
        }
    }

    private static class ScanThread
    extends Thread {
        private final HRegion region;

        public ScanThread(HRegion region) {
            this.region = region;
        }

        @Override
        public void run() {
            try {
                this.initiateScan(this.region);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initiateScan(HRegion region) throws IOException {
            Scan scan = new Scan();
            scan.setCaching(1);
            HRegion.RegionScannerImpl resScanner = null;
            try {
                resScanner = region.getScanner(scan);
                ArrayList results = new ArrayList();
                boolean next = resScanner.next(results);
                try {
                    counter.incrementAndGet();
                    latch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                while (next) {
                    next = resScanner.next(results);
                }
            }
            finally {
                scanCompletedCounter.incrementAndGet();
                resScanner.close();
            }
        }
    }
}

