/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterNotCarryTable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterNotCarryTable.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterNotCarryTable.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static HMaster master;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration c = UTIL.getConfiguration();
        FSUtils.setRootDir((Configuration)c, (Path)UTIL.getDataTestDir());
        UTIL.startMiniZKCluster();
        master = new HMaster(UTIL.getConfiguration());
        master.start();
        while (master.getAssignmentManager() != null) {
            LOG.debug("Wait master to create AssignmentManager");
            Thread.sleep(1000L);
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        master.stop("Shutdown");
        UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testMasterNotCarryTable() {
        Assert.assertFalse((boolean)LoadBalancer.isTablesOnMaster((Configuration)UTIL.getConfiguration()));
        Assert.assertFalse((boolean)LoadBalancer.isSystemTablesOnlyOnMaster((Configuration)UTIL.getConfiguration()));
    }

    @Test
    public void testMasterBlockCache() {
        Assert.assertNull((Object)master.getCacheConfig().getBlockCache());
    }

    @Test
    public void testMasterMemStoreLAB() {
        Assert.assertNull((Object)ChunkCreator.getInstance());
    }
}

